/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeCltSvr;
import ctree.jdbc.CtreeDA;
import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeProcArgType;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.SQLPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;

public final class CtreeSnIoSqlda
implements CtreeError {
    int status = 0;
    CtreeCltSvr CltSvr;
    CtreeProcArgType[] Ioflags;
    short[] flags;
    int NumParams;
    CtreeDA DA;

    public CtreeSnIoSqlda() {
        this.CltSvr = new CtreeCltSvr(1);
        this.Ioflags = null;
        this.flags = null;
        this.NumParams = 0;
        this.DA = null;
    }

    public CtreeSnIoSqlda(int n, CtreeDA ctreeDA) {
        this.CltSvr = new CtreeCltSvr(n);
        this.Ioflags = null;
        this.flags = null;
        this.NumParams = 0;
        this.DA = ctreeDA;
    }

    public void close() {
        if (this.DA != null && this.CltSvr.getType() == 1) {
            this.DA.close();
            this.DA = null;
        }
        if (this.Ioflags != null) {
            for (int i = 0; i < this.Ioflags.length; ++i) {
                this.Ioflags[i] = null;
            }
            this.Ioflags = null;
        }
        this.CltSvr = null;
        this.flags = null;
    }

    public void finalize() {
        this.close();
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setCltSvr(CtreeCltSvr ctreeCltSvr) {
        this.CltSvr = ctreeCltSvr;
    }

    public void setProcArgType(CtreeProcArgType[] ctreeProcArgTypeArray) {
        this.Ioflags = ctreeProcArgTypeArray;
    }

    public void setFlag(int n, short s) {
        this.flags[n] = s;
    }

    public short getFlag(int n) {
        return this.flags[n];
    }

    public void setNumParams(int n) {
        this.NumParams = n;
    }

    public void setDA(CtreeDA ctreeDA) {
        this.DA = ctreeDA;
    }

    public int getStatus() {
        return this.status;
    }

    public CtreeCltSvr getCltSvr() {
        return this.CltSvr;
    }

    public CtreeProcArgType[] getProcArgTypeArray() {
        return this.Ioflags;
    }

    public CtreeProcArgType getProcArgType(int n) {
        return this.Ioflags[n];
    }

    public int getNumParams() {
        return this.NumParams;
    }

    public CtreeDA getDA() {
        return this.DA;
    }

    public void marshal_DA(SQLPacket sQLPacket) throws IOException, SQLException {
        DataOutputStream dataOutputStream = sQLPacket.getOutputStream();
        dataOutputStream.writeInt(this.status);
        if (this.CltSvr.getType() == 0) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            this.CltSvr.setType(1);
            this.CltSvr.marshal(sQLPacket);
            if (this.DA == null || this.DA.getNColumns() == 0) {
                dataOutputStream.writeInt(0);
                return;
            }
            int n6 = this.DA.getNColumns();
            dataOutputStream.writeInt(n6);
            dataOutputStream.writeInt(this.DA.getNVars());
            for (n5 = 0; n5 < n6; ++n5) {
                dataOutputStream.writeInt(this.DA.getHostType(n5));
            }
            if (this.DA.getPrecisionArray() != null) {
                n5 = 1;
                dataOutputStream.writeInt(n5);
                for (n4 = 0; n4 < n6; ++n4) {
                    dataOutputStream.writeInt(this.DA.getPrecision(n4));
                }
            } else {
                n5 = 0;
                dataOutputStream.writeInt(n5);
            }
            if (this.DA.getScaleArray() != null) {
                n4 = 1;
                dataOutputStream.writeInt(n4);
                for (n3 = 0; n3 < n6; ++n3) {
                    dataOutputStream.writeInt(this.DA.getScale(n3));
                }
            } else {
                n4 = 0;
                dataOutputStream.writeInt(n4);
            }
            n3 = this.DA.getNRows();
            dataOutputStream.writeInt(n3);
            for (n2 = 0; n2 < n6; ++n2) {
                dataOutputStream.writeInt(this.DA.getLength(n2));
            }
            for (n2 = 0; n2 < n6; ++n2) {
                for (n = 0; n < n3; ++n) {
                    dataOutputStream.writeInt(this.DA.getIValue(n2, n));
                }
            }
            for (n2 = 0; n2 < n6; ++n2) {
                for (n = 0; n < n3; ++n) {
                    if (-1 == this.DA.getIValue(n2, n)) continue;
                    this.DA.getValue(n2, n).marshal(sQLPacket);
                }
            }
        } else if (this.CltSvr.getType() == 1) {
            throw new CtreeSQLException("Marshalling as server side. Unexpected", 26008);
        }
    }

    public void unmarshal(SQLPacket sQLPacket) throws IOException, SQLException {
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        this.status = dataInputStream.readInt();
        this.CltSvr.unmarshal(dataInputStream);
        if (this.CltSvr.getType() == 0) {
            int n;
            int n2;
            if (this.status != 0 && this.status != 100) {
                return;
            }
            this.NumParams = dataInputStream.readInt();
            if (this.NumParams == 0) {
                dataInputStream.readInt();
                return;
            }
            short s = (short)dataInputStream.readInt();
            int n3 = this.DA.getNRows();
            this.DA.resize(s, n3);
            this.flags = new short[this.NumParams];
            this.Ioflags = new CtreeProcArgType[this.NumParams];
            for (n2 = 0; n2 < this.NumParams; ++n2) {
                this.flags[n2] = (short)dataInputStream.readInt();
                this.Ioflags[n2] = new CtreeProcArgType(this.flags[n2]);
            }
            for (n2 = 0; n2 < this.NumParams; ++n2) {
                for (n = 0; n < n3; ++n) {
                    if (this.Ioflags[n2].getProcType() != 1) continue;
                    this.DA.setIValue(n2, n, (byte)dataInputStream.readInt());
                }
            }
            for (n2 = 0; n2 < this.NumParams; ++n2) {
                for (n = 0; n < n3; ++n) {
                    if (this.Ioflags[n2].getProcType() != 1) continue;
                    if (this.DA.getIValue(n2, n) != -1) {
                        this.DA.getValue(n2, n).unmarshal(sQLPacket, this.DA.getHostType(n2));
                        continue;
                    }
                    this.DA.getValue(n2, n).makeNull();
                }
            }
        } else if (this.CltSvr.getType() == 1) {
            throw new CtreeSQLException("Marshalling as server side. Unexpected", 26008);
        }
    }
}

