/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.CursorT;
import ctree.jdbc.StatementType;
import ctree.jdbc.StatementUid;
import java.sql.SQLException;
import java.util.StringTokenizer;

class SQLStatement
implements StatementType,
CtreeError {
    private int NParams = 0;
    private int NColumns = 0;
    private int NRows = 0;
    private boolean IsDynamic;
    protected boolean IsScrollable;
    private boolean IsOpen;
    private boolean HasResultset;
    private StatementUid StmtId;
    private int StmtType;
    private String Stmt;
    private CursorT Cur;
    private int[] updatedRowCounts;

    public SQLStatement(boolean bl, String string, StatementUid statementUid) throws SQLException {
        this.IsDynamic = bl;
        this.IsScrollable = false;
        this.IsOpen = false;
        this.HasResultset = false;
        this.StmtId = statementUid;
        this.SetStatement(string);
        this.Cur = new CursorT(this.StmtId, this.Stmt, this.IsDynamic, this.IsScrollable);
    }

    public SQLStatement(boolean bl, boolean bl2, String string, StatementUid statementUid) throws SQLException {
        this.IsDynamic = bl;
        this.IsScrollable = bl2;
        this.IsOpen = false;
        this.HasResultset = false;
        this.StmtId = statementUid;
        this.SetStatement(string);
        this.Cur = new CursorT(this.StmtId, this.Stmt, this.IsDynamic, this.IsScrollable);
    }

    public int Reset() {
        this.IsOpen = false;
        this.HasResultset = false;
        return 0;
    }

    public StatementUid GetUid() {
        return this.StmtId;
    }

    public void SetUid(StatementUid statementUid) {
        this.StmtId = statementUid;
    }

    public int GetStatementType() {
        return this.StmtType;
    }

    public boolean IsDynamic() {
        return this.IsDynamic;
    }

    public boolean IsOpen() {
        return this.IsOpen;
    }

    public void SetClose() {
        this.IsOpen = false;
    }

    public void SetOpen() {
        this.IsOpen = true;
    }

    public boolean HasResultset() {
        return this.HasResultset;
    }

    public void DoHaveResultSet() {
        this.HasResultset = true;
    }

    public void SetCursor(CursorT cursorT) {
        this.Cur = cursorT;
    }

    public CursorT GetCursor() {
        return this.Cur;
    }

    public int SetStatement(String string) throws SQLException {
        if (string == null || string.equals("")) {
            throw new CtreeSQLException(26055);
        }
        int n = (string = string.trim()).length();
        if (n == 0) {
            throw new CtreeSQLException(26055);
        }
        if (string.charAt(0) == '-') {
            if (string.charAt(1) == '-') {
                int n2 = string.indexOf(10);
                string = n2 > 1 ? string.substring(1 + n2) : new String("");
            }
            string = new String("");
        }
        if (string.equals("")) {
            throw new SQLException("Invalid  statement");
        }
        String string2 = string.toUpperCase();
        string2 = string2.replace('{', ' ').replace('}', ' ').trim();
        String string3 = string2.replace('=', ' ').trim();
        if (string2.startsWith("SELECT")) {
            this.StmtType = 0;
        } else if (string2.startsWith("WITH")) {
            this.StmtType = 0;
        } else if (string3.startsWith("CALL") || string3.startsWith("?")) {
            this.StmtType = 1;
        } else if (string2.startsWith("INSERT")) {
            this.StmtType = 2;
        } else if (string2.startsWith("UPDATE")) {
            this.StmtType = 3;
        } else if (string2.startsWith("DELETE")) {
            this.StmtType = 4;
        } else if (string2.startsWith("QUIT")) {
            System.exit(0);
        } else if (string2.startsWith("CREATE")) {
            String string4;
            this.StmtType = 5;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \n\t\r");
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens() && ((string4 = stringTokenizer.nextToken()).equals("PROCEDURE") || string4.equals("TRIGGER") || string4.equals("FUNCTION"))) {
                string = string + "\n";
            }
        } else {
            this.StmtType = string2.startsWith("BATCH") ? 6 : 5;
        }
        this.Stmt = string;
        return 0;
    }

    public String GetStatement() {
        return this.Stmt;
    }

    public int GetNParams() {
        return this.NParams;
    }

    public int GetNColumns() {
        return this.NColumns;
    }

    public int GetNRows() {
        return this.NRows;
    }

    public void SetNParams(int n) {
        this.NParams = n;
    }

    public void SetNColumns(int n) {
        this.NColumns = n;
    }

    public void SetNRows(int n) {
        this.NRows = n;
    }

    public void SetNrBatchRows(int[] nArray) {
        this.updatedRowCounts = nArray;
    }

    public int[] GetNrBatchRows() {
        return this.updatedRowCounts;
    }
}

