/*
 * Decompiled with CFR 0.152.
 */
package Isam;

import Isam.Converters;
import Isam.Enums;
import Isam.JCtree;
import Isam.Structures;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CtreeFile {
    static final short START_SECT = 16;
    static final short END_SECT = 1024;
    static final short CTREE_FILES = 128;
    static final short DATA_BUFFERS = 32;
    static final short INDEX_BUFFERS = 32;
    int ret;
    boolean opened;
    boolean withRes;
    boolean hasDelSpaceIndex;
    boolean autoSizeBuffers;
    public boolean openedWithResources;
    short filno;
    long numberOfRecords = -1L;
    long numberOfKeys = -1L;
    int isSuperfileHost;
    int numberOfIndexMembers;
    int numberOfSuperfileMembers;
    int logicalFileSize;
    int fixRecLen;
    int x8Mode;
    public short currentIndex;
    private String fileName;
    String regId;
    String logPath;
    Enums.LOG_MODE logMode;
    Enums.FILE_TYPE fileType;
    public Enums.FILE_MODE openedMode;
    Structures.CONVMAP_STRUCT convMap;
    Structures.IFIL_STRUCT ifil;
    ArrayList<Structures.DATOBJ_STRUCT> dodaArray;
    JCtree ctree = new JCtree("ctreeJNIStd");

    public CtreeFile(String string, String string2, String string3, Enums.LOG_MODE lOG_MODE) {
        this.regId = string;
        this.fileName = string2;
        this.logPath = string3;
        this.logMode = lOG_MODE;
        this.isSuperfileHost = -1;
        this.numberOfIndexMembers = -1;
        this.x8Mode = -1;
        this.fileType = Enums.FILE_TYPE.UNKNOW;
        this.convMap = new Structures.CONVMAP_STRUCT();
        this.convMap.align = (byte)-1;
        this.currentIndex = 0;
        this.fixRecLen = 0;
        this.openedWithResources = false;
    }

    CtreeFile(String string, String string2, String string3, Enums.LOG_MODE lOG_MODE, boolean bl) {
        this.regId = string;
        this.fileName = string2;
        this.logPath = string3;
        this.logMode = lOG_MODE;
        this.autoSizeBuffers = bl;
        this.isSuperfileHost = -1;
        this.numberOfIndexMembers = -1;
        this.x8Mode = -1;
        this.fileType = Enums.FILE_TYPE.UNKNOW;
        this.convMap = new Structures.CONVMAP_STRUCT();
        this.convMap.align = (byte)-1;
        this.currentIndex = 0;
        this.fixRecLen = 0;
        this.openedWithResources = false;
    }

    public int abort() {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.Abort();
    }

    public int AddRecord(byte[] byArray) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.AddRecord(this.filno, byArray);
    }

    public int AddVRecord(byte[] byArray, int n) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.AddVRecord(this.filno, byArray, n);
    }

    public long begin(Enums.TRAN_BEGIN_MODE tRAN_BEGIN_MODE) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.Begin(tRAN_BEGIN_MODE.value);
    }

    public int commit(Enums.TRAN_END_MODE tRAN_END_MODE) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.Commit(tRAN_END_MODE.value);
    }

    public void closeFile() throws JCtree.CtreeException {
        if (this.opened) {
            this.ctree.SwitchCtree(this.regId);
            this.ret = this.ctree.CloseCtFile(this.filno);
        }
        if (this.ret != 0) {
            throw new JCtree.CtreeException("CloseFile", this.ret);
        }
        this.opened = false;
    }

    public void closeFileWithResource() throws JCtree.CtreeException {
        if (this.opened) {
            this.ctree.SwitchCtree(this.regId);
            this.ret = this.ctree.CloseRFile(this.filno);
        }
        if (this.ret != 0) {
            throw new JCtree.CtreeException("CloseFileWithResource", this.ret);
        }
        this.opened = false;
    }

    public long currentFileOffset() {
        this.ctree.SwitchCtree(this.regId);
        int n = this.ctree.CurrentFileOffset(this.filno);
        int n2 = this.ctree.GetHighWord();
        return this.ctree.Get64(n2, n);
    }

    public int deleteRecord() {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.DeleteRecord(this.filno);
    }

    public int deleteVRecord() {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.DeleteVRecord(this.filno);
    }

    public int lastRecord(byte[] byArray) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.LastRecord((short)(this.filno + this.currentIndex), byArray);
    }

    public int lastVRecord(byte[] byArray) throws JCtree.CtreeException {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.LastVRecord((short)(this.filno + this.currentIndex), byArray);
    }

    public int lockCtData(Enums.LOCK_MODE lOCK_MODE, long l) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.LockCtData(this.filno, lOCK_MODE.value, l);
    }

    public int lockIsam(Enums.LOCK_MODE lOCK_MODE) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.LockIsam(lOCK_MODE.value);
    }

    public int nextRecord(byte[] byArray) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.NextRecord((short)(this.filno + this.currentIndex), byArray);
    }

    public int nextVRecord(byte[] byArray) throws JCtree.CtreeException {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.NextVRecord((short)(this.filno + this.currentIndex), byArray);
    }

    public long numberOfKeyEntries() {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.NbrOfKeyEntries((short)(this.filno + this.currentIndex));
    }

    public short openFile(Enums.FILE_MODE fILE_MODE) throws JCtree.CtreeException {
        return this._openFile(fILE_MODE, false);
    }

    public short openFileWithResource(Enums.FILE_MODE fILE_MODE) throws JCtree.CtreeException {
        return this._openFile(fILE_MODE, true);
    }

    public int previousRecord(byte[] byArray) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.PreviousRecord((short)(this.filno + this.currentIndex), byArray);
    }

    public int previousVRecord(byte[] byArray) throws JCtree.CtreeException {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.PreviousVRecord((short)(this.filno + this.currentIndex), byArray);
    }

    public int reReadRecord(byte[] byArray) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.ReReadRecord(this.filno, byArray);
    }

    public int reReadVRecord(byte[] byArray) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.ReReadVRecord(this.filno, byArray);
    }

    public int reWriteRecord(byte[] byArray) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.ReWriteRecord(this.filno, byArray);
    }

    public int reWritePartialRecord(byte[] byArray, int n) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.ReWritePartialRecord(this.filno, byArray, n);
    }

    public int reWriteVRecord(byte[] byArray, int n) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.ReWriteVRecord(this.filno, byArray, n);
    }

    public int setRecord(long l, byte[] byArray, int n) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.SetRecord(this.filno, l, byArray, n);
    }

    public int vRecordLength() {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.VRecordLength(this.filno);
    }

    private short _openFile(Enums.FILE_MODE fILE_MODE, boolean bl) throws JCtree.CtreeException {
        this.openedWithResources = bl;
        if (this.opened) {
            throw new JCtree.CtreeException("OpenFile - File already opened");
        }
        this.ctree.SwitchCtree(this.regId);
        this.openedMode = fILE_MODE;
        this.filno = this.getFileName().contains("!") ? this.ctree.AvailableFileNbr(2) : this.ctree.AvailableFileNbr(1);
        if (this.filno == -1) {
            throw new JCtree.CtreeException("OpenFile - Not enough file numbers available");
        }
        if (this.autoSizeBuffers) {
            int n;
            boolean bl2 = false;
            int n2 = n = 16;
            n = 16;
            n2 = 16;
            do {
                this.ret = 0;
                this.ctree.CloseIsam();
                if (this.logPath != null) {
                    this.ret = this.ctree.SetLogPath(this.logPath, this.logMode);
                }
                short s = this.ctree.InitISAMXtd(32, 128, n2, 32, Enums.USER_PROF.setValue(Enums.USER_PROF.NTKEY.value()), "ADMIN", "ADMIN", "");
                this.ctree.SwitchCtree(this.regId);
                if (s != 0) {
                    throw new JCtree.CtreeException("InitISAMXtd", s);
                }
                int n3 = this.getFileName().indexOf(33);
                if (n3 > -1) {
                    String string = this.getFileName().substring(0, n3);
                    this.ret = this.ctree.OpenCtFile(this.filno, string, fILE_MODE.value | Enums.FILE_MODE.SUPERFILE.value);
                    if (this.ret == 0) {
                        this.filno = (short)(this.filno + 4);
                    }
                }
                if (this.ret == 0) {
                    if (bl) {
                        this.ret = this.ctree.OpenFileWithResource(this.filno, this.getFileName(), fILE_MODE.value);
                        this.ret = this.ret == -1 ? this.ctree.GetIsamError() : 0;
                    } else {
                        this.ret = this.ctree.OpenCtFile(this.filno, this.getFileName(), fILE_MODE.value);
                    }
                }
                if (this.ret == Enums.ERROR_CODE.KSIZ_ERR.value) {
                    if (bl2) {
                        n = (short)(n / 2);
                        n2 = (short)(n2 + n);
                    } else {
                        n = n2;
                        n2 = (short)(n2 + n);
                    }
                }
                if (this.ret != Enums.ERROR_CODE.SPAG_ERR.value) continue;
                n = (short)(n / 2);
                n2 = (short)(n2 - n);
                bl2 = true;
            } while ((this.ret == Enums.ERROR_CODE.KSIZ_ERR.value || this.ret == Enums.ERROR_CODE.SPAG_ERR.value) && n2 <= 1024);
        } else if (bl) {
            this.ctree.SwitchCtree(this.regId);
            this.ret = this.ctree.OpenFileWithResource(this.filno, this.getFileName(), fILE_MODE.value);
            this.ret = this.ret == -1 ? this.ctree.GetIsamError() : 0;
        } else {
            this.ctree.SwitchCtree(this.regId);
            this.ret = this.ctree.OpenCtFile(this.filno, this.getFileName(), fILE_MODE.value);
        }
        if (this.ret != 0) {
            throw new JCtree.CtreeException("OpenCtFile", this.ret);
        }
        this.ctree.SwitchCtree(this.regId);
        this.fixRecLen = this.ctree.GetCtFileInfo(this.filno, Enums.GETFIL_MODE.RECLEN);
        this.opened = true;
        this.withRes = bl;
        return this.filno;
    }

    public int fillBuffer(byte[] byArray, ArrayList<Structures.DATOBJ_STRUCT> arrayList) throws JCtree.CtreeException {
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Serializable serializable;
            Structures.DATOBJ_STRUCT dATOBJ_STRUCT = arrayList.get(i);
            Enums.FIELD_TYPE fIELD_TYPE = dATOBJ_STRUCT.ftype;
            if (!bl) {
                n = dATOBJ_STRUCT.fadr;
            }
            if (fIELD_TYPE != Enums.FIELD_TYPE.VSTRING && fIELD_TYPE != Enums.FIELD_TYPE.VPSTRING && fIELD_TYPE != Enums.FIELD_TYPE.V2STRING && fIELD_TYPE != Enums.FIELD_TYPE.V4STRING && fIELD_TYPE != Enums.FIELD_TYPE.UNICODE && fIELD_TYPE != Enums.FIELD_TYPE.UNICODE2) {
                if (n + dATOBJ_STRUCT.flen > byArray.length) {
                    serializable = new JCtree.CtreeException("FillBuffer - Buffer too small");
                    throw serializable;
                }
            } else {
                bl = true;
            }
            try {
                switch (fIELD_TYPE) {
                    case BOOL: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = false;
                        }
                        byArray[n] = (Boolean)dATOBJ_STRUCT.data == true ? (byte)1 : 0;
                        n += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case CHAR: 
                    case CHARU: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = (short)0;
                        }
                        serializable = (Short)dATOBJ_STRUCT.data;
                        byArray[n] = serializable.byteValue();
                        n += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case SFLOAT: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = Float.valueOf(0.0f);
                        }
                        byte[] byArray2 = CtreeFile.floatToByteArray(((Float)dATOBJ_STRUCT.data).floatValue());
                        System.arraycopy(byArray2, 0, byArray, n, 4);
                        n += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case EFLOAT: 
                    case DFLOAT: 
                    case TIMES: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = 0.0;
                        }
                        byte[] byArray2 = CtreeFile.doubleToByteArray((Double)dATOBJ_STRUCT.data);
                        System.arraycopy(byArray2, 0, byArray, n, 8);
                        n += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case INT2: 
                    case INT2U: {
                        if (dATOBJ_STRUCT.data == null) {
                            int n2 = 0;
                            dATOBJ_STRUCT.data = n2;
                        }
                        Number number = (Integer)dATOBJ_STRUCT.data;
                        byte[] byArray2 = CtreeFile.shortToByteArray(((Integer)number).shortValue());
                        System.arraycopy(byArray2, 0, byArray, n, 2);
                        n += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case INT4: 
                    case INT4U: {
                        if (dATOBJ_STRUCT.data == null) {
                            long l = 0L;
                            dATOBJ_STRUCT.data = l;
                        }
                        Number number = (Long)dATOBJ_STRUCT.data;
                        byte[] byArray2 = CtreeFile.intToByteArray(((Long)number).intValue());
                        System.arraycopy(byArray2, 0, byArray, n, 4);
                        n += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case MONEY: 
                    case DATE: 
                    case TIME: {
                        if (dATOBJ_STRUCT.data == null) {
                            int n3 = 0;
                            dATOBJ_STRUCT.data = n3;
                        }
                        byte[] byArray2 = CtreeFile.intToByteArray(((Integer)dATOBJ_STRUCT.data).intValue());
                        System.arraycopy(byArray2, 0, byArray, n, 4);
                        n += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case INT8: 
                    case INT8U: 
                    case CURRENCY: {
                        if (dATOBJ_STRUCT.data == null) {
                            long l = 0L;
                            dATOBJ_STRUCT.data = l;
                        }
                        byte[] byArray2 = CtreeFile.longToByteArray((Long)dATOBJ_STRUCT.data);
                        System.arraycopy(byArray2, 0, byArray, n, 8);
                        n += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case NUMBER: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = new byte[19];
                        }
                        System.arraycopy((byte[])dATOBJ_STRUCT.data, 0, byArray, n, 19);
                        n += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case ARRAY: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = new byte[dATOBJ_STRUCT.flen];
                        }
                        System.arraycopy((byte[])dATOBJ_STRUCT.data, 0, byArray, n, dATOBJ_STRUCT.flen);
                        n += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case FSTRING: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = "";
                        }
                        String string = (String)dATOBJ_STRUCT.data;
                        byte[] byArray2 = string.getBytes(Charset.defaultCharset());
                        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                        n += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case FUNICODE: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = "";
                        }
                        String string = (String)dATOBJ_STRUCT.data;
                        byte[] byArray2 = string.getBytes("UTF-16");
                        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                        n += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case FPSTRING: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = "";
                        }
                        String string = (String)dATOBJ_STRUCT.data;
                        byte[] byArray2 = string.getBytes(Charset.defaultCharset());
                        byArray[n] = (byte)byArray2.length;
                        System.arraycopy(byArray2, 0, byArray, n + 1, byArray2.length);
                        n += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case F2STRING: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = "";
                        }
                        String string = (String)dATOBJ_STRUCT.data;
                        byte[] byArray2 = string.getBytes(Charset.defaultCharset());
                        byte[] byArray3 = CtreeFile.shortToByteArray((short)byArray2.length);
                        System.arraycopy(byArray3, 0, byArray, n, 2);
                        System.arraycopy(byArray2, 0, byArray, n += 2, byArray2.length);
                        n += dATOBJ_STRUCT.flen - 2;
                        break;
                    }
                    case FUNICODE2: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = "";
                        }
                        String string = (String)dATOBJ_STRUCT.data;
                        byte[] byArray2 = string.getBytes("UTF-16");
                        byte[] byArray3 = CtreeFile.shortToByteArray((short)byArray2.length);
                        System.arraycopy(byArray3, 0, byArray, n, 2);
                        System.arraycopy(byArray2, 0, byArray, n += 2, byArray2.length);
                        n += dATOBJ_STRUCT.flen - 2;
                        break;
                    }
                    case F4STRING: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = "";
                        }
                        String string = (String)dATOBJ_STRUCT.data;
                        byte[] byArray2 = string.getBytes(Charset.defaultCharset());
                        byte[] byArray3 = CtreeFile.intToByteArray(byArray2.length);
                        System.arraycopy(byArray3, 0, byArray, n, 4);
                        System.arraycopy(byArray2, 0, byArray, n += 4, byArray2.length);
                        n += dATOBJ_STRUCT.flen - 4;
                        break;
                    }
                    case VSTRING: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = "";
                        }
                        String string = (String)dATOBJ_STRUCT.data;
                        byte[] byArray2 = string.getBytes(Charset.defaultCharset());
                        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                        n += byArray2.length;
                        byArray[n++] = 0;
                        break;
                    }
                    case UNICODE: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = "";
                        }
                        String string = (String)dATOBJ_STRUCT.data;
                        byte[] byArray2 = string.getBytes("UTF-16");
                        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                        n += byArray2.length;
                        byArray[n++] = 0;
                        byArray[n++] = 0;
                        break;
                    }
                    case VPSTRING: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = "";
                        }
                        String string = (String)dATOBJ_STRUCT.data;
                        byte[] byArray2 = string.getBytes(Charset.defaultCharset());
                        byArray[n] = (byte)byArray2.length;
                        System.arraycopy(byArray2, 0, byArray, ++n, byArray2.length);
                        n += byArray2.length;
                        break;
                    }
                    case V2STRING: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = "";
                        }
                        String string = (String)dATOBJ_STRUCT.data;
                        byte[] byArray2 = string.getBytes(Charset.defaultCharset());
                        byte[] byArray3 = CtreeFile.shortToByteArray((short)byArray2.length);
                        System.arraycopy(byArray3, 0, byArray, n, 2);
                        System.arraycopy(byArray2, 0, byArray, n += 2, byArray2.length);
                        n += byArray2.length;
                        break;
                    }
                    case UNICODE2: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = "";
                        }
                        String string = (String)dATOBJ_STRUCT.data;
                        byte[] byArray2 = string.getBytes("UTF-16");
                        byte[] byArray3 = CtreeFile.shortToByteArray((short)byArray2.length);
                        System.arraycopy(byArray3, 0, byArray, n, 2);
                        System.arraycopy(byArray2, 0, byArray, n += 2, byArray2.length);
                        n += byArray2.length;
                        break;
                    }
                    case V4STRING: {
                        if (dATOBJ_STRUCT.data == null) {
                            dATOBJ_STRUCT.data = "";
                        }
                        String string = (String)dATOBJ_STRUCT.data;
                        byte[] byArray2 = string.getBytes(Charset.defaultCharset());
                        byte[] byArray3 = CtreeFile.intToByteArray(byArray2.length);
                        System.arraycopy(byArray3, 0, byArray, n, 4);
                        System.arraycopy(byArray2, 0, byArray, n += 4, byArray2.length);
                        n += byArray2.length;
                        break;
                    }
                    default: {
                        JCtree.CtreeException ctreeException = new JCtree.CtreeException("FillBuffer - Invalid Type : " + fIELD_TYPE.toString());
                        throw ctreeException;
                    }
                }
                continue;
            }
            catch (Exception exception) {
                throw new JCtree.CtreeException("Invalid Value - " + exception.getMessage(), 999);
            }
        }
        return n;
    }

    public void fillDoda(ArrayList<Structures.DATOBJ_STRUCT> arrayList, byte[] byArray) throws JCtree.CtreeException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        Structures.CONVMAP_STRUCT cONVMAP_STRUCT = null;
        this.ctree.SwitchCtree(this.regId);
        try {
            cONVMAP_STRUCT = this.getSchemaMap();
        }
        catch (JCtree.CtreeException ctreeException) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Structures.DATOBJ_STRUCT dATOBJ_STRUCT = arrayList.get(i);
            dATOBJ_STRUCT.formattedValue = null;
            Enums.FIELD_TYPE fIELD_TYPE = dATOBJ_STRUCT.ftype;
            if (!bl) {
                n3 = dATOBJ_STRUCT.fadr;
            }
            if (fIELD_TYPE != Enums.FIELD_TYPE.VSTRING && fIELD_TYPE != Enums.FIELD_TYPE.VPSTRING && fIELD_TYPE != Enums.FIELD_TYPE.V2STRING && fIELD_TYPE != Enums.FIELD_TYPE.V4STRING && fIELD_TYPE != Enums.FIELD_TYPE.UNICODE && fIELD_TYPE != Enums.FIELD_TYPE.UNICODE2) {
                if (n3 + dATOBJ_STRUCT.flen > byArray.length) {
                    return;
                }
            } else if (n3 + dATOBJ_STRUCT.flen < this.fixRecLen) {
                if (n3 + dATOBJ_STRUCT.flen > byArray.length) {
                    return;
                }
                n = n3;
            } else if (bl) {
                n = n3;
            } else {
                bl = true;
                n = n3 = this.fixRecLen;
            }
            try {
                switch (fIELD_TYPE) {
                    case BOOL: {
                        dATOBJ_STRUCT.data = CtreeFile.byteArraytoBoolean(byArray, n3);
                        n3 += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case CHAR: 
                    case CHARU: {
                        dATOBJ_STRUCT.data = (short)byArray[n3];
                        n3 += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case SFLOAT: {
                        dATOBJ_STRUCT.data = Float.valueOf(CtreeFile.byteArrayToSingle(byArray, n3));
                        n3 += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case EFLOAT: 
                    case DFLOAT: 
                    case TIMES: {
                        dATOBJ_STRUCT.data = CtreeFile.byteArrayToDouble(byArray, n3);
                        n3 += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case INT2: 
                    case INT2U: {
                        dATOBJ_STRUCT.data = (int)CtreeFile.byteArrayToShort(byArray, n3);
                        n3 += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case INT4: 
                    case INT4U: {
                        dATOBJ_STRUCT.data = (long)CtreeFile.byteArrayToInt(byArray, n3);
                        n3 += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case MONEY: 
                    case DATE: 
                    case TIME: {
                        dATOBJ_STRUCT.data = CtreeFile.byteArrayToInt(byArray, n3);
                        n3 += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case INT8: 
                    case INT8U: 
                    case CURRENCY: {
                        dATOBJ_STRUCT.data = CtreeFile.byteArrayToLong(byArray, n3);
                        n3 += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case NUMBER: 
                    case ARRAY: 
                    case FSTRING: 
                    case FUNICODE: {
                        byte[] byArray2 = new byte[dATOBJ_STRUCT.flen];
                        System.arraycopy(byArray, n3, byArray2, 0, dATOBJ_STRUCT.flen);
                        dATOBJ_STRUCT.data = byArray2;
                        n3 += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case FPSTRING: {
                        n2 = byArray[n3];
                        byte[] byArray2 = new byte[n2];
                        System.arraycopy(byArray, n3 + 1, byArray2, 0, n2);
                        dATOBJ_STRUCT.data = byArray2;
                        n3 += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case F2STRING: 
                    case FUNICODE2: {
                        n2 = CtreeFile.byteArrayToShort(byArray, n3);
                        byte[] byArray2 = new byte[n2];
                        System.arraycopy(byArray, n3 + 2, byArray2, 0, n2);
                        dATOBJ_STRUCT.data = byArray2;
                        n3 += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case F4STRING: {
                        n2 = CtreeFile.byteArrayToInt(byArray, n3);
                        byte[] byArray2 = new byte[n2];
                        System.arraycopy(byArray, n3 + 4, byArray2, 0, n2);
                        dATOBJ_STRUCT.data = byArray2;
                        n3 += dATOBJ_STRUCT.flen;
                        break;
                    }
                    case VSTRING: {
                        while (n < byArray.length && byArray[n] != cONVMAP_STRUCT.flddelm) {
                            ++n;
                        }
                        byte[] byArray2 = new byte[n - n3];
                        System.arraycopy(byArray, n3, byArray2, 0, n - n3);
                        dATOBJ_STRUCT.data = byArray2;
                        n3 = ++n;
                        break;
                    }
                    case UNICODE: {
                        while (n < byArray.length && byArray[n] != cONVMAP_STRUCT.flddelm) {
                            n += 2;
                        }
                        byte[] byArray2 = new byte[n - n3];
                        System.arraycopy(byArray, n3, byArray2, 0, n - n3);
                        dATOBJ_STRUCT.data = byArray2;
                        n3 = n + 2;
                        break;
                    }
                    case VPSTRING: {
                        n2 = byArray[n3];
                        byte[] byArray2 = new byte[n2];
                        System.arraycopy(byArray, n3 + 1, byArray2, 0, n2);
                        dATOBJ_STRUCT.data = byArray2;
                        n3 = n3 + 1 + n2;
                        break;
                    }
                    case V2STRING: 
                    case UNICODE2: {
                        n2 = CtreeFile.byteArrayToShort(byArray, n3);
                        byte[] byArray2 = new byte[n2];
                        System.arraycopy(byArray, n3 + 2, byArray2, 0, n2);
                        dATOBJ_STRUCT.data = byArray2;
                        n3 = n3 + 2 + n2;
                        break;
                    }
                    case V4STRING: {
                        n2 = CtreeFile.byteArrayToInt(byArray, n3);
                        byte[] byArray2 = new byte[n2];
                        System.arraycopy(byArray, n3 + 4, byArray2, 0, n2);
                        dATOBJ_STRUCT.data = byArray2;
                        n3 = n3 + 4 + n2;
                        break;
                    }
                    default: {
                        JCtree.CtreeException ctreeException = new JCtree.CtreeException("FillDoda - Invalid Type :" + (Object)((Object)Enums.FIELD_TYPE.setValue(fIELD_TYPE.value)));
                        throw ctreeException;
                    }
                }
                continue;
            }
            catch (Exception exception) {
                boolean bl2 = false;
            }
        }
    }

    public void fillDodaFormatted(ArrayList<Structures.DATOBJ_STRUCT> arrayList, byte[] byArray) throws JCtree.CtreeException {
        this.ctree.SwitchCtree(this.regId);
        this.fillDoda(arrayList, byArray);
        block18: for (int i = 0; i < arrayList.size(); ++i) {
            Structures.DATOBJ_STRUCT dATOBJ_STRUCT = arrayList.get(i);
            Enums.FIELD_TYPE fIELD_TYPE = dATOBJ_STRUCT.ftype;
            if (dATOBJ_STRUCT.data == null) continue;
            switch (fIELD_TYPE) {
                case BOOL: {
                    dATOBJ_STRUCT.formattedValue = dATOBJ_STRUCT.data.toString();
                    continue block18;
                }
                case ARRAY: {
                    dATOBJ_STRUCT.formattedValue = this.byteArrayToFormattedString((byte[])dATOBJ_STRUCT.data);
                    continue block18;
                }
                case NUMBER: {
                    dATOBJ_STRUCT.formattedValue = Converters.ConvertNumberToString((byte[])dATOBJ_STRUCT.data);
                    continue block18;
                }
                case MONEY: {
                    dATOBJ_STRUCT.formattedValue = Converters.ConvertMoneyToString((Integer)dATOBJ_STRUCT.data);
                    continue block18;
                }
                case CURRENCY: {
                    dATOBJ_STRUCT.formattedValue = Converters.ConvertCurrencyToString((Long)dATOBJ_STRUCT.data);
                    continue block18;
                }
                case DATE: {
                    DateFormat dateFormat;
                    Calendar calendar;
                    try {
                        if ((Integer)dATOBJ_STRUCT.data > 0) {
                            calendar = Converters.ConvertDateToCalendar((Integer)dATOBJ_STRUCT.data);
                            dateFormat = SimpleDateFormat.getDateInstance(3);
                            this.doShortTo4((SimpleDateFormat)dateFormat);
                            dATOBJ_STRUCT.formattedValue = dateFormat.format(calendar.getTime());
                            continue block18;
                        }
                        dATOBJ_STRUCT.formattedValue = "";
                    }
                    catch (Exception exception) {
                        dATOBJ_STRUCT.formattedValue = "Invalid Value";
                    }
                    continue block18;
                }
                case TIME: {
                    DateFormat dateFormat;
                    Calendar calendar;
                    try {
                        if ((Integer)dATOBJ_STRUCT.data > 0) {
                            calendar = Converters.ConvertTimeToCalendar((Integer)dATOBJ_STRUCT.data);
                            dateFormat = DateFormat.getTimeInstance(2);
                            dATOBJ_STRUCT.formattedValue = dateFormat.format(calendar.getTime());
                            continue block18;
                        }
                        dATOBJ_STRUCT.formattedValue = "";
                    }
                    catch (Exception exception) {
                        dATOBJ_STRUCT.formattedValue = "Invalid Value";
                    }
                    continue block18;
                }
                case TIMES: {
                    DateFormat dateFormat;
                    Calendar calendar;
                    try {
                        if ((Double)dATOBJ_STRUCT.data != 0.0) {
                            calendar = Converters.ConvertDateTimeToCalendar((Double)dATOBJ_STRUCT.data);
                            dateFormat = SimpleDateFormat.getDateTimeInstance(3, 2);
                            this.doShortTo4((SimpleDateFormat)dateFormat);
                            dATOBJ_STRUCT.formattedValue = dateFormat.format(calendar.getTime());
                            continue block18;
                        }
                        dATOBJ_STRUCT.formattedValue = "";
                    }
                    catch (Exception exception) {
                        dATOBJ_STRUCT.formattedValue = "Invalid Value";
                    }
                    continue block18;
                }
                case FSTRING: 
                case FPSTRING: 
                case F2STRING: 
                case F4STRING: 
                case VSTRING: 
                case VPSTRING: 
                case V2STRING: 
                case V4STRING: {
                    dATOBJ_STRUCT.formattedValue = new String((byte[])dATOBJ_STRUCT.data, Charset.forName("iso-8859-1"));
                    continue block18;
                }
                case FUNICODE: 
                case FUNICODE2: 
                case UNICODE: 
                case UNICODE2: {
                    dATOBJ_STRUCT.formattedValue = new String((byte[])dATOBJ_STRUCT.data, Charset.forName("UTF-16"));
                    continue block18;
                }
                default: {
                    dATOBJ_STRUCT.formattedValue = dATOBJ_STRUCT.data.toString();
                }
            }
        }
    }

    public void doShortTo4(SimpleDateFormat simpleDateFormat) {
        String string = simpleDateFormat.toPattern();
        int n = string.length();
        int n2 = string.lastIndexOf(121) + 1;
        string = string.substring(0, n2) + "yy" + (n2 < n ? string.substring(n2, n) : "");
        simpleDateFormat.applyPattern(string);
    }

    public int firstRecord(byte[] byArray) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.FirstRecord((short)(this.filno + this.currentIndex), byArray);
    }

    public int firstVRecord(byte[] byArray) throws JCtree.CtreeException {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.FirstVRecord((short)(this.filno + this.currentIndex), byArray);
    }

    public int getCtFileInfo(Enums.GETFIL_MODE gETFIL_MODE) {
        this.ctree.SwitchCtree(this.regId);
        return this.ctree.GetCtFileInfo(this.filno, gETFIL_MODE);
    }

    public long getCtResource(byte[] byArray, byte[] byArray2, int n) {
        this.ctree.SwitchCtree(this.regId);
        int n2 = this.ctree.GetCtResource(this.filno, byArray, byArray2, n);
        int n3 = this.ctree.GetHighWord();
        return this.ctree.Get64(n3, n2);
    }

    public boolean isSuperfileHost() {
        if (this.isSuperfileHost == -1) {
            int n = this.getCtFileInfo(Enums.GETFIL_MODE.FILMOD);
            this.isSuperfileHost = (n & Enums.FILE_MODE.SUPERFILE.value) == Enums.FILE_MODE.SUPERFILE.value ? 1 : 0;
        }
        return this.isSuperfileHost != 0;
    }

    public boolean isIndex() {
        if (this.fileType == Enums.FILE_TYPE.UNKNOW) {
            int n = this.getCtFileInfo(Enums.GETFIL_MODE.FILTYP);
            if (n == Enums.FILE_TYPE.DATA_FILE.value) {
                this.fileType = Enums.FILE_TYPE.DATA_FILE;
            } else if (n == Enums.FILE_TYPE.INDX_FILE.value) {
                this.fileType = Enums.FILE_TYPE.INDX_FILE;
            } else if (n == Enums.FILE_TYPE.VDAT_FILE.value) {
                this.fileType = Enums.FILE_TYPE.VDAT_FILE;
            }
        }
        return this.fileType == Enums.FILE_TYPE.INDX_FILE;
    }

    public ArrayList<Structures.DATOBJ_STRUCT> getDodaArray() {
        if (this.dodaArray == null || this.dodaArray.isEmpty()) {
            this.ctree.SwitchCtree(this.regId);
            try {
                this.convMap = this.ctree.GetSchemaMap(this.filno);
                this.dodaArray = this.ctree.GetDodaArray(this.filno);
            }
            catch (JCtree.CtreeException ctreeException) {
                // empty catch block
            }
        }
        return this.dodaArray;
    }

    public Structures.HEADER_STRUCT getHeader(int n) throws JCtree.CtreeException {
        this.ctree.SwitchCtree(this.regId);
        byte[] byArray = new byte[8192];
        int n2 = this.ctree.GetFileHeader((short)(this.filno + n), byArray);
        Structures.HEADER_STRUCT hEADER_STRUCT = new Structures.HEADER_STRUCT();
        Class<?> clazz = hEADER_STRUCT.getClass();
        Field[] fieldArray = clazz.getFields();
        int n3 = 8;
        for (Field field : fieldArray) {
            Class<?> clazz2 = field.getType();
            String string = clazz2.getName();
            try {
                if (string.equals("long")) {
                    long l = CtreeFile.byteArrayToLong(byArray, n3);
                    field.setLong(hEADER_STRUCT, l);
                    n3 += 8;
                    continue;
                }
                if (string.equals("int")) {
                    int n4 = CtreeFile.byteArrayToInt(byArray, n3);
                    field.setInt(hEADER_STRUCT, n4);
                    n3 += 4;
                    continue;
                }
                if (string.equals("short")) {
                    short s = CtreeFile.byteArrayToShort(byArray, n3);
                    field.setShort(hEADER_STRUCT, s);
                    n3 += 2;
                    continue;
                }
                if (!string.equals("byte")) continue;
                byte by = byArray[n3];
                field.setByte(hEADER_STRUCT, by);
                ++n3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.getLogger(CtreeFile.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(CtreeFile.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            }
        }
        return hEADER_STRUCT;
    }

    public static boolean byteArraytoBoolean(byte[] byArray, int n) {
        return byArray[n] != 0;
    }

    public static byte[] shortToByteArray(short s) {
        return new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
    }

    public static short byteArrayToShort(byte[] byArray, int n) {
        short s = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = byArray[i + n] & 0xFF;
            s = (short)(s + (n2 << 8 * i));
        }
        return s;
    }

    public static byte[] intToByteArray(long l) {
        return new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL)};
    }

    public static int byteArrayToInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            int n3 = byArray[i + n] & 0xFF;
            n2 += n3 << 8 * i;
        }
        return n2;
    }

    public static byte[] longToByteArray(long l) {
        return new byte[]{(byte)(l & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)(l >>> 32 & 0xFFL), (byte)(l >>> 40 & 0xFFL), (byte)(l >>> 48 & 0xFFL), (byte)(l >>> 56 & 0xFFL)};
    }

    public static long byteArrayToLong(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            long l2 = byArray[i + n] & 0xFF;
            l += l2 << 8 * i;
        }
        return l;
    }

    public static float byteArrayToSingle(byte[] byArray, int n) {
        int n2 = CtreeFile.byteArrayToInt(byArray, n);
        return Float.intBitsToFloat(n2);
    }

    public static byte[] doubleToByteArray(double d) {
        byte[] byArray = new byte[8];
        long l = Double.doubleToLongBits(d);
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(l >> i * 8 & 0xFFL);
        }
        return byArray;
    }

    public static byte[] floatToByteArray(float f) {
        byte[] byArray = new byte[4];
        int n = Float.floatToIntBits(f);
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(n >> i * 8 & 0xFF);
        }
        return byArray;
    }

    public static double byteArrayToDouble(byte[] byArray, int n) {
        long l = CtreeFile.byteArrayToLong(byArray, n);
        return Double.longBitsToDouble(l);
    }

    public static String byteArrayToString(byte[] byArray, int n) {
        int n2;
        for (n2 = n; n2 < byArray.length && byArray[n2] != 0; ++n2) {
        }
        return new String(byArray, n, n2 - n);
    }

    private String byteArrayToFormattedString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append("-");
            }
            stringBuilder.append(String.format("%02X", byArray[i]));
        }
        return stringBuilder.toString();
    }

    public Structures.IFIL_STRUCT getIfil() {
        if (this.ifil == null) {
            this.ctree.SwitchCtree(this.regId);
            try {
                this.ifil = this.ctree.GetIFile(this.filno);
                this.ifil.tfilno = this.filno;
                this.ifil.isValid = true;
            }
            catch (JCtree.CtreeException ctreeException) {
                this.ifil = new Structures.IFIL_STRUCT();
                this.ifil.isValid = false;
            }
        }
        return this.ifil;
    }

    public int getNumberOfFields() throws JCtree.CtreeException {
        if (this.convMap.align == -1) {
            this.convMap = this.ctree.GetSchemaMap(this.filno);
        }
        return this.convMap.nbrflds;
    }

    public Integer getNumberOfIndexMembers() {
        if (this.numberOfIndexMembers == -1) {
            this.numberOfIndexMembers = this.getCtFileInfo(Enums.GETFIL_MODE.NKYMEM);
        }
        return this.numberOfIndexMembers;
    }

    public String getSymbolicNames(Enums.GETNAM_MODE gETNAM_MODE) throws JCtree.CtreeException {
        StringBuilder stringBuilder = new StringBuilder(256);
        this.ctree.SwitchCtree(this.regId);
        this.ret = this.ctree.GetSymbolicNames(this.filno, stringBuilder, gETNAM_MODE);
        if (this.ret != 0 && this.ret != 101) {
            throw new JCtree.CtreeException("GetSymbolicNames", this.ret);
        }
        return stringBuilder.toString();
    }

    public Structures.XCREBLK_STRUCT getXtdCreateBlock() throws JCtree.CtreeException {
        this.ctree.SwitchCtree(this.regId);
        this.ctree.ClearLastError();
        Structures.XCREBLK_STRUCT xCREBLK_STRUCT = this.ctree.GetXtdCreateBlock(this.filno);
        if (this.ctree.GetLastError() != 0) {
            throw new JCtree.CtreeException("GetXtdCreateBlock", this.ret);
        }
        return xCREBLK_STRUCT;
    }

    public Structures.CONVMAP_STRUCT getSchemaMap() throws JCtree.CtreeException {
        if (this.convMap == null) {
            this.convMap = this.ctree.GetSchemaMap(this.filno);
        }
        return this.convMap;
    }

    public ArrayList<String> getSuperfileMembers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        short s = 1;
        while (n == 0) {
            this.ctree.SwitchCtree(this.regId);
            String string = this.ctree.GetSuperFileNames(this.filno, s);
            n = this.ctree.GetLastError();
            if (n == 0) {
                arrayList.add(string);
            }
            s = (short)(s + 1);
        }
        return arrayList;
    }

    public Enums.FILE_TYPE getFileType() {
        if (this.fileType == Enums.FILE_TYPE.UNKNOW) {
            this.isIndex();
        }
        return this.fileType;
    }

    public int getRecordLength() {
        if (this.fixRecLen == 0) {
            this.fixRecLen = this.getCtFileInfo(Enums.GETFIL_MODE.RECLEN);
        }
        return this.fixRecLen;
    }

    public int getNodeSize() {
        return this.getCtFileInfo(Enums.GETFIL_MODE.NODSIZ);
    }

    public int getLastError() {
        return this.ctree.GetLastError();
    }

    public Integer getLogicalFileSize() {
        return this.getCtFileInfo(Enums.GETFIL_MODE.LOGSIZ);
    }

    public Long getORDKey(byte[] byArray, long l, byte[] byArray2) {
        return this.ctree.GetORDKey((short)(this.filno + this.currentIndex), byArray, l, byArray2);
    }

    public Integer getPhysicalFileSize() {
        return this.getCtFileInfo(Enums.GETFIL_MODE.PHYSIZ);
    }

    public int getFileMode() {
        int n = this.getCtFileInfo(Enums.GETFIL_MODE.FILMOD);
        return n;
    }

    public int getOpenedMode() {
        return this.openedMode.value;
    }

    public int getFileAlignment() {
        return this.getCtFileInfo(Enums.GETFIL_MODE.ALIGNM);
    }

    public Long getNumberOfRecords() {
        if (this.numberOfRecords == -1L) {
            this.ctree.SwitchCtree(this.regId);
            int n = this.ctree.NbrOfRecords(this.filno);
            int n2 = this.ctree.GetHighWord();
            this.numberOfRecords = this.ctree.Get64(n2, n);
        }
        return this.numberOfRecords;
    }

    public int getNumberOfIndices() {
        if (this.ifil.isValid) {
            return this.ifil.dnumidx;
        }
        return -1;
    }

    public Long getNumberOfKeyEntries() {
        if (this.numberOfKeys == -1L) {
            int n = this.filno;
            if (!this.isIndex()) {
                n = this.filno + 1;
            }
            this.ctree.SwitchCtree(this.regId);
            int n2 = this.ctree.NbrOfKeyEntries((short)n);
            int n3 = this.ctree.GetHighWord();
            this.numberOfKeys = this.ctree.Get64(n3, n2);
        }
        return this.numberOfKeys;
    }

    public boolean isOpen() {
        return this.opened;
    }

    public boolean isVariableLength() {
        return this.fileType == Enums.FILE_TYPE.VDAT_FILE;
    }

    public String getFileName() {
        return this.fileName;
    }
}

