/*
 * Decompiled with CFR 0.152.
 */
package Isam;

import Isam.CtreeFile;
import Isam.Enums;
import Isam.JCtree;

public class CtreeSession {
    static final short START_SECT = 16;
    static final short END_SECT = 1024;
    static final short CTREE_FILES = 128;
    static final short DATA_BUFFERS = 32;
    static final short INDEX_BUFFERS = 32;
    static boolean autoSizeBuffers;
    static String logPath;
    static Enums.LOG_MODE logMode;
    static boolean ctreeInitialized;
    static boolean alreadyInitialized;
    static int instances;
    String regId = "myCtree";
    private String libName = "mtclijni";
    boolean sessionInitialized;
    JCtree ctree;

    public void Close() {
        if (ctreeInitialized && this.sessionInitialized) {
            this.ctree.SwitchCtree(this.regId);
            this.ctree.CloseIsam();
            this.ctree.UnRegisterCtree(this.regId);
            this.sessionInitialized = false;
            if (--instances == 0) {
                if (!alreadyInitialized && this.ctree.IsMultiThreaded) {
                    this.ctree.ThreadTerm();
                }
                ctreeInitialized = false;
            }
        }
    }

    public CtreeSession(String string) throws JCtree.CtreeException {
        this.libName = string;
        this._CtreeSession(this.regId, (short)32, (short)128, (short)16, (short)32, Enums.USER_PROF.NTKEY, "ADMIN", "ADMIN", "");
    }

    public CtreeSession(String string, Enums.USER_PROF uSER_PROF) throws JCtree.CtreeException {
        this.libName = string;
        this._CtreeSession(this.regId, (short)32, (short)128, (short)16, (short)32, uSER_PROF, "ADMIN", "ADMIN", "");
    }

    public CtreeSession(String string, Enums.USER_PROF uSER_PROF, String string2, String string3, String string4) throws JCtree.CtreeException {
        this._CtreeSession(string, (short)32, (short)128, (short)16, (short)32, uSER_PROF, string2, string3, string4);
    }

    public CtreeSession(Enums.USER_PROF uSER_PROF, String string, String string2, String string3) throws JCtree.CtreeException {
        this._CtreeSession("myCtree", (short)32, (short)128, (short)16, (short)32, uSER_PROF, string, string2, string3);
    }

    public CtreeSession(short s, short s2, short s3, short s4, Enums.USER_PROF uSER_PROF, String string, String string2, String string3) throws JCtree.CtreeException {
        this._CtreeSession("myCtree", s, s2, s3, s4, uSER_PROF, string, string2, string3);
    }

    public CtreeSession(String string, short s, short s2, short s3, short s4, Enums.USER_PROF uSER_PROF, String string2, String string3, String string4) throws JCtree.CtreeException {
        this._CtreeSession(string, s, s2, s3, s4, uSER_PROF, string2, string3, string4);
    }

    private void _CtreeSession(String string, short s, short s2, short s3, short s4, Enums.USER_PROF uSER_PROF, String string2, String string3, String string4) throws JCtree.CtreeException {
        int n = 0;
        if (!ctreeInitialized) {
            this.ctree = new JCtree(this.getLibName());
            if (this.ctree == null) {
                throw new JCtree.CtreeException("Invalid c-tree session.", 999);
            }
            if (this.ctree.IsMultiThreaded) {
                n = this.ctree.ThrdInit(3, Enums.THREAD_MODE.AUTO);
            }
            ctreeInitialized = true;
            if (n != 0) {
                if (n == 125) {
                    alreadyInitialized = true;
                } else {
                    throw new JCtree.CtreeException("ThrdInit", n);
                }
            }
        }
        n = this.ctree.RegisterCtree(string);
        this.regId = string;
        if (n != 0) {
            throw new JCtree.CtreeException("RegisterCtree", n);
        }
        if (logPath != null) {
            n = this.ctree.SetLogPath(logPath, logMode);
        }
        if ((n = (int)this.ctree.InitISAMXtd(s, s2, s3, s4, uSER_PROF, string2, string3, string4)) != 0) {
            this.ctree.UnRegisterCtree(string);
            ctreeInitialized = false;
            throw new JCtree.CtreeException("InitISAMXtd", n);
        }
        this.sessionInitialized = true;
        ++instances;
    }

    public CtreeFile AllocateCtreeFile(String string) {
        CtreeFile ctreeFile = new CtreeFile(this.regId, string, logPath, logMode);
        return ctreeFile;
    }

    public CtreeFile AllocateCtreeFile(String string, boolean bl) {
        CtreeFile ctreeFile = new CtreeFile(this.regId, string, logPath, logMode, bl);
        return ctreeFile;
    }

    public static void SetLogFilesPath(String string, Enums.LOG_MODE lOG_MODE) {
        logPath = string;
        logMode = lOG_MODE;
    }

    public void SetTempPath(String string) {
        this.ctree.SwitchCtree(this.regId);
        this.ctree.SetTempPath(string);
    }

    public String getLibName() {
        return this.libName;
    }

    public void setLibName(String string) {
        this.libName = string;
    }

    static {
        instances = 0;
    }
}

