/*
 * Decompiled with CFR 0.152.
 */
package com.standbysoft.component.date.swing;

import com.standbysoft.component.date.swing.WeekModel;
import com.standbysoft.component.date.swing.event.WeekModelEvent;
import com.standbysoft.component.date.swing.event.WeekModelListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.event.EventListenerList;

public class DefaultWeekModel
implements WeekModel {
    public static final int DOW_NAMES_SHORT = 0;
    public static final int DOW_NAMES_LONG = 1;
    public static final int DOW_NAMES_LETTER = 2;
    protected EventListenerList listenerList = new EventListenerList();
    protected static int[] WEEK_DAYS = new int[]{1, 2, 3, 4, 5, 6, 7};
    private Calendar B;
    protected int dow;
    protected int month;
    protected int week;
    protected int year;
    private int A;
    protected int dowFirst;
    protected int[] dows = new int[7];
    protected int dowFormat;
    protected Locale locale;
    protected String[] dowNames = new String[7];
    protected boolean dowSelectionAllowed;
    protected boolean weekSelectionAllowed;
    protected boolean isoWeekNumbersEnabled;

    public DefaultWeekModel() {
        this.locale = Locale.getDefault();
        this.B = Calendar.getInstance();
        this.B.clear();
        this.week = -1;
        this.year = -1;
        this.dow = -1;
        this.month = -1;
        this.A = this.B.getMinimalDaysInFirstWeek();
        this.dowFirst = this.B.getFirstDayOfWeek();
        this.dowFormat = 0;
        this.A();
        this.B();
        this.dowSelectionAllowed = false;
        this.weekSelectionAllowed = false;
        this.isoWeekNumbersEnabled = false;
    }

    public String[] getDowNames() {
        return this.dowNames;
    }

    protected String[] getDowNames(int n, Locale locale) throws IllegalArgumentException {
        if (n == 0) {
            return new DateFormatSymbols(locale).getShortWeekdays();
        }
        if (n == 1) {
            return new DateFormatSymbols(locale).getWeekdays();
        }
        if (n == 2) {
            String[] stringArray = new DateFormatSymbols(locale).getWeekdays();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() <= 0) continue;
                stringArray[i] = stringArray[i].substring(0, 1);
            }
            return stringArray;
        }
        throw new IllegalArgumentException("The specified format is not allowed.");
    }

    public void setDowNamesFormat(int n) {
        if (this.dowFormat != n) {
            this.dowFormat = n;
            this.B();
        }
    }

    public int getDowNamesFormat() {
        return this.dowFormat;
    }

    public void setLocale(Locale locale) {
        if (this.locale != locale) {
            this.locale = locale;
            this.B = Calendar.getInstance(locale);
            this.A = this.B.getMinimalDaysInFirstWeek();
            this.setISOWeekNumbers(this.isoWeekNumbersEnabled);
            this.setDowFirst(this.B.getFirstDayOfWeek());
            this.A();
            this.B();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void B() {
        String[] stringArray = this.getDowNames(this.dowFormat, this.locale);
        for (int i = 0; i < this.dows.length; ++i) {
            this.dowNames[i] = stringArray[this.dows[i]];
        }
        this.fireDowNamesChanged(new WeekModelEvent(this));
    }

    private void A() {
        int n = 0;
        while (WEEK_DAYS[n] != this.dowFirst) {
            ++n;
        }
        for (int i = 0; i < 7; ++i) {
            this.dows[i] = WEEK_DAYS[(n + i) % 7];
        }
    }

    public int getSelectedMonth() {
        return this.month;
    }

    public int getSelectedDow() {
        return this.dow;
    }

    public void setSelectedDow(int n, int n2) {
        if (this.dow != n2) {
            this.dow = n2;
            this.month = n;
            this.fireDowChanged(new WeekModelEvent(this));
        }
    }

    public int getDowFirst() {
        return this.dowFirst;
    }

    public void setDowFirst(int n) {
        if (this.dowFirst != n) {
            boolean bl = false;
            for (int i = 0; i < WEEK_DAYS.length; ++i) {
                if (WEEK_DAYS[i] != n) continue;
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.dowFirst = n;
            this.B.setFirstDayOfWeek(this.dowFirst);
            this.A();
            this.B();
            this.fireDowFirstChanged(new WeekModelEvent(this));
            this.fireWeekNumbersChanged(new WeekModelEvent(this));
        }
    }

    public int[] getDows() {
        return this.dows;
    }

    public int getSelectedWeek() {
        return this.week;
    }

    public int getSelectedYear() {
        return this.year;
    }

    public void setSelectedWeek(int n, int n2) {
        this.year = n;
        this.week = n2;
        this.fireWeekChanged(new WeekModelEvent(this));
    }

    public boolean isDowSelectionAllowed() {
        return this.dowSelectionAllowed;
    }

    public void setDowSelectionAllowed(boolean bl) {
        this.dowSelectionAllowed = bl;
    }

    public boolean isWeekSelectionAllowed() {
        return this.weekSelectionAllowed;
    }

    public void setWeekSelectionAllowed(boolean bl) {
        this.weekSelectionAllowed = bl;
    }

    public int getWeekNumber(Date date, TimeZone timeZone) {
        this.B.setTimeZone(timeZone);
        this.B.setTime(date);
        return this.B.get(3);
    }

    public void setISOWeekNumbers(boolean bl) {
        if (this.isoWeekNumbersEnabled != bl) {
            this.isoWeekNumbersEnabled = bl;
            if (this.isoWeekNumbersEnabled) {
                this.B.setMinimalDaysInFirstWeek(4);
            } else {
                this.B.setMinimalDaysInFirstWeek(this.A);
            }
            this.fireWeekNumbersChanged(new WeekModelEvent(this));
        }
    }

    public boolean isISOWeekNumbers() {
        return this.isoWeekNumbersEnabled;
    }

    public void setWeekNumberISOFormatEnabled(boolean bl) {
        this.setISOWeekNumbers(bl);
    }

    public boolean isWeekNumberISOFormatEnabled() {
        return this.isISOWeekNumbers();
    }

    public void addWeekModelListener(WeekModelListener weekModelListener) {
        this.listenerList.add(WeekModelListener.class, weekModelListener);
    }

    public void removeWeekModelListener(WeekModelListener weekModelListener) {
        this.listenerList.remove(WeekModelListener.class, weekModelListener);
    }

    protected void fireWeekChanged(WeekModelEvent weekModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$standbysoft$component$date$swing$event$WeekModelListener == null ? DefaultWeekModel.class$("com.standbysoft.component.date.swing.event.WeekModelListener") : class$com$standbysoft$component$date$swing$event$WeekModelListener)) continue;
            ((WeekModelListener)objectArray[i + 1]).selectedWeekChanged(weekModelEvent);
        }
    }

    protected void fireDowNamesChanged(WeekModelEvent weekModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$standbysoft$component$date$swing$event$WeekModelListener == null ? DefaultWeekModel.class$("com.standbysoft.component.date.swing.event.WeekModelListener") : class$com$standbysoft$component$date$swing$event$WeekModelListener)) continue;
            ((WeekModelListener)objectArray[i + 1]).dowNamesChanged(weekModelEvent);
        }
    }

    protected void fireDowFirstChanged(WeekModelEvent weekModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$standbysoft$component$date$swing$event$WeekModelListener == null ? DefaultWeekModel.class$("com.standbysoft.component.date.swing.event.WeekModelListener") : class$com$standbysoft$component$date$swing$event$WeekModelListener)) continue;
            ((WeekModelListener)objectArray[i + 1]).dowFirstChanged(weekModelEvent);
        }
    }

    protected void fireDowChanged(WeekModelEvent weekModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$standbysoft$component$date$swing$event$WeekModelListener == null ? DefaultWeekModel.class$("com.standbysoft.component.date.swing.event.WeekModelListener") : class$com$standbysoft$component$date$swing$event$WeekModelListener)) continue;
            ((WeekModelListener)objectArray[i + 1]).selectedDowChanged(weekModelEvent);
        }
    }

    protected void fireWeekNumbersChanged(WeekModelEvent weekModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$standbysoft$component$date$swing$event$WeekModelListener == null ? DefaultWeekModel.class$("com.standbysoft.component.date.swing.event.WeekModelListener") : class$com$standbysoft$component$date$swing$event$WeekModelListener)) continue;
            ((WeekModelListener)objectArray[i + 1]).weekNumbersChanged(weekModelEvent);
        }
    }
}

