/*
 * Decompiled with CFR 0.152.
 */
package com.standbysoft.component.date.swing.plaf.basic;

import com.standbysoft.component.date.event.DateSelectionAdapter;
import com.standbysoft.component.date.event.DateSelectionEvent;
import com.standbysoft.component.date.event.DateSelectionListener;
import com.standbysoft.component.date.swing.DateRenderer;
import com.standbysoft.component.date.swing.DefaultMonthModel;
import com.standbysoft.component.date.swing.JDateComponent;
import com.standbysoft.component.date.swing.JMonth;
import com.standbysoft.component.date.swing.MonthModel;
import com.standbysoft.component.date.swing.event.MonthModelAdapter;
import com.standbysoft.component.date.swing.event.MonthModelEvent;
import com.standbysoft.component.date.swing.event.MonthModelListener;
import com.standbysoft.component.date.swing.plaf.DateUI;
import com.standbysoft.component.date.swing.plaf.basic.AbstractMonthViewUI;
import com.standbysoft.component.date.swing.plaf.basic.DateRendererUIResource;
import com.standbysoft.component.date.swing.plaf.basic.DefaultMonthUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class BasicMonthViewUI
extends AbstractMonthViewUI {
    protected MouseListener todayMouseListener;
    protected MouseListener noneMouseListener;
    private ActionListener T;
    private DateSelectionListener V;
    private MonthModelListener U;
    protected List months;
    private Map W;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMonthViewUI();
    }

    protected void installComponents() {
        this.W = new HashMap();
        this.months = new ArrayList();
        super.installComponents();
    }

    protected JButton createPreviousYearButton() {
        return null;
    }

    protected JButton createNextYearButton() {
        return null;
    }

    protected JButton createPreviousMonthButton() {
        return null;
    }

    protected JButton createNextMonthButton() {
        return null;
    }

    protected JComponent createTodayComponent() {
        return null;
    }

    protected JComponent createNoneComponent() {
        return null;
    }

    protected JMonth createMonth() {
        return new JMonth(){

            public boolean isFocusTraversable() {
                return false;
            }

            public void requestFocus() {
                if (this.getUI() != null && this.getUI() instanceof DefaultMonthUI) {
                    DefaultMonthUI defaultMonthUI = (DefaultMonthUI)this.getUI();
                    defaultMonthUI.V();
                }
                super.requestFocus();
            }

            public void updateUI() {
            }
        };
    }

    protected void updateMonthUI() {
        this.A(this.months.toArray(new JMonth[0]));
    }

    private void A(JMonth[] jMonthArray) {
        String string = (String)this.monthView.getClientProperty("JMonthView.monthUI");
        if (string == null) {
            string = (String)UIManager.get("MonthUI");
        }
        try {
            Class<?> clazz = Class.forName(string);
            for (int i = 0; i < jMonthArray.length; ++i) {
                JMonth jMonth = jMonthArray[i];
                DateUI dateUI = (DateUI)clazz.newInstance();
                jMonth.setUI(dateUI);
                jMonth.invalidate();
            }
            this.monthView.invalidate();
        }
        catch (Exception exception) {
            System.err.println("Failed to register internal MonthUI delegate for " + this.monthView.getName());
            exception.printStackTrace();
        }
    }

    protected void installListeners() {
        super.installListeners();
        if (this.V == null) {
            this.V = this.createDateSelectionListener();
            this.monthView.addDateSelectionListener(this.V);
        }
        if (this.U == null) {
            this.U = this.createMonthModelListener();
            this.monthView.addMonthModelListener(this.U);
        }
        if (this.todayMouseListener == null && this.todayComponent != null) {
            this.todayMouseListener = this.createTodayMouseListener();
            this.todayComponent.addMouseListener(this.todayMouseListener);
        }
        if (this.noneMouseListener == null && this.noneComponent != null) {
            this.noneMouseListener = this.createNoneMouseListener();
            this.noneComponent.addMouseListener(this.noneMouseListener);
        }
        if (this.T == null) {
            this.T = this.F();
        }
    }

    protected DateSelectionListener createDateSelectionListener() {
        return new _A();
    }

    protected MonthModelListener createMonthModelListener() {
        return new _B();
    }

    protected MouseListener createTodayMouseListener() {
        return new _C();
    }

    protected MouseListener createNoneMouseListener() {
        return new _E();
    }

    private ActionListener F() {
        return new _D();
    }

    protected void uninstallComponents() {
        super.uninstallComponents();
        this.W = null;
        Iterator iterator = this.months.iterator();
        while (iterator.hasNext()) {
            JMonth jMonth = (JMonth)iterator.next();
            iterator.remove();
            jMonth = null;
        }
        this.months = null;
    }

    protected void uninstallListeners() {
        JMonth jMonth;
        super.uninstallListeners();
        if (this.V != null) {
            this.monthView.removeDateSelectionListener(this.V);
            this.V = null;
        }
        if (this.U != null) {
            this.monthView.removeMonthModelListener(this.U);
            this.U = null;
        }
        if (this.todayMouseListener != null) {
            this.todayComponent.removeMouseListener(this.todayMouseListener);
            this.todayMouseListener = null;
        }
        if (this.noneMouseListener != null) {
            this.noneComponent.removeMouseListener(this.noneMouseListener);
            this.noneMouseListener = null;
        }
        Iterator iterator = this.months.iterator();
        while (iterator.hasNext()) {
            jMonth = (JMonth)iterator.next();
            MonthModelListener monthModelListener = (MonthModelListener)this.W.remove(jMonth);
            jMonth.removeMonthModelListener(monthModelListener);
            monthModelListener = null;
        }
        if (this.T != null) {
            iterator = this.months.iterator();
            while (iterator.hasNext()) {
                jMonth = (JMonth)iterator.next();
                jMonth.removeActionListener(this.T);
            }
            this.T = null;
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(240 * this.monthView.getColumns(), 180 * this.monthView.getRows());
    }

    private void E() {
        Calendar calendar = this.monthView.getCalendar();
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            calendar.set(this.monthView.getYear(), this.monthView.getMonth(), 1);
            calendar.add(2, i);
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.getMonthModel().setMonth(calendar.get(2), calendar.get(1));
        }
    }

    private void G() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.getMonthModel().setToday(this.monthView.getMonthModel().getToday());
        }
    }

    protected void updateFont() {
        Font font = this.monthView.getFont();
        if (font instanceof UIResource) {
            font = font.deriveFont(font.getStyle());
        }
        if (this.todayComponent != null) {
            this.todayComponent.setFont(font);
        }
        if (this.noneComponent != null) {
            this.noneComponent.setFont(font);
        }
        if (this.previousYearButton != null) {
            this.previousYearButton.setFont(font);
        }
        if (this.nextYearButton != null) {
            this.nextYearButton.setFont(font);
        }
        if (this.previousMonthButton != null) {
            this.previousMonthButton.setFont(font);
        }
        if (this.nextMonthButton != null) {
            this.nextMonthButton.setFont(font);
        }
        for (int i = 0; i < this.months.size(); ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setFont(font);
        }
    }

    protected void updateLocale() {
        Locale locale = this.monthView.getLocale();
        if (this.todayComponent != null) {
            this.todayComponent.setLocale(locale);
        }
        if (this.noneComponent != null) {
            this.noneComponent.setLocale(locale);
        }
        for (int i = 0; i < this.months.size(); ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setLocale(locale);
        }
    }

    protected void updateTimeZone() {
        TimeZone timeZone = this.monthView.getTimeZone();
        for (int i = 0; i < this.months.size(); ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setTimeZone(timeZone);
        }
    }

    protected void updateEnabled() {
        boolean bl = this.monthView.isEnabled();
        if (this.previousYearButton != null) {
            this.previousYearButton.setEnabled(bl);
        }
        if (this.nextYearButton != null) {
            this.nextYearButton.setEnabled(bl);
        }
        if (this.previousMonthButton != null) {
            this.previousMonthButton.setEnabled(bl);
        }
        if (this.nextMonthButton != null) {
            this.nextMonthButton.setEnabled(bl);
        }
        for (int i = 0; i < this.months.size(); ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setEnabled(bl);
        }
    }

    protected void updateRenderer() {
        for (int i = 0; i < this.months.size(); ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setDateRenderer(this.monthView.getDateRenderer());
        }
    }

    protected void updateMonthBackground() {
        Color color = this.monthView.getMonthBackground();
        for (int i = 0; i < this.months.size(); ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setMonthBackground(color);
        }
        if (this.todayComponent != null) {
            this.todayComponent.setBackground(color);
        }
        if (this.noneComponent != null) {
            this.noneComponent.setBackground(color);
        }
        this.monthView.setBackground(color);
    }

    protected void updateForeground() {
        Color color = this.monthView.getForeground();
        for (int i = 0; i < this.months.size(); ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setForeground(color);
        }
        if (color != null && color instanceof ColorUIResource) {
            color = new Color(color.getRGB());
        }
        if (this.todayComponent != null) {
            this.todayComponent.setForeground(color);
        }
        if (this.noneComponent != null) {
            this.noneComponent.setForeground(color);
        }
    }

    protected void updateTitleBackground() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setTitleBackground(this.monthView.getTitleBackground());
        }
    }

    protected void updateTitleForeground() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setTitleForeground(this.monthView.getTitleForeground());
        }
    }

    protected void updateTrailingForeground() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setTrailingForeground(this.monthView.getTrailingForeground());
        }
    }

    protected void updateGridColor() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setGridColor(this.monthView.getGridColor());
        }
    }

    protected void updateWeekNumbersVisible() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setWeekNumbersVisible(this.monthView.isWeekNumbersVisible());
        }
    }

    protected void updateWeekNamesVisible() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setWeekNamesVisible(this.monthView.isWeekNamesVisible());
        }
    }

    protected void updateHorizontalLinesVisible() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setHorizontalLinesVisible(this.monthView.isHorizontalLinesVisible());
        }
    }

    protected void updateVerticalLinesVisible() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setVerticalLinesVisible(this.monthView.isVerticalLinesVisible());
        }
    }

    protected void updateDatesOrientation() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setDatesOrientation(this.monthView.getDatesOrientation());
        }
    }

    protected void updateDisplayToday() {
        if (this.todayComponent != null) {
            this.todayComponent.setVisible(this.monthView.isStatusVisible() && this.monthView.isTodayButtonVisible());
        }
    }

    protected void updateTodayButtonText() {
        if (this.todayComponent != null && this.todayComponent instanceof JLabel) {
            ((JLabel)this.todayComponent).setText(this.monthView.getTodayButtonText());
        }
    }

    protected void updateNoneButtonVisible() {
        if (this.noneComponent != null) {
            this.noneComponent.setVisible(this.monthView.isStatusVisible() && this.monthView.isNoneButtonVisible() && this.monthView.isEmptySelectionAllowed());
        }
    }

    protected void updateNoneButtonText() {
        if (this.noneComponent != null && this.noneComponent instanceof JLabel) {
            ((JLabel)this.noneComponent).setText(this.monthView.getNoneButtonText());
        }
    }

    protected void updateDateSelectionModel() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setDateSelectionModel(this.monthView.getDateSelectionModel());
        }
        this.updateNoneButtonVisible();
    }

    protected void updateToggleDateSelectionEnabled() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setToggleDateSelectionEnabled(this.monthView.isToggleDateSelectionEnabled());
        }
    }

    protected void updateTrailingNextEnabled() {
        if (this.months.size() > 0) {
            int n = this.monthView.getRows() * this.monthView.getColumns();
            JMonth jMonth = (JMonth)this.months.get(n - 1);
            jMonth.setTrailingNextEnabled(this.monthView.isTrailingNextEnabled());
        }
    }

    protected void updateTrailingPreviousEnabled() {
        if (this.months.size() > 0) {
            JMonth jMonth = (JMonth)this.months.get(0);
            jMonth.setTrailingPreviousEnabled(this.monthView.isTrailingPreviousEnabled());
        }
    }

    protected void updateWeekLabelsHighlight() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.putClientProperty("JMonth.isWeekLabelsHighlighted", this.monthView.getClientProperty("JMonth.isWeekLabelsHighlighted"));
        }
    }

    protected void updateMonthModel() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setMonthModel(new _F(this.monthView.getMonthModel()));
        }
        this.E();
    }

    protected void updateWeekModel() {
        int n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = (JMonth)this.months.get(i);
            jMonth.setWeekModel(this.monthView.getWeekModel());
        }
    }

    protected void updateRowsColumns() {
        int n;
        for (n = 0; n < this.months.size(); ++n) {
            this.monthView.remove((JMonth)this.months.get(n));
        }
        n = this.monthView.getRows() * this.monthView.getColumns();
        for (int i = 0; i < n; ++i) {
            JMonth jMonth = this.B(i);
            this.monthView.add((Component)jMonth, "Month");
            jMonth.setTrailingNextEnabled(false);
            jMonth.setTrailingPreviousEnabled(false);
        }
        if (this.months.size() > 0) {
            ((JMonth)this.months.get(0)).setTrailingPreviousEnabled(true);
            ((JMonth)this.months.get(n - 1)).setTrailingNextEnabled(true);
            if (this.monthView.getLayout() instanceof AbstractMonthViewUI.CalendarLayout) {
                AbstractMonthViewUI.CalendarLayout calendarLayout = (AbstractMonthViewUI.CalendarLayout)this.monthView.getLayout();
                calendarLayout.setColumns(this.monthView.getColumns());
                calendarLayout.setRows(this.monthView.getRows());
            }
            this.monthView.revalidate();
        }
    }

    private JMonth B(int n) {
        JMonth jMonth = null;
        if (this.months.size() <= n) {
            while (this.months.size() <= n) {
                jMonth = this.createMonth();
                jMonth.setAutoUpdateToday(false);
                this.months.add(jMonth);
                this.A(jMonth);
                _G _G2 = new _G(n);
                this.W.put(jMonth, _G2);
                jMonth.addMonthModelListener(_G2);
                if (this.T == null) {
                    this.T = this.F();
                }
                jMonth.addActionListener(this.T);
                this.A(new JMonth[]{jMonth});
            }
        } else {
            jMonth = (JMonth)this.months.get(n);
            this.A(jMonth);
        }
        return jMonth;
    }

    private void A(JMonth jMonth) {
        Font font = this.monthView.getFont();
        if (font != null && font instanceof UIResource) {
            font = font.deriveFont(font.getStyle());
        }
        jMonth.setFont(font);
        Color color = this.monthView.getMonthBackground();
        if (color != null && color instanceof UIResource) {
            color = new Color(color.getRGB());
        }
        jMonth.setMonthBackground(color);
        color = this.monthView.getForeground();
        if (color != null && color instanceof UIResource) {
            color = new Color(color.getRGB());
        }
        jMonth.setForeground(color);
        color = this.monthView.getTitleBackground();
        if (color != null && color instanceof UIResource) {
            color = new Color(color.getRGB());
        }
        jMonth.setTitleBackground(color);
        color = this.monthView.getTitleForeground();
        if (color != null && color instanceof UIResource) {
            color = new Color(color.getRGB());
        }
        jMonth.setTitleForeground(color);
        color = this.monthView.getTrailingForeground();
        if (color != null && color instanceof UIResource) {
            color = new Color(color.getRGB());
        }
        jMonth.setTrailingForeground(color);
        color = this.monthView.getGridColor();
        if (color != null && color instanceof UIResource) {
            color = new Color(color.getRGB());
        }
        jMonth.setGridColor(color);
        DateRenderer dateRenderer = this.monthView.getDateRenderer();
        if (dateRenderer != null && dateRenderer instanceof DateRendererUIResource) {
            dateRenderer = ((DateRendererUIResource)dateRenderer).getDateRenderer();
        }
        jMonth.setDateRenderer(dateRenderer);
        jMonth.setLocale(this.monthView.getLocale());
        jMonth.setEnabled(this.monthView.isEnabled());
        jMonth.setWeekNumbersVisible(this.monthView.isWeekNumbersVisible());
        jMonth.setWeekNamesVisible(this.monthView.isWeekNamesVisible());
        jMonth.setHorizontalLinesVisible(this.monthView.isHorizontalLinesVisible());
        jMonth.setVerticalLinesVisible(this.monthView.isVerticalLinesVisible());
        jMonth.putClientProperty("JMonth.isWeekLabelsHighlighted", this.monthView.getClientProperty("JMonth.isWeekLabelsHighlighted"));
        jMonth.setDateSelectionModel(this.monthView.getDateSelectionModel());
        jMonth.setToggleDateSelectionEnabled(this.monthView.isToggleDateSelectionEnabled());
        jMonth.setWeekModel(this.monthView.getWeekModel());
        jMonth.setMonthModel(new _F(this.monthView.getMonthModel()));
        jMonth.setTimeZone(this.monthView.getTimeZone());
        jMonth.setDatesOrientation(this.monthView.getDatesOrientation());
        Calendar calendar = this.monthView.getCalendar();
        calendar.set(this.monthView.getYear(), this.monthView.getMonth(), 1);
        int n = this.months.indexOf(jMonth);
        calendar.add(2, n);
        jMonth.getMonthModel().setMonth(calendar.get(2), calendar.get(1));
    }

    private class _F
    extends DefaultMonthModel {
        private MonthModel I;

        public _F(MonthModel monthModel) {
            this.I = monthModel;
        }

        public String[] getMonthNames() {
            return this.I.getMonthNames();
        }
    }

    private class _G
    extends MonthModelAdapter {
        private int B;

        public _G(int n) {
            this.B = n;
        }

        public void monthChanged(MonthModelEvent monthModelEvent) {
            JMonth jMonth = (JMonth)monthModelEvent.getSource();
            Calendar calendar = BasicMonthViewUI.this.monthView.getCalendar();
            calendar.set(jMonth.getYear(), jMonth.getMonth(), 1);
            calendar.add(2, -this.B);
            BasicMonthViewUI.this.monthView.getMonthModel().setMonth(calendar.get(2), calendar.get(1));
        }
    }

    private class _D
    implements ActionListener {
        private _D() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = BasicMonthViewUI.this.monthView.getActionCommand();
            BasicMonthViewUI.this.monthView.setActionCommand(actionEvent.getActionCommand());
            BasicMonthViewUI.this.monthView.fireActionEvent();
            BasicMonthViewUI.this.monthView.setActionCommand(string);
        }
    }

    private class _E
    extends MouseAdapter {
        private _E() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0 && BasicMonthViewUI.this.monthView.isEnabled()) {
                BasicMonthViewUI.this.monthView.requestFocus();
                BasicMonthViewUI.this.monthView.getDateSelectionModel().removeAllDates();
            }
        }
    }

    private class _C
    extends MouseAdapter {
        private ActionEvent B;
        private Action A = new JDateComponent.SelectTodayAction();

        private _C() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0 && BasicMonthViewUI.this.monthView.isEnabled()) {
                BasicMonthViewUI.this.monthView.requestFocus();
                if (this.B == null) {
                    this.B = new ActionEvent(BasicMonthViewUI.this.monthView, 0, "select-today");
                }
                this.A.actionPerformed(this.B);
            }
        }
    }

    private class _B
    extends MonthModelAdapter {
        private _B() {
        }

        public void monthChanged(MonthModelEvent monthModelEvent) {
            BasicMonthViewUI.this.E();
        }

        public void todayChanged(MonthModelEvent monthModelEvent) {
            BasicMonthViewUI.this.G();
        }
    }

    private class _A
    extends DateSelectionAdapter {
        private _A() {
        }

        public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
            BasicMonthViewUI.this.monthView.scrollDateToVisible(dateSelectionEvent.getFirstDate());
        }

        public void emptySelectionAllowedChanged(DateSelectionEvent dateSelectionEvent) {
            BasicMonthViewUI.this.updateNoneButtonVisible();
        }
    }
}

