/*
 * Decompiled with CFR 0.152.
 */
package com.standbysoft.component.date.swing.plaf.basic;

import com.standbysoft.component.date.event.DateSelectionAdapter;
import com.standbysoft.component.date.event.DateSelectionEvent;
import com.standbysoft.component.date.event.DateSelectionListener;
import com.standbysoft.component.date.swing.JDatePicker;
import com.standbysoft.component.date.swing.plaf.DateUI;
import com.standbysoft.component.date.swing.plaf.basic.Y;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;

public class SpinnerTimePickerUI
extends DateUI {
    protected JDatePicker datePicker;
    protected JSpinner hourSpinner;
    protected JSpinner minuteSpinner;
    protected JSpinner secondSpinner;
    private DateSelectionListener D;
    private ChangeListener A;
    private ChangeListener C;
    private ChangeListener E;
    private KeyListener F;
    private boolean B = true;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SpinnerTimePickerUI();
    }

    public void installUI(JComponent jComponent) {
        this.datePicker = (JDatePicker)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    protected void installDefaults() {
    }

    protected void installComponents() {
        this.hourSpinner = this.createHourSpinner();
        this.minuteSpinner = this.createMinuteSpinner();
        this.secondSpinner = this.createSecondSpinner();
        this.datePicker.setLayout(new FlowLayout(1));
        if (this.hourSpinner != null) {
            this.datePicker.add(this.hourSpinner);
            if (this.minuteSpinner != null || this.secondSpinner != null) {
                this.datePicker.add(new JLabel(":"));
            }
        }
        if (this.minuteSpinner != null) {
            this.datePicker.add(this.minuteSpinner);
            if (this.secondSpinner != null) {
                this.datePicker.add(new JLabel(":"));
            }
        }
        if (this.secondSpinner != null) {
            this.datePicker.add(this.secondSpinner);
        }
        this.A();
    }

    protected JSpinner createHourSpinner() {
        Y y = new Y(new SpinnerNumberModel(0, 0, 23, 1));
        return y;
    }

    protected JSpinner createMinuteSpinner() {
        Y y = new Y(new SpinnerNumberModel(0, 0, 59, 1));
        return y;
    }

    protected JSpinner createSecondSpinner() {
        Y y = new Y(new SpinnerNumberModel(0, 0, 59, 1));
        return y;
    }

    protected void installListeners() {
        this.F = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    SpinnerTimePickerUI.this.datePicker.setActionCommand("enterPressed");
                    SpinnerTimePickerUI.this.datePicker.fireActionEvent();
                } else if (keyEvent.getKeyCode() == 27) {
                    SpinnerTimePickerUI.this.datePicker.setActionCommand("escPressed");
                    SpinnerTimePickerUI.this.datePicker.fireActionEvent();
                }
            }
        };
        if (this.hourSpinner != null) {
            this.A = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    SpinnerTimePickerUI.this.datePicker.getDateModel().set(11, (Integer)SpinnerTimePickerUI.this.hourSpinner.getValue());
                    SpinnerTimePickerUI.this.datePicker.commitEdit();
                }
            };
            this.hourSpinner.addChangeListener(this.A);
            ((JSpinner.DefaultEditor)this.hourSpinner.getEditor()).getTextField().addKeyListener(this.F);
        }
        if (this.minuteSpinner != null) {
            this.C = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    SpinnerTimePickerUI.this.datePicker.getDateModel().set(12, (Integer)SpinnerTimePickerUI.this.minuteSpinner.getValue());
                    SpinnerTimePickerUI.this.datePicker.commitEdit();
                }
            };
            this.minuteSpinner.addChangeListener(this.C);
            ((JSpinner.DefaultEditor)this.minuteSpinner.getEditor()).getTextField().addKeyListener(this.F);
        }
        if (this.secondSpinner != null) {
            this.E = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    SpinnerTimePickerUI.this.datePicker.getDateModel().set(13, (Integer)SpinnerTimePickerUI.this.secondSpinner.getValue());
                    SpinnerTimePickerUI.this.datePicker.commitEdit();
                }
            };
            this.secondSpinner.addChangeListener(this.E);
            ((JSpinner.DefaultEditor)this.secondSpinner.getEditor()).getTextField().addKeyListener(this.F);
        }
        this.D = new _A();
        this.datePicker.addDateSelectionListener(this.D);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        if (this.D != null) {
            this.datePicker.removeDateSelectionListener(this.D);
        }
        if (this.A != null) {
            this.hourSpinner.removeChangeListener(this.A);
        }
        if (this.C != null) {
            this.minuteSpinner.removeChangeListener(this.C);
        }
        if (this.E != null) {
            this.secondSpinner.removeChangeListener(this.E);
        }
        if (this.F != null) {
            if (this.hourSpinner != null) {
                ((JSpinner.DefaultEditor)this.hourSpinner.getEditor()).getTextField().removeKeyListener(this.F);
            }
            if (this.minuteSpinner != null) {
                ((JSpinner.DefaultEditor)this.minuteSpinner.getEditor()).getTextField().removeKeyListener(this.F);
            }
            if (this.secondSpinner != null) {
                ((JSpinner.DefaultEditor)this.secondSpinner.getEditor()).getTextField().removeKeyListener(this.F);
            }
        }
    }

    protected void uninstallComponents() {
        this.datePicker.removeAll();
        this.datePicker.setLayout(null);
        this.datePicker = null;
        this.hourSpinner = null;
        this.minuteSpinner = null;
        this.secondSpinner = null;
    }

    private void A() {
        Date date = this.datePicker.getSelectedDate();
        if (date != null) {
            Calendar calendar = this.datePicker.getCalendar();
            calendar.setTime(date);
            this.B = false;
            if (this.hourSpinner != null) {
                this.hourSpinner.setValue(new Integer(calendar.get(11)));
            }
            if (this.minuteSpinner != null) {
                this.minuteSpinner.setValue(new Integer(calendar.get(12)));
            }
            if (this.secondSpinner != null) {
                this.secondSpinner.setValue(new Integer(calendar.get(13)));
            }
            this.B = true;
        }
    }

    private class _A
    extends DateSelectionAdapter {
        private _A() {
        }

        public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
            if (SpinnerTimePickerUI.this.B) {
                SpinnerTimePickerUI.this.A();
            }
        }
    }
}

