/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeCostInfo;
import ctree.jdbc.CtreeError;
import ctree.jdbc.SQLPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class CtreeCA
implements CtreeError {
    int Sqlcode;
    String Sqlstate;
    String Sqlerrm;
    int[] Sqlerrd;
    String Sqlerrp;
    String Sqlwarn;
    String Sqlext;
    CtreeCostInfo EstimatedCost;
    CtreeCostInfo ActualCost;
    int Number;
    char[] More;
    byte WarnFlag;
    String CommandFunction;
    String DynamicFunction;
    String ClassOrigin;
    String SubClassOrigin;
    String TableName;
    String ColumnName;

    public CtreeCA() {
        this.Sqlcode = 0;
        this.Sqlerrd = new int[8];
        for (int i = 0; i < 8; ++i) {
            this.Sqlerrd[i] = 0;
        }
        this.Sqlerrm = null;
        this.Sqlstate = null;
        this.Sqlwarn = null;
        this.Sqlext = null;
        this.Sqlerrp = null;
        this.More = new char[1];
        this.CommandFunction = null;
        this.DynamicFunction = null;
        this.ClassOrigin = null;
        this.SubClassOrigin = null;
        this.TableName = null;
        this.ColumnName = null;
        this.EstimatedCost = new CtreeCostInfo();
        this.ActualCost = new CtreeCostInfo();
    }

    public CtreeCA(int n, String string, int[] nArray) {
        this.Sqlcode = n;
        this.Sqlerrm = string;
        this.Sqlerrd = nArray;
    }

    public void close() {
        this.Sqlerrd = null;
        this.Sqlerrm = null;
        this.Sqlstate = null;
        this.Sqlwarn = null;
        this.Sqlext = null;
        this.Sqlerrp = null;
        this.More = null;
        this.CommandFunction = null;
        this.DynamicFunction = null;
        this.ClassOrigin = null;
        this.SubClassOrigin = null;
        this.TableName = null;
        this.ColumnName = null;
        this.EstimatedCost = null;
        this.ActualCost = null;
    }

    public void finalize() {
        this.close();
    }

    public void print(String string) {
        System.out.println("\n" + string + "\tSqlcode = " + this.Sqlcode + "Sqlerrm = " + this.Sqlerrm + "\n");
    }

    public int getErrorCode() {
        return this.Sqlcode;
    }

    public String getErrorMessage() {
        return this.Sqlerrm;
    }

    public void setErrorCode(int n) {
        this.Sqlcode = n;
    }

    public void setErrorMessage(String string) {
        this.Sqlerrm = string;
    }

    public void setSqlstate(String string) {
        this.Sqlstate = string;
    }

    public String getSqlstate() {
        return this.Sqlstate;
    }

    public void setSqlerrm(String string) {
        this.Sqlerrm = string;
    }

    public String getSqlerrm() {
        return this.Sqlerrm;
    }

    public void setSqlerrp(String string) {
        this.Sqlerrp = string;
    }

    public String getSqlerrp() {
        return this.Sqlerrp;
    }

    public void setSqlwarn(String string) {
        this.Sqlwarn = string;
    }

    public String getSqlwarn() {
        return this.Sqlwarn;
    }

    public void setSqlext(String string) {
        this.Sqlext = string;
    }

    public String getSqlext() {
        return this.Sqlext;
    }

    public void setCommandFunction(String string) {
        this.CommandFunction = string;
    }

    public String getCommandFunction() {
        return this.CommandFunction;
    }

    public void setDynamicFunction(String string) {
        this.DynamicFunction = string;
    }

    public String getDynamicFunction() {
        return this.DynamicFunction;
    }

    public void setClassOrigin(String string) {
        this.ClassOrigin = string;
    }

    public String getClassOrigin() {
        return this.ClassOrigin;
    }

    public void setSubClassOrigin(String string) {
        this.SubClassOrigin = string;
    }

    public String getSubClassOrigin() {
        return this.SubClassOrigin;
    }

    public void setTableName(String string) {
        this.TableName = string;
    }

    public String getTableName() {
        return this.TableName;
    }

    public void setColumnName(String string) {
        this.ColumnName = string;
    }

    public String getColumnName() {
        return this.ColumnName;
    }

    public void setEstimatedCost(CtreeCostInfo ctreeCostInfo) {
        this.EstimatedCost = ctreeCostInfo;
    }

    public CtreeCostInfo getEstimatedCost() {
        return this.EstimatedCost;
    }

    public void setActualCost(CtreeCostInfo ctreeCostInfo) {
        this.ActualCost = ctreeCostInfo;
    }

    public CtreeCostInfo getActualCost() {
        return this.ActualCost;
    }

    public void setSqlerrd(int n, int n2) {
        this.Sqlerrd[n] = n2;
    }

    public int getSqlerrd(int n) {
        return this.Sqlerrd[n];
    }

    public void setWarnFlag(byte by) {
        this.WarnFlag = by;
    }

    public byte getWarnFlag() {
        return this.WarnFlag;
    }

    public void marshal(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeInt(this.Sqlcode);
            if (this.Sqlcode < 0) {
                dataOutputStream.writeUTF(this.Sqlerrm);
                dataOutputStream.writeUTF(this.Sqlstate);
                dataOutputStream.writeUTF(this.ClassOrigin);
                dataOutputStream.writeUTF(this.SubClassOrigin);
                dataOutputStream.writeUTF(this.TableName);
                dataOutputStream.writeUTF(this.ColumnName);
            }
            for (int i = 0; i < 8; ++i) {
                dataOutputStream.writeInt(this.Sqlerrd[i]);
            }
            if (this.WarnFlag == 1) {
                dataOutputStream.writeByte(this.WarnFlag);
                dataOutputStream.writeUTF(this.Sqlwarn);
            } else {
                dataOutputStream.writeByte(this.WarnFlag);
            }
            this.EstimatedCost.marshal(dataOutputStream);
            dataOutputStream.writeUTF(this.CommandFunction);
            dataOutputStream.writeUTF(this.DynamicFunction);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public void unmarshal(SQLPacket sQLPacket) throws IOException {
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        this.Sqlcode = dataInputStream.readInt();
        if (this.Sqlcode < 0) {
            sQLPacket.unmarshalInt();
            this.Sqlerrm = sQLPacket.unmarshalString();
            this.Sqlstate = sQLPacket.unmarshalString();
            this.ClassOrigin = sQLPacket.unmarshalString();
            this.SubClassOrigin = sQLPacket.unmarshalString();
            this.TableName = sQLPacket.unmarshalString();
            this.ColumnName = sQLPacket.unmarshalString();
        }
        for (int i = 0; i < 8; ++i) {
            this.Sqlerrd[i] = dataInputStream.readInt();
        }
        if (sQLPacket.unicodeCompatibility()) {
            char[] cArray = sQLPacket.unmarshallChars();
            this.WarnFlag = cArray.length > 0 ? (byte)cArray[0] : (byte)0;
            this.Sqlwarn = cArray.length <= 1 ? null : new String(cArray);
        } else {
            this.Sqlwarn = sQLPacket.unmarshalString();
            byte[] byArray = this.Sqlwarn.getBytes();
            this.WarnFlag = byArray.length > 0 ? byArray[0] : (byte)0;
            if (byArray.length <= 1) {
                this.Sqlwarn = null;
            }
        }
        this.EstimatedCost.unmarshal(dataInputStream);
        this.CommandFunction = sQLPacket.unmarshalString();
        this.DynamicFunction = sQLPacket.unmarshalString();
    }
}

