/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeLOBOutputStream;
import ctree.jdbc.CtreeLOBWriter;
import ctree.jdbc.CtreeReaderUnicodeInputStream;
import ctree.jdbc.CtreeResultSet;
import ctree.jdbc.CtreeSQLException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class CtreeClob
implements Clob,
CtreeError {
    int columnIndex;
    CtreeResultSet rs;

    CtreeClob(CtreeResultSet ctreeResultSet, int n) {
        this.rs = ctreeResultSet;
        this.columnIndex = n;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.rs.getAsciiStream(this.columnIndex);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.rs.getCharacterStream(this.columnIndex);
    }

    @Override
    public String getSubString(long l, int n) throws SQLException {
        if (n < 0) {
            throw new CtreeSQLException(26089);
        }
        return this.rs.getString(this.columnIndex, (int)l, n);
    }

    @Override
    public long length() throws SQLException {
        return this.rs.getLength(this.columnIndex);
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        throw new CtreeSQLException("Driver does not support this function", 26065);
    }

    @Override
    public long position(String string, long l) throws SQLException {
        throw new CtreeSQLException("Driver does not support this function", 26065);
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        return new CtreeLOBOutputStream(this, (int)l);
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        return new CtreeLOBWriter(this, (int)l);
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        if (string == null) {
            throw new CtreeSQLException("Invalid string object", 26055);
        }
        int n = 0;
        try {
            InputStream inputStream = null;
            if (this.rs.UnicodeCompatibility()) {
                inputStream = new CtreeReaderUnicodeInputStream(new StringReader(string));
                n = string.length();
            } else {
                inputStream = new ByteArrayInputStream(string.getBytes("US-ASCII"));
                n = inputStream.available();
            }
            this.rs.putData(this.columnIndex, (int)l, inputStream);
        }
        catch (IOException iOException) {
            throw new CtreeSQLException(iOException.getMessage(), 26026);
        }
        return n;
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        if (string == null) {
            throw new CtreeSQLException("Invalid string object", 26055);
        }
        byte[] byArray = string.getBytes();
        if (n < 0 || n > byArray.length) {
            throw new CtreeSQLException(26090);
        }
        if (n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new CtreeSQLException(26089);
        }
        return this.setString(l, string.substring(n, n2 + n));
    }

    @Override
    public void truncate(long l) throws SQLException {
        throw new CtreeSQLException("Driver does not support this function", 26065);
    }

    @Override
    public Reader getCharacterStream(long l, long l2) {
        System.out.println("To be implemented ");
        return null;
    }

    @Override
    public void free() {
        System.out.println("To be implemented ");
    }
}

