/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.ConnectOptions;
import ctree.jdbc.CtreeCA;
import ctree.jdbc.CtreeCallableStatement;
import ctree.jdbc.CtreeDA;
import ctree.jdbc.CtreeData;
import ctree.jdbc.CtreeDatabaseMetaData;
import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeJDBCObject;
import ctree.jdbc.CtreePreparedStatement;
import ctree.jdbc.CtreeResultSet;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.CtreeSQLProcInfo;
import ctree.jdbc.CtreeSQLWarning;
import ctree.jdbc.CtreeStatement;
import ctree.jdbc.CursorT;
import ctree.jdbc.SQLXApi;
import ctree.jdbc.StatementType;
import ctree.jdbc.StatementUid;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.ShardingKey;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Wrapper;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;

public class CtreeConnection
extends CtreeJDBCObject
implements Connection,
CtreeError,
StatementType,
ConnectOptions,
Wrapper {
    private static final PrintStream o = System.out;
    final int TRANSACTIONLEVEL = 4;
    final int DHXN_READ_UNCOMMITTED = 0;
    final int DHXN_READ_COMMITTED = 1;
    final int DHXN_REPEATABLE_READ = 2;
    final int DHXN_SERIALIZABLE = 3;
    public SQLXApi connectionID;
    private String userId;
    private SQLWarning warnings;
    private SQLException exceptions;
    private String URL;
    private static final int DH_MAX_USERNAME_LEN = 64;
    private static final int DH_DBOPTIONS_LEN = 512;
    private CtreeCA m_consqlca;
    private boolean m_isMidofTransaction = false;
    private Properties clientInfo;
    private int holdability = 2;

    public CtreeConnection(String string, String string2, String string3, String string4) throws SQLException {
        this.Int_CtreeConnection(-1, string, string2, string3, string4);
    }

    public CtreeConnection(String string, String string2, String string3, String string4, int n) throws SQLException {
        this.Int_CtreeConnection(n, string, string2, string3, string4);
    }

    private void Int_CtreeConnection(int n, String string, String string2, String string3, String string4) throws SQLException {
        this.m_consqlca = new CtreeCA();
        this.warnings = null;
        this.exceptions = null;
        if (CtreeConnection.traceOn()) {
            CtreeConnection.trace("@CtreeConnection ( connectStr = " + string + ", userid = " + string2 + ", passwd =  **** )");
        }
        if (string2.length() > 64) {
            throw new CtreeSQLException(26081);
        }
        if (string3.length() > 64) {
            throw new CtreeSQLException(26082);
        }
        if (string4 != null && string4.length() > 512) {
            throw new CtreeSQLException(26083);
        }
        this.userId = string2;
        this.URL = string;
        this.connectionID = n >= 0 ? new SQLXApi(n, string, string2, string3, string4) : new SQLXApi(string, string2, string3, string4);
        if (CtreeConnection.traceOn()) {
            CtreeConnection.trace("@CtreeConnection<return> connectionID = " + this.connectionID);
        }
        this.clientInfo = new Properties();
        this.clientInfo.setProperty("ApplicationName", "");
        this.clientInfo.setProperty("ClientUser", "");
        this.clientInfo.setProperty("ClientHostname", "");
    }

    public CtreeConnection(String string, String string2, String string3, String string4, SQLXApi sQLXApi) throws SQLException {
        this.m_consqlca = new CtreeCA();
        this.warnings = null;
        this.exceptions = null;
        if (CtreeConnection.traceOn()) {
            CtreeConnection.trace("@CtreeConnection ( connectStr = " + string + ", userid = " + string2 + ", passwd =  **** ). Reuse of pooled connection");
        }
        if (string2.length() > 64) {
            throw new CtreeSQLException(26081);
        }
        if (string3.length() > 64) {
            throw new CtreeSQLException(26082);
        }
        if (string4 != null && string4.length() > 512) {
            throw new CtreeSQLException(26083);
        }
        this.userId = string2;
        this.URL = string;
        this.connectionID = sQLXApi;
        this.clientInfo = new Properties();
        this.clientInfo.setProperty("ApplicationName", "");
        this.clientInfo.setProperty("ClientUser", "");
        this.clientInfo.setProperty("ClientHostname", "");
    }

    protected void finalize() {
        try {
            if (CtreeConnection.traceOn()) {
                CtreeConnection.trace("@CtreeConnection.finalize (connectionID = " + this.connectionID + ")");
            }
            this.close();
        }
        catch (Exception exception) {
            o.println("CtreeConnection " + exception);
        }
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        if (CtreeConnection.traceOn()) {
            CtreeConnection.trace("@CtreeConnection.createStatement()");
        }
        return this.createCtreeStatement(1003, 1007, this.holdability);
    }

    @Override
    public void setShardingKey(ShardingKey shardingKey) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void setShardingKey(ShardingKey shardingKey, ShardingKey shardingKey2) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public boolean setShardingKeyIfValid(ShardingKey shardingKey, int n) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void beginRequest() throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void endRequest() throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        if (CtreeConnection.traceOn()) {
            CtreeConnection.trace("@CtreeConnection.prepareStatement (sql=" + string + ")");
        }
        return this.createCtreePreparedStatement(string, 1003, 1007, this.holdability);
    }

    @Override
    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        if (CtreeConnection.traceOn()) {
            CtreeConnection.trace("@CtreeConnection.prepareCall (sql=" + string + ")");
        }
        return this.createCtreeCallableStatement(string, 1003, 1007, this.holdability);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        return this.createCtreeDatabaseMetaData();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (CtreeConnection.traceOn()) {
            CtreeConnection.trace("@CtreeConnection.close (connectionID = " + this.connectionID + ")");
        }
        if (this.connectionID != null) {
            this.connectionID.Disconnect();
            this.connectionID = null;
        }
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.connectionID == null;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        String string = this.m_consqlca.getSqlwarn();
        CtreeSQLWarning ctreeSQLWarning = null;
        if (string != null) {
            if (string.charAt(1) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26070);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26070));
                }
            }
            if (string.charAt(2) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26071);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26071));
                }
            }
            if (string.charAt(3) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26072);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26072));
                }
            }
            if (string.charAt(4) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26073);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26073));
                }
            }
            if (string.charAt(6) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26074);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26074));
                }
            }
        }
        if (this.warnings != null) {
            for (SQLWarning sQLWarning = this.warnings; sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(sQLWarning.getErrorCode());
                    continue;
                }
                ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(sQLWarning.getErrorCode()));
            }
        }
        return ctreeSQLWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        while (this.warnings != null) {
            SQLWarning sQLWarning = this.warnings.getNextWarning();
            this.warnings.setNextWarning(null);
            this.warnings = sQLWarning;
        }
    }

    public synchronized void setAutoClose(boolean bl) throws SQLException {
        int n = 0;
        if (bl) {
            n = 1;
        }
        this.checkConnection();
        this.connectionID.SetConnectOption(2, n);
        this.m_isMidofTransaction = false;
    }

    public synchronized boolean getAutoClose() throws SQLException {
        this.checkConnection();
        return this.connectionID.GetConnectOption(2) != 0;
    }

    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.checkConnection();
        int n = !bl ? 0 : 1;
        this.connectionID.SetConnectOption(3, n);
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkConnection();
        return this.connectionID.GetConnectOption(3) != 0;
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.checkConnection();
        this.connectionID.Commit(this.m_consqlca);
        this.m_isMidofTransaction = false;
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkConnection();
        this.connectionID.Rollback(this.m_consqlca);
    }

    @Override
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        if (!this.getAutoCommit() && this.m_isMidofTransaction) {
            throw new CtreeSQLException("Transaction isolation level cannot be set in the middle of Transaction", 26063);
        }
        this.checkConnection();
        this.connectionID.SetConnectOption(4, this.getCtreeXnLevel(n));
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkConnection();
        return this.getJDBCXnLevel(this.connectionID.GetConnectOption(4));
    }

    @Override
    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.checkConnection();
        int n = 0;
        if (bl) {
            n = 1;
        }
        this.connectionID.SetConnectOption(1, n);
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        this.checkConnection();
        return this.connectionID.GetConnectOption(1) != 0;
    }

    public synchronized boolean isUnicodeServer() throws SQLException {
        this.checkConnection();
        return this.connectionID.IsUnicodeServer();
    }

    protected int charSize() throws SQLException {
        this.checkConnection();
        return this.connectionID.charSize();
    }

    private int getCtreeXnLevel(int n) throws SQLException {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
        }
        throw new CtreeSQLException(26055);
    }

    private int getJDBCXnLevel(int n) throws SQLException {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
        }
        throw new CtreeSQLException(26055);
    }

    public String getuserid() throws SQLException {
        return this.userId;
    }

    private void checkConnection() throws SQLException {
        if (this.isClosed()) {
            throw new CtreeSQLException(26002);
        }
    }

    synchronized int getRowCount(StatementUid statementUid) throws SQLException {
        this.checkConnection();
        int n = -1;
        n = this.connectionID.NrRows(statementUid);
        if (n < 0) {
            throw new CtreeSQLException(26048);
        }
        return n;
    }

    synchronized boolean hasResultSet(StatementUid statementUid) throws SQLException {
        this.checkConnection();
        int n = this.connectionID.GetStatementType(statementUid);
        if (n < 0) {
            throw new CtreeSQLException(26033);
        }
        return this.connectionID.HasResultset(statementUid);
    }

    synchronized CursorT getCursor(StatementUid statementUid) {
        return this.connectionID.getCursor(statementUid);
    }

    synchronized String getCursorName(StatementUid statementUid) {
        return this.connectionID.getCursorName(statementUid);
    }

    synchronized void setCursorName(StatementUid statementUid, String string) {
        this.connectionID.setCursorName(statementUid, string);
    }

    synchronized int getStatementType(StatementUid statementUid) {
        return this.connectionID.GetStatementType(statementUid);
    }

    synchronized StatementUid Tables(String string, String string2, String string3, String[] stringArray, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        this.checkConnection();
        StatementUid statementUid = new StatementUid();
        this.connectionID.Tables(statementUid, string, string2, string3, stringArray, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid Columns(String string, String string2, String string3, String string4, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        this.checkConnection();
        int n = 0;
        StatementUid statementUid = new StatementUid();
        n = this.connectionID.Columns(statementUid, string, string2, string3, string4, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid TypeInfo(CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        this.checkConnection();
        StatementUid statementUid = new StatementUid();
        this.connectionID.TypeInfo(statementUid, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid Schemas(CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.checkConnection();
        this.connectionID.Schemas(statementUid, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid Catalogs(CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.checkConnection();
        this.connectionID.Catalogs(statementUid, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid TableTypes(CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.checkConnection();
        this.connectionID.TableTypes(statementUid, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid Procedures(String string, String string2, String string3, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.checkConnection();
        this.connectionID.Procedures(statementUid, string, string2, string3, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid TablePrivileges(String string, String string2, String string3, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.checkConnection();
        this.connectionID.TablePrivileges(statementUid, string, string2, string3, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid VersionColumns(String string, String string2, String string3, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.checkConnection();
        this.connectionID.VersionColumns(statementUid, string, string2, string3, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid PrimaryKeys(String string, String string2, String string3, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.checkConnection();
        this.connectionID.PrimaryKeys(statementUid, string, string2, string3, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid ExportedKeys(String string, String string2, String string3, CtreeDatabaseMetaData ctreeDatabaseMetaData, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.checkConnection();
        this.connectionID.ExportedKeys(statementUid, string, string2, string3, ctreeDatabaseMetaData, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid CrossReference(String string, String string2, String string3, String string4, String string5, String string6, CtreeDatabaseMetaData ctreeDatabaseMetaData, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.checkConnection();
        this.connectionID.CrossReference(statementUid, string, string2, string3, string4, string5, string6, ctreeDatabaseMetaData, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid ImportedKeys(String string, String string2, String string3, CtreeDatabaseMetaData ctreeDatabaseMetaData, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.connectionID.ImportedKeys(statementUid, string, string2, string3, ctreeDatabaseMetaData, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid IndexInfo(String string, String string2, String string3, boolean bl, boolean bl2, CtreeDatabaseMetaData ctreeDatabaseMetaData, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.checkConnection();
        this.connectionID.IndexInfo(statementUid, string, string2, string3, bl, bl2, ctreeDatabaseMetaData, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid BestRowIdentifier(String string, String string2, String string3, int n, boolean bl, CtreeDatabaseMetaData ctreeDatabaseMetaData, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.checkConnection();
        this.connectionID.BestRowIdentifier(statementUid, string, string2, string3, n, bl, ctreeDatabaseMetaData, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid ProcedureColumns(String string, String string2, String string3, String string4, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.checkConnection();
        this.connectionID.ProcedureColumns(statementUid, string, string2, string3, string4, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid ColumnPrivileges(String string, String string2, String string3, String string4, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.checkConnection();
        this.connectionID.ColumnPrivileges(statementUid, string, string2, string3, string4, ctreeDA, ctreeCA);
        return statementUid;
    }

    public synchronized StatementUid executeDirect(String string, CtreeDA ctreeDA, CtreeCA ctreeCA, String string2, int n, int n2, boolean bl) throws SQLException {
        StatementUid statementUid = new StatementUid();
        statementUid.setCursorName(string2);
        this.checkConnection();
        this.connectionID.ExecDirect(statementUid, string, ctreeDA, ctreeCA, n, n2, bl);
        if (!this.getAutoCommit()) {
            this.m_isMidofTransaction = true;
        }
        return statementUid;
    }

    synchronized StatementUid prepare(String string, CtreeDA ctreeDA, CtreeDA ctreeDA2, boolean bl) throws SQLException {
        StatementUid statementUid = new StatementUid();
        this.checkConnection();
        boolean bl2 = false;
        this.connectionID.Prepare(statementUid, string, bl2, ctreeDA, ctreeDA2, bl);
        return statementUid;
    }

    synchronized boolean execute(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        this.checkConnection();
        if (this.connectionID.Execute(statementUid, ctreeDA, ctreeCA) != 0) {
            return false;
        }
        if (!this.getAutoCommit()) {
            this.m_isMidofTransaction = true;
        }
        return true;
    }

    synchronized void freeStatement(StatementUid statementUid) throws SQLException {
        if (!this.isClosed()) {
            this.connectionID.FreeStatement(statementUid, true);
        }
    }

    synchronized boolean fetch(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        return this.connectionID.Fetch(statementUid, ctreeDA, ctreeCA);
    }

    synchronized boolean getData(StatementUid statementUid, CtreeData ctreeData) throws SQLException {
        return this.connectionID.getData(statementUid, ctreeData);
    }

    synchronized void putData(StatementUid statementUid, InputStream inputStream, int n, String string, int n2) throws SQLException {
        this.connectionID.putData(statementUid, inputStream, n, string, n2);
    }

    public void cancel() throws SQLException {
    }

    public synchronized void closeCursor(StatementUid statementUid) throws SQLException {
        if (!this.isClosed()) {
            if (CtreeConnection.traceOn()) {
                CtreeConnection.trace("@CtreeConnection:closeCursor, closing cursor");
            }
            this.connectionID.CloseCursor(statementUid, this.m_consqlca);
        } else if (CtreeConnection.traceOn()) {
            CtreeConnection.trace("@CtreeConnection:closeCursor, cursor not open");
        }
    }

    public synchronized boolean isOpen(StatementUid statementUid) throws SQLException {
        this.checkConnection();
        return this.connectionID.isOpen(statementUid);
    }

    public String getURL() {
        return this.URL;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (CtreeConnection.traceOn()) {
            CtreeConnection.trace("@CtreeConnection.PreparedStatement(resultSetType = " + n + ", resultSetConcurrency = " + n2 + ")");
        }
        return this.createCtreePreparedStatement(string, n, n2, this.holdability);
    }

    public Map getTypeMap() throws SQLException {
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26075));
        } else {
            this.warnings = new CtreeSQLWarning(26075);
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (CtreeConnection.traceOn()) {
            CtreeConnection.trace("@CtreeConnection.prepareCall(resultSetType = " + n + ", resultSetConcurrency = " + n2 + ")");
        }
        return this.createCtreeCallableStatement(string, n, n2, this.holdability);
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        if (CtreeConnection.traceOn()) {
            CtreeConnection.trace("@CtreeConnection.createStatement(resultSetType = " + n + ", resultSetConcurrency = " + n2 + ")");
        }
        return this.createCtreeStatement(n, n2, this.holdability);
    }

    private int fixResultSetType(int n) throws SQLException {
        if (n != 1003 && n != 1004) {
            if (this.warnings != null) {
                this.warnings.setNextWarning(new CtreeSQLWarning(26078));
            } else {
                this.warnings = new CtreeSQLWarning(26078);
            }
            return 1004;
        }
        return n;
    }

    private int fixResultSetConcurrency(int n) throws SQLException {
        if (n != 1007) {
            if (this.warnings != null) {
                this.warnings.setNextWarning(new CtreeSQLWarning(26098));
            } else {
                this.warnings = new CtreeSQLWarning(26098);
            }
            return 1007;
        }
        return n;
    }

    private int fixResultSetHoldability(int n) throws SQLException {
        if (n != 2) {
            if (this.warnings != null) {
                this.warnings.setNextWarning(new CtreeSQLWarning(26099));
            } else {
                this.warnings = new CtreeSQLWarning(26099);
            }
        }
        return 2;
    }

    protected CtreeStatement createCtreeStatement(int n, int n2, int n3) throws SQLException {
        n = this.fixResultSetType(n);
        n2 = this.fixResultSetConcurrency(n2);
        n3 = this.fixResultSetHoldability(n3);
        return new CtreeStatement(this, n, n2);
    }

    protected CtreePreparedStatement createCtreePreparedStatement(String string) throws SQLException {
        return new CtreePreparedStatement(this, string, 1003, 1007);
    }

    protected CtreePreparedStatement createCtreePreparedStatement(String string, int n, int n2, int n3) throws SQLException {
        n = this.fixResultSetType(n);
        n2 = this.fixResultSetConcurrency(n2);
        n3 = this.fixResultSetHoldability(n3);
        return new CtreePreparedStatement(this, string, n, n2);
    }

    protected CtreeCallableStatement createCtreeCallableStatement(String string) throws SQLException {
        return new CtreeCallableStatement(this, string, 1003, 1007);
    }

    protected CtreeCallableStatement createCtreeCallableStatement(String string, int n, int n2, int n3) throws SQLException {
        n = this.fixResultSetType(n);
        n2 = this.fixResultSetConcurrency(n2);
        n3 = this.fixResultSetHoldability(n3);
        return new CtreeCallableStatement(this, string, n, n2);
    }

    protected CtreeDatabaseMetaData createCtreeDatabaseMetaData() throws SQLException {
        return new CtreeDatabaseMetaData(this);
    }

    @Override
    public synchronized void setHoldability(int n) throws SQLException {
        if (n != 2) {
            throw new CtreeSQLException(26065);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.holdability;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public synchronized Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (CtreeConnection.traceOn()) {
            CtreeConnection.trace("@CtreeConnection.createStatement(resultSetType = " + n + ", resultSetConcurrency = " + n2 + ", resultSetHoldability = " + n3 + ")");
        }
        return this.createCtreeStatement(n, n2, n3);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (CtreeConnection.traceOn()) {
            CtreeConnection.trace("@CtreeConnection.prepareStatement(resultSetType = " + n + ", resultSetConcurrency = " + n2 + ", resultSetHoldability = " + n3 + ")");
        }
        return this.createCtreePreparedStatement(string, n, n2, n3);
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (CtreeConnection.traceOn()) {
            CtreeConnection.trace("@CtreeConnection.prepareCall(resultSetType = " + n + ", resultSetConcurrency = " + n2 + ", resultSetHoldability = " + n3 + ")");
        }
        return this.createCtreeCallableStatement(string, n, n2, n3);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (n == 2) {
            return this.prepareStatement(string);
        }
        throw new SQLFeatureNotSupportedException(CtreeSQLException.getErrorMessage(26065), CtreeSQLException.getSQLState(26065), 26065);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(CtreeSQLException.getErrorMessage(26065), CtreeSQLException.getSQLState(26065), 26065);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(CtreeSQLException.getErrorMessage(26065), CtreeSQLException.getSQLState(26065), 26065);
    }

    synchronized StatementUid SuperTypes(String string, String string2, String string3, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        this.checkConnection();
        StatementUid statementUid = new StatementUid();
        this.connectionID.SuperTypes(statementUid, string, string2, string3, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid PseudoColumns(String string, String string2, String string3, String string4, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        this.checkConnection();
        StatementUid statementUid = new StatementUid();
        this.connectionID.PseudoColumns(statementUid, string, string2, string3, string4, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid SuperTables(String string, String string2, String string3, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        this.checkConnection();
        StatementUid statementUid = new StatementUid();
        this.connectionID.SuperTables(statementUid, string, string2, string3, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid Attributes(String string, String string2, String string3, String string4, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        this.checkConnection();
        StatementUid statementUid = new StatementUid();
        this.connectionID.Attributes(statementUid, string, string2, string3, string4, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid UDTs(String string, String string2, String string3, int[] nArray, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        this.checkConnection();
        StatementUid statementUid = new StatementUid();
        this.connectionID.UDTs(statementUid, string, string2, string3, nArray, ctreeDA, ctreeCA);
        return statementUid;
    }

    public synchronized StatementUid executeDirectBatch(String string, Vector vector, CtreeCA ctreeCA, String string2, int n) throws SQLException {
        StatementUid statementUid = new StatementUid();
        statementUid.setCursorName(string2);
        this.checkConnection();
        this.connectionID.ExecDirectBatch(string, vector, ctreeCA, statementUid, n);
        return statementUid;
    }

    public int[] getRowCounts(StatementUid statementUid) throws SQLException {
        this.checkConnection();
        return this.connectionID.GetNrBatchRows(statementUid);
    }

    public synchronized boolean executeBatch(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        this.checkConnection();
        return this.connectionID.ExecBatch(statementUid, ctreeDA, ctreeCA);
    }

    void validateClientInfoValue(String string, String string2) {
        String string3 = string2;
        int n = string3.length();
        if (n > 128) {
            if (this.warnings != null) {
                this.warnings.setNextWarning(new CtreeSQLWarning(26093));
            } else {
                this.warnings = new CtreeSQLWarning(26093);
            }
        }
    }

    void validateClientInfoKey(String string) {
        if (!(string.equals("ApplicationName") || string.equals("ClientUser") || string.equals("ClientHostname"))) {
            if (this.warnings != null) {
                this.warnings.setNextWarning(new CtreeSQLWarning(26092));
            } else {
                this.warnings = new CtreeSQLWarning(26092);
            }
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.validateClientInfoKey(string);
        return this.clientInfo.getProperty(string);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Properties properties = new Properties(this.clientInfo);
        return properties;
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        boolean bl = false;
        try {
            bl = this.isClosed();
        }
        catch (SQLException sQLException) {
            CtreeSQLException ctreeSQLException = new CtreeSQLException(26015);
            throw new SQLClientInfoException(CtreeSQLException.getErrorMessage(26015), CtreeSQLException.getSQLState(26015), 26015, null);
        }
        if (bl) {
            CtreeSQLException ctreeSQLException = new CtreeSQLException(26015);
            throw new SQLClientInfoException(CtreeSQLException.getErrorMessage(26015), CtreeSQLException.getSQLState(26015), 26015, null);
        }
        this.validateClientInfoKey(string);
        this.validateClientInfoValue(string, string2);
        if (string2.length() <= 128) {
            this.clientInfo.setProperty(string, string2);
        } else {
            this.clientInfo.setProperty(string, string2.substring(0, 128));
        }
    }

    synchronized StatementUid getClientInfoProperties(CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        this.checkConnection();
        StatementUid statementUid = new StatementUid();
        this.connectionID.getClientInfoProperties(statementUid, ctreeDA, ctreeCA);
        return statementUid;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (properties.isEmpty()) {
            this.clientInfo.setProperty("ApplicationName", "");
            this.clientInfo.setProperty("ClientUser", "");
            this.clientInfo.setProperty("ClientHostname", "");
        } else {
            this.clientInfo.clear();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.clientInfo.setProperty(string, properties.getProperty(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int n) throws SQLException {
        if (n < 0) {
            throw new CtreeSQLException(26096);
        }
        if (this.isClosed()) {
            return false;
        }
        CtreePreparedStatement ctreePreparedStatement = null;
        try {
            ctreePreparedStatement = this.createCtreePreparedStatement("SELECT 999");
            ctreePreparedStatement.setQueryTimeout(n);
            CtreeResultSet ctreeResultSet = (CtreeResultSet)ctreePreparedStatement.executeQuery();
            if (ctreeResultSet.next() && ctreeResultSet.getInt(1) == 999) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sQLException) {
            boolean bl = false;
            return bl;
        }
        finally {
            ctreePreparedStatement.setQueryTimeout(0);
            ctreePreparedStatement.close();
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        CtreeSQLException ctreeSQLException = new CtreeSQLException(26030);
        throw new SQLFeatureNotSupportedException(CtreeSQLException.getErrorMessage(26030), CtreeSQLException.getSQLState(26030), 26030);
    }

    @Override
    public Clob createClob() throws SQLException {
        CtreeSQLException ctreeSQLException = new CtreeSQLException(26030);
        throw new SQLFeatureNotSupportedException(CtreeSQLException.getErrorMessage(26030), CtreeSQLException.getSQLState(26030), 26030);
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return this.getClass().getName().equals(clazz.getName());
    }

    public CtreeConnection unwrap(Class clazz) throws SQLException {
        boolean bl = clazz.getName().equals(this.getClass().getName());
        if (!bl) {
            throw new CtreeSQLException(26094);
        }
        return this;
    }

    synchronized StatementUid getFunctions(String string, String string2, String string3, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        this.checkConnection();
        StatementUid statementUid = new StatementUid();
        this.connectionID.getFunctions(statementUid, string, string2, string3, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid getFunctionColumns(String string, String string2, String string3, String string4, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        this.checkConnection();
        StatementUid statementUid = new StatementUid();
        this.connectionID.getFunctionColumns(statementUid, string, string2, string3, string4, ctreeDA, ctreeCA);
        return statementUid;
    }

    synchronized StatementUid getSchemas(String string, String string2, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        this.checkConnection();
        StatementUid statementUid = new StatementUid();
        this.connectionID.getSchemas(statementUid, string, string2, ctreeDA, ctreeCA);
        return statementUid;
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        CtreeSQLException ctreeSQLException = new CtreeSQLException(26030);
        throw new SQLFeatureNotSupportedException(CtreeSQLException.getErrorMessage(26030), CtreeSQLException.getSQLState(26030), 26030);
    }

    @Override
    public NClob createNClob() throws SQLException {
        CtreeSQLException ctreeSQLException = new CtreeSQLException(26030);
        throw new SQLFeatureNotSupportedException(CtreeSQLException.getErrorMessage(26030), CtreeSQLException.getSQLState(26030), 26030);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        CtreeSQLException ctreeSQLException = new CtreeSQLException(26030);
        throw new SQLFeatureNotSupportedException(CtreeSQLException.getErrorMessage(26030), CtreeSQLException.getSQLState(26030), 26030);
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        CtreeSQLException ctreeSQLException = new CtreeSQLException(26030);
        throw new SQLFeatureNotSupportedException(CtreeSQLException.getErrorMessage(26030), CtreeSQLException.getSQLState(26030), 26030);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        CtreeSQLException ctreeSQLException = new CtreeSQLException(26030);
        throw new SQLFeatureNotSupportedException(CtreeSQLException.getErrorMessage(26030), CtreeSQLException.getSQLState(26030), 26030);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setSchema(String string) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    public int dumpSp(CtreeSQLProcInfo ctreeSQLProcInfo) {
        return this.connectionID.dumpSp(ctreeSQLProcInfo);
    }

    public int deploySp(CtreeSQLProcInfo ctreeSQLProcInfo, CtreeSQLProcInfo.CtreeSQLProcOptions ctreeSQLProcOptions) {
        ctreeSQLProcInfo.setOptions(ctreeSQLProcOptions);
        return this.connectionID.deploySp(ctreeSQLProcInfo);
    }

    public Charset getCharset() {
        if (this.connectionID == null) {
            return null;
        }
        return this.connectionID.getCharset();
    }

    protected int getNOfRows(StatementUid statementUid) throws SQLException {
        this.checkConnection();
        int n = this.connectionID.getNOfRows(statementUid);
        return n;
    }

    protected int getMaxFieldSize() {
        if (this.connectionID != null) {
            return this.connectionID.maxFieldSize;
        }
        return 8192;
    }
}

