/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.CtreeURL;
import ctree.jdbc.CtreeValue;
import ctree.jdbc.SQLPacket;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public final class CtreeDA
implements CtreeError {
    private Charset csm;
    private short allocatedColumns;
    private short allocatedRows;
    private int charSize;
    private boolean unicodeCompatibility;
    private short nVars;
    private short nColumns;
    private short nRows;
    private CtreeValue[][] values;
    private int[] precisions;
    private short[] scales;
    private short[] hostTypes;
    private int[] lengths;
    private short[] flags;
    private short varnmSize;
    private String[] varNames;
    private String[] indVarNames;
    private int[] rlengths;
    private String[] collateNames;
    private String[] charsetNames;
    private String[] baseColumnNames;
    private String[] baseTableNames;
    private short[] searchables;
    private short[] updatables;
    private short[] paramTypes;
    private String[] tableNames;
    private short[] verboseTypes;
    private short[] odbcFlags;
    private short[] dateIntCodes;
    private short[] dateIntPrecs;
    private SQLType[] sqlTypes;
    boolean isDescribeParamCalled = false;
    private static short PRECISION_OF_DATE = (short)10;
    private static short PRECISION_OF_FLOAT = (short)7;
    private static short PRECISION_OF_DOUBLE = (short)15;
    private static short PRECISION_OF_INTEGER = (short)10;
    private static short PRECISION_OF_SMALLINT = (short)5;
    private static short PRECISION_OF_TIME = (short)8;
    private static short PRECISION_OF_TINYINT = (short)3;
    private static short PRECISION_OF_TIMESTAMP = (short)23;
    private static short SCALE_OF_TIMESTAMP = (short)3;
    private static short SIZE_OF_DATE = (short)4;
    private static short SIZE_OF_TIME = (short)6;
    private static short SIZE_OF_TIMESTAMP = (short)10;
    private static short MAX_PRECISION = (short)32;
    private final short item_varchar = (short)16;
    private final short item_varbinary = (short)32;
    private final short item_money = (short)64;
    private int maxFieldSize;
    private int arraySize;
    private boolean[] outFlags;

    private void AllocArrays() {
        int n;
        this.allocatedRows = this.nRows;
        this.allocatedColumns = this.nColumns;
        if (this.allocatedColumns == 0) {
            this.allocatedColumns = 1;
        }
        if (this.allocatedRows == 0) {
            this.allocatedRows = 1;
        }
        this.values = new CtreeValue[this.allocatedColumns][this.allocatedRows];
        this.hostTypes = new short[this.allocatedColumns];
        this.sqlTypes = new SQLType[this.allocatedColumns];
        this.scales = new short[this.allocatedColumns];
        this.precisions = new int[this.allocatedColumns];
        this.lengths = new int[this.allocatedColumns];
        this.flags = new short[this.allocatedColumns];
        this.outFlags = new boolean[this.allocatedColumns];
        this.varNames = new String[this.allocatedColumns];
        this.indVarNames = new String[this.allocatedColumns];
        this.rlengths = new int[this.allocatedColumns];
        this.collateNames = new String[this.allocatedColumns];
        this.charsetNames = new String[this.allocatedColumns];
        this.baseColumnNames = new String[this.allocatedColumns];
        this.baseTableNames = new String[this.allocatedColumns];
        this.searchables = new short[this.allocatedColumns];
        this.updatables = new short[this.allocatedColumns];
        this.paramTypes = new short[this.allocatedColumns];
        this.tableNames = new String[this.allocatedColumns];
        this.verboseTypes = new short[this.allocatedColumns];
        this.odbcFlags = new short[this.allocatedColumns];
        this.dateIntCodes = new short[this.allocatedColumns];
        this.dateIntPrecs = new short[this.allocatedColumns];
        for (n = 0; n < this.allocatedColumns; ++n) {
            this.hostTypes[n] = -1;
            this.sqlTypes[n] = null;
            this.scales[n] = 0;
            this.precisions[n] = 0;
            this.lengths[n] = 0;
            this.outFlags[n] = false;
            this.varNames[n] = null;
            this.indVarNames[n] = null;
            this.rlengths[n] = 0;
            this.collateNames[n] = null;
            this.charsetNames[n] = null;
            this.baseColumnNames[n] = null;
            this.baseTableNames[n] = null;
            this.searchables[n] = 0;
            this.updatables[n] = 0;
            this.paramTypes[n] = 0;
            this.tableNames[n] = null;
            this.verboseTypes[n] = 0;
            this.odbcFlags[n] = 0;
            this.dateIntCodes[n] = 0;
            this.dateIntPrecs[n] = 0;
        }
        for (n = 0; n < this.allocatedColumns; ++n) {
            for (int i = 0; i < this.allocatedRows; ++i) {
                this.values[n][i] = new CtreeValue(this.unicodeCompatibility);
            }
        }
    }

    public CtreeDA(int n, int n2, int n3, boolean bl, Charset charset, int n4) {
        this.charSize = n3;
        this.unicodeCompatibility = bl;
        this.allocatedColumns = 0;
        this.allocatedRows = 0;
        this.nColumns = (short)n;
        this.nRows = (short)n2;
        this.varnmSize = (short)65;
        this.maxFieldSize = n4;
        this.csm = charset != null ? charset : CtreeURL.defaultCharset;
        this.AllocArrays();
    }

    public CtreeDA(int n, boolean bl, Charset charset, int n2) {
        this(0, 0, n, bl, charset, n2);
    }

    public void setParameterCount(String string) {
        int n = 0;
        short s = 0;
        if (string.startsWith("CALL") || string.startsWith("call")) {
            return;
        }
        block5: while (n < string.length()) {
            switch (string.charAt(n)) {
                case '?': {
                    s = (short)(s + 1);
                    ++n;
                    continue block5;
                }
                case '\"': {
                    ++n;
                    while (string.charAt(n) != '\"') {
                        ++n;
                    }
                    ++n;
                    continue block5;
                }
                case '\'': {
                    ++n;
                    while (string.charAt(n) != '\'') {
                        ++n;
                    }
                    ++n;
                    continue block5;
                }
            }
            ++n;
        }
        this.setNColumns(s);
        this.nVars = s;
        this.nColumns = s;
    }

    public void close() {
        int n;
        for (n = 0; n < this.allocatedColumns; ++n) {
            for (int i = 0; i < this.allocatedRows; ++i) {
                this.values[n][i] = null;
            }
        }
        for (n = 0; n < this.allocatedColumns; ++n) {
            this.varNames[n] = null;
            this.indVarNames[n] = null;
            this.collateNames[n] = null;
            this.charsetNames[n] = null;
            this.baseColumnNames[n] = null;
            this.baseTableNames[n] = null;
            this.tableNames[n] = null;
        }
        this.values = null;
        this.hostTypes = null;
        this.sqlTypes = null;
        this.scales = null;
        this.precisions = null;
        this.lengths = null;
        this.flags = null;
        this.outFlags = null;
        this.varNames = null;
        this.indVarNames = null;
        this.rlengths = null;
        this.collateNames = null;
        this.charsetNames = null;
        this.baseColumnNames = null;
        this.baseTableNames = null;
        this.searchables = null;
        this.updatables = null;
        this.paramTypes = null;
        this.tableNames = null;
        this.verboseTypes = null;
        this.odbcFlags = null;
        this.dateIntCodes = null;
        this.dateIntPrecs = null;
        this.nRows = 0;
        this.nColumns = 0;
        this.allocatedRows = 0;
        this.allocatedColumns = 0;
    }

    public void finalize() {
        this.close();
    }

    public void resize(int n, int n2) {
        if (this.values == null) {
            this.nColumns = (short)n;
            this.nRows = (short)n2;
            this.AllocArrays();
            return;
        }
        if (n > this.allocatedColumns) {
            short[] sArray = this.hostTypes;
            this.hostTypes = new short[n];
            System.arraycopy(sArray, 0, this.hostTypes, 0, this.allocatedColumns);
            SQLType[] sQLTypeArray = this.sqlTypes;
            this.sqlTypes = new SQLType[n];
            System.arraycopy(sQLTypeArray, 0, this.sqlTypes, 0, this.allocatedColumns);
            short[] sArray2 = this.scales;
            this.scales = new short[n];
            System.arraycopy(sArray2, 0, this.scales, 0, this.allocatedColumns);
            int[] nArray = this.precisions;
            this.precisions = new int[n];
            System.arraycopy(nArray, 0, this.precisions, 0, this.allocatedColumns);
            boolean[] blArray = this.outFlags;
            this.outFlags = new boolean[n];
            System.arraycopy(blArray, 0, this.outFlags, 0, this.allocatedColumns);
            int[] nArray2 = this.lengths;
            this.lengths = new int[n];
            System.arraycopy(nArray2, 0, this.lengths, 0, this.allocatedColumns);
            short[] sArray3 = this.flags;
            this.flags = new short[n];
            System.arraycopy(sArray3, 0, this.flags, 0, this.allocatedColumns);
            String[] stringArray = this.varNames;
            this.varNames = new String[n];
            System.arraycopy(stringArray, 0, this.varNames, 0, this.allocatedColumns);
            String[] stringArray2 = this.indVarNames;
            this.indVarNames = new String[n];
            System.arraycopy(stringArray2, 0, this.indVarNames, 0, this.allocatedColumns);
            int[] nArray3 = this.rlengths;
            this.rlengths = new int[n];
            System.arraycopy(nArray3, 0, this.rlengths, 0, this.allocatedColumns);
            String[] stringArray3 = this.collateNames;
            this.collateNames = new String[n];
            System.arraycopy(stringArray3, 0, this.collateNames, 0, this.allocatedColumns);
            String[] stringArray4 = this.charsetNames;
            this.charsetNames = new String[n];
            System.arraycopy(stringArray4, 0, this.charsetNames, 0, this.allocatedColumns);
            String[] stringArray5 = this.baseColumnNames;
            this.baseColumnNames = new String[n];
            System.arraycopy(stringArray5, 0, this.baseColumnNames, 0, this.allocatedColumns);
            String[] stringArray6 = this.baseTableNames;
            this.baseTableNames = new String[n];
            System.arraycopy(stringArray6, 0, this.baseTableNames, 0, this.allocatedColumns);
            short[] sArray4 = this.searchables;
            this.searchables = new short[n];
            System.arraycopy(sArray4, 0, this.searchables, 0, this.allocatedColumns);
            short[] sArray5 = this.updatables;
            this.updatables = new short[n];
            System.arraycopy(sArray5, 0, this.updatables, 0, this.allocatedColumns);
            short[] sArray6 = this.paramTypes;
            this.paramTypes = new short[n];
            System.arraycopy(sArray6, 0, this.paramTypes, 0, this.allocatedColumns);
            String[] stringArray7 = this.tableNames;
            this.tableNames = new String[n];
            System.arraycopy(stringArray7, 0, this.tableNames, 0, this.allocatedColumns);
            short[] sArray7 = this.verboseTypes;
            this.verboseTypes = new short[n];
            System.arraycopy(sArray7, 0, this.verboseTypes, 0, this.allocatedColumns);
            short[] sArray8 = this.odbcFlags;
            this.odbcFlags = new short[n];
            System.arraycopy(sArray8, 0, this.odbcFlags, 0, this.allocatedColumns);
            short[] sArray9 = this.dateIntCodes;
            this.dateIntCodes = new short[n];
            System.arraycopy(sArray9, 0, this.dateIntCodes, 0, this.allocatedColumns);
            short[] sArray10 = this.dateIntPrecs;
            this.dateIntPrecs = new short[n];
            System.arraycopy(sArray10, 0, this.dateIntPrecs, 0, this.allocatedColumns);
            for (int i = this.allocatedColumns; i < n; ++i) {
                this.hostTypes[i] = -1;
                this.lengths[i] = 0;
                this.scales[i] = 0;
                this.precisions[i] = 0;
                this.outFlags[i] = false;
                this.varNames[i] = null;
                this.indVarNames[i] = null;
                this.rlengths[i] = 0;
                this.collateNames[i] = null;
                this.charsetNames[i] = null;
                this.baseColumnNames[i] = null;
                this.baseTableNames[i] = null;
                this.searchables[i] = 0;
                this.updatables[i] = 0;
                this.paramTypes[i] = 0;
                this.tableNames[i] = null;
                this.verboseTypes[i] = 0;
                this.odbcFlags[i] = 0;
                this.dateIntCodes[i] = 0;
                this.dateIntPrecs[i] = 0;
                this.sqlTypes[i] = null;
            }
            if (n2 > this.allocatedRows) {
                int n3;
                int n4;
                CtreeValue[][] ctreeValueArray = this.values;
                this.values = new CtreeValue[n][n2];
                for (n4 = 0; n4 < this.allocatedColumns; ++n4) {
                    System.arraycopy(ctreeValueArray[n4], 0, this.values[n4], 0, this.allocatedRows);
                    for (n3 = (int)this.allocatedRows; n3 < n2; ++n3) {
                        this.values[n4][n3] = new CtreeValue(this.unicodeCompatibility);
                    }
                }
                for (n4 = this.allocatedColumns; n4 < n; ++n4) {
                    for (n3 = 0; n3 < n2; ++n3) {
                        this.values[n4][n3] = new CtreeValue(this.unicodeCompatibility);
                    }
                }
                this.allocatedRows = (short)n2;
            } else {
                int n5;
                CtreeValue[][] ctreeValueArray = this.values;
                this.values = new CtreeValue[n][this.allocatedRows];
                for (n5 = 0; n5 < this.allocatedColumns; ++n5) {
                    System.arraycopy(ctreeValueArray[n5], 0, this.values[n5], 0, this.allocatedRows);
                }
                for (n5 = this.allocatedColumns; n5 < n; ++n5) {
                    for (int i = 0; i < this.allocatedRows; ++i) {
                        this.values[n5][i] = new CtreeValue(this.unicodeCompatibility);
                    }
                }
            }
            this.allocatedColumns = (short)n;
        } else if (n2 > this.allocatedRows) {
            CtreeValue[][] ctreeValueArray = this.values;
            this.values = new CtreeValue[this.allocatedColumns][n2];
            for (int i = 0; i < this.allocatedColumns; ++i) {
                System.arraycopy(ctreeValueArray[i], 0, this.values[i], 0, this.allocatedRows);
                for (int j = this.allocatedRows; j < n2; ++j) {
                    this.values[i][j] = new CtreeValue(this.unicodeCompatibility);
                }
            }
            this.allocatedRows = (short)n2;
        }
        this.nColumns = (short)n;
        this.nRows = (short)n2;
    }

    public void print(String string) throws SQLException {
        int n;
        System.out.println(string + "\t" + this.nColumns + " columns " + this.nRows + " rows");
        for (n = 0; n < this.nColumns; ++n) {
            System.out.println(n + "/ " + this.varNames[n] + " " + this.indVarNames[n] + " T" + this.sqlTypes[n]);
        }
        for (int i = 0; i < this.nRows; ++i) {
            for (n = 0; n < this.nColumns; ++n) {
                if (this.values[n][i] != null) {
                    this.values[n][i].print();
                    System.out.println(" ");
                    continue;
                }
                System.out.println("NULL");
            }
        }
        System.out.println("--------------------------------------------");
    }

    public short getNColumns() {
        return this.nColumns;
    }

    public void setNColumns(short s) {
        this.resize(s, this.nRows);
    }

    public short getNRows() {
        return this.nRows;
    }

    public void setNRows(short s) {
        this.resize(this.nColumns, s);
    }

    public short getNVars() {
        return this.nVars;
    }

    public void setNVars(short s) {
        this.nVars = s;
    }

    void nullError() throws SQLException {
        throw new CtreeSQLException(26055);
    }

    void checkFieldRange(int n) throws SQLException {
        if (n < 0 || n >= this.nColumns) {
            throw new CtreeSQLException(26049);
        }
    }

    public void setType(int n, SQLType sQLType) throws SQLException {
        this.checkFieldRange(n);
        if (sQLType == JDBCType.CHAR && this.unicodeCompatibility) {
            this.hostTypes[n] = 17;
            this.lengths[n] = this.lengths[n] * this.charSize;
        } else if (sQLType == JDBCType.VARCHAR && this.unicodeCompatibility) {
            this.hostTypes[n] = 18;
            this.lengths[n] = this.lengths[n] * this.charSize;
        }
        this.sqlTypes[n] = (JDBCType)sQLType;
    }

    public void setLength(int n, int n2) throws SQLException {
        this.checkFieldRange(n);
        this.lengths[n] = n2;
    }

    public void setPrecision(int n, short s) throws SQLException {
        this.checkFieldRange(n);
        this.precisions[n] = s;
    }

    public void setScale(int n, short s) throws SQLException {
        this.checkFieldRange(n);
        this.scales[n] = s;
    }

    public void setScale(int n, int n2) throws SQLException {
        this.checkFieldRange(n);
        this.scales[n] = (short)n2;
    }

    public void setVarName(int n, String string) throws SQLException {
        this.checkFieldRange(n);
        this.varNames[n] = string;
    }

    public void setIndVarName(int n, String string) throws SQLException {
        this.checkFieldRange(n);
        this.indVarNames[n] = string;
    }

    public void setRlength(int n, int n2) throws SQLException {
        this.checkFieldRange(n);
        this.rlengths[n] = n2;
    }

    public void setCollateName(int n, String string) throws SQLException {
        this.checkFieldRange(n);
        this.collateNames[n] = string;
    }

    public void setCharsetName(int n, String string) throws SQLException {
        this.checkFieldRange(n);
        this.charsetNames[n] = string;
    }

    public void setBaseColumnName(int n, String string) throws SQLException {
        this.checkFieldRange(n);
        this.baseColumnNames[n] = string;
    }

    public void setBaseTableName(int n, String string) throws SQLException {
        this.checkFieldRange(n);
        this.baseTableNames[n] = string;
    }

    public void setSearchable(int n, short s) throws SQLException {
        this.checkFieldRange(n);
        this.searchables[n] = s;
    }

    public void setUpdatable(int n, short s) throws SQLException {
        this.checkFieldRange(n);
        this.updatables[n] = s;
    }

    public void setParamType(int n, short s) throws SQLException {
        this.checkFieldRange(n);
        this.paramTypes[n] = s;
    }

    public void setTableName(int n, String string) throws SQLException {
        this.checkFieldRange(n);
        this.tableNames[n] = string;
    }

    public void setVerboseType(int n, short s) throws SQLException {
        this.checkFieldRange(n);
        this.verboseTypes[n] = s;
    }

    public void setOdbcFlag(int n, short s) throws SQLException {
        this.checkFieldRange(n);
        this.odbcFlags[n] = s;
    }

    public void setFlag(int n, short s) throws SQLException {
        this.checkFieldRange(n);
        this.flags[n] = s;
    }

    public void setVarnmSize(short s) {
        this.varnmSize = s;
    }

    public short getVarnmSize() {
        return this.varnmSize;
    }

    public void setClength(int n, int n2) throws SQLException {
    }

    public void setDateIntCode(int n, short s) throws SQLException {
        this.checkFieldRange(n);
        this.dateIntCodes[n] = s;
    }

    public void setDateIntPrec(int n, short s) throws SQLException {
        this.checkFieldRange(n);
        this.dateIntPrecs[n] = s;
    }

    public void setSqlTypes(int n, short s) throws SQLException {
        this.checkFieldRange(n);
        switch (s) {
            case 4: {
                this.sqlTypes[n] = JDBCType.INTEGER;
                break;
            }
            case 16: {
                this.sqlTypes[n] = JDBCType.BIGINT;
                break;
            }
            case 3: {
                this.sqlTypes[n] = JDBCType.SMALLINT;
                break;
            }
            case 11: {
                this.sqlTypes[n] = JDBCType.TINYINT;
                break;
            }
            case 13: {
                this.sqlTypes[n] = JDBCType.BIT;
                break;
            }
            case 2: 
            case 8: {
                this.sqlTypes[n] = JDBCType.NUMERIC;
                break;
            }
            case 5: {
                this.sqlTypes[n] = JDBCType.REAL;
                break;
            }
            case 6: {
                if (this.lengths[n] == 4) {
                    this.sqlTypes[n] = JDBCType.FLOAT;
                    break;
                }
                this.sqlTypes[n] = JDBCType.DOUBLE;
                break;
            }
            case 7: {
                this.sqlTypes[n] = JDBCType.DATE;
                break;
            }
            case 9: {
                this.sqlTypes[n] = JDBCType.TIME;
                break;
            }
            case 10: {
                this.sqlTypes[n] = JDBCType.TIMESTAMP;
                break;
            }
            case 1: 
            case 17: {
                this.sqlTypes[n] = JDBCType.CHAR;
                break;
            }
            case 18: 
            case 21: {
                this.sqlTypes[n] = JDBCType.VARCHAR;
                break;
            }
            case 12: {
                this.sqlTypes[n] = JDBCType.BINARY;
                break;
            }
            case 26: {
                this.sqlTypes[n] = JDBCType.VARBINARY;
                break;
            }
            case 15: {
                this.sqlTypes[n] = JDBCType.LONGVARBINARY;
                break;
            }
            case 14: 
            case 24: {
                this.sqlTypes[n] = JDBCType.LONGVARCHAR;
                break;
            }
            case 23: {
                this.sqlTypes[n] = JDBCType.CLOB;
                break;
            }
            case 22: {
                this.sqlTypes[n] = JDBCType.BLOB;
                break;
            }
        }
    }

    public void setHostType(int n, short s) throws SQLException {
        this.checkFieldRange(n);
        this.hostTypes[n] = s;
    }

    private short getObjectHostType(Object object) {
        int n = -1;
        if (object instanceof Integer) {
            n = 4;
        } else if (object instanceof Long) {
            n = 16;
        } else if (object instanceof Short) {
            n = 3;
        } else if (object instanceof Byte) {
            n = 11;
        } else if (object instanceof Boolean) {
            n = 13;
        } else if (object instanceof BigDecimal) {
            n = 2;
        } else if (object instanceof Float) {
            n = 5;
        } else if (object instanceof Double) {
            n = 6;
        } else if (object instanceof Date) {
            n = 7;
        } else if (object instanceof Time) {
            n = 9;
        } else if (object instanceof Timestamp) {
            n = 10;
        } else if (object instanceof InputStream) {
            n = 26;
        } else if (object instanceof byte[]) {
            n = 12;
        } else if (object instanceof Blob) {
            n = 22;
        } else if (object instanceof Clob) {
            n = 23;
        } else if (object instanceof String) {
            n = this.unicodeCompatibility ? 18 : 21;
        }
        return (short)n;
    }

    protected void setHostTypes(int n, Object object) {
        short s = this.getObjectHostType(object);
        this.setHostTypes(n, s);
    }

    private void setHostTypes(int n, short s) {
        short s2 = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        switch (s) {
            case 4: {
                s2 = 4;
                n2 = 4;
                n3 = PRECISION_OF_INTEGER;
                break;
            }
            case 16: {
                s2 = 16;
                n2 = 8;
                n3 = 19;
                break;
            }
            case 3: {
                s2 = 3;
                n2 = 4;
                n3 = PRECISION_OF_SMALLINT;
                break;
            }
            case 11: {
                s2 = 11;
                n2 = 1;
                n3 = PRECISION_OF_TINYINT;
                break;
            }
            case 13: {
                s2 = 13;
                n2 = 1;
                break;
            }
            case 2: {
                s2 = 2;
                n2 = 19;
                n3 = MAX_PRECISION;
                break;
            }
            case 5: {
                s2 = 5;
                n2 = 4;
                n3 = PRECISION_OF_FLOAT;
                break;
            }
            case 6: {
                s2 = 6;
                n2 = 8;
                n3 = PRECISION_OF_DOUBLE;
                break;
            }
            case 7: {
                s2 = 7;
                n2 = SIZE_OF_DATE;
                n3 = PRECISION_OF_DATE;
                break;
            }
            case 9: {
                s2 = 9;
                n2 = SIZE_OF_TIME;
                n3 = PRECISION_OF_TIME;
                break;
            }
            case 10: {
                s2 = 10;
                n2 = SIZE_OF_TIMESTAMP;
                n3 = PRECISION_OF_TIMESTAMP;
                n4 = SCALE_OF_TIMESTAMP;
                break;
            }
            case 26: {
                s2 = 26;
                break;
            }
            case 12: {
                s2 = 12;
                break;
            }
            case 1: {
                if (this.unicodeCompatibility) {
                    this.hostTypes[n] = 17;
                    break;
                }
                this.hostTypes[n] = 1;
                break;
            }
            case 21: {
                if (this.unicodeCompatibility) {
                    s2 = 18;
                    break;
                }
                s2 = 21;
                break;
            }
            case 22: {
                s2 = 22;
                n2 = this.maxFieldSize;
                break;
            }
            case 23: {
                s2 = 23;
                n2 = this.maxFieldSize;
            }
        }
        if (s2 != -1) {
            this.hostTypes[n] = s2;
            if (n2 != -1) {
                this.lengths[n] = n2;
            }
            if (n3 != -1) {
                this.precisions[n] = n3;
            }
            if (n4 != -1) {
                this.scales[n] = n4;
            }
            try {
                this.setSqlTypes(n, s2);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public SQLType getSqlType(int n) throws SQLException {
        return this.sqlTypes[n];
    }

    public short getHostType(int n) throws SQLException {
        return this.hostTypes[n];
    }

    public int getLength(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.lengths[n];
    }

    public int getPrecision(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.precisions[n];
    }

    public int[] getPrecisionArray() {
        return this.precisions;
    }

    public short getScale(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.scales[n];
    }

    public short[] getScaleArray() {
        return this.scales;
    }

    public String getVarName(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.varNames[n];
    }

    public String[] getVarNameArray() throws SQLException {
        return this.varNames;
    }

    public String getIndVarName(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.indVarNames[n];
    }

    public String[] getIndVarNameArray() {
        return this.indVarNames;
    }

    public int getClength(int n) throws SQLException {
        return 0;
    }

    public int getRlength(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.rlengths[n];
    }

    public int[] getRlengthArray() {
        return this.rlengths;
    }

    public String getCollateName(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.collateNames[n];
    }

    public String[] getCollateNameArray() {
        return this.collateNames;
    }

    public String getCharsetName(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.charsetNames[n];
    }

    public String[] getCharsetNameArray() throws SQLException {
        return this.charsetNames;
    }

    public String getBaseColumnName(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.baseColumnNames[n];
    }

    public String[] getBaseColumnNameArray() {
        return this.baseColumnNames;
    }

    public String getBaseTableName(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.baseTableNames[n];
    }

    public String[] getBaseTableNameArray() {
        return this.baseTableNames;
    }

    public short getSearchable(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.searchables[n];
    }

    public short[] getSearchableArray() {
        return this.searchables;
    }

    public short getUpdatable(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.updatables[n];
    }

    public short[] getUpdatableArray() {
        return this.updatables;
    }

    public short getParamType(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.paramTypes[n];
    }

    public short[] getParamTypeArray() {
        return this.paramTypes;
    }

    public String getTableName(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.tableNames[n];
    }

    public String[] getTableNameArray() {
        return this.tableNames;
    }

    public short getVerboseType(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.verboseTypes[n];
    }

    public short[] getVerboseTypeArray() {
        return this.verboseTypes;
    }

    public short getOdbcFlag(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.odbcFlags[n];
    }

    public short getFlag(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.flags[n];
    }

    public short[] getFlagArray() throws SQLException {
        return this.flags;
    }

    public short[] getOdbcFlagArray() {
        return this.odbcFlags;
    }

    public short getDateIntCode(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.dateIntCodes[n];
    }

    public short[] getDateIntCodeArray() {
        return this.dateIntCodes;
    }

    public short getDateIntPrec(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.dateIntPrecs[n];
    }

    public short[] getDateIntPrecArray() {
        return this.dateIntPrecs;
    }

    public String getTypeName(int n) throws SQLException {
        SQLType sQLType = this.getSqlType(n);
        switch ((JDBCType)sQLType) {
            case TINYINT: {
                return "tinyint";
            }
            case SMALLINT: {
                return "smallint";
            }
            case INTEGER: {
                return "integer";
            }
            case BIGINT: {
                return "bigint";
            }
            case REAL: {
                return "real";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case NUMERIC: {
                if ((this.getOdbcFlag(n) & 0x40) == 64) {
                    return "money";
                }
                return "numeric";
            }
            case DECIMAL: {
                return "decimal";
            }
            case BIT: {
                return "bit";
            }
            case CHAR: {
                return "char";
            }
            case VARCHAR: {
                return "varchar";
            }
            case LONGVARCHAR: {
                return "longvarchar";
            }
            case BINARY: {
                return "binary";
            }
            case VARBINARY: {
                return "varbinary";
            }
            case LONGVARBINARY: {
                return "longvarbinary";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
        }
        throw new SQLException("Unknown type error " + sQLType);
    }

    public int getFieldIndex(String string) throws SQLException {
        for (int i = 0; i < this.nColumns; ++i) {
            if (!string.equalsIgnoreCase(this.varNames[i])) continue;
            return i;
        }
        throw new CtreeSQLException(26049);
    }

    public void checkRange(int n, int n2) throws SQLException {
        if (n < 0 || n >= this.nColumns) {
            throw new CtreeSQLException(26049);
        }
        if (n2 < 0 || n2 >= this.nRows) {
            throw new CtreeSQLException(26048);
        }
    }

    public boolean wasNull(int n, int n2) throws SQLException {
        this.checkRange(n, n2);
        if (this.values[n][n2] == null) {
            return true;
        }
        return this.values[n][n2].isNull();
    }

    public void makeNull(int n, int n2, SQLType sQLType) throws SQLException {
        this.checkRange(n, n2);
        if (this.CanChangeType(n, n2)) {
            short s = CtreeValue.SQLToHostType(sQLType, this.unicodeCompatibility);
            this.setHostTypes(n, s);
            this.setSqlTypes(n, s);
        }
        this.values[n][n2].makeNull();
    }

    protected void makeNull(int n, int n2, short s) throws SQLException {
        this.checkRange(n, n2);
        if (this.CanChangeType(n, n2)) {
            this.setHostTypes(n, s);
            this.setSqlTypes(n, s);
        }
        this.values[n][n2].makeNull();
    }

    public void setString(int n, int n2, String string) throws SQLException {
        int n3 = 0;
        n3 = this.unicodeCompatibility ? (string.length() + 1) * this.charSize : string.getBytes(this.csm).length + 1;
        if (this.hostTypes[n] == 12 || this.hostTypes[n] == 26) {
            n3 = (string.length() + 1) * this.charSize + 4;
        }
        this.setValue(n, n2, string);
        if (this.lengths[n] < n3) {
            this.lengths[n] = n3;
        }
    }

    public void setBytes(int n, int n2, byte[] byArray) throws SQLException {
        this.setValue(n, n2, byArray);
        if (this.lengths[n] < byArray.length + 4) {
            this.lengths[n] = byArray.length + 4;
        }
    }

    public void setAsciiStream(int n, int n2, InputStream inputStream, int n3, SQLType sQLType) throws SQLException {
        this.values[n][n2] = new CtreeValue(inputStream, n3, sQLType);
    }

    public void setUnicodeStream(int n, int n2, InputStream inputStream, int n3, SQLType sQLType) throws SQLException {
        if (sQLType == JDBCType.LONGVARBINARY) {
            this.hostTypes[n] = 15;
        } else if (sQLType == JDBCType.BLOB) {
            this.hostTypes[n] = 22;
        } else if (sQLType == JDBCType.CLOB) {
            this.hostTypes[n] = 23;
        }
        this.lengths[n] = n3;
        this.values[n][n2] = new CtreeValue(inputStream, n3, sQLType);
        if (!this.isDescribeParamCalled) {
            this.lengths[n] = this.maxFieldSize;
        }
    }

    public void setBinaryStream(int n, int n2, InputStream inputStream, int n3, SQLType sQLType) throws SQLException {
        this.values[n][n2] = new CtreeValue(inputStream, n3, sQLType);
    }

    public String getString(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getString();
    }

    public boolean getBooleanValue(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getBooleanValue();
    }

    public Boolean getBoolean(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getBoolean();
    }

    public byte getByteValue(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getByteValue();
    }

    public Byte getByte(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getByte();
    }

    public short getShortValue(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getShortValue();
    }

    public Short getShort(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getShort();
    }

    public int getIntegerValue(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getIntegerValue();
    }

    public Integer getInteger(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getInteger();
    }

    public long getLongValue(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getLongValue();
    }

    public Long getLong(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getLong();
    }

    public float getFloatValue(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getFloatValue();
    }

    public Float getFloat(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getFloat();
    }

    public double getDoubleValue(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getDoubleValue();
    }

    public Double getDouble(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getDouble();
    }

    public BigDecimal getBigDecimal(int n, int n2, int n3) throws SQLException {
        return this.getNonNULLValue(n, n2).getBigDecimal(n3);
    }

    public byte[] getBytes(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getBytes();
    }

    public Date getDate(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getDate();
    }

    public Time getTime(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getTime();
    }

    public Timestamp getTimestamp(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getTimestamp();
    }

    public Reader getCharacterStream(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getCharacterStream();
    }

    public InputStream getAsciiStream(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getAsciiStream();
    }

    public InputStream getUnicodeStream(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getUnicodeStream();
    }

    public InputStream getBinaryStream(int n, int n2) throws SQLException {
        return this.getNonNULLValue(n, n2).getBinaryStream();
    }

    CtreeValue getValue(int n, int n2) throws SQLException {
        return this.values[n][n2];
    }

    byte getIValue(int n, int n2) throws SQLException {
        if (this.values[n][n2] == null) {
            return -1;
        }
        if (this.values[n][n2].isNull()) {
            return -1;
        }
        return 0;
    }

    CtreeValue getNonNULLValue(int n, int n2) throws SQLException {
        CtreeValue ctreeValue = this.getValue(n, n2);
        if (ctreeValue == null) {
            this.nullError();
        }
        return ctreeValue;
    }

    private void setVerifiedValue(int n, int n2, Object object) throws SQLException {
        if (this.values[n][n2] != null) {
            this.values[n][n2].setCtreeValue(object);
        } else {
            this.values[n][n2] = new CtreeValue(object, this.unicodeCompatibility);
        }
    }

    boolean CanChangeType(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = n2 == 0 && this.nRows == 1 || !this.isDescribeParamCalled && this.hostTypes[n] == -1;
        if (bl && this.isDescribeParamCalled && (this.hostTypes[n] == 14 || this.hostTypes[n] == 15 || this.hostTypes[n] == 22 || this.hostTypes[n] == 23 || this.hostTypes[n] == 24 || this.hostTypes[n] == 25)) {
            return false;
        }
        return bl;
    }

    void setValue(int n, int n2, Object object) throws SQLException {
        boolean bl;
        block26: {
            Object object2;
            short s;
            block27: {
                short s2;
                this.checkRange(n, n2);
                if (object == null) {
                    throw new SQLException("NULL value");
                }
                bl = this.CanChangeType(n, n2);
                if (bl || (s = this.hostTypes[n]) == (s2 = this.getObjectHostType(object)) || CtreeValue.isCharType(s) && CtreeValue.isCharType(s2)) break block26;
                object2 = null;
                boolean bl2 = false;
                switch (s2) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 11: 
                    case 13: 
                    case 16: {
                        object2 = object.toString();
                        break;
                    }
                    case 7: {
                        object2 = Calendar.getInstance();
                        ((Calendar)object2).setTime((Date)object);
                        bl2 = true;
                        break;
                    }
                    case 9: {
                        object2 = Calendar.getInstance();
                        ((Calendar)object2).setTimeInMillis(((Time)object).getTime());
                        bl2 = true;
                        break;
                    }
                    case 10: {
                        object2 = Calendar.getInstance();
                        ((Calendar)object2).setTimeInMillis(((Timestamp)object).getTime());
                        bl2 = true;
                        break;
                    }
                    case 1: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: {
                        object2 = object;
                    }
                }
                if (object2 == null) {
                    throw new CtreeSQLException(26028);
                }
                if (!bl2) break block27;
                switch (s) {
                    case 7: {
                        object = new Date(((Calendar)object2).getTimeInMillis());
                        break block26;
                    }
                    case 9: {
                        object = new Time(((Calendar)object2).getTimeInMillis());
                        break block26;
                    }
                    case 10: {
                        object = new Timestamp(((Calendar)object2).getTimeInMillis());
                        break block26;
                    }
                    default: {
                        throw new CtreeSQLException(26028);
                    }
                }
            }
            switch (s) {
                case 2: 
                case 8: {
                    object = new BigDecimal((String)object2);
                    break;
                }
                case 3: {
                    object = new Byte((String)object2);
                    break;
                }
                case 4: {
                    object = new Integer((String)object2);
                    break;
                }
                case 11: {
                    object = new Short((String)object2);
                    break;
                }
                case 16: {
                    object = new Long((String)object2);
                    break;
                }
                case 5: {
                    object = new Float((String)object2);
                    break;
                }
                case 6: {
                    object = new Double((String)object2);
                    break;
                }
                case 13: {
                    object = new Boolean((String)object2);
                    break;
                }
                case 1: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    object = object2;
                    break;
                }
                default: {
                    throw new CtreeSQLException(26028);
                }
            }
        }
        this.setVerifiedValue(n, n2, object);
        if (bl) {
            this.setHostTypes(n, object);
        }
    }

    void setIValue(int n, int n2, byte by) throws SQLException {
        this.checkRange(n, n2);
        if (by == -1) {
            this.values[n][n2].makeNull();
        } else {
            this.values[n][n2].makeNotNull();
        }
    }

    Object getObject(int n, int n2) throws SQLException {
        this.checkRange(n, n2);
        CtreeValue ctreeValue = this.values[n][n2];
        if (ctreeValue != null) {
            return ctreeValue.getObject();
        }
        return null;
    }

    public void setOutFlag(int n) throws SQLException {
        this.checkFieldRange(n);
        this.outFlags[n] = true;
    }

    public boolean isOutParam(int n) throws SQLException {
        this.checkFieldRange(n);
        return this.outFlags[n];
    }

    InputStream getInputStream(int n, int n2) throws SQLException {
        this.checkRange(n, n2);
        return this.values[n][n2].getInputStream();
    }

    int available(int n, int n2) throws SQLException {
        this.checkRange(n, n2);
        return this.values[n][n2].available();
    }

    public void setArraySize(int n) {
        this.arraySize = n;
    }

    public int getArraySize() {
        return this.arraySize;
    }

    protected void setMaxFieldSize(int n) {
        this.maxFieldSize = n;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public void marshal(SQLPacket sQLPacket) throws IOException, SQLException {
        int n;
        DataOutputStream dataOutputStream = sQLPacket.getOutputStream();
        int n2 = this.getNColumns();
        dataOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeInt(this.getHostType(n));
        }
        dataOutputStream.writeInt(this.getNRows());
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeInt(this.getLength(n));
        }
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeInt(this.getIValue(n, 0));
        }
        for (n = 0; n < n2; ++n) {
            if (-1 == this.getIValue(n, 0)) continue;
            this.getValue(n, 0).marshal(sQLPacket);
        }
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkFieldRange(n);
        switch ((JDBCType)this.getSqlType(n)) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case REAL: 
            case FLOAT: 
            case DOUBLE: 
            case NUMERIC: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    public String getColumnClassName(int n) throws SQLException {
        switch ((JDBCType)this.getSqlType(n)) {
            case TINYINT: {
                return "java.lang.Byte";
            }
            case SMALLINT: {
                return "java.lang.Short";
            }
            case INTEGER: {
                return "java.lang.Integer";
            }
            case BIGINT: {
                return "java.math.BigInteger";
            }
            case REAL: {
                return "java.lang.Float";
            }
            case FLOAT: 
            case DOUBLE: {
                return "java.lang.Double";
            }
            case NUMERIC: 
            case DECIMAL: {
                return "java.math.BigDecimal";
            }
            case BIT: {
                return "java.lang.Boolean";
            }
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: {
                return "java.lang.String";
            }
            case BINARY: 
            case VARBINARY: 
            case LONGVARBINARY: {
                return "java.lang.Byte[]";
            }
            case DATE: {
                return "java.sql.Date";
            }
            case TIME: {
                return "java.sql.Time";
            }
            case TIMESTAMP: {
                return "java.sql.Timestamp";
            }
        }
        return null;
    }

    public static SQLType typesToJdbcTypes(int n) throws CtreeSQLException {
        switch (n) {
            case 2003: {
                return JDBCType.ARRAY;
            }
            case -5: {
                return JDBCType.BIGINT;
            }
            case -2: {
                return JDBCType.BINARY;
            }
            case -7: {
                return JDBCType.BIT;
            }
            case 2004: {
                return JDBCType.BLOB;
            }
            case 16: {
                return JDBCType.BOOLEAN;
            }
            case 1: {
                return JDBCType.CHAR;
            }
            case 2005: {
                return JDBCType.CLOB;
            }
            case 70: {
                return JDBCType.DATALINK;
            }
            case 91: {
                return JDBCType.DATE;
            }
            case 3: {
                return JDBCType.DECIMAL;
            }
            case 2001: {
                return JDBCType.DISTINCT;
            }
            case 8: {
                return JDBCType.DOUBLE;
            }
            case 6: {
                return JDBCType.FLOAT;
            }
            case 4: {
                return JDBCType.INTEGER;
            }
            case 2000: {
                return JDBCType.JAVA_OBJECT;
            }
            case -16: {
                return JDBCType.LONGNVARCHAR;
            }
            case -4: {
                return JDBCType.LONGVARBINARY;
            }
            case -1: {
                return JDBCType.LONGVARCHAR;
            }
            case -15: {
                return JDBCType.NCHAR;
            }
            case 2011: {
                return JDBCType.NCLOB;
            }
            case 0: {
                return JDBCType.NULL;
            }
            case 2: {
                return JDBCType.NUMERIC;
            }
            case -9: {
                return JDBCType.NVARCHAR;
            }
            case 1111: {
                return JDBCType.OTHER;
            }
            case 7: {
                return JDBCType.REAL;
            }
            case 2006: {
                return JDBCType.REF;
            }
            case 2012: {
                return JDBCType.REF_CURSOR;
            }
            case -8: {
                return JDBCType.ROWID;
            }
            case 5: {
                return JDBCType.SMALLINT;
            }
            case 2009: {
                return JDBCType.SQLXML;
            }
            case 2002: {
                return JDBCType.STRUCT;
            }
            case 92: {
                return JDBCType.TIME;
            }
            case 2013: {
                return JDBCType.TIME_WITH_TIMEZONE;
            }
            case 93: {
                return JDBCType.TIMESTAMP;
            }
            case 2014: {
                return JDBCType.TIMESTAMP_WITH_TIMEZONE;
            }
            case -6: {
                return JDBCType.TINYINT;
            }
            case -3: {
                return JDBCType.VARBINARY;
            }
            case 12: {
                return JDBCType.VARCHAR;
            }
        }
        throw new CtreeSQLException("Invalid conversion error ", 26065);
    }

    public static int jdbcTypesToTypes(SQLType sQLType) throws CtreeSQLException {
        switch ((JDBCType)sQLType) {
            case ARRAY: {
                return 2003;
            }
            case BIGINT: {
                return -5;
            }
            case BINARY: {
                return -2;
            }
            case BIT: {
                return -7;
            }
            case BLOB: {
                return 2004;
            }
            case BOOLEAN: {
                return 16;
            }
            case CHAR: {
                return 1;
            }
            case CLOB: {
                return 2005;
            }
            case DATALINK: {
                return 70;
            }
            case DATE: {
                return 91;
            }
            case DECIMAL: {
                return 3;
            }
            case DISTINCT: {
                return 2001;
            }
            case DOUBLE: {
                return 8;
            }
            case FLOAT: {
                return 6;
            }
            case INTEGER: {
                return 4;
            }
            case JAVA_OBJECT: {
                return 2000;
            }
            case LONGNVARCHAR: {
                return -16;
            }
            case LONGVARBINARY: {
                return -4;
            }
            case LONGVARCHAR: {
                return -1;
            }
            case NCHAR: {
                return -15;
            }
            case NCLOB: {
                return 2011;
            }
            case NULL: {
                return 0;
            }
            case NUMERIC: {
                return 2;
            }
            case NVARCHAR: {
                return -9;
            }
            case OTHER: {
                return 1111;
            }
            case REAL: {
                return 7;
            }
            case REF: {
                return 2006;
            }
            case REF_CURSOR: {
                return 2012;
            }
            case ROWID: {
                return -8;
            }
            case SMALLINT: {
                return 5;
            }
            case SQLXML: {
                return 2009;
            }
            case STRUCT: {
                return 2002;
            }
            case TIME: {
                return 92;
            }
            case TIME_WITH_TIMEZONE: {
                return 2013;
            }
            case TIMESTAMP: {
                return 93;
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return 2014;
            }
            case TINYINT: {
                return -6;
            }
            case VARBINARY: {
                return -3;
            }
            case VARCHAR: {
                return 12;
            }
        }
        throw new CtreeSQLException("Invalid conversion error ", 26065);
    }

    public short getAllocatedColumns() {
        return this.allocatedColumns;
    }

    public short getAllocatedRows() {
        return this.allocatedRows;
    }
}

