/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeSQLException;
import java.io.IOException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class CtreeLOBWriter
extends Writer
implements CtreeError {
    protected Clob clob;
    protected int pos;
    protected boolean isClosed;

    public CtreeLOBWriter(Clob clob, int n) throws SQLException {
        if (clob == null) {
            throw new NullPointerException();
        }
        if (n < 1) {
            throw new CtreeSQLException(26088);
        }
        this.clob = clob;
        this.pos = n;
        this.isClosed = false;
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        try {
            if (this.isClosed) {
                throw new IOException("Invalid State of Writer.");
            }
            this.clob.setString(this.pos, String.valueOf(cArray), n, n2);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.isClosed) {
            throw new IOException("Invalid State of Writer.");
        }
    }
}

