/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeDA;
import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeSQLException;
import java.sql.JDBCType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Wrapper;

public final class CtreeResultSetMetaData
implements ResultSetMetaData,
CtreeError,
Wrapper {
    CtreeDA meta;

    CtreeResultSetMetaData(CtreeDA ctreeDA) throws SQLException {
        this.meta = ctreeDA;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return this.meta.getFlag(n - 1);
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        switch ((JDBCType)CtreeDA.typesToJdbcTypes(this.getColumnType(n))) {
            case TINYINT: {
                return 4;
            }
            case SMALLINT: {
                return 6;
            }
            case INTEGER: {
                return 11;
            }
            case BIGINT: {
                return 20;
            }
            case REAL: {
                return 13;
            }
            case FLOAT: {
                return 22;
            }
            case DOUBLE: {
                return 22;
            }
            case NUMERIC: 
            case DECIMAL: {
                return this.meta.getPrecision(n - 1) + 2;
            }
            case BIT: {
                return 1;
            }
            case CHAR: 
            case VARCHAR: {
                return this.meta.getPrecision(n - 1);
            }
            case LONGVARCHAR: {
                return 2000;
            }
            case BINARY: 
            case VARBINARY: {
                return this.meta.getPrecision(n - 1) * 2;
            }
            case LONGVARBINARY: {
                return 4000;
            }
            case DATE: {
                return this.meta.getPrecision(n - 1);
            }
            case TIME: {
                return this.meta.getPrecision(n - 1);
            }
            case TIMESTAMP: {
                return this.meta.getPrecision(n - 1);
            }
        }
        throw new CtreeSQLException(26028);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.meta.getNColumns();
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        return this.meta.getPrecision(n - 1);
    }

    @Override
    public int getScale(int n) throws SQLException {
        return this.meta.getScale(n - 1);
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        return CtreeDA.jdbcTypesToTypes(this.meta.getSqlType(n - 1));
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        switch ((JDBCType)CtreeDA.typesToJdbcTypes(this.getColumnType(n))) {
            case CHAR: 
            case VARCHAR: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        return this.meta.getSearchable(n - 1) != 0;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        return this.meta.getTypeName(n - 1).equals("money");
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return this.meta.isSigned(n - 1);
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        return true;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        return null;
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        return null;
    }

    @Override
    public String getTableName(int n) throws SQLException {
        return this.meta.getTableName(n - 1);
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        String string = this.meta.getIndVarName(n - 1);
        if (string == null || string.equals("")) {
            string = this.meta.getVarName(n - 1);
        }
        return string;
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return this.meta.getVarName(n - 1);
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        return this.meta.getTypeName(n - 1);
    }

    public int getColumnIndex(String string) throws SQLException {
        return this.meta.getFieldIndex(string);
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        return this.meta.getColumnClassName(n - 1);
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return this.getClass().getName().equals(clazz.getName());
    }

    public CtreeResultSetMetaData unwrap(Class clazz) throws SQLException {
        boolean bl = clazz.getName().equals(this.getClass().getName());
        if (!bl) {
            throw new CtreeSQLException(26094);
        }
        return this;
    }
}

