/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.SQLControlPacket;
import ctree.jdbc.SQLNetworkException;
import ctree.jdbc.SQLTransport;
import ctree.jdbc.ctSHMjni;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class CtreeSHMSQLTransportImpl
extends SQLTransport
implements CtreeError {
    long shmSocket = 0L;
    private ByteBuffer outBuffer = null;
    private ByteBuffer inBuffer = null;
    private byte[] _inBuffer = null;

    CtreeSHMSQLTransportImpl() {
        this.ControlPacket = new SQLControlPacket();
    }

    public void connect(String string, int n, int n2) throws SQLNetworkException {
        this.shmSocket = ctSHMjni.createSocketID();
        if (this.shmSocket == 0L) {
            throw new SQLNetworkException(-30011);
        }
        if (ctSHMjni.connect(this.shmSocket, n, n2) < 0) {
            throw new SQLNetworkException(100);
        }
    }

    @Override
    public byte[] receive(int n) throws SQLNetworkException, IOException {
        int n2;
        if (this.inBuffer == null || this.inBuffer.capacity() < n) {
            this.inBuffer = ByteBuffer.allocateDirect(n);
            this._inBuffer = new byte[n];
        }
        if ((n2 = ctSHMjni.receive(this.shmSocket, this.inBuffer, n)) != 0) {
            throw new SQLNetworkException(n2);
        }
        this.inBuffer.clear();
        this.inBuffer.get(this._inBuffer, 0, this._inBuffer.length);
        return this._inBuffer;
    }

    @Override
    public void send(byte[] byArray) throws IOException, SQLNetworkException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.shmSocket == 0L) {
            throw new SQLNetworkException(-30103);
        }
        this.ControlPacket.marshal(byteArrayOutputStream);
        byteArrayOutputStream.write(byArray);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        int n = byArray2.length;
        if (this.outBuffer == null || this.outBuffer.capacity() < n) {
            this.outBuffer = ByteBuffer.allocateDirect(n);
        }
        this.outBuffer.clear();
        this.outBuffer.put(byArray2);
        int n2 = ctSHMjni.send(this.shmSocket, this.outBuffer, n);
        if (n2 != 0) {
            throw new SQLNetworkException(n2);
        }
    }

    @Override
    public void close() throws IOException {
        if (ctSHMjni.close(this.shmSocket) != 0) {
            throw new IOException("Couldn't close shared memory connection");
        }
        this.shmSocket = 0L;
    }

    @Override
    public void unmarshal(InputStream inputStream) throws IOException {
        this.ControlPacket.unmarshal(inputStream);
    }

    @Override
    public InputStream getInputStream() throws IOException, SQLNetworkException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    boolean isSHM() {
        return true;
    }

    @Override
    public void SslHandshake(int n) throws IOException {
        throw new IOException("SSL does not apply to shared memory connection");
    }
}

