/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeCltSvr;
import ctree.jdbc.CtreeData;
import ctree.jdbc.CtreeError;
import ctree.jdbc.SQLPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public final class CtreeSnPutData
implements CtreeError {
    int status = 0;
    CtreeCltSvr CltSvr;
    CtreeData PutData;

    public CtreeSnPutData() {
        this.CltSvr = new CtreeCltSvr(1);
        this.PutData = new CtreeData();
    }

    public CtreeSnPutData(int n, CtreeData ctreeData) {
        this.CltSvr = new CtreeCltSvr(n);
        this.PutData = ctreeData;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setCltSvr(CtreeCltSvr ctreeCltSvr) {
        this.CltSvr = ctreeCltSvr;
    }

    public void setPutData(CtreeData ctreeData) {
        this.PutData = ctreeData;
    }

    public int getStatus() {
        return this.status;
    }

    public CtreeCltSvr getCltSvr() {
        return this.CltSvr;
    }

    public CtreeData getPutData() {
        return this.PutData;
    }

    public void marshal(SQLPacket sQLPacket) throws IOException, SQLException {
        DataOutputStream dataOutputStream = sQLPacket.getOutputStream();
        dataOutputStream.writeInt(this.status);
        if (this.CltSvr.getType() == 0) {
            this.CltSvr.setType(1);
            this.CltSvr.marshal(sQLPacket);
            dataOutputStream.writeInt(this.PutData.getHostType());
            int n = this.PutData.getLength();
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(this.PutData.getPosition());
            if (n >= 0) {
                dataOutputStream.writeInt(n);
                dataOutputStream.write(this.PutData.getBuffer(), 0, n);
                int n2 = n % 4;
                if (n2 != 0) {
                    byte[] byArray = new byte[]{0, 0, 0};
                    dataOutputStream.write(byArray, 0, 4 - n2);
                }
            }
            sQLPacket.marshalString(this.PutData.getHandle());
        } else if (this.CltSvr.getType() == 1) {
            this.CltSvr.setType(0);
            this.CltSvr.marshal(sQLPacket);
        }
    }

    public void unmarshal(InputStream inputStream) throws IOException, SQLException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.status = dataInputStream.readInt();
        this.CltSvr.unmarshal(dataInputStream);
        int n = this.CltSvr.getType();
        if (n == 0) {
            if (this.status != 0) {
                return;
            }
        } else if (this.CltSvr.getType() == 1) {
            this.PutData.setHostType(dataInputStream.readShort());
            this.PutData.setLength(dataInputStream.readInt());
            this.PutData.setPosition(dataInputStream.readInt());
            byte[] byArray = new byte[dataInputStream.readInt()];
            dataInputStream.readFully(byArray);
            this.PutData.setBuffer(byArray);
            this.PutData.setHandle(dataInputStream.readUTF());
        }
    }
}

