/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeCA;
import ctree.jdbc.CtreeConnection;
import ctree.jdbc.CtreeDA;
import ctree.jdbc.CtreeData;
import ctree.jdbc.CtreeDatabaseMetaData;
import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeJDBCObject;
import ctree.jdbc.CtreeResultSet;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.CtreeSQLWarning;
import ctree.jdbc.StatementUid;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;

public class CtreeStatement
extends CtreeJDBCObject
implements Statement,
CtreeError {
    static int EXEC_UPDT = 0;
    static int EXEC_QUERY = 1;
    static int EXEC = 2;
    static int EXEC_BATCH = 3;
    private static final PrintStream o = System.out;
    private CtreeConnection connection;
    private CtreeResultSet resultset;
    private int updatecount;
    private SQLWarning warnings;
    private StatementUid statementID;
    private int resultSetType;
    private int resultSetConcurrency;
    private String statement;
    private long maxrows;
    private int maxFieldSize;
    protected String cursorName;
    private boolean isStmtClosed;
    protected int timeout;
    private CtreeCA m_sqlca;
    Vector batchSQLStmts = null;
    private int charsize = 0;
    private int UnicodeCompatibility = -1;

    protected CtreeStatement(CtreeConnection ctreeConnection, int n, int n2) throws SQLException {
        this.setConnection(ctreeConnection);
        this.resultset = null;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.updatecount = -1;
        this.statementID = null;
        this.statement = null;
        this.maxrows = 0L;
        this.maxFieldSize = this.connection.getMaxFieldSize();
        this.warnings = null;
        this.isStmtClosed = false;
        this.m_sqlca = new CtreeCA();
        this.timeout = -1;
        if (CtreeStatement.traceOn()) {
            CtreeStatement.trace("@CtreeStatement (resultSetType = " + this.resultSetType + ", resultSetConcurrency = " + this.resultSetConcurrency + ")");
        }
    }

    protected void setConnection(CtreeConnection ctreeConnection) {
        this.connection = ctreeConnection;
    }

    protected CtreeConnection CtreeGetConnection() {
        return this.connection;
    }

    protected void setResultSet(CtreeResultSet ctreeResultSet) throws SQLException {
        if (this.resultset != null) {
            this.resultset.close();
        }
        this.resultset = ctreeResultSet;
    }

    protected CtreeResultSet getCurrentResultSet() {
        return this.resultset;
    }

    protected void setUpdateCount(int n) throws SQLException {
        this.updatecount = n;
    }

    protected StatementUid getStatementID() {
        return this.statementID;
    }

    protected void setStatementID(StatementUid statementUid, String string) throws SQLException {
        if (this.statementID != null) {
            this.CtreeGetConnection().freeStatement(this.statementID);
        }
        this.statementID = statementUid;
        this.statement = string;
        if (this.resultset != null) {
            this.resultset.setStatementID(statementUid);
        }
    }

    protected String getStatement() {
        return this.statement;
    }

    protected void finalize() {
        try {
            if (CtreeStatement.traceOn()) {
                CtreeStatement.trace("@CtreeStatement.finalize (statementId = " + this.getStatementID() + ", statement = " + this.getStatement() + ")");
            }
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void checkConnection() throws SQLException {
        if (this.connection == null) {
            throw new CtreeSQLException(26002);
        }
        if (this.isStmtClosed) {
            throw new CtreeSQLException("Statement already closed", 26063);
        }
    }

    public ResultSet Tables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().Tables(string, string2, string3, stringArray, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "Tables()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet Columns(String string, String string2, String string3, String string4) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().Columns(string, string2, string3, string4, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "Columns()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet TypeInfo() throws SQLException {
        this.checkConnection();
        this.setResultSet(this.createCtreeResultSet());
        this.setStatementID(this.CtreeGetConnection().TypeInfo(this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "TypeInfo()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet Schemas() throws SQLException {
        this.checkConnection();
        this.setResultSet(this.createCtreeResultSet());
        this.setStatementID(this.CtreeGetConnection().Schemas(this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "Schemas()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet Catalogs() throws SQLException {
        this.checkConnection();
        this.setResultSet(this.createCtreeResultSet());
        this.setStatementID(this.CtreeGetConnection().Catalogs(this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "Catalogs()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet Procedures(String string, String string2, String string3) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().Procedures(string, string2, string3, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "Procedures()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet ProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().ProcedureColumns(string, string2, string3, string4, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "ProcedureColumns()");
        this.getCurrentResultSet().getOutputDA().setVarName(0, "PROCEDURE_CAT");
        this.getCurrentResultSet().getOutputDA().setVarName(1, "PROCEDURE_SCHEM");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet TableTypes() throws SQLException {
        this.checkConnection();
        this.setResultSet(this.createCtreeResultSet());
        this.setStatementID(this.CtreeGetConnection().TableTypes(this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "TableTypes()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet ColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().ColumnPrivileges(string, string2, string3, string4, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "ColumnPrivileges()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet BestRowIdentifier(String string, String string2, String string3, int n, boolean bl, CtreeDatabaseMetaData ctreeDatabaseMetaData) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().BestRowIdentifier(string, string2, string3, n, bl, ctreeDatabaseMetaData, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "BestRowIdentifier()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet VersionColumns(String string, String string2, String string3) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().VersionColumns(string, string2, string3, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "VersionColumns()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet PrimaryKeys(String string, String string2, String string3) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().PrimaryKeys(string, string2, string3, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "PrimaryKeys()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet ImportedKeys(String string, String string2, String string3, CtreeDatabaseMetaData ctreeDatabaseMetaData) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().ImportedKeys(string, string2, string3, ctreeDatabaseMetaData, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "ImportedKeys()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet ExportedKeys(String string, String string2, String string3, CtreeDatabaseMetaData ctreeDatabaseMetaData) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().ExportedKeys(string, string2, string3, ctreeDatabaseMetaData, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "ExportedKeys()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet IndexInfo(String string, String string2, String string3, boolean bl, boolean bl2, CtreeDatabaseMetaData ctreeDatabaseMetaData) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().IndexInfo(string, string2, string3, bl, bl2, ctreeDatabaseMetaData, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "IndexInfo()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet CrossReference(String string, String string2, String string3, String string4, String string5, String string6, CtreeDatabaseMetaData ctreeDatabaseMetaData) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2, string5);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().CrossReference(string, string2, string3, string4, string5, string6, ctreeDatabaseMetaData, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "CrossReference()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet TablePrivileges(String string, String string2, String string3) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().TablePrivileges(string, string2, string3, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "TablePrivileges()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.checkConnection();
        if (this.batchSQLStmts != null) {
            throw new CtreeSQLException(26084);
        }
        if (CtreeStatement.traceOn()) {
            CtreeStatement.trace("@CtreeStatement.executeQuery (sql = " + string + " )");
        }
        this.setResultSet(this.createCtreeResultSet());
        this.setStatementID(this.CtreeGetConnection().executeDirect(string, this.getCurrentResultSet().getOutputDA(), this.m_sqlca, this.cursorName, EXEC_QUERY, this.timeout, this.isScrollable()), string);
        if (CtreeStatement.traceOn()) {
            CtreeStatement.trace("@CtreeStatement.executeQuery (statementId = " + this.getStatementID() + ", statement = " + this.getStatement() + ")");
        }
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        if (this.isScrollable()) {
            this.resultset.SetNOfRows(this.CtreeGetConnection().getNOfRows(this.statementID));
        }
        return this.resultset;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.checkConnection();
        if (this.batchSQLStmts != null) {
            throw new CtreeSQLException(26084);
        }
        if (CtreeStatement.traceOn()) {
            CtreeStatement.trace("@CtreeStatement.executeUpdate (sql = " + string + " )");
        }
        this.setStatementID(this.CtreeGetConnection().executeDirect(string, null, this.m_sqlca, this.cursorName, EXEC_UPDT, this.timeout, false), string);
        if (CtreeStatement.traceOn()) {
            CtreeStatement.trace("@CtreeStatement.executeUpdate (statementId = " + this.getStatementID() + ", statement = " + this.getStatement() + ")");
        }
        int n = this.CtreeGetConnection().getRowCount(this.getStatementID());
        this.setUpdateCount(n);
        return n;
    }

    @Override
    public void close() throws SQLException {
        try {
            if (CtreeStatement.traceOn()) {
                CtreeStatement.trace("@CtreeStatement.close (statementId = " + this.getStatementID() + ", statement = " + this.getStatement() + ")");
            }
            if (this.resultset != null) {
                this.resultset.close();
                this.resultset = null;
            }
            if (this.getStatementID() != null) {
                this.CtreeGetConnection().freeStatement(this.statementID);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw new CtreeSQLException(exception.getMessage(), 26064);
        }
        finally {
            this.resultset = null;
            this.statementID = null;
            this.statement = null;
            this.isStmtClosed = true;
            this.updatecount = -1;
            this.clearWarnings();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            throw new CtreeSQLException(26055);
        }
        this.maxFieldSize = n < this.connection.getMaxFieldSize() ? n : this.connection.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return (int)this.maxrows;
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            throw new CtreeSQLException(26055);
        }
        this.maxrows = n;
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return this.maxrows;
    }

    @Override
    public void setLargeMaxRows(long l) throws SQLException {
        if (l < 0L) {
            throw new CtreeSQLException(26055);
        }
        this.maxrows = l;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.timeout == -1) {
            return 0;
        }
        return this.timeout;
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            throw new CtreeSQLException(26055);
        }
        this.timeout = n;
        StatementUid statementUid = this.getStatementID();
        if (statementUid != null) {
            statementUid.setTimeOut(n);
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.CtreeGetConnection().cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        String string = this.m_sqlca.getSqlwarn();
        CtreeSQLWarning ctreeSQLWarning = null;
        if (string != null) {
            if (string.charAt(1) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26070);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26070));
                }
            }
            if (string.charAt(2) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26071);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26071));
                }
            }
            if (string.charAt(3) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26072);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26072));
                }
            }
            if (string.charAt(4) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26073);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26073));
                }
            }
            if (string.charAt(6) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26074);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26074));
                }
            }
        }
        if (this.warnings != null) {
            for (SQLWarning sQLWarning = this.warnings; sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(sQLWarning.getErrorCode());
                    continue;
                }
                ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(sQLWarning.getErrorCode()));
            }
        }
        return ctreeSQLWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        while (this.warnings != null) {
            SQLWarning sQLWarning = this.warnings.getNextWarning();
            this.warnings.setNextWarning(null);
            this.warnings = sQLWarning;
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.cursorName = string;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.checkConnection();
        if (this.batchSQLStmts != null) {
            throw new CtreeSQLException(26084);
        }
        if (CtreeStatement.traceOn()) {
            CtreeStatement.trace("@CtreeStatement.execute (sql = " + string + " )");
        }
        this.setResultSet(this.createCtreeResultSet());
        this.setStatementID(this.CtreeGetConnection().executeDirect(string, this.getCurrentResultSet().getOutputDA(), this.m_sqlca, this.cursorName, EXEC, this.timeout, this.isScrollable()), string);
        if (CtreeStatement.traceOn()) {
            CtreeStatement.trace("@CtreeStatement.execute (statementId = " + this.getStatementID() + ", statement = " + this.getStatement() + ")");
        }
        if (this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            if (this.isScrollable()) {
                this.resultset.SetNOfRows(this.CtreeGetConnection().getNOfRows(this.getStatementID()));
            }
            return true;
        }
        int n = this.CtreeGetConnection().getRowCount(this.getStatementID());
        this.setUpdateCount(n);
        this.setResultSet(null);
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isStmtClosed) {
            throw new CtreeSQLException("Statement already closed", 26063);
        }
        return this.resultset;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.resultset != null) {
            return -1;
        }
        return this.updatecount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.resultset != null) {
            this.resultset.close();
        }
        this.updatecount = -1;
        return false;
    }

    boolean fetch(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        return this.CtreeGetConnection().fetch(statementUid, ctreeDA, ctreeCA);
    }

    boolean getData(CtreeData ctreeData) throws SQLException {
        return this.CtreeGetConnection().getData(this.getStatementID(), ctreeData);
    }

    void closeCursor(StatementUid statementUid) throws SQLException {
        this.CtreeGetConnection().closeCursor(statementUid);
    }

    boolean isOpen(StatementUid statementUid) throws SQLException {
        return this.CtreeGetConnection().isOpen(statementUid);
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26077));
        } else {
            this.warnings = new CtreeSQLWarning(26077);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26077));
        } else {
            this.warnings = new CtreeSQLWarning(26077);
        }
        return 1000;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26077));
        } else {
            this.warnings = new CtreeSQLWarning(26077);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26077));
        } else {
            this.warnings = new CtreeSQLWarning(26077);
        }
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        if (this.batchSQLStmts == null) {
            this.batchSQLStmts = new Vector();
        }
        this.batchSQLStmts.add(string);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchSQLStmts = null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkConnection();
        if (this.batchSQLStmts == null) {
            int[] nArray = new int[]{};
            return nArray;
        }
        this.setStatementID(this.CtreeGetConnection().executeDirectBatch("BATCH", this.batchSQLStmts, this.m_sqlca, this.cursorName, this.timeout), "");
        int[] nArray = this.CtreeGetConnection().getRowCounts(this.getStatementID());
        this.clearBatch();
        return nArray;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    protected CtreeResultSet createCtreeResultSet() throws SQLException {
        return new CtreeResultSet(this);
    }

    protected CtreeResultSet recreateCtreeResultSet() throws SQLException {
        return new CtreeResultSet(this.resultset);
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    public ResultSet SuperTypes(String string, String string2, String string3) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().SuperTypes(string, string2, string3, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "SuperTypes()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet PseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().PseudoColumns(string, string2, string3, string4, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "SuperTypes()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet SuperTables(String string, String string2, String string3) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().SuperTables(string, string2, string3, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "SuperTables()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet Attributes(String string, String string2, String string3, String string4) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().Attributes(string, string2, string3, string4, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "Attributes()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet UDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().UDTs(string, string2, string3, nArray, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "UDTs()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet getClientInfoProperties() throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().getClientInfoProperties(this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "getClientInfoProperties()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.isClosed()) {
            throw new CtreeSQLException(26095);
        }
        return false;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw new CtreeSQLException(26095);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isStmtClosed;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return this.getClass().getName().equals(clazz.getName());
    }

    public CtreeStatement unwrap(Class clazz) throws SQLException {
        boolean bl = clazz.getName().equals(this.getClass().getName());
        if (!bl) {
            throw new CtreeSQLException(26094);
        }
        return this;
    }

    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().getFunctions(string, string2, string3, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "getFunctions()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().getFunctionColumns(string, string2, string3, string4, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "getFunctionColumns()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    public ResultSet getSchemas(String string, String string2) throws SQLException {
        this.checkConnection();
        CtreeResultSet ctreeResultSet = this.createCtreeResultSet();
        ctreeResultSet.setSchemaValue(string2);
        this.setResultSet(ctreeResultSet);
        this.setStatementID(this.CtreeGetConnection().getSchemas(string, string2, this.getCurrentResultSet().getOutputDA(), this.m_sqlca), "getSchemas()");
        if (!this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26033);
        }
        return this.resultset;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkConnection();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    public boolean isScrollable() throws SQLException {
        return this.resultSetType == 1004;
    }

    protected boolean UnicodeCompatibility() {
        if (this.UnicodeCompatibility == -1) {
            try {
                this.UnicodeCompatibility = this.connection.isUnicodeServer() ? 1 : 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.UnicodeCompatibility == 1;
    }

    protected int charSize() {
        if (this.charsize == 0) {
            try {
                this.charsize = this.connection.charSize();
            }
            catch (Exception exception) {
                return 1;
            }
        }
        return this.charsize;
    }

    public Charset getCharset() {
        return this.CtreeGetConnection().getCharset();
    }
}

