/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.CursorT;
import ctree.jdbc.StatementType;
import ctree.jdbc.StatementUid;
import java.sql.SQLException;
import java.util.StringTokenizer;

class SQLStatement
implements StatementType,
CtreeError {
    private int NParams = 0;
    private int NColumns = 0;
    private int NRows = 0;
    private boolean IsDynamic;
    protected boolean IsScrollable;
    private boolean IsOpen;
    private boolean HasResultset;
    private StatementUid StmtId;
    private int StmtType;
    private String Stmt;
    private CursorT Cur;
    private int[] updatedRowCounts;

    public SQLStatement(boolean bl, String string, StatementUid statementUid) throws SQLException {
        this.IsDynamic = bl;
        this.IsScrollable = false;
        this.IsOpen = false;
        this.HasResultset = false;
        this.StmtId = statementUid;
        this.SetStatement(string);
        this.Cur = new CursorT(this.StmtId, this.Stmt, this.IsDynamic, this.IsScrollable);
    }

    public SQLStatement(boolean bl, boolean bl2, String string, StatementUid statementUid) throws SQLException {
        this.IsDynamic = bl;
        this.IsScrollable = bl2;
        this.IsOpen = false;
        this.HasResultset = false;
        this.StmtId = statementUid;
        this.SetStatement(string);
        this.Cur = new CursorT(this.StmtId, this.Stmt, this.IsDynamic, this.IsScrollable);
    }

    public int Reset() {
        this.IsOpen = false;
        this.HasResultset = false;
        return 0;
    }

    public StatementUid GetUid() {
        return this.StmtId;
    }

    public void SetUid(StatementUid statementUid) {
        this.StmtId = statementUid;
    }

    public int GetStatementType() {
        return this.StmtType;
    }

    public boolean IsDynamic() {
        return this.IsDynamic;
    }

    public boolean IsOpen() {
        return this.IsOpen;
    }

    public void SetClose() {
        this.IsOpen = false;
    }

    public void SetOpen() {
        this.IsOpen = true;
    }

    public boolean HasResultset() {
        return this.HasResultset;
    }

    public void DoHaveResultSet() {
        this.HasResultset = true;
    }

    public void SetCursor(CursorT cursorT) {
        this.Cur = cursorT;
    }

    public CursorT GetCursor() {
        return this.Cur;
    }

    public int SetStatement(String object) throws SQLException {
        if (object == null || ((String)object).equals("")) {
            throw new CtreeSQLException(26055);
        }
        int n = ((String)(object = ((String)object).trim())).length();
        if (n == 0) {
            throw new CtreeSQLException(26055);
        }
        if (((String)object).charAt(0) == '-') {
            if (((String)object).charAt(1) == '-') {
                int n2 = ((String)object).indexOf(10);
                object = n2 > 1 ? ((String)object).substring(1 + n2) : new String("");
            }
            object = new String("");
        }
        if (((String)object).equals("")) {
            throw new SQLException("Invalid  statement");
        }
        String string = ((String)object).toUpperCase();
        string = string.replace('{', ' ').replace('}', ' ').trim();
        String string2 = string.replace('=', ' ').trim();
        if (string.startsWith("SELECT")) {
            this.StmtType = 0;
        } else if (string.startsWith("WITH")) {
            this.StmtType = 0;
        } else if (string2.startsWith("CALL") || string2.startsWith("?")) {
            this.StmtType = 1;
        } else if (string.startsWith("INSERT")) {
            this.StmtType = 2;
        } else if (string.startsWith("UPDATE")) {
            this.StmtType = 3;
        } else if (string.startsWith("DELETE")) {
            this.StmtType = 4;
        } else if (string.startsWith("QUIT")) {
            System.exit(0);
        } else if (string.startsWith("CREATE")) {
            String string3;
            this.StmtType = 5;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\t\r");
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens() && ((string3 = stringTokenizer.nextToken()).equals("PROCEDURE") || string3.equals("TRIGGER") || string3.equals("FUNCTION"))) {
                object = (String)object + "\n";
            }
        } else {
            this.StmtType = string.startsWith("BATCH") ? 6 : 5;
        }
        this.Stmt = object;
        return 0;
    }

    public String GetStatement() {
        return this.Stmt;
    }

    public int GetNParams() {
        return this.NParams;
    }

    public int GetNColumns() {
        return this.NColumns;
    }

    public int GetNRows() {
        return this.NRows;
    }

    public void SetNParams(int n) {
        this.NParams = n;
    }

    public void SetNColumns(int n) {
        this.NColumns = n;
    }

    public void SetNRows(int n) {
        this.NRows = n;
    }

    public void SetNrBatchRows(int[] nArray) {
        this.updatedRowCounts = nArray;
    }

    public int[] GetNrBatchRows() {
        return this.updatedRowCounts;
    }
}

