/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.ClRqTypes;
import ctree.jdbc.ConnectOptions;
import ctree.jdbc.CtreeCA;
import ctree.jdbc.CtreeCapabilityInfo;
import ctree.jdbc.CtreeCustom;
import ctree.jdbc.CtreeDA;
import ctree.jdbc.CtreeData;
import ctree.jdbc.CtreeDatabaseMetaData;
import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeInt;
import ctree.jdbc.CtreeIsolationLvl;
import ctree.jdbc.CtreeJDBCObject;
import ctree.jdbc.CtreeObfs;
import ctree.jdbc.CtreeSHMSQLTransportImpl;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.CtreeSQLNetworkImpl;
import ctree.jdbc.CtreeSQLProcInfo;
import ctree.jdbc.CtreeSQLTransportImpl;
import ctree.jdbc.CtreeSnDesc;
import ctree.jdbc.CtreeSnFst;
import ctree.jdbc.CtreeSnGetData;
import ctree.jdbc.CtreeSnIoSqlda;
import ctree.jdbc.CtreeSnPutData;
import ctree.jdbc.CtreeStatement;
import ctree.jdbc.CtreeTmHdl;
import ctree.jdbc.CtreeURL;
import ctree.jdbc.CursorT;
import ctree.jdbc.NetInitCS;
import ctree.jdbc.NetfnsCS;
import ctree.jdbc.SQLNetworkException;
import ctree.jdbc.SQLStatement;
import ctree.jdbc.SQLTransport;
import ctree.jdbc.StatementType;
import ctree.jdbc.StatementUid;
import ctree.jdbc.ctSHMjni;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.sql.BatchUpdateException;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Vector;

public final class SQLXApi
extends CtreeJDBCObject
implements CtreeError,
StatementType,
ConnectOptions {
    public static int TPE_TRANS_ABORTED = 1;
    private CtreeTmHdl TransHandle;
    private CtreeSQLNetworkImpl NetworkHandle;
    private SQLTransport TransportHandle;
    private NetfnsCS RPCFnsHandle;
    private String PortStr;
    private String DBName;
    private String Host;
    private String Identification;
    private String Authentication;
    private String DBOption;
    private String SuperUser;
    private CtreeCapabilityInfo CapInfo;
    private SQLStatement CurrentStatement;
    private SQLStatement[] Statements;
    private int NStatements;
    private int TotalNStatements;
    private boolean AutoCloseFlag;
    private boolean AutoCommitFlag;
    private boolean XnOutstandingFlag;
    private boolean ReadOnlyFlag;
    private int sslLevel = 0;
    private boolean XAPiDebugFlag;
    private boolean TransactionActive;
    public static final int DEFAULT_SOCKET_TIMEOUT = 0;
    private int SOCKET_TIMEOUT;
    public static final int DEFAULT_LOGIN_TIMEOUT = 15000;
    private Socket clientSocket = null;
    private Exception connectException = null;
    public String identifier_case = null;
    public String quoted_identifier_case = null;
    protected int maxFieldSize = 8192;
    private int time_high = 0;
    private short time_low = 0;
    private int maxArraySize = 64000;
    private int fetch_size = 20;
    private CtreeObfs pobfs;
    private Charset csm = null;
    public static final String CLIINFO_KEY_APPNAME_DEFAULT = "";
    public static final String CLIINFO_KEY_USER_DEFAULT = "";
    public static final String CLIINFO_KEY_HOST_DEFAULT = "";
    public static final String CLIINFO_KEY_APPNAME = "ApplicationName";
    public static final String CLIINFO_KEY_USER = "ClientUser";
    public static final String CLIINFO_KEY_HOST = "ClientHostname";
    public static final int MAX_CLIINFO_VALLEN = 128;

    public SQLXApi(String string, String string2, String string3, String string4) throws SQLException {
        this.Int_SQLXApi(0, string, string2, string3, string4);
    }

    public SQLXApi(int n, String string, String string2, String string3, String string4) throws SQLException {
        this.Int_SQLXApi(n, string, string2, string3, string4);
    }

    private void Int_SQLXApi(int n, String string, String string2, String string3, String string4) throws SQLException {
        this.SOCKET_TIMEOUT = n;
        this.SetDB(string);
        if (this.Identification == null) {
            this.Identification = new String(string2);
        }
        if (this.Authentication == null) {
            this.Authentication = new String(string3);
        }
        StringBuffer stringBuffer = new StringBuffer("DH_CHARSET_NAME=");
        stringBuffer.append(this.csm.displayName());
        stringBuffer.append(":CONN_OPT=");
        stringBuffer.append(string4);
        stringBuffer.append(":LS=2:LS=1");
        stringBuffer.append(CtreeCustom.getPowner(string2));
        this.DBOption = stringBuffer.toString();
        this.SuperUser = new String("admin");
        this.NetworkHandle = null;
        this.TransHandle = null;
        this.TransportHandle = null;
        this.CurrentStatement = null;
        this.NStatements = 0;
        this.TotalNStatements = 15;
        this.time_high = 0;
        this.time_low = 0;
        this.Statements = new SQLStatement[this.TotalNStatements];
        for (int i = 0; i < this.TotalNStatements; ++i) {
            this.Statements[i] = null;
        }
        this.AutoCommitFlag = true;
        this.XnOutstandingFlag = false;
        this.AutoCloseFlag = true;
        this.ReadOnlyFlag = false;
        this.XAPiDebugFlag = false;
        this.identifier_case = "IC_LOWER";
        this.quoted_identifier_case = "IC_SENSITIVE";
        this.maxFieldSize = 8192;
        this.Connect();
        this.getOptions();
    }

    private void getIDCase() {
        try {
            StatementUid statementUid = new StatementUid();
            CtreeDA ctreeDA = new CtreeDA(2, 2, this.charSize(), this.UnicodeCompatibility(), this.csm, 8192);
            CtreeCA ctreeCA = new CtreeCA();
            this.ExecDirect(statementUid, "call \"" + this.SuperUser + "\".\"sql_get_idcase\"()", ctreeDA, ctreeCA, CtreeStatement.EXEC, 0, false);
            this.Fetch(statementUid, ctreeDA, ctreeCA);
            this.identifier_case = ctreeDA.getString(0, 0);
            this.quoted_identifier_case = ctreeDA.getString(1, 0);
            this.CloseCursor(statementUid, ctreeCA);
        }
        catch (Exception exception) {
            this.identifier_case = "IC_LOWER";
            this.quoted_identifier_case = "IC_SENSITIVE";
        }
    }

    private void getOptions() {
        try {
            StatementUid statementUid = new StatementUid();
            CtreeDA ctreeDA = new CtreeDA(3, 1, this.charSize(), this.UnicodeCompatibility(), this.csm, 8192);
            CtreeCA ctreeCA = new CtreeCA();
            this.ExecDirect(statementUid, "call \"" + this.SuperUser + "\".\"fc_get_options\"()", ctreeDA, ctreeCA, CtreeStatement.EXEC, 0, false);
            this.Fetch(statementUid, ctreeDA, ctreeCA);
            this.identifier_case = ctreeDA.getString(0, 0);
            this.quoted_identifier_case = ctreeDA.getString(1, 0);
            this.maxFieldSize = ctreeDA.getIntegerValue(2, 0);
            this.CloseCursor(statementUid, ctreeCA);
        }
        catch (CtreeSQLException ctreeSQLException) {
            this.identifier_case = "IC_LOWER";
            this.quoted_identifier_case = "IC_SENSITIVE";
            this.maxFieldSize = 8192;
            if (ctreeSQLException.getErrorCode() == -20122) {
                this.getIDCase();
            }
        }
        catch (Exception exception) {
            this.identifier_case = "IC_LOWER";
            this.quoted_identifier_case = "IC_SENSITIVE";
            this.maxFieldSize = 8192;
        }
    }

    public int Connect() throws SQLException {
        CtreeInt ctreeInt = new CtreeInt();
        CtreeCA ctreeCA = new CtreeCA();
        boolean bl = false;
        if (ctSHMjni.available() && this.sslLevel == 0 && this.checkLocalConn()) {
            bl = this.connectSHM(15000);
        }
        if (!bl) {
            this.connectSocket();
        }
        this.RPCFnsHandle.RemAttach(this.GetDBName(), this.Identification, this.Authentication, this.DBOption, ctreeCA, ctreeInt);
        if (ctreeInt.getValue() != 0) {
            this.NetworkHandle.close();
            this.TransportHandle = null;
            this.NetworkHandle = null;
            this.TransHandle = null;
            throw new CtreeSQLException(ctreeCA);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket establishConnection(String string, int n) throws Exception {
        try {
            this.connectException = null;
            int n2 = DriverManager.getLoginTimeout() * 1000;
            if (n2 <= 0) {
                n2 = 15000;
            }
            this.clientSocket = new Socket();
            this.clientSocket.bind(null);
            this.clientSocket.connect(new InetSocketAddress(string, n), n2);
        }
        catch (Exception exception) {
            this.connectException = exception;
            return this.connectException;
        }
        finally {
            if (this.clientSocket != null && this.clientSocket.isConnected()) {
                return this.clientSocket;
            }
            if (this.connectException == null || this.connectException instanceof InterruptedIOException) {
                throw new CtreeSQLException(26005);
            }
            throw this.connectException;
        }
    }

    public int Disconnect() throws SQLException {
        try {
            this.TransportHandle.close();
        }
        catch (IOException iOException) {
            throw new CtreeSQLException(iOException.getMessage(), 26003);
        }
        this.TransportHandle = null;
        this.NetworkHandle = null;
        this.TransHandle = null;
        this.RPCFnsHandle = null;
        this.Identification = null;
        this.Authentication = null;
        this.SuperUser = null;
        for (int i = 0; i < this.TotalNStatements; ++i) {
            this.Statements[i] = null;
        }
        this.Statements = null;
        return 0;
    }

    public int GetAttachId() {
        return 0;
    }

    public boolean GetTransactionActive() {
        return this.TransactionActive;
    }

    public String GetSuperUser() {
        return this.SuperUser;
    }

    public void SetTransactionActive(boolean bl) {
        this.TransactionActive = bl;
    }

    public void SetXnOutstandingFlag(boolean bl) {
        this.XnOutstandingFlag = bl;
    }

    public boolean GetXnOutstandingFlag() {
        return this.XnOutstandingFlag;
    }

    public SQLStatement getStatement(StatementUid statementUid) {
        return this.Statements[statementUid.GetStatementId()];
    }

    public boolean isDynamic(StatementUid statementUid) {
        return this.getStatement(statementUid).IsDynamic();
    }

    public boolean isOpen(StatementUid statementUid) {
        return this.getStatement(statementUid).IsOpen();
    }

    public void setCursorName(StatementUid statementUid, String string) {
        this.getStatement(statementUid).GetCursor().setCursorName(string);
    }

    public String getCursorName(StatementUid statementUid) {
        return this.getStatement(statementUid).GetCursor().GetCursorName();
    }

    public CursorT getCursor(StatementUid statementUid) {
        return this.getStatement(statementUid).GetCursor();
    }

    public int SetConnectOption(int n, int n2) throws SQLException {
        switch (n) {
            case 1: {
                if (n2 == 1) {
                    this.ReadOnlyFlag = true;
                    break;
                }
                if (n2 != 0) break;
                this.ReadOnlyFlag = false;
                break;
            }
            case 3: {
                if (n2 == 1) {
                    CtreeCA ctreeCA;
                    int n3;
                    if (!this.AutoCommitFlag && (n3 = this.Commit(ctreeCA = new CtreeCA())) != 0) {
                        throw new CtreeSQLException(ctreeCA);
                    }
                    this.AutoCommitFlag = true;
                }
                if (n2 != 0) break;
                this.AutoCommitFlag = false;
                break;
            }
            case 2: {
                if (n2 == 1) {
                    this.AutoCloseFlag = true;
                    break;
                }
                if (n2 != 0) break;
                this.AutoCloseFlag = false;
                break;
            }
            case 4: {
                this.TransHandle.setIsolationLvl(new CtreeIsolationLvl(n2));
                break;
            }
            default: {
                throw new CtreeSQLException(26039);
            }
        }
        return 0;
    }

    public int GetConnectOption(int n) throws SQLException {
        switch (n) {
            case 1: {
                if (this.ReadOnlyFlag) {
                    return 1;
                }
                return 0;
            }
            case 3: {
                if (this.AutoCommitFlag) {
                    return 1;
                }
                return 0;
            }
            case 2: {
                if (this.AutoCloseFlag) {
                    return 1;
                }
                return 0;
            }
            case 4: {
                return this.TransHandle.getIsolationLvl().getIsolationLvl();
            }
        }
        throw new CtreeSQLException(26039);
    }

    public int NrParams(StatementUid statementUid) throws SQLException {
        return this.getStatement(statementUid).GetNParams();
    }

    public int NrColumns(StatementUid statementUid) throws SQLException {
        return this.getStatement(statementUid).GetNColumns();
    }

    public int NrRows(StatementUid statementUid) throws SQLException {
        return this.getStatement(statementUid).GetNRows();
    }

    public int GetStatementType(StatementUid statementUid) {
        return this.getStatement(statementUid).GetStatementType();
    }

    public boolean HasResultset(StatementUid statementUid) {
        return this.getStatement(statementUid).HasResultset();
    }

    public boolean IsUnicodeServer() {
        return this.TransportHandle.IsUnicodeServer();
    }

    public SQLStatement NewStatement(StatementUid statementUid, boolean bl, String string) throws SQLException {
        return this.NewStatement(statementUid, bl, false, string, -1);
    }

    public SQLStatement NewStatement(StatementUid statementUid, boolean bl, String string, int n) throws SQLException {
        return this.NewStatement(statementUid, bl, false, string, n);
    }

    public SQLStatement NewStatement(StatementUid statementUid, boolean bl, boolean bl2, String string, int n) throws SQLException {
        int n2;
        int n3;
        for (n3 = 0; n3 < this.TotalNStatements; ++n3) {
            if (this.Statements[n3] != null) continue;
            statementUid.SetStatementId(n3);
            this.Statements[n3] = new SQLStatement(bl, bl2, string, statementUid);
            int n4 = this.getTimeHigh();
            short s = this.getTimeLow();
            statementUid.setUUid(n4, s, n);
            ++this.NStatements;
            return this.Statements[n3];
        }
        if (this.NStatements == this.TotalNStatements) {
            this.TotalNStatements += 10;
            SQLStatement[] sQLStatementArray = new SQLStatement[this.TotalNStatements];
            for (n2 = 0; n2 < this.NStatements; ++n2) {
                sQLStatementArray[n2] = this.Statements[n2];
            }
            for (n2 = this.NStatements; n2 < this.TotalNStatements; ++n2) {
                sQLStatementArray[n2] = null;
            }
            this.Statements = sQLStatementArray;
        }
        statementUid.SetStatementId(this.NStatements);
        this.Statements[this.NStatements] = new SQLStatement(bl, bl2, string, statementUid);
        n3 = this.getTimeHigh();
        n2 = this.getTimeLow();
        statementUid.setUUid(n3, (short)n2, n);
        ++this.NStatements;
        return this.Statements[this.NStatements - 1];
    }

    public int FreeStatement(StatementUid statementUid, boolean bl) throws SQLException {
        CtreeCA ctreeCA = new CtreeCA();
        int n = statementUid.GetStatementId();
        if (n >= this.TotalNStatements) {
            throw new CtreeSQLException(26026);
        }
        if (this.Statements[n] == null) {
            throw new CtreeSQLException(26026);
        }
        if (this.Statements[n].IsOpen()) {
            this.CloseCursor(statementUid, ctreeCA);
        }
        if (bl) {
            this.Statements[n] = null;
            --this.NStatements;
        }
        return 0;
    }

    public int Commit(CtreeCA ctreeCA) throws SQLException {
        this.EndXaction(ctreeCA);
        for (int i = 0; i < this.TotalNStatements; ++i) {
            if (this.Statements[i] == null) continue;
            this.Statements[i].Reset();
        }
        return 0;
    }

    public int EndXaction(CtreeCA ctreeCA) throws SQLException {
        if (this.TransHandle == null) {
            return 0;
        }
        if ((this.TransHandle.TransFlags & TPE_TRANS_ABORTED) != 0) {
            this.TmExec(ClRqTypes.SQLM_ABORT_TRANS, ctreeCA);
        } else {
            this.TmExec(ClRqTypes.SQLM_COMMIT_TRANS, ctreeCA);
        }
        this.SetTransactionActive(false);
        this.SetXnOutstandingFlag(false);
        return 0;
    }

    public int Rollback(CtreeCA ctreeCA) throws SQLException {
        this.MarkAbort(ctreeCA);
        this.EndXaction(ctreeCA);
        for (int i = 0; i < this.TotalNStatements; ++i) {
            if (this.Statements[i] == null) continue;
            this.Statements[i].Reset();
        }
        return 0;
    }

    public int MarkAbort(CtreeCA ctreeCA) throws SQLException {
        this.TransHandle.TransFlags |= TPE_TRANS_ABORTED;
        this.TmExec(ClRqTypes.SQLM_MARK_ABORT, ctreeCA);
        return 0;
    }

    public synchronized int ExecDirect(StatementUid statementUid, String string, CtreeDA ctreeDA, CtreeCA ctreeCA, int n, int n2, boolean bl) throws SQLException {
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, bl, string, n2);
        if (n == CtreeStatement.EXEC_UPDT && sQLStatement.GetStatementType() == 0) {
            throw new CtreeSQLException("SELECT not supported for executeUpdate", 26063);
        }
        if (sQLStatement.GetStatementType() != 0 && sQLStatement.GetStatementType() != 1 && this.ReadOnlyFlag) {
            throw new CtreeSQLException("Statement execution cancelled as connection is in readonly mode", 26063);
        }
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        if (sQLStatement.GetStatementType() == 0 || sQLStatement.GetStatementType() == 1 && sQLStatement.GetNColumns() > 0) {
            sQLStatement.SetOpen();
            if (!bl) {
                sQLStatement.SetNRows(0);
            }
            sQLStatement.DoHaveResultSet();
        } else if (this.AutoCommitFlag) {
            return this.Commit(ctreeCA);
        }
        this.XnOutstandingFlag = true;
        return 0;
    }

    public synchronized int Prepare(StatementUid statementUid, String string, boolean bl, CtreeDA ctreeDA, CtreeDA ctreeDA2, boolean bl2) throws SQLException {
        CtreeCA ctreeCA = new CtreeCA();
        SQLStatement sQLStatement = this.NewStatement(statementUid, bl, bl2, string, -1);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_PREPARE, null, null, ctreeCA);
        if (ctreeDA != null) {
            try {
                this.DescribeParam(statementUid, ctreeDA, ctreeCA);
                ctreeDA.isDescribeParamCalled = true;
            }
            catch (CtreeSQLException ctreeSQLException) {
                ctreeDA.isDescribeParamCalled = false;
            }
        }
        if (ctreeDA2 != null) {
            this.Describe(statementUid, ctreeDA2, ctreeCA);
        }
        this.XnOutstandingFlag = true;
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int Execute(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        SQLStatement sQLStatement = this.getStatement(statementUid);
        if (sQLStatement.GetStatementType() != 0 && sQLStatement.GetStatementType() != 1 && this.ReadOnlyFlag) {
            throw new CtreeSQLException("Statement execution cancelled as connection is in readonly mode", 26063);
        }
        if (sQLStatement.GetStatementType() != 0) {
            CursorT cursorT = sQLStatement.GetCursor();
            if (cursorT == null || cursorT.StmtId == null || cursorT.Stmt == null) {
                throw new CtreeSQLException(26026);
            }
            if (ctreeDA != null) {
                if (sQLStatement.GetStatementType() != 5) {
                    int n = 0;
                    n = this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECUTE, ctreeDA, null, ctreeCA);
                    if (n != 0) {
                        return n;
                    }
                } else {
                    int n = 0;
                    n = this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECUTE, ctreeDA, null, ctreeCA);
                    if (n != 0) {
                        return n;
                    }
                }
                if (sQLStatement.GetStatementType() == 1) {
                    if (sQLStatement.GetNColumns() <= 0) return 0;
                    this.OpenCursor(statementUid, ctreeDA, ctreeCA);
                    sQLStatement.DoHaveResultSet();
                }
            }
        } else {
            this.OpenCursor(statementUid, ctreeDA, ctreeCA);
        }
        if (sQLStatement.GetStatementType() != 0 && sQLStatement.GetStatementType() != 1) {
            sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
            if (!this.AutoCommitFlag) return 0;
            return this.Commit(ctreeCA);
        }
        sQLStatement.DoHaveResultSet();
        return 0;
    }

    public int DescribeParam(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        SQLStatement sQLStatement = this.getStatement(statementUid);
        if (sQLStatement.GetStatementType() == 5) {
            ctreeDA.setNColumns((short)0);
            sQLStatement.SetNParams(0);
        } else {
            CursorT cursorT = sQLStatement.GetCursor();
            if (cursorT == null || cursorT.StmtId == null || cursorT.Stmt == null) {
                throw new CtreeSQLException(26026);
            }
            this.SQLExec(sQLStatement, ClRqTypes.SQLM_DESCRIBE_PARAM, ctreeDA, null, ctreeCA);
            short s = ctreeDA.getNVars();
            if (s < 0) {
                ctreeDA.resize(-s, ctreeDA.getNRows());
                this.SQLExec(sQLStatement, ClRqTypes.SQLM_DESCRIBE_PARAM, ctreeDA, null, ctreeCA);
            }
            ctreeDA.setNColumns(ctreeDA.getNVars());
            sQLStatement.SetNParams(ctreeDA.getNColumns());
        }
        return 0;
    }

    public int Describe(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        SQLStatement sQLStatement = this.getStatement(statementUid);
        if (sQLStatement.GetStatementType() == 0 || sQLStatement.GetStatementType() == 1) {
            CursorT cursorT = sQLStatement.GetCursor();
            if (cursorT == null || cursorT.StmtId == null || cursorT.Stmt == null) {
                throw new CtreeSQLException(26026);
            }
            this.SQLExec(sQLStatement, ClRqTypes.SQLM_DESCRIBE, null, ctreeDA, ctreeCA);
            int n = ctreeDA.getNVars();
            short s = ctreeDA.getNRows();
            if (n < 0) {
                n = -n;
                ctreeDA.resize(n, s);
                this.SQLExec(sQLStatement, ClRqTypes.SQLM_DESCRIBE, null, ctreeDA, ctreeCA);
            }
            ctreeDA.setNColumns(ctreeDA.getNVars());
            boolean bl = false;
            if (ctreeCA.getCommandFunction().equals("SELECT FOR UPDATE") || ctreeCA.getDynamicFunction().equals("SELECT FOR UPDATE")) {
                bl = true;
                ctreeDA.resize(n, 1);
                ctreeDA.setArraySize(1);
            }
            if (!bl) {
                int n2;
                n = ctreeDA.getNColumns();
                int n3 = 0;
                for (n2 = 0; n2 < n; ++n2) {
                    n3 += ctreeDA.getLength(n2);
                }
                if (n3 > 0) {
                    n2 = this.maxArraySize / n3;
                    if (n2 > this.fetch_size) {
                        n2 = this.fetch_size;
                    } else if (n2 < 1) {
                        n2 = 1;
                    }
                    ctreeDA.resize(n, n2);
                    ctreeDA.setArraySize(n2);
                }
            }
            sQLStatement.SetNColumns(ctreeDA.getNColumns());
        }
        return 0;
    }

    public int OpenCursor(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        SQLStatement sQLStatement = this.getStatement(statementUid);
        CursorT cursorT = sQLStatement.GetCursor();
        if (sQLStatement.IsOpen()) {
            this.CloseCursor(statementUid, ctreeCA);
        }
        if (cursorT == null || cursorT.StmtId == null || cursorT.Stmt == null) {
            throw new CtreeSQLException(26026);
        }
        if (!cursorT.IsDynamic && ctreeDA == null) {
            this.SQLExec(sQLStatement, ClRqTypes.SQLM_OPEN1, cursorT.Insqlda, null, ctreeCA);
        } else {
            this.SQLExec(sQLStatement, ClRqTypes.SQLM_OPEN1, ctreeDA, null, ctreeCA);
        }
        sQLStatement.SetOpen();
        if (sQLStatement.IsScrollable) {
            sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        } else {
            sQLStatement.SetNRows(0);
        }
        return 0;
    }

    public int CloseCursor(StatementUid statementUid, CtreeCA ctreeCA) throws SQLException {
        SQLStatement sQLStatement = this.getStatement(statementUid);
        if (!sQLStatement.IsOpen()) {
            return 0;
        }
        CursorT cursorT = sQLStatement.GetCursor();
        if (cursorT == null || cursorT.StmtId == null || cursorT.Stmt == null) {
            throw new CtreeSQLException(26026);
        }
        if (cursorT.fetch_flag == 100 && !cursorT.long_flds_exist && !cursorT.IsScrollable) {
            cursorT.fetch_flag = 0;
            ctreeCA.Sqlcode = 0;
        } else {
            this.SQLExec(sQLStatement, ClRqTypes.SQLM_CLOSE, null, null, ctreeCA);
        }
        int n = 0;
        for (int i = 0; i < this.TotalNStatements; ++i) {
            if (this.Statements[i] == null || !this.Statements[i].IsOpen()) continue;
            ++n;
        }
        if (this.AutoCommitFlag && n == 1) {
            this.Commit(ctreeCA);
        }
        sQLStatement.SetClose();
        return 0;
    }

    public boolean Fetch(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        SQLStatement sQLStatement = this.getStatement(statementUid);
        short s = ctreeDA.getNColumns();
        if (s > 0) {
            int n;
            CursorT cursorT = sQLStatement.GetCursor();
            if (cursorT == null || cursorT.StmtId == null || cursorT.Stmt == null) {
                throw new CtreeSQLException(26026);
            }
            if (cursorT.first_fetch) {
                for (n = 0; n < ctreeDA.getNVars(); ++n) {
                    SQLType sQLType = ctreeDA.getSqlType(n);
                    if (sQLType != JDBCType.LONGVARBINARY && sQLType != JDBCType.BLOB && sQLType != JDBCType.LONGVARCHAR && sQLType != JDBCType.CLOB) continue;
                    cursorT.long_flds_exist = true;
                }
            }
            n = cursorT.long_flds_exist ? this.SQLExec(sQLStatement, ClRqTypes.SQLM_FETCH2, ctreeDA, null, ctreeCA) : this.SQLExec(sQLStatement, ClRqTypes.SQLM_FETCH3, ctreeDA, null, ctreeCA);
            if (cursorT.first_fetch) {
                if (ctreeCA.Sqlcode == 100 && ctreeCA.Sqlerrd[2] == 0) {
                    cursorT.long_flds_exist = false;
                }
                cursorT.first_fetch = false;
            }
            sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
            return n != 100;
        }
        if (s == 0) {
            return false;
        }
        throw new CtreeSQLException(26049);
    }

    public boolean getData(StatementUid statementUid, CtreeData ctreeData) throws SQLException {
        CtreeCA ctreeCA = new CtreeCA();
        CtreeSnGetData ctreeSnGetData = new CtreeSnGetData(0, ctreeData);
        SQLStatement sQLStatement = this.getStatement(statementUid);
        Object object = sQLStatement.GetCursor().GetCursorName();
        if (((String)object).equals("")) {
            object = "cur" + sQLStatement.GetCursor().getCursorID();
            sQLStatement.GetCursor().setCursorName((String)object);
            sQLStatement.GetCursor().incCursorID();
        }
        StatementUid statementUid2 = sQLStatement.GetUid();
        boolean bl = sQLStatement.IsDynamic();
        int n = !bl ? 0 : 1;
        String string = sQLStatement.GetStatement();
        CtreeInt ctreeInt = new CtreeInt();
        this.RPCFnsHandle.RemSQLGetData(ClRqTypes.SQLM_GETDATA, this.TransHandle, sQLStatement.GetUid(), (String)object, n, string, ctreeSnGetData, ctreeCA, ctreeInt);
        if (ctreeCA.Sqlcode != 0 && ctreeCA.Sqlcode != 100) {
            CtreeSQLException ctreeSQLException = new CtreeSQLException(ctreeCA);
            if (this.AutoCommitFlag) {
                try {
                    this.Rollback(ctreeCA);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw ctreeSQLException;
        }
        if (ctreeInt.getValue() != 0 && ctreeInt.getValue() != 100) {
            CtreeSQLException ctreeSQLException = new CtreeSQLException(ctreeInt.getValue());
            if (this.AutoCommitFlag) {
                try {
                    this.Rollback(ctreeCA);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw ctreeSQLException;
        }
        return ctreeInt.getValue() != 100;
    }

    public void putData(StatementUid statementUid, InputStream inputStream, int n, String string, int n2) throws SQLException {
        Object object;
        SQLStatement sQLStatement = this.getStatement(statementUid);
        Object object2 = sQLStatement.GetCursor().GetCursorName();
        if (((String)object2).equals("")) {
            object = sQLStatement.GetCursor();
            object2 = "cur" + ((CursorT)object).getCursorID();
            ((CursorT)object).setCursorName((String)object2);
            ((CursorT)object).incCursorID();
        }
        object = sQLStatement.GetStatement();
        int n3 = this.maxFieldSize;
        byte[] byArray = new byte[n3];
        if (n2 < 0) {
            throw new CtreeSQLException(26088);
        }
        int n4 = n2;
        CtreeData ctreeData = new CtreeData(byArray, n4, n3, (short)n, string);
        CtreeSnPutData ctreeSnPutData = new CtreeSnPutData(0, ctreeData);
        int n5 = 0;
        int n6 = sQLStatement.IsDynamic() ? 1 : 0;
        CtreeCA ctreeCA = new CtreeCA();
        CtreeInt ctreeInt = new CtreeInt();
        boolean bl = true;
        while (n5 >= 0) {
            try {
                n5 = inputStream.read(byArray, 0, n3);
            }
            catch (IOException iOException) {
                throw new CtreeSQLException(iOException.getMessage(), 26055);
            }
            if (n5 <= 0 && !bl) break;
            if (n5 < 0) {
                n5 = 0;
            }
            ctreeData.setLength(n5);
            ctreeData.setPosition(n4);
            this.RPCFnsHandle.RemSQLPutData(ClRqTypes.SQLM_PUTDATA, this.TransHandle, statementUid, (String)object2, n6, (String)object, ctreeSnPutData, ctreeCA, ctreeInt);
            if (ctreeCA.getErrorCode() != 0) {
                CtreeSQLException ctreeSQLException = new CtreeSQLException(ctreeCA);
                if (this.AutoCommitFlag) {
                    try {
                        this.Rollback(ctreeCA);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw ctreeSQLException;
            }
            if (ctreeInt.getValue() != 0) {
                CtreeSQLException ctreeSQLException = new CtreeSQLException(ctreeInt.getValue());
                if (this.AutoCommitFlag) {
                    try {
                        this.Rollback(ctreeCA);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw ctreeSQLException;
            }
            n4 = n == 17 ? (n4 += n5 / 2) : (n4 += n5);
            bl = false;
        }
        ctreeData.setLength(0);
        ctreeData.setPosition(n4);
        this.RPCFnsHandle.RemSQLPutData(ClRqTypes.SQLM_PUTDATA, this.TransHandle, statementUid, (String)object2, n6, (String)object, ctreeSnPutData, ctreeCA, ctreeInt);
        if (ctreeCA.getErrorCode() != 0) {
            CtreeSQLException ctreeSQLException = new CtreeSQLException(ctreeCA);
            if (this.AutoCommitFlag) {
                try {
                    this.Rollback(ctreeCA);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw ctreeSQLException;
        }
        if (ctreeInt.getValue() != 0) {
            CtreeSQLException ctreeSQLException = new CtreeSQLException(ctreeInt.getValue());
            if (this.AutoCommitFlag) {
                try {
                    this.Rollback(ctreeCA);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw ctreeSQLException;
        }
        if (this.AutoCommitFlag) {
            this.Commit(ctreeCA);
        }
    }

    public int TableTypes(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string = this.getSqlStmtTableTypes();
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int Tables(StatementUid statementUid, String string, String string2, String string3, String[] stringArray, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string4 = this.getSqlStmtTables(string, string2, string3, stringArray);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string4);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int Columns(StatementUid statementUid, String string, String string2, String string3, String string4, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string5 = this.getSqlStmtColumns(string, string2, string3, string4);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string5);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int Schemas(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string = this.getSqlStmtSchemas();
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int Catalogs(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string = this.getSqlStmtCatalogs();
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int TypeInfo(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string = this.getSqlStmtTypeInfo();
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int PrimaryKeys(StatementUid statementUid, String string, String string2, String string3, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string4 = this.getSqlStmtPrimaryKeys(string, string2, string3);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string4);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int ImportedKeys(StatementUid statementUid, String string, String string2, String string3, CtreeDatabaseMetaData ctreeDatabaseMetaData, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string4 = this.getSqlStmtImportedKeys(string, string2, string3, ctreeDatabaseMetaData);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string4);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int ExportedKeys(StatementUid statementUid, String string, String string2, String string3, CtreeDatabaseMetaData ctreeDatabaseMetaData, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string4 = this.getSqlStmtExportedKeys(string, string2, string3, ctreeDatabaseMetaData);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string4);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int VersionColumns(StatementUid statementUid, String string, String string2, String string3, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string4 = this.getSqlStmtVersionColumns(string, string2, string3);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string4);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int BestRowIdentifier(StatementUid statementUid, String string, String string2, String string3, int n, boolean bl, CtreeDatabaseMetaData ctreeDatabaseMetaData, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string4 = this.getSqlStmtBestRowIdentifier(string, string2, string3, n, bl, ctreeDatabaseMetaData);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string4);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int CrossReference(StatementUid statementUid, String string, String string2, String string3, String string4, String string5, String string6, CtreeDatabaseMetaData ctreeDatabaseMetaData, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string7 = this.getSqlStmtCrossReference(string, string2, string3, string4, string5, string6, ctreeDatabaseMetaData);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string7);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int IndexInfo(StatementUid statementUid, String string, String string2, String string3, boolean bl, boolean bl2, CtreeDatabaseMetaData ctreeDatabaseMetaData, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string4 = this.getSqlStmtIndexInfo(string, string2, string3, bl, bl2, ctreeDatabaseMetaData);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string4);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int TablePrivileges(StatementUid statementUid, String string, String string2, String string3, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string4 = this.getSqlStmtTablePrivileges(string, string2, string3);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string4);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int ColumnPrivileges(StatementUid statementUid, String string, String string2, String string3, String string4, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string5 = this.getSqlStmtColumnPrivileges(string, string2, string3, string4);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string5);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int Procedures(StatementUid statementUid, String string, String string2, String string3, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string4 = this.getSqlStmtProcedures(string, string2, string3);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string4);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int ProcedureColumns(StatementUid statementUid, String string, String string2, String string3, String string4, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string5 = this.getSqlStmtProcedureColumns(string, string2, string3, string4);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string5);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        ctreeCA.Sqlerrd[3] = 0;
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int SQLExec(SQLStatement sQLStatement, int n, CtreeDA ctreeDA, CtreeDA ctreeDA2, CtreeCA ctreeCA) throws SQLException {
        Object object;
        CtreeSnFst ctreeSnFst = null;
        CtreeSnIoSqlda ctreeSnIoSqlda = null;
        CtreeSnDesc ctreeSnDesc = null;
        boolean bl = false;
        Object object2 = sQLStatement.GetCursor().GetCursorName();
        if (((String)object2).equals("")) {
            object2 = "cur" + sQLStatement.GetCursor().getCursorID();
            sQLStatement.GetCursor().setCursorName((String)object2);
            sQLStatement.GetCursor().incCursorID();
        }
        StatementUid statementUid = sQLStatement.GetUid();
        boolean bl2 = sQLStatement.IsDynamic();
        int n2 = bl2 ? 1 : 0;
        String string = sQLStatement.GetStatement();
        CtreeInt ctreeInt = new CtreeInt();
        if (n == ClRqTypes.SQLM_DESCRIBE || n == ClRqTypes.SQLM_DESCRIBE_90) {
            if (SQLXApi.traceOn()) {
                SQLXApi.trace("@SQLXApi.SQLExec DESCRIBE");
            }
            ctreeSnDesc = new CtreeSnDesc(0, ctreeDA2);
            this.RPCFnsHandle.RemSQLDescribe(n, this.TransHandle, statementUid, (String)object2, n2, string, this.GetAttachId(), ctreeSnDesc, ctreeCA, ctreeInt);
        } else if (n == ClRqTypes.SQLM_DESCRIBE_PARAM || n == ClRqTypes.SQLM_DESCRIBE_PARAM_90) {
            if (SQLXApi.traceOn()) {
                SQLXApi.trace("@SQLXApi.SQLExec DESCRIBE_PARAM");
            }
            ctreeSnDesc = new CtreeSnDesc(0, ctreeDA);
            this.RPCFnsHandle.RemSQLDescribeParam(n, this.TransHandle, statementUid, n2, string, ctreeSnDesc, ctreeCA, ctreeInt);
        } else if (n == ClRqTypes.SQLM_SELECT || n == ClRqTypes.SQLM_FETCHRID) {
            if (SQLXApi.traceOn()) {
                SQLXApi.trace("@SQLXApi.SQLExec SELECT");
            }
            ctreeSnFst = new CtreeSnFst(0, ctreeDA2);
            this.RPCFnsHandle.RemSQLSelect(n, this.TransHandle, statementUid, (String)object2, n2, string, this.GetAttachId(), ctreeDA, ctreeSnFst, ctreeCA, ctreeInt);
        } else {
            if (n == ClRqTypes.SQLM_GETDATA) {
                throw new CtreeSQLException(26065);
            }
            if (n == ClRqTypes.SQLM_PUTDATA) {
                throw new CtreeSQLException(26065);
            }
            if (n == ClRqTypes.SQLM_FETCH2 || n == ClRqTypes.SQLM_FETCH3) {
                if (SQLXApi.traceOn()) {
                    if (n == ClRqTypes.SQLM_FETCH2) {
                        SQLXApi.trace("@SQLXApi.SQLExec FETCH2");
                    } else {
                        SQLXApi.trace("@SQLXApi.SQLExec FETCH3");
                    }
                }
                ctreeSnFst = new CtreeSnFst(0, ctreeDA);
                CursorT cursorT = sQLStatement.GetCursor();
                if (cursorT.fetch_flag == 100 && !cursorT.IsScrollable) {
                    ctreeCA.Sqlcode = 100;
                    if (SQLXApi.traceOn()) {
                        SQLXApi.trace("@SQLXApi.SQLExec short circuit, SQL_NOT_FOUND");
                    }
                    return cursorT.fetch_flag;
                }
                if (cursorT.IsScrollable) {
                    n2 |= 2;
                }
                n2 |= cursorT.operation;
                CtreeInt ctreeInt2 = new CtreeInt(cursorT.position);
                if (SQLXApi.traceOn()) {
                    SQLXApi.trace("@SQLXApi.SQLExec FETCH before back end call : flags = " + n2 + ", position = " + ctreeInt2.getValue());
                }
                this.RPCFnsHandle.RemSQLFetch(n, this.TransHandle, statementUid, (String)object2, n2, "", this.GetAttachId(), ctreeSnFst, ctreeCA, ctreeInt, ctreeInt2);
                if (SQLXApi.traceOn()) {
                    SQLXApi.trace("@SQLXApi.SQLExec FETCH after back end call :  position = " + ctreeInt2.getValue());
                }
                if (cursorT.IsScrollable) {
                    cursorT.setPosition(ctreeInt2.getValue());
                }
                if (100 == ctreeCA.Sqlcode) {
                    cursorT.fetch_flag = 100;
                }
                if (ctreeCA.Sqlerrd[3] != 0) {
                    return 0;
                }
                if (ctreeCA.Sqlcode == 100) {
                    return 100;
                }
                CtreeSQLException ctreeSQLException = new CtreeSQLException(ctreeCA);
                if (this.AutoCommitFlag) {
                    try {
                        this.Rollback(ctreeCA);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw ctreeSQLException;
            }
            if (SQLXApi.traceOn()) {
                SQLXApi.trace("@SQLXApi.SQLExec default (exec)");
            }
            bl = true;
            object = sQLStatement.GetCursor();
            if (((CursorT)object).IsScrollable) {
                n2 |= 2;
            }
            ctreeSnIoSqlda = new CtreeSnIoSqlda(0, ctreeDA);
            this.RPCFnsHandle.RemSQLExec(n, this.TransHandle, statementUid, (String)object2, n2, string, this.GetAttachId(), ctreeSnIoSqlda, ctreeCA, ctreeInt);
            if (n == ClRqTypes.SQLM_EXECDIRECT1) {
                if (ctreeCA.Sqlcode == 100) {
                    ((CursorT)object).fetch_flag = 100;
                    ctreeCA.Sqlcode = 0;
                } else {
                    ((CursorT)object).fetch_flag = 0;
                }
            } else if (n == ClRqTypes.SQLM_OPEN1) {
                if (ctreeCA.Sqlcode == 100) {
                    ((CursorT)object).fetch_flag = 100;
                    ctreeCA.Sqlcode = 0;
                } else {
                    ((CursorT)object).fetch_flag = 0;
                }
            }
        }
        if (ctreeCA.Sqlcode != 0 && ctreeCA.Sqlcode != 100) {
            object = new CtreeSQLException(ctreeCA);
            if (this.AutoCommitFlag) {
                try {
                    this.Rollback(ctreeCA);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw object;
        }
        if (ctreeInt.getValue() != 0) {
            object = new CtreeSQLException(ctreeInt.getValue());
            if (this.AutoCommitFlag) {
                try {
                    this.Rollback(ctreeCA);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw object;
        }
        return 0;
    }

    public int TmExec(int n, CtreeCA ctreeCA) throws SQLException {
        CtreeInt ctreeInt = new CtreeInt();
        this.RPCFnsHandle.RemTmExec(n, this.TransHandle, ctreeCA, ctreeInt);
        if (ctreeInt.getValue() != 0) {
            throw new CtreeSQLException(ctreeCA);
        }
        return 0;
    }

    public void cancel() throws SQLException {
        this.NetworkHandle.cancel();
    }

    public String GetDBName() {
        return this.DBName;
    }

    public String GetUName() {
        return this.Identification;
    }

    public String GetHost() {
        return this.Host;
    }

    public int GetPort() {
        return new Integer(this.PortStr);
    }

    public void SetDB(String string) throws CtreeSQLException {
        CtreeURL ctreeURL = new CtreeURL(string, false);
        this.PortStr = ctreeURL.getPortStr();
        this.DBName = ctreeURL.getDbName();
        this.Host = ctreeURL.getHost();
        this.csm = ctreeURL.getCharset();
        this.Identification = ctreeURL.getUser();
        this.Authentication = ctreeURL.getPassword();
        this.sslLevel = ctreeURL.getSSL();
    }

    private String getSqlStmtTables(String string, String string2, String string3, String[] stringArray) throws CtreeSQLException {
        char[] cArray = new char[]{'0', '0', '0', '0', '0', '0'};
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        string = this.validateArg(string);
        string2 = this.validateArg(string2);
        string3 = this.validateArg(string3);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringArray[i] = stringArray[i].trim();
                if (stringArray[i].compareTo("SYSTEM TABLE") == 0 || stringArray[i].compareTo("'SYSTEM TABLE'") == 0) {
                    cArray[0] = 83;
                    bl = true;
                    continue;
                }
                if (stringArray[i].compareTo("TABLE") == 0 || stringArray[i].compareTo("'TABLE'") == 0) {
                    cArray[1] = 65;
                    cArray[2] = 84;
                    bl = true;
                    continue;
                }
                if (stringArray[i].compareTo("VIEW") == 0 || stringArray[i].compareTo("'VIEW'") == 0) {
                    cArray[3] = 86;
                    cArray[4] = 67;
                    bl = true;
                    continue;
                }
                if (stringArray[i].compareTo("SYNONYM") == 0 || stringArray[i].compareTo("'SYNONYM'") == 0) {
                    cArray[5] = 89;
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].compareTo("%") == 0 || stringArray[i].compareTo("'%'") == 0 || stringArray[i].compareTo("") != 0) continue;
                bl4 = true;
            }
            if (bl4 && (bl || bl2)) {
                bl4 = false;
            }
        } else {
            bl = true;
            bl2 = true;
        }
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        String string4 = new String(" where ");
        if (bl) {
            object2 = new String("select distinct convert ('CHAR(32)',decode(0,1,'')) \"TABLE_CAT\", \"owner\" \"TABLE_SCHEM\",  \"tbl\" \"TABLE_NAME\", rtrim(decode(\"tbltype\", 'V','VIEW', 'S','SYSTEM TABLE','C','VIEW','TABLE'),' ') \"TABLE_TYPE\",  convert ('CHAR(32)', decode(1,0,' ')) \"REMARKS\",  convert ('CHAR(32)', decode(1, 0, 1)) \"TYPE_CAT\",  convert ('CHAR(32)', decode(1,0,1)) \"TYPE_SCHEM\", convert ('CHAR(32)', decode(1,0,1)) \"TYPE_NAME\",convert ('CHAR(32)', decode(1,0,1))  \"SELF_REFERENCING_COL_NAME\",  convert ('CHAR(32)', decode(1,0,1))  \"REF_GENERATION\" from \"" + this.SuperUser + "\".\"systables\" ");
            if (string3 != null && !string3.equals("")) {
                object2 = (String)object2 + string4 + " \"tbl\" like '" + string3 + "'";
                string4 = " and ";
            }
            if (string2 != null) {
                object2 = (String)object2 + string4 + " \"owner\" like '" + string2 + "'";
                string4 = " and ";
            }
            if (stringArray != null && !bl4) {
                if (bl3) {
                    object2 = (String)object2 + string4 + " 1 = 0 ";
                } else {
                    String string5 = " ";
                    object2 = (String)object2 + string4 + " \"tbltype\" in (";
                    for (int i = 0; i < 6; ++i) {
                        if (cArray[i] == '0') continue;
                        object2 = (String)object2 + string5 + "'" + cArray[i] + "'";
                        string5 = ",";
                    }
                    object2 = (String)object2 + ")";
                }
            }
        }
        if (bl2) {
            object3 = new String("select distinct convert ('CHAR(32)', decode(1,0,1))  \"TABLE_CAT\", \"sowner\" \"TABLE_SCHEM\",  \"sname\" \"TABLE_NAME\", 'SYNONYM' \"TABLE_TYPE\",  convert ('CHAR(32)', decode(0,1,'')) \"REMARKS\",  convert ('CHAR(32)', decode(1,0,1)) \"TYPE_CAT\",  convert ('CHAR(32)', decode(1,0,1)) \"TYPE_SCHEM\",  convert ('CHAR(32)', decode(1,0,1)) \"TYPE_NAME\",  convert ('CHAR(32)', decode(1,0,1)) \"SELF_REFERENCING_COL_NAME\", convert('CHAR(32)',decode(1,0,1)) \"REF_GENERATION\" from \"" + this.SuperUser + "\".\"syssynonyms\" ");
            string4 = " where ";
            if (string3 != null) {
                object3 = (String)object3 + string4 + " \"sname\" like '" + string3 + "'";
                string4 = " and ";
            }
            if (string2 != null) {
                object3 = (String)object3 + string4 + " \"sowner\" like '" + string2 + "'";
                string4 = " and ";
            }
        }
        object = object2 != null && object3 != null ? (String)object2 + " \n union \n" + (String)object3 : (object2 != null ? object2 : (object3 != null ? object3 : new String("select distinct convert ('CHAR(32)',decode(0,1,'')) \"TABLE_CAT\", \"owner\" \"TABLE_SCHEM\",  \"tbl\" \"TABLE_NAME\", rtrim(decode(\"tbltype\", 'V','VIEW', 'S','SYSTEM TABLE','C','VIEW','TABLE'),' ') \"TABLE_TYPE\",  convert ('CHAR(32)', decode(1,0,' ')) \"REMARKS\",  convert ('CHAR(32)', decode(1, 0, 1)) \"TYPE_CAT\",  convert ('CHAR(32)', decode(1,0,1)) \"TYPE_SCHEM\", convert ('CHAR(32)', decode(1,0,1)) \"TYPE_NAME\",convert ('CHAR(32)', decode(1,0,1))  \"SELF_REFERENCING_COL_NAME\",  convert ('CHAR(32)', decode(1,0,1))  \"REF_GENERATION\" from \"" + this.SuperUser + "\".\"systables\" where 1 = 0")));
        object = (String)object + " order by 4, 2, 3";
        return object;
    }

    private String getSqlStmtTableTypes() {
        String string = new String("select rtrim('SYSTEM TABLE') as 'TABLE_TYPE' from \"" + this.SuperUser + "\".\"syscalctable\" union select rtrim('SYNONYM') from \"" + this.SuperUser + "\".\"syscalctable\" union select rtrim('TABLE') from \"" + this.SuperUser + "\".\"syscalctable\" union select rtrim('VIEW') from \"" + this.SuperUser + "\".\"syscalctable\" order by 1");
        return string;
    }

    private String getSqlStmtTablePrivileges(String string, String string2, String string3) throws CtreeSQLException {
        string = this.validateArg(string);
        string2 = this.validateArg(string2);
        string3 = this.validateArg(string3);
        String string4 = "call \"" + this.SuperUser + "\".\"sql_table_privileges\"('',0,";
        string4 = string2 != null && !string2.equals("") ? string4 + "'" + string2 + "'," + string2.length() + "," : string4 + "'%',1,";
        string4 = string3 != null && !string3.equals("") ? string4 + "'" + string3 + "'," + string3.length() + ")" : string4 + "'%',1)";
        return string4;
    }

    private String getSqlStmtColumns(String string, String string2, String string3, String string4) throws CtreeSQLException {
        string = this.validateArg(string);
        string2 = this.validateArg(string2);
        string3 = this.validateArg(string3);
        string4 = this.validateArg(string4);
        String string5 = " where ";
        Object object = new String("select decode(0,1,'') 'TABLE_CAT',\"owner\" 'TABLE_SCHEM',\"tbl\" 'TABLE_NAME',\"col\" 'COLUMN_NAME',decode(odbcinfo(\"coltype\",0,'datatype'),9,91,10,92,11,93,-8,1,-9,12,odbcinfo(\"coltype\",0,'datatype')) 'DATA_TYPE',rtrim(decode(\"coltype\",'double','double precision','nchar','character','nvarchar','varchar',\"coltype\"),' ')'TYPE_NAME',odbcinfo(\"coltype\", \"width\",'precision') 'COLUMN_SIZE',decode(0,1,'') 'BUFFER_LENGTH',odbcinfo(\"coltype\",\"scale\",'scale') 'DECIMAL_DIGITS',odbcinfo(\"coltype\",0,'radix') 'NUM_PREC_RADIX',convert('integer',decode(\"nullflag\",'Y',1,'N',0)) 'NULLABLE',decode(0,1,'') 'REMARKS',\"dflt_value\" 'COLUMN_DEF',decode(0,1,'') 'SQL_DATA_TYPE',decode(0,1,'') 'SQL_DATETIME_SUB',convert('integer',decode(\"coltype\",'character',\"width\",'varchar',\"width\",'nchar',\"width\" * " + this.charSize() + ",'nvarchar',\"width\" * " + this.charSize() + ",0)) 'CHAR_OCTET_LENGTH',\"id\"+1 'ORDINAL_POSITION',decode(\"nullflag\",'Y','YES','N','NO') 'IS_NULLABLE',convert('CHAR(32)', decode(1, 0, 1))  \"SCOPE_CATALOG\", convert('CHAR(32)', decode(1, 0, 1))  \"SCOPE_SCHEMA\" ,convert('CHAR(32)', decode(1, 0, 1))  \"SCOPE_TABLE\" ,convert('smallint', decode(1, 0, 1))  \"SOURCE_DATA_TYPE\" from \"" + this.SuperUser + "\".\"syscolumns\" ");
        if (string3 != null && !string3.equals("")) {
            object = (String)object + string5 + " \"tbl\" like '" + string3 + "'";
            string5 = " and ";
        }
        if (string2 != null) {
            object = (String)object + string5 + " \"owner\" like '" + string2 + "'";
            string5 = " and ";
        }
        if (string4 != null && !string4.equals("")) {
            object = (String)object + string5 + " \"col\" like '" + string4 + "'";
            string5 = " and ";
        }
        object = (String)object + " order by \"" + this.SuperUser + "\".\"syscolumns\".\"owner\",\"" + this.SuperUser + "\".\"syscolumns\".\"tbl\",\"" + this.SuperUser + "\".\"syscolumns\".\"id\"";
        return object;
    }

    private String getSqlStmtBestRowIdentifier(String string, String string2, String string3, int n, boolean bl, CtreeDatabaseMetaData ctreeDatabaseMetaData) throws CtreeSQLException {
        string = this.validateArg(string);
        string2 = this.validateArg(string2);
        string3 = this.validateArg(string3);
        String string4 = " where ";
        Object object = new String("select convert('smallint'," + ctreeDatabaseMetaData.bestRowTransaction + ") 'SCOPE','rowid' \"COLUMN_NAME\",convert('smallint',1) 'DATA_TYPE','character' \"TYPE_NAME\",convert('integer',18) 'COLUMN_SIZE',convert('integer',0) 'BUFFER_LENGTH',convert('smallint',1) 'DECIMAL_DIGITS',convert('smallint'," + ctreeDatabaseMetaData.bestRowPseudo + ") 'PSEUDO_COLUMN'from \"" + this.SuperUser + "\".\"systables\"");
        if (string3 != null && !string3.equals("")) {
            object = (String)object + string4 + " \"tbl\" = '" + string3 + "'";
            string4 = " and ";
        }
        if (string2 != null) {
            object = (String)object + string4 + " \"owner\" = '" + string2 + "'";
            string4 = " and ";
        }
        if (n != ctreeDatabaseMetaData.bestRowTransaction) {
            object = (String)object + string4 + " 1 = 0";
        }
        return object;
    }

    private String getSqlStmtColumnPrivileges(String string, String string2, String string3, String string4) throws CtreeSQLException {
        Object object = new String("call \"" + this.SuperUser + "\".\"sql_column_privileges\"('',0,");
        object = string2 != null ? (String)object + "'" + string2 + "'," + string2.length() + "," : (String)object + "'%',1,";
        object = string3 != null && !string3.equals("") ? (String)object + "'" + string3 + "'," + string3.length() + "," : (String)object + "'%',1,";
        object = string4 != null && !string4.equals("") ? (String)object + "'" + string4 + "'," + string4.length() + ")" : (String)object + "'%',1)";
        return object;
    }

    private String getSqlStmtVersionColumns(String string, String string2, String string3) throws CtreeSQLException {
        string = this.validateArg(string);
        string2 = this.validateArg(string2);
        string3 = this.validateArg(string3);
        String string4 = new String("select convert('smallint',0) 'SCOPE','' 'COLUMN_NAME',convert('smallint',0) 'DATA_TYPE', '' 'TYPE_NAME', convert('integer',0) 'COLUMN_SIZE', convert('integer',0) 'BUFFER_LENGTH', convert('smallint',0) 'DECIMAL_DIGITS', convert('smallint',0) 'PSEUDO_COLUMN' from \"" + this.SuperUser + "\".\"syscalctable\" where 1 = 0");
        return string4;
    }

    private String getSqlStmtSchemas() throws CtreeSQLException {
        String string = new String("select distinct \"owner\" \"TABLE_SCHEM\" ,convert('CHAR(32)',decode(1,0,1)) \"TABLE_CATALOG\" from \"" + this.SuperUser + "\".\"systables\" order by 2,1 ");
        return string;
    }

    private String getSqlStmtCatalogs() throws CtreeSQLException {
        String string = new String("select convert ('CHAR(32)', decode(1,0,1)) \"TABLE_CAT\" from \"" + this.SuperUser + "\".\"syscalctable\" where 1 = 0");
        return string;
    }

    private String getSqlStmtTypeInfo() throws CtreeSQLException {
        String string = new String("select \"dhtypename\" 'TYPE_NAME',decode(\"dhtypename\",'timestamp',93,'date',91,'time',92,'money', 111, \"datatype\") 'DATA_TYPE',\"typeprecision\" 'PRECISION',\"literalprefix\" 'LITERAL_PREFIX', \"literalsuffix\" 'LITERAL_SUFFIX',\"createparams\" 'CREATE_PARAMS',\"nullable\" 'NULLABLE',\"casesensitive\" 'CASE_SENSITIVE',\"searchable\" 'SEARCHABLE',\"unsignedattr\" 'UNSIGNED_ATTRIBUTE',\"odbcmoney\" 'FIXED_PREC_SCALE',\"autoincr\" 'AUTO_INCREMENT',\"localtypename\" 'LOCAL_TYPE_NAME' ,convert('smallint',decode(\"dhtypename\",'numeric',0,'money',2,'decimal',0,'timestamp',3)) 'MINIMUM_SCALE',convert('smallint',decode(\"dhtypename\",'numeric',32,'money',2,'decimal',32,'timestamp',3)) 'MAXIMUM_SCALE',decode(0,1,'') 'SQL_DATA_TYPE',decode(0,1,'') 'SQL_DATETIME_SUB',odbcinfo(\"dhtypename\",0,'radix') 'NUM_PREC_RADIX' from \"" + this.SuperUser + "\".\"sysdatatypes\" order by 2");
        return string;
    }

    private String getSqlStmtPrimaryKeys(String string, String string2, String string3) throws CtreeSQLException {
        Object object = new String("select decode(0,1,'')  'TABLE_CAT',\"" + this.SuperUser + "\".\"sys_keycol_usage\".\"owner\" 'TABLE_SCHEM',\"" + this.SuperUser + "\".\"sys_keycol_usage\".\"tblname\" 'TABLE_NAME',\"" + this.SuperUser + "\".\"sys_keycol_usage\".\"colname\" 'COLUMN_NAME',convert('smallint',\"" + this.SuperUser + "\".\"sys_keycol_usage\".\"colposition\" + 1) 'KEY_SEQ',\"" + this.SuperUser + "\".\"sys_keycol_usage\".\"cnstrname\" 'PK_NAME'  from \"" + this.SuperUser + "\".\"sys_keycol_usage\",\"" + this.SuperUser + "\".\"sys_tbl_constrs\" where ");
        if (string2 != null) {
            object = (String)object + " \"" + this.SuperUser + "\".\"sys_keycol_usage\".\"owner\" = '" + string2 + "' and ";
        }
        if (string3 == null || string3.equals("")) {
            throw new CtreeSQLException(26055);
        }
        object = (String)object + " \"" + this.SuperUser + "\".\"sys_keycol_usage\".\"tblname\" = '" + string3 + "' and ";
        object = (String)object + "\"" + this.SuperUser + "\".\"sys_keycol_usage\".\"owner\" = \"" + this.SuperUser + "\".\"sys_tbl_constrs\".\"owner\" and \"" + this.SuperUser + "\".\"sys_keycol_usage\".\"tblname\" = \"" + this.SuperUser + "\".\"sys_tbl_constrs\".\"tblname\" and \"" + this.SuperUser + "\".\"sys_keycol_usage\".\"cnstrname\" = \"" + this.SuperUser + "\".\"sys_tbl_constrs\".\"cnstrname\" and \"" + this.SuperUser + "\".\"sys_tbl_constrs\".\"cnstrtype\" = 'P' ";
        return object;
    }

    private String getSqlStmtImportedKeys(String string, String string2, String string3, CtreeDatabaseMetaData ctreeDatabaseMetaData) throws CtreeSQLException {
        Object object = new String("select decode(0,1,'') 'PKTABLE_CAT', t4.\"owner\" 'PKTABLE_SCHEM', t4.\"tblname\" 'PKTABLE_NAME', t4.\"colname\" 'PKCOLUMN_NAME',decode(0,1,'') 'FKTABLE_CAT', t1.\"owner\" 'FKTABLE_SCHEM', t1.\"tblname\" 'FKTABLE_NAME', t1.\"colname\" 'FKCOLUMN_NAME', convert('smallint',t1.\"colposition\" + 1) 'KEY_SEQ', convert('smallint'," + ctreeDatabaseMetaData.importedKeyRestrict + ") 'UPDATE_RULE', convert('smallint'," + ctreeDatabaseMetaData.importedKeyRestrict + ") 'DELETE_RULE',t3.\"cnstrname\" 'FK_NAME', t4.\"cnstrname\" 'PK_NAME', convert('smallint'," + 7 + ") 'DEFERRABILITY' from \"" + this.SuperUser + "\".\"sys_keycol_usage\" t1, \"" + this.SuperUser + "\".\"sys_tbl_constrs\" t2, \"" + this.SuperUser + "\".\"sys_ref_constrs\" t3, \"" + this.SuperUser + "\".\"sys_keycol_usage\" t4 where ");
        if (string2 != null) {
            object = (String)object + "t1.\"owner\" = '" + string2 + "' and ";
        }
        if (string3 == null || string3.equals("")) {
            throw new CtreeSQLException(26055);
        }
        object = (String)object + "t1.\"tblname\" = '" + string3 + "' and ";
        object = (String)object + " t2.\"cnstrtype\" = 'F' and t2.\"tblname\" = t1.\"tblname\" and t2.\"owner\" = t1.\"owner\" and t2.\"cnstrname\" = t1.\"cnstrname\" and t3.\"tblname\" = t1.\"tblname\" and t3.\"owner\" = t1.\"owner\" and t3.\"cnstrname\" = t1.\"cnstrname\" and t4.\"tblname\" = t3.\"reftblname\" and t4.\"cnstrname\" = t3.\"refcnstrname\" and\tt1.\"colposition\" = t4.\"colposition\" order by 1, 2, 3, 9";
        return object;
    }

    private String getSqlStmtExportedKeys(String string, String string2, String string3, CtreeDatabaseMetaData ctreeDatabaseMetaData) throws CtreeSQLException {
        string = this.validateArg(string);
        string2 = this.validateArg(string2);
        string3 = this.validateArg(string3);
        Object object = new String("select distinct decode(0,1,'') 'PKTABLE_CAT', t2.\"refowner\" 'PKTABLE_SCHEM', t2.\"reftblname\" 'PKTABLE_NAME', t1.\"colname\" 'PKCOLUMN_NAME', decode(0,1,'') 'FKTABLE_CAT', t4.\"owner\" 'FKTABLE_SCHEM', t4.\"tblname\" 'FKTABLE_NAME', t4.\"colname\" 'FKCOLUMN_NAME', convert('smallint',t4.\"colposition\" + 1) 'KEY_SEQ', convert('smallint'," + ctreeDatabaseMetaData.importedKeyRestrict + ") 'UPDATE_RULE', convert('smallint'," + ctreeDatabaseMetaData.importedKeyRestrict + ") 'DELETE_RULE', t2.\"cnstrname\" 'FK_NAME',t2.\"refcnstrname\" 'PK_NAME', convert('smallint'," + 7 + ") 'DEFERRABILITY' from \"" + this.SuperUser + "\".\"sys_keycol_usage\" t1, \"" + this.SuperUser + "\".\"sys_ref_constrs\" t2, \"" + this.SuperUser + "\".\"systables\" t3, \"" + this.SuperUser + "\".\"sys_keycol_usage\" t4 where ");
        if (string2 != null) {
            object = (String)object + "t2.\"refowner\" = '" + string2 + "' and ";
        }
        if (string3 == null || string3.equals("")) {
            throw new CtreeSQLException(26055);
        }
        object = (String)object + "t2.\"reftblname\" = '" + string3 + "' and ";
        object = (String)object + " t1.\"owner\" = t2.\"refowner\" and t1.\"tblname\" = t2.\"reftblname\" and t1.\"cnstrname\" = t2.\"refcnstrname\" and t2.\"tblname\" = t3.\"tbl\" and t3.\"tbl_status\" = 'Y' and t4.\"owner\" = t2.\"owner\" and t4.\"tblname\" = t2.\"tblname\" and t4.\"cnstrname\" = t2.\"cnstrname\" and t4.\"colposition\" = t1.\"colposition\" order by 5, 6, 7, 9";
        return object;
    }

    private String getSqlStmtCrossReference(String string, String string2, String string3, String string4, String string5, String string6, CtreeDatabaseMetaData ctreeDatabaseMetaData) throws CtreeSQLException {
        string = this.validateArg(string);
        string2 = this.validateArg(string2);
        string3 = this.validateArg(string3);
        string4 = this.validateArg(string4);
        string5 = this.validateArg(string5);
        string6 = this.validateArg(string6);
        Object object = new String("select decode(0,1,'') 'PKTABLE_CAT', t4.\"owner\" 'PKTABLE_SCHEM', t4.\"tblname\" 'PKTABLE_NAME', t4.\"colname\" 'PKCOLUMN_NAME',decode(0,1,'') 'FKTABLE_CAT',t1.\"owner\" 'FKTABLE_SCHEM', t1.\"tblname\" 'FKTABLE_NAME', t1.\"colname\" 'FKCOLUMN_NAME',convert('smallint',t1.\"colposition\" + 1) 'KEY_SEQ',convert('smallint'," + ctreeDatabaseMetaData.importedKeyRestrict + ") 'UPDATE_RULE', convert('smallint'," + ctreeDatabaseMetaData.importedKeyRestrict + ") 'DELETE_RULE', t3.\"cnstrname\" 'FK_NAME', t4.\"cnstrname\" 'PK_NAME', convert('smallint'," + 7 + ")  'DEFERRABILITY' from \"" + this.SuperUser + "\".\"sys_keycol_usage\" t1, \"" + this.SuperUser + "\".\"sys_tbl_constrs\" t2,\"" + this.SuperUser + "\".\"sys_ref_constrs\" t3, \"" + this.SuperUser + "\".\"sys_keycol_usage\" t4 where ");
        if (string5 != null) {
            object = (String)object + "t1.\"owner\" = '" + string5 + "' and ";
        }
        if (string6 == null || string6.equals("")) {
            throw new CtreeSQLException(26055);
        }
        object = (String)object + "t1.\"tblname\" = '" + string6 + "' and ";
        object = (String)object + " t2.\"cnstrtype\" = 'F' and t2.\"tblname\" = t1.\"tblname\" and t2.\"owner\" = t1.\"owner\" and t2.\"cnstrname\" = t1.\"cnstrname\" and t3.\"tblname\" = t1.\"tblname\" and t3.\"owner\" = t1.\"owner\" and t3.\"cnstrname\" = t1.\"cnstrname\" and t4.\"tblname\" = t3.\"reftblname\" and t4.\"cnstrname\" = t3.\"refcnstrname\" and t1.\"colposition\" = t4.\"colposition\" and ";
        if (string2 != null) {
            object = (String)object + "t4.\"owner\" = '" + string2 + "' and ";
        }
        if (string3 == null || string3.equals("")) {
            throw new CtreeSQLException(26055);
        }
        object = (String)object + "t4.\"tblname\" = '" + string3 + "' ";
        object = (String)object + " order by 5, 6, 7, 9";
        return object;
    }

    private String getSqlStmtIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2, CtreeDatabaseMetaData ctreeDatabaseMetaData) throws CtreeSQLException {
        string = this.validateArg(string);
        string2 = this.validateArg(string2);
        string3 = this.validateArg(string3);
        Object object = new String("select decode(0,1,'') 'TABLE_CAT', t1.\"owner\" 'TABLE_SCHEM', t1.\"tbl\" 'TABLE_NAME', convert('smallint',0) 'NON_UNIQUE', decode (0, 1, t1.\"owner\") 'INDEX_QUALIFIER', decode (0, 1, t1.\"owner\") 'INDEX_NAME', convert('smallint'," + ctreeDatabaseMetaData.tableIndexStatistic + ") \"TYPE\", convert('smallint',0) 'ORDINAL_POSITION', decode (0, 1, t1.\"owner\") 'COLUMN_NAME', decode (0, 1, t1.\"owner\") 'ASC_OR_DESC', convert('integer',decode (0, 1, '')) 'CARDINALITY', convert('integer',decode (0, 1, '')) 'PAGES', decode (0, 1, '') 'FILTER_CONDITION' from \"" + this.SuperUser + "\".\"systables\" t1 where ");
        if (string2 != null) {
            object = (String)object + "t1.\"owner\" = '" + string2 + "' and ";
        }
        if (string3 == null || string3.equals("")) {
            throw new CtreeSQLException(26055);
        }
        object = (String)object + "t1.\"tbl\" = '" + string3 + "' ";
        object = (String)object + "union all select decode(0,1,'') 'TABLE_CAT', t2.\"tblowner\" 'TABLE_SCHEM', t2.\"tbl\" 'TABLE_NAME', convert('smallint',decode (t2.\"idxtype\", 'U',0 , 'D', 1)) 'NON_UNIQUE', t2.\"idxowner\" 'INDEX_QUALIFIER', t2.\"idxname\" 'INDEX_NAME', convert('smallint',decode(t2.\"idxmethod\",'H'," + ctreeDatabaseMetaData.tableIndexHashed + "," + ctreeDatabaseMetaData.tableIndexOther + " )) \"TYPE\",convert('smallint',t2.\"idxseq\" + 1) 'ORDINAL_POSITION', t2.\"colname\" 'COLUMN_NAME', t2.\"idxorder\" 'ASC_OR_DESC', convert('integer',decode(0,1,'')) 'CARDINALITY', convert('integer',decode(0,1,'')) 'PAGES', decode(0,1,'') 'FILTER_CONDITION' from \"" + this.SuperUser + "\".\"sysindexes\" t2 where ";
        if (string2 != null) {
            object = (String)object + "t2.\"tblowner\" = '" + string2 + "' and ";
        }
        if (string3 == null || string3.equals("")) {
            throw new CtreeSQLException(26055);
        }
        object = (String)object + "t2.\"tbl\" = '" + string3 + "' ";
        if (bl) {
            object = (String)object + " and t2.\"idxtype\" = 'U'";
        }
        object = (String)object + " order by 4, 7, 6, 8";
        return object;
    }

    private String getSqlStmtProcedures(String string, String string2, String string3) throws CtreeSQLException {
        string = this.validateArg(string);
        string2 = this.validateArg(string2);
        string3 = this.validateArg(string3);
        Object object = new String("call \"" + this.SuperUser + "\".\"sqlproc\"('',0,");
        object = string2 != null ? (String)object + "'" + string2 + "'," + string2.length() + "," : (String)object + "'%',1,";
        object = string3 != null && !string3.equals("") ? (String)object + "'" + string3 + "'," + string3.length() + ")" : (String)object + "'%',1)";
        return object;
    }

    private String getSqlStmtProcedureColumns(String string, String string2, String string3, String string4) throws CtreeSQLException {
        string = this.validateArg(string);
        string2 = this.validateArg(string2);
        string3 = this.validateArg(string3);
        string4 = this.validateArg(string4);
        Object object = new String("call \"" + this.SuperUser + "\".\"sqlprocedurecols2x\"('',0,");
        object = string2 != null ? (String)object + "'" + string2 + "'," + string2.length() + "," : (String)object + "'%',1,";
        object = string3 != null && !string3.equals("") ? (String)object + "'" + string3 + "'," + string3.length() + "," : (String)object + "'%',1,";
        object = string4 != null && !string4.equals("") ? (String)object + "'" + string4 + "'," + string4.length() + ")" : (String)object + "'%',1)";
        return object;
    }

    public String validateArg(String string) throws CtreeSQLException {
        if (string != null) {
            if ((string = string.trim()).startsWith("\"")) {
                int n = (string = string.substring(1)).indexOf("\"");
                if (n != string.length() - 1) {
                    throw new CtreeSQLException(26055);
                }
                string = string.substring(0, string.length());
            } else if (string.indexOf("\"") != -1) {
                throw new CtreeSQLException(26055);
            }
        }
        return string;
    }

    public int SuperTypes(StatementUid statementUid, String string, String string2, String string3, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string4 = this.getSqlStmtSuperTypes(string, string2, string3);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string4);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int SuperTables(StatementUid statementUid, String string, String string2, String string3, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string4 = this.getSqlStmtSuperTables(string, string2, string3);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string4);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int PseudoColumns(StatementUid statementUid, String string, String string2, String string3, String string4, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string5 = this.getSqlStmtPseudoColumns(string, string2, string3, string4);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string5);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int Attributes(StatementUid statementUid, String string, String string2, String string3, String string4, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string5 = this.getSqlStmtAttributes(string, string2, string3, string4);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string5);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    public int UDTs(StatementUid statementUid, String string, String string2, String string3, int[] nArray, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string4 = this.getSqlStmtUDTs(string, string2, string3, nArray);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string4);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    private String getSqlStmtPseudoColumns(String string, String string2, String string3, String string4) throws CtreeSQLException {
        String string5 = new String("SELECT convert('CHAR(32)', decode(1,0,1)) \"TABLE_CAT\", convert('CHAR(32)', decode(1,0,1))  \"TABLE_SCHEM\", convert('CHAR(32)', decode(1,0,1)) \"TABLE_NAME\", convert('CHAR(32)', decode(1,0,1)) \"COLUMN_NAME\", convert('CHAR(32)', decode(1,0,1)) decode(0,1,'') 'DATA_TYPE', decode(0,1,'') 'COLUMN_SIZE', decode(0,1,'') 'DECIMAL_DIGITS', decode(0,1,'') 'NUM_PREC_RADIX', \"COLUMN_USAGE\", convert('CHAR(32)', decode(1,0,1)) \"REMARKS\", convert('CHAR(32)', decode(1,0,1)) decode(0,1,'') 'CHAR_OCTET_LENGTH', \"IS_NULLABLE\", convert('CHAR(32)', decode(1,0,1))" + this.SuperUser + "\".\"syscalctable\" where 1=0");
        return string5;
    }

    private String getSqlStmtSuperTypes(String string, String string2, String string3) throws CtreeSQLException {
        String string4 = new String("SELECT convert('CHAR(32)', decode(1,0,1)) \"TYPE_CAT\", convert('CHAR(32)', decode(1,0,1))  \"TYPE_SCHEM\", convert('CHAR(32)', decode(1,0,1)) \"TYPE_NAME\", convert('CHAR(32)', decode(1,0,'')) \"SUPERTYPE_CAT\", convert('CHAR(32)',decode(1,0,1)) \"SUPERTYPE_SCHEM\", convert('CHAR(32)', decode(1,0,' ')) \"SUPERTYPE_NAME\" from \"" + this.SuperUser + "\".\"syscalctable\" where 1=0");
        return string4;
    }

    private String getSqlStmtSuperTables(String string, String string2, String string3) throws CtreeSQLException {
        String string4 = new String(" SELECT convert('CHAR(32)', decode(1,0,1))  \"TABLE_CAT\", convert('CHAR(32)', decode(1,0,1))  \"TABLE_SCHEM\", convert('CHAR(32)', decode(1,0,'')) \"TABLE_NAME\", convert('CHAR(32)', decode(1,0,''))  \"SUPERTABLE_NAME\" from \"" + this.SuperUser + "\".\"syscalctable\" where 1=0");
        return string4;
    }

    private String getSqlStmtAttributes(String string, String string2, String string3, String string4) throws CtreeSQLException {
        String string5 = new String("select convert('CHAR(32)', decode(1,0,1)) \"TYPE_CAT\", \"owner\" \"TYPE_SCHEM\",\"tbl\" \"TYPE_NAME\",\"col\" \"ATTR_NAME\", decode(odbcinfo(\"coltype\",0,'datatype'),9,91,10,92,11,93,  odbcinfo(\"coltype\",0,'datatype')) \"DATA_TYPE\", rtrim(decode(\"coltype\",'double','double precision',\"coltype\"),'') \"ATTR_TYPE_NAME\", odbcinfo(\"coltype\", \"width\",'precision')\"ATTR_SIZE\", odbcinfo(\"coltype\",\"scale\",'scale') \"DECIMAL_DIGITS\",  odbcinfo(\"coltype\",0,'radix') \"NUM_PREC_RADIX\", convert('integer',decode(\"nullflag\",'Y',1,'N',0)) \"NULLABLE\", convert('CHAR(32)', decode(1,0,1)) \"REMARKS\", \"dflt_value\" \"ATTR_DEF\", convert('integer', decode(1,0,1)) \"SQL_DATA_TYPE\", convert('integer', decode(1,0,1)) \"SQL_DATETIME_SUB\",convert('integer',decode(\"coltype\",'character', \"width\", 'var',\"width\",0)) \"CHAR_OCTET_LENGTH\", \"id\"+1 \"ORDINAL_POSITION\", decode(\"nullflag\",'Y','YES','N','NO') \"IS_NULLABLE\",  convert('CHAR(32)', decode(1,0,1)) \"SCOPE_CATALOG\", convert('CHAR(32)', decode(1,0,1)) \"SCOPE_SCHEMA\",  convert('CHAR(32)', decode(1,0,1)) \"SCOPE_TABLE\",  convert('smallint', decode(1,0,1)) \"SOURCE_DATA_TYPE\" from \"" + this.SuperUser + "\".\"syscolumns\" where 1 =0");
        return string5;
    }

    private String getSqlStmtUDTs(String string, String string2, String string3, int[] nArray) throws CtreeSQLException {
        String string4 = new String(" select convert ('CHAR(32)', decode(1,0,1)) \"TYPE_CAT\", convert ('CHAR(32)', decode(1,0,1)) \"TYPE_SCHEM\", convert ('CHAR(32)', decode(1,0,'')) \"TYPE_NAME\" ,  convert ('CHAR(32)', decode(1,0,'')) \"CLASS_NAME\",  convert ('CHAR(32)', decode(1,0,'')) \"DATA_TYPE\" , convert ('CHAR(32)', decode(1,0,'')) \"REMARKS\",  convert('smallint', decode(1,0,1)) \"BASE_TYPE\"  from \"" + this.SuperUser + "\".\"syscalctable\" where 1 = 0");
        return string4;
    }

    public synchronized boolean ExecDirectBatch(String string, Vector vector, CtreeCA ctreeCA, StatementUid statementUid, int n) throws SQLException {
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string, n);
        CtreeDA ctreeDA = this.constructInputCtreeDA(vector);
        try {
            this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECTBATCH, ctreeDA, null, ctreeCA);
        }
        catch (SQLException sQLException) {
            ctreeCA.setErrorCode(sQLException.getErrorCode());
            ctreeCA.setSqlstate(sQLException.getSQLState());
            ctreeCA.setErrorMessage(sQLException.getMessage());
        }
        int[] nArray = this.extractRowCountsFromCtreeDA(ctreeDA, true);
        if (ctreeCA.getErrorCode() != 0 && ctreeCA.getErrorCode() != 100) {
            throw new BatchUpdateException(ctreeCA.getErrorMessage(), ctreeCA.getSqlstate(), ctreeCA.getErrorCode(), nArray);
        }
        sQLStatement.SetNrBatchRows(nArray);
        if (this.AutoCommitFlag) {
            this.Commit(ctreeCA);
        }
        return true;
    }

    public CtreeDA constructInputCtreeDA(Vector vector) throws SQLException {
        int n = vector.size();
        CtreeDA ctreeDA = new CtreeDA(2, n, this.charSize(), this.UnicodeCompatibility(), this.csm, this.maxFieldSize);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.get(i);
            ctreeDA.setString(0, i, string);
            ctreeDA.setValue(1, i, new Integer(-1));
            if (n2 >= string.length()) continue;
            n2 = string.length();
        }
        ctreeDA.setParamType(1, (short)2);
        if (this.TransportHandle.IsUnicodeServer()) {
            ctreeDA.setHostType(0, (short)17);
        } else {
            ctreeDA.setHostType(0, (short)1);
        }
        ctreeDA.setLength(0, n2 * this.charSize() + 2);
        ctreeDA.setClength(0, n2 * 3 + 2);
        return ctreeDA;
    }

    protected int charSize() {
        return this.TransportHandle.ServerCharSize();
    }

    protected boolean UnicodeCompatibility() {
        return this.TransportHandle.UnicodeCompatibility();
    }

    public int[] extractRowCountsFromCtreeDA(CtreeDA ctreeDA, boolean bl) throws SQLException {
        int n = ctreeDA.getNRows();
        int[] nArray = new int[n];
        int n2 = ctreeDA.getNColumns() - 1;
        int n3 = n;
        for (int i = 0; i < n; ++i) {
            nArray[i] = ctreeDA.getIntegerValue(n2, i);
            if (nArray[i] != -3 || !bl) continue;
            n3 = i + 1;
            break;
        }
        if (!bl) {
            return nArray;
        }
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    public int[] GetNrBatchRows(StatementUid statementUid) throws SQLException {
        return this.getStatement(statementUid).GetNrBatchRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean ExecBatch(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        SQLStatement sQLStatement = this.getStatement(statementUid);
        int n = ctreeDA.getNColumns() - 1;
        for (int i = 0; i < ctreeDA.getNRows(); ++i) {
            boolean bl = false;
            if (i == 0) {
                bl = ctreeDA.isDescribeParamCalled;
                ctreeDA.isDescribeParamCalled = false;
            }
            try {
                ctreeDA.setValue(n, i, new Integer(-1));
                continue;
            }
            finally {
                if (i == 0) {
                    ctreeDA.isDescribeParamCalled = bl;
                }
            }
        }
        ctreeDA.setParamType(n, (short)2);
        try {
            this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECBATCH, ctreeDA, null, ctreeCA);
        }
        catch (SQLException sQLException) {
            ctreeCA.setErrorCode(sQLException.getErrorCode());
            ctreeCA.setSqlstate(sQLException.getSQLState());
            ctreeCA.setErrorMessage(sQLException.getMessage());
        }
        int[] nArray = this.extractRowCountsFromCtreeDA(ctreeDA, false);
        if (ctreeCA.getErrorCode() != 0 && ctreeCA.getErrorCode() != 100) {
            throw new BatchUpdateException("Error occured during batching :" + ctreeCA.getErrorMessage(), ctreeCA.getSqlstate(), ctreeCA.getErrorCode(), nArray);
        }
        sQLStatement.SetNrBatchRows(nArray);
        if (this.AutoCommitFlag) {
            this.Commit(ctreeCA);
        }
        return true;
    }

    private synchronized int getTimeHigh() {
        ++this.time_high;
        if (this.time_high >= Integer.MAX_VALUE) {
            this.time_high = 0;
        }
        return this.time_high;
    }

    private synchronized short getTimeLow() {
        this.time_low = (short)(this.time_low + 1);
        if (this.time_low >= Short.MAX_VALUE) {
            this.time_low = 0;
        }
        return this.time_low;
    }

    public int getClientInfoProperties(StatementUid statementUid, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string = this.getSqlClientInfoProperties();
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    private String getSqlClientInfoProperties() {
        String string = null;
        string = new String("SELECT 'ApplicationName ' as 'NAME','128'  as 'MAX_LEN','' as 'DEFAULT_VALUE', 'Name of the application using current  connection' as 'DESCRIPTION' FROM syscalctable UNION SELECT 'ClientUser' as 'NAME','128'  as 'MAX_LEN','' as 'DEFAULT_VALUE', 'The name of the user using current application' as 'DESCRIPTION' FROM syscalctable UNION SELECT 'ClientHostname' as 'NAME','128'  as 'MAX_LEN','' as 'DEFAULT_VALUE', 'The hostname for the current connection' as 'DESCRIPTION' FROM syscalctable ORDER by 1");
        return string;
    }

    public int getFunctions(StatementUid statementUid, String string, String string2, String string3, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string4 = this.getSqlStmtFunctions(string, string2, string3);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string4);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    private String getSqlStmtFunctions(String string, String string2, String string3) throws SQLException {
        string = this.validateArg(string);
        string2 = this.validateArg(string2);
        string3 = this.validateArg(string3);
        Object object = null;
        String string4 = null;
        object = new String("SELECT convert ('CHAR(32)', decode(1,0,'')) \"FUNCTION_CAT\",\"owner\" 'FUNTION_SCHEM', \"proc_name\" 'FUNCTION_NAME',\"proc_type\" 'REMARKS', convert('SMALLINT', 1) 'FUNCTION_TYPE',convert ('CHAR(32)', decode(1,0,'')) \"SPECIFIC_NAME\" from \"" + this.SuperUser + "\".\"sysprocedures\" ");
        object = (String)object + " where ( proc_type = 'udf' OR proc_type = 'built_in_fn') ";
        string4 = " and ";
        if (string3 != null && !string3.equals("")) {
            object = (String)object + string4 + " \"proc_name\" like '" + string3 + "'";
            string4 = " and ";
        }
        if (string2 != null && !string2.equals("")) {
            object = (String)object + string4 + " \"owner\" like '" + string2 + "'";
        }
        object = (String)object + " order by 2,3,4";
        return object;
    }

    public int getFunctionColumns(StatementUid statementUid, String string, String string2, String string3, String string4, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string5 = this.getSqlStmtFunctionColumns(string, string2, string3, string4);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string5);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    private String getSqlStmtFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        string = this.validateArg(string);
        string2 = this.validateArg(string2);
        string3 = this.validateArg(string3);
        string4 = this.validateArg(string4);
        Object object = null;
        String string5 = new String(" where ");
        object = new String("SELECT convert ('CHAR(32)', decode(1,0,'')) \"FUNCTION_CAT\",p.\"owner\" 'FUNTION_SCHEM',p.\"proc_name\" 'FUNCTION_NAME', c.\"col\" 'COLUMN_NAME', convert('SMALLINT', decode(c.\"argtype\", 'in', 1, 'return', 4)) \"COLUMN_TYPE\",convert('INTEGER', decode(odbcinfo(\"datatype\",0,'datatype'),9,91,10,92,11,93,-8,1,-9,12,odbcinfo(\"datatype\",0,'datatype'))) \"DATA_TYPE\" ,c.\"datatype\" 'TYPE_NAME',convert('integer',odbcinfo(\"datatype\", c.\"width\",'precision')) \"PRECISION\",convert('integer', odbcinfo(\"datatype\", c.\"width\",'length')) \"LENGTH\",convert('SMALLINT', odbcinfo(\"datatype\", c.\"scale\",'scale')) \"SCALE\",convert('SMALLINT', odbcinfo(\"datatype\",0,'radix')) 'RADIX',convert('SMALLINT',decode(\"nullflag\",'Y',1,'N',0)) 'NULLABLE',decode(0,1,'') 'REMARKS',convert('integer',decode(c.\"datatype\",'character', \"width\", 'varchar',\"width\", 'varbinary', \"width\", 'binary', \"width\")) \"CHAR_OCTET_LENGTH\",c.\"id\"+1 'ORDINAL_POSITION',decode(\"nullflag\",'Y','YES','N','NO') 'IS_NULLABLE', convert ('CHAR(32)', decode(1,0,'')) \"SPECIFIC_NAME\"  from \"" + this.SuperUser + "\".\"sysprocedures\" p,  \"" + this.SuperUser + "\".\"sysproccolumns\" c ");
        object = (String)object + string5 + " ( p.proc_type = 'udf' OR  p.proc_type = 'built_in_fn') and p.proc_id = c.proc_id ";
        string5 = " and ";
        if (string3 != null && !string3.equals("")) {
            object = (String)object + string5 + "p.\"proc_name\"  like '" + string3 + "'";
            string5 = " and ";
        }
        if (string2 != null && !string2.equals("")) {
            object = (String)object + string5 + "p.\"owner\" like '" + string2 + "'";
            string5 = " and ";
        }
        if (string4 != null && !string4.equals("")) {
            object = (String)object + string5 + "c.\"col\"  like '" + string4 + "'";
        }
        object = (String)object + " order by 2,3,4";
        return object;
    }

    public int getSchemas(StatementUid statementUid, String string, String string2, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string3 = this.getSqlStmtSchemas(string, string2);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string3);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    private String getSqlStmtSchemas(String string, String string2) throws CtreeSQLException {
        string = this.validateArg(string);
        string2 = this.validateArg(string2);
        Object object = null;
        String string3 = new String(" where ");
        object = new String("select distinct \"owner\" \"TABLE_SCHEM\" ,convert('CHAR(32)',decode(1,0,1)) \"TABLE_CATALOG\" from \"" + this.SuperUser + "\".\"systables\" ");
        string3 = " where ";
        if (string2 != null && !string2.equals("")) {
            object = (String)object + string3 + " \"owner\" like '" + string2 + "'";
        }
        object = (String)object + " order by 2,1 ";
        return object;
    }

    public int setSchema(StatementUid statementUid, String string, String string2, CtreeDA ctreeDA, CtreeCA ctreeCA) throws SQLException {
        String string3 = this.getSqlStmtSchemas(string, string2);
        SQLStatement sQLStatement = this.NewStatement(statementUid, true, string3);
        this.SQLExec(sQLStatement, ClRqTypes.SQLM_EXECDIRECT1, null, null, ctreeCA);
        sQLStatement.SetNRows(ctreeCA.Sqlerrd[2]);
        if (ctreeDA != null) {
            this.Describe(statementUid, ctreeDA, ctreeCA);
        }
        sQLStatement.SetOpen();
        sQLStatement.SetNRows(0);
        sQLStatement.DoHaveResultSet();
        this.XnOutstandingFlag = true;
        return 0;
    }

    private String getSqlStmtSetSchema(String string) throws CtreeSQLException {
        String string2 = new String("set schema " + string);
        return string2;
    }

    private boolean checkLocalConn() {
        try {
            InetAddress inetAddress = InetAddress.getByName(this.Host);
            return inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || NetworkInterface.getByInetAddress(inetAddress) != null;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return false;
    }

    private void connectSocket() throws SQLException {
        Socket socket = null;
        while (true) {
            try {
                socket = this.establishConnection(this.GetHost(), this.GetPort());
                socket.setTcpNoDelay(true);
                socket.setSoTimeout(this.SOCKET_TIMEOUT);
                this.TransportHandle = new CtreeSQLTransportImpl(socket);
                this.NetworkHandle = new CtreeSQLNetworkImpl(this.TransportHandle);
            }
            catch (UnknownHostException unknownHostException) {
                try {
                    if (this.NetworkHandle != null) {
                        this.NetworkHandle.close();
                    } else if (this.TransportHandle != null) {
                        this.TransportHandle.close();
                    } else if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.NetworkHandle = null;
                this.TransportHandle = null;
                socket = null;
                throw new CtreeSQLException("Unknown host " + unknownHostException.getMessage(), 26010);
            }
            catch (IOException iOException) {
                try {
                    if (this.NetworkHandle != null) {
                        this.NetworkHandle.close();
                    } else if (this.TransportHandle != null) {
                        this.TransportHandle.close();
                    } else if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.NetworkHandle = null;
                this.TransportHandle = null;
                socket = null;
                throw new CtreeSQLException(iOException.getMessage(), 26003);
            }
            catch (Exception exception) {
                try {
                    if (this.NetworkHandle != null) {
                        this.NetworkHandle.close();
                    } else if (this.TransportHandle != null) {
                        this.TransportHandle.close();
                    } else if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.NetworkHandle = null;
                this.TransportHandle = null;
                socket = null;
                throw new CtreeSQLException(exception.getMessage(), 26003);
            }
            this.TransHandle = new CtreeTmHdl();
            NetInitCS netInitCS = new NetInitCS(this.NetworkHandle);
            try {
                netInitCS.FindSvr1(this.GetDBName() + ";" + CtreeCustom.getPowner(this.GetUName()), this.GetUName(), this.sslLevel);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -30102) continue;
                this.NetworkHandle.close();
                this.NetworkHandle = null;
                this.TransportHandle = null;
                this.TransHandle = null;
                throw sQLException;
            }
            break;
        }
        this.RPCFnsHandle = new NetfnsCS(this.NetworkHandle, this.charSize(), this.UnicodeCompatibility(), this.csm);
    }

    private boolean connectSHM(int n) throws SQLException {
        CtreeSHMSQLTransportImpl ctreeSHMSQLTransportImpl = new CtreeSHMSQLTransportImpl();
        try {
            ctreeSHMSQLTransportImpl.connect(this.GetHost(), this.GetPort(), n);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
        catch (SQLNetworkException sQLNetworkException) {
            return false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
        this.TransportHandle = ctreeSHMSQLTransportImpl;
        this.NetworkHandle = new CtreeSQLNetworkImpl(this.TransportHandle);
        this.TransHandle = new CtreeTmHdl();
        NetInitCS netInitCS = new NetInitCS(this.NetworkHandle);
        try {
            netInitCS.FindSvr1(this.GetDBName() + ";" + CtreeCustom.getPowner(this.GetUName()), this.GetUName(), 0);
        }
        catch (SQLException sQLException) {
            this.NetworkHandle.close();
            this.NetworkHandle = null;
            this.TransportHandle = null;
            this.TransHandle = null;
            return false;
        }
        this.RPCFnsHandle = new NetfnsCS(this.NetworkHandle, this.charSize(), this.UnicodeCompatibility(), this.csm);
        return true;
    }

    public int dumpSp(CtreeSQLProcInfo ctreeSQLProcInfo) {
        CtreeInt ctreeInt = new CtreeInt();
        try {
            this.RPCFnsHandle.RemSQLDump(this.TransHandle, ctreeSQLProcInfo, ctreeInt);
        }
        catch (SQLNetworkException sQLNetworkException) {
            return sQLNetworkException.getErrorCode();
        }
        catch (SQLException sQLException) {
            return sQLException.getErrorCode();
        }
        return ctreeInt.getValue();
    }

    public int deploySp(CtreeSQLProcInfo ctreeSQLProcInfo) {
        CtreeInt ctreeInt = new CtreeInt();
        try {
            this.RPCFnsHandle.RemSQLDeploy(this.TransHandle, ctreeSQLProcInfo, ctreeInt);
        }
        catch (SQLNetworkException sQLNetworkException) {
            return sQLNetworkException.getErrorCode();
        }
        catch (SQLException sQLException) {
            return sQLException.getErrorCode();
        }
        return ctreeInt.getValue();
    }

    protected Charset getCharset() {
        return this.csm;
    }

    protected int getNOfRows(StatementUid statementUid) {
        return this.getStatement(statementUid).GetNRows();
    }
}

