/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbcx;

import ctree.jdbc.CtreeConnection;
import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeSQLException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ConnectionBuilder;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.ShardingKeyBuilder;
import java.sql.Wrapper;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class CtreeDataSource
implements DataSource,
Referenceable,
Serializable,
CtreeError,
Wrapper {
    String user;
    String password;
    String portNumber = "6597";
    String serverName = "localhost";
    String databaseName;
    String dataSourceName;
    String description = "c-treeACE DataSource";
    int loginTimeout;
    PrintWriter printWriter;

    @Override
    public Connection getConnection() throws SQLException {
        return new CtreeConnection(this.getURL(), this.user, this.password, "");
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        return new CtreeConnection(this.getURL(), string, string2, "");
    }

    @Override
    public ConnectionBuilder createConnectionBuilder() throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public ShardingKeyBuilder createShardingKeyBuilder() throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.printWriter = printWriter;
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public void setPortNumber(String string) {
        this.portNumber = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getPortNumber() {
        return this.portNumber;
    }

    public String getURL() {
        return "jdbc:ctree://" + this.serverName + ":" + this.portNumber + "/" + this.databaseName;
    }

    @Override
    public Reference getReference() {
        Reference reference = new Reference(this.getClass().getName(), "ctree.jdbcx.CtreeObjectFactory", null);
        reference.add(new StringRefAddr("serverName", this.getServerName()));
        reference.add(new StringRefAddr("dataSourceName", this.getDataSourceName()));
        reference.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.getPassword()));
        reference.add(new StringRefAddr("portNumber", this.getPortNumber()));
        reference.add(new StringRefAddr("description", this.getDescription()));
        return reference;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return this.getClass().getName().equals(clazz.getName());
    }

    public CtreeDataSource unwrap(Class clazz) throws SQLException {
        boolean bl = clazz.getName().equals(this.getClass().getName());
        if (!bl) {
            throw new CtreeSQLException(26094);
        }
        return this;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException(CtreeSQLException.getErrorMessage(26030), CtreeSQLException.getSQLState(26030), 26030);
    }
}

