/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbcx;

import ctree.jdbc.CtreeResultSet;
import ctree.jdbc.CtreeStatement;
import ctree.jdbcx.CtreeConnectionHandle;
import ctree.jdbcx.CtreePooledConnection;
import ctree.jdbcx.CtreePooledResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;

class CtreePooledStatement
extends CtreeStatement {
    protected CtreePooledConnection pooledConnection;
    protected CtreeConnectionHandle connectionHandle;

    public CtreePooledStatement(CtreePooledConnection ctreePooledConnection, CtreeConnectionHandle ctreeConnectionHandle, int n, int n2) throws SQLException {
        super(ctreeConnectionHandle, n, n2);
        this.pooledConnection = ctreePooledConnection;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = super.executeQuery(string);
        }
        catch (SQLException sQLException) {
            this.pooledConnection.handleSQLException(sQLException);
        }
        return resultSet;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        int n = 0;
        try {
            n = super.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            this.pooledConnection.handleSQLException(sQLException);
        }
        return n;
    }

    @Override
    public void close() throws SQLException {
        try {
            super.close();
        }
        catch (SQLException sQLException) {
            this.pooledConnection.handleSQLException(sQLException);
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        boolean bl = false;
        try {
            bl = super.execute(string);
        }
        catch (SQLException sQLException) {
            this.pooledConnection.handleSQLException(sQLException);
        }
        return bl;
    }

    @Override
    protected CtreeResultSet createCtreeResultSet() throws SQLException {
        return new CtreePooledResultSet(this.pooledConnection, this);
    }
}

