/*
 * Decompiled with CFR 0.152.
 */
package ctree.sqlsp;

import java.util.Hashtable;

public class DDMJavaCache {
    private String[] lruList;
    Hashtable<String, Object> dhcache;
    private int max_entries;
    private int no_of_elem = 0;

    public DDMJavaCache(int n) {
        this.log("IN : DDMJavaCache constructor \n");
        this.dhcache = new Hashtable(n);
        this.lruList = new String[n];
        this.max_entries = n;
        this.log("OUT : DDMJavaCache constructor \n");
    }

    public synchronized Object get(String string) throws Exception {
        int n;
        this.log("IN : DDMJavaCache::get \n");
        this.log("String to be got " + string + "\n");
        for (n = 0; n < this.no_of_elem && !string.equals(this.lruList[n]); ++n) {
        }
        if (n == this.no_of_elem) {
            this.log("OUT : DDMJavaCache::get \n");
            return null;
        }
        System.arraycopy(this.lruList, 0, this.lruList, 1, n);
        this.lruList[0] = new String(string);
        this.log("DC257 : String got from the lrulist" + string + "\n");
        this.log("OUT : DDMJavaCache::get \n");
        return this.dhcache.get(string);
    }

    public synchronized void put(String string, Object object) {
        this.log("IN : DDMJavaCache::put \n");
        if (this.no_of_elem == this.max_entries) {
            this.log("Cache is full,removing last elem \n");
            this.dhcache.remove(this.lruList[this.no_of_elem - 1]);
            --this.no_of_elem;
            this.log("Calling clearBaseCache \n");
            this.clearBaseCache();
            this.log("Returned from clearBaseCache \n");
        }
        if (this.no_of_elem > 0) {
            System.arraycopy(this.lruList, 0, this.lruList, 1, this.no_of_elem);
        }
        this.lruList[0] = new String(string);
        this.log("Elem being put " + string + " \n");
        Object object2 = this.dhcache.put(string, object);
        this.log("The old key " + object2 + " \n");
        if (this.no_of_elem != this.max_entries) {
            ++this.no_of_elem;
        }
        this.log("no_of_elem " + this.no_of_elem + " \n");
        this.log("OUT : DDMJavaCache::put \n");
    }

    public synchronized void clear() {
        this.log("IN : DDMJavaCache::clear \n");
        for (int i = 0; i < this.no_of_elem; ++i) {
            this.log("i        :" + i + " ");
            this.log(this.lruList[i] + " \n");
            this.lruList[i] = null;
        }
        this.dhcache.clear();
        this.no_of_elem = 0;
        this.log("OUT : DDMJavaCache::clear \n");
    }

    public native void clearBaseCache();

    public native void log(String var1);

    public native void err(String var1);
}

