/*
 * Decompiled with CFR 0.152.
 */
package com.faircom.persistence.eclipselink;

import com.faircom.persistence.eclipselink.CtreeConnection;
import com.faircom.persistence.eclipselink.CtreeInteractionSpec;
import com.faircom.persistence.eclipselink.CtreeMappedRecord;
import com.faircom.persistence.eclipselink.CtreeOperation;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;
import org.eclipse.persistence.eis.EISException;

public class CtreeInteraction
implements Interaction {
    private CtreeConnection connection;

    public CtreeInteraction(CtreeConnection ctreeConnection) {
        this.connection = ctreeConnection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Record execute(InteractionSpec interactionSpec, Record record) throws ResourceException {
        if (!(interactionSpec instanceof CtreeInteractionSpec)) {
            throw EISException.invalidInteractionSpecType();
        }
        if (!(record instanceof CtreeMappedRecord)) {
            throw EISException.invalidRecordType();
        }
        CtreeInteractionSpec ctreeInteractionSpec = (CtreeInteractionSpec)interactionSpec;
        CtreeMappedRecord ctreeMappedRecord = (CtreeMappedRecord)record;
        CtreeOperation ctreeOperation = ctreeInteractionSpec.getOperation();
        String string = ctreeInteractionSpec.getTable();
        if (ctreeOperation == null) {
            ResourceException resourceException = new ResourceException("ctree operation must be set");
            throw resourceException;
        }
        if (string == null) {
            throw new ResourceException("table name must be set");
        }
        switch (ctreeOperation) {
            case INSERT: {
                this.connection.write(string, ctreeMappedRecord);
                return ctreeMappedRecord;
            }
            case REMOVE: {
                this.connection.remove(string, ctreeMappedRecord);
                return null;
            }
            case FIND: {
                return this.connection.find(string, ctreeMappedRecord, ctreeInteractionSpec);
            }
        }
        throw new ResourceException("Invalid operation: " + (Object)((Object)ctreeOperation));
    }

    public boolean execute(InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException {
        if (!(interactionSpec instanceof CtreeInteractionSpec)) {
            throw EISException.invalidInteractionSpecType();
        }
        if (!(record instanceof CtreeMappedRecord) || !(record2 instanceof CtreeMappedRecord)) {
            throw EISException.invalidRecordType();
        }
        CtreeInteractionSpec ctreeInteractionSpec = (CtreeInteractionSpec)interactionSpec;
        CtreeMappedRecord ctreeMappedRecord = (CtreeMappedRecord)record;
        CtreeMappedRecord ctreeMappedRecord2 = (CtreeMappedRecord)record2;
        CtreeOperation ctreeOperation = ctreeInteractionSpec.getOperation();
        String string = ctreeInteractionSpec.getTable();
        if (ctreeOperation == null) {
            throw new ResourceException("c-tree operation must be set");
        }
        if (string == null) {
            throw new ResourceException("DB name must be set");
        }
        try {
            if (ctreeOperation == CtreeOperation.UPDATE) {
                this.connection.update(string, ctreeMappedRecord2, ctreeMappedRecord);
                return true;
            }
            throw new ResourceException("Invalid operation: " + (Object)((Object)ctreeOperation));
        }
        catch (Exception exception) {
            throw new ResourceException(exception.toString(), (Throwable)exception);
        }
    }

    public void clearWarnings() throws ResourceException {
    }

    public void close() throws ResourceException {
    }

    public ResourceWarning getWarnings() throws ResourceException {
        return null;
    }
}

