/*
 * Decompiled with CFR 0.152.
 */
package drctree;

import drctree.DrCtreeApp;
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppProperties {
    public String lookAndFeel = "System";
    public int autoRefreshRate = 0;
    public String fileFilter = "";
    public Rectangle bounds;
    public boolean showHiddenDirs;
    public boolean openWithRes;
    Properties applicationProps = new Properties();

    public void loadProperties() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream("./DrCtree.cfg");
            this.applicationProps.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.applicationProps.isEmpty()) {
            String string = this.applicationProps.getProperty("bounds");
            if (string != null) {
                String[] stringArray = string.split(",");
                this.bounds = new Rectangle(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
            }
            if ((string = this.applicationProps.getProperty("lookAndFeel")) != null) {
                this.lookAndFeel = string;
            }
            if ((string = this.applicationProps.getProperty("autoRefreshRate")) != null) {
                this.autoRefreshRate = Integer.parseInt(string);
            }
            if ((string = this.applicationProps.getProperty("fileFilter")) != null) {
                this.fileFilter = string;
            }
            if ((string = this.applicationProps.getProperty("showHiddenDirs")) != null) {
                boolean bl = this.showHiddenDirs = string.equals("true");
            }
            if ((string = this.applicationProps.getProperty("openWithRes")) != null) {
                this.openWithRes = string.equals("true");
            }
        }
    }

    public void saveProperties() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("./DrCtree.cfg");
            if (this.bounds != null) {
                this.applicationProps.setProperty("bounds", Integer.toString(this.bounds.x) + "," + Integer.toString(this.bounds.y) + "," + Integer.toString(this.bounds.width) + "," + Integer.toString(this.bounds.height));
            }
            if (this.lookAndFeel != null) {
                this.applicationProps.setProperty("lookAndFeel", this.lookAndFeel);
            }
            if (this.fileFilter != null) {
                this.applicationProps.setProperty("fileFilter", this.fileFilter);
            }
            this.applicationProps.setProperty("autoRefreshRate", Integer.toString(this.autoRefreshRate));
            this.applicationProps.setProperty("showHiddenDirs", this.showHiddenDirs ? "true" : "false");
            this.applicationProps.setProperty("openWithRes", this.openWithRes ? "true" : "false");
            this.applicationProps.store(fileOutputStream, "---DrCtree---");
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(DrCtreeApp.class.getName()).log(Level.SEVERE, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(DrCtreeApp.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }
}

