/*
 * Decompiled with CFR 0.152.
 */
package drctree;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import Isam.CtreeFile;
import Isam.JCtree;
import Isam.Structures;
import drctree.Globals;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ConvMapTable
extends FcBaseDynamicTable {
    private convMapTableModel tableModel = new convMapTableModel(this);
    protected boolean inError;

    public ConvMapTable(boolean bl) {
        this.setModel((TableModel)((Object)this.tableModel));
        this.tableModel.setupColumns();
    }

    public convMapTableModel getModel() {
        return this.tableModel;
    }

    void selectRow(String string) {
        this.tableModel.selecRow(string);
    }

    void fill(CtreeFile ctreeFile) {
        this.clearTable();
        this.tableModel.fill(ctreeFile);
    }

    public class convMapTableModel
    extends FcBaseTableModel {
        convMapTableModel(ConvMapTable convMapTable2) {
            super((FcBaseDynamicTable)convMapTable2, true);
            this.table = convMapTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"#", "Element", "Description", "Value", "Type"};
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(30);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(80);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(160);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(100);
            tableColumn = this.table.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(50);
            this.autoSizeColumns.set(3, true);
            this.readOnlyColumns.set(0, true);
            this.readOnlyColumns.set(1, true);
            this.readOnlyColumns.set(2, true);
            this.readOnlyColumns.set(4, true);
        }

        private void fill(CtreeFile ctreeFile) {
            if (ctreeFile.isOpen()) {
                int n = 0;
                try {
                    Structures.CONVMAP_STRUCT cONVMAP_STRUCT = ctreeFile.getSchemaMap();
                    if (cONVMAP_STRUCT.align == -1) {
                        return;
                    }
                    String[] stringArray = new String[]{"HIGH / LOW", "LOW / HIGH", "pdp"};
                    String string = "";
                    if (cONVMAP_STRUCT.flavor > 0) {
                        string = stringArray[cONVMAP_STRUCT.flavor - 1];
                    }
                    this.addRow((Integer)n++, "flavor", "Data Flavor", "(" + cONVMAP_STRUCT.flavor + ") " + string, "UTEXT");
                    String string2 = "";
                    switch (cONVMAP_STRUCT.align) {
                        case 1: {
                            string2 = "byte";
                            break;
                        }
                        case 2: {
                            string2 = "word";
                            break;
                        }
                        case 4: {
                            string2 = "double word";
                            break;
                        }
                        case 8: {
                            string2 = "quad word";
                        }
                    }
                    this.addRow((Integer)n++, "align", "Data Alignment", "(" + cONVMAP_STRUCT.align + ") " + string2, "UTEXT");
                    this.addRow((Integer)n++, "flddelm", "Field Delimiter Byte", cONVMAP_STRUCT.flddelm, "UTEXT");
                    this.addRow((Integer)n++, "padding", "Field Padding Byte", cONVMAP_STRUCT.padding, "UTEXT");
                    this.addRow((Integer)n++, "maplen", "Total Length of Map", cONVMAP_STRUCT.maplen, "VRLEN");
                    this.addRow((Integer)n++, "nbrflds", "Number of Fields", cONVMAP_STRUCT.nbrflds, "VRLEN");
                    this.addRow((Integer)n++, "nbrblks", "Number of Fields Blocks", cONVMAP_STRUCT.nbrblks, "VRLEN");
                }
                catch (JCtree.CtreeException ctreeException) {
                    Globals.showException(ctreeException, "getXtdCreateBlock");
                }
            }
            super.fireTableDataChanged();
        }

        public void addRow(Integer n, String string, String string2, String string3, String string4) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(n);
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }

        public void addRow(Integer n, String string, String string2, int n2, String string3) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(n);
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(n2);
            arrayList.add(string3);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }

        private void selecRow(String string) {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                Integer n2 = (Integer)this.getValueAt(i, 0);
                if (!n2.toString().equals(string)) continue;
                i = this.table.convertRowIndexToView(i);
                this.table.setRowSelectionInterval(i, i);
                Rectangle rectangle = this.table.getCellRect(i, i, true);
                this.table.scrollRectToVisible(rectangle);
            }
        }
    }

    class PopupActions
    implements ActionListener {
        int mode;

        public PopupActions(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ConvMapTable.this.getSelectedRows();
        }
    }

    public class TTMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
            ConvMapTable.this.showTooltip = false;
        }
    }
}

