/*
 * Decompiled with CFR 0.152.
 */
package drctree;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import Isam.CtreeFile;
import Isam.Structures;
import drctree.HeaderDesc;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DatobjTable
extends FcBaseDynamicTable {
    private DatobjTableModel tableModel;
    protected boolean inError;
    private HeaderDesc headerDesc = new HeaderDesc();

    public DatobjTable(boolean bl) {
        this.tableModel = new DatobjTableModel(this);
        this.setModel((TableModel)((Object)this.tableModel));
        this.tableModel.setupColumns();
    }

    public DatobjTableModel getModel() {
        return this.tableModel;
    }

    void selectRow(String string) {
        this.tableModel.selecRow(string);
    }

    void fill(CtreeFile ctreeFile) {
        this.clearTable();
        this.tableModel.fill(ctreeFile);
    }

    public class DatobjTableModel
    extends FcBaseTableModel {
        DatobjTableModel(DatobjTable datobjTable2) {
            super((FcBaseDynamicTable)datobjTable2, true);
            this.table = datobjTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"#", "fadr", "flen", "ftype", "fsymb"};
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(30);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(80);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(80);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(160);
            tableColumn = this.table.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(160);
            this.autoSizeColumns.set(4, true);
            this.readOnlyColumns.set(0, true);
        }

        private void fill(CtreeFile ctreeFile) {
            if (ctreeFile.isOpen()) {
                int n = 0;
                int n2 = 0;
                ArrayList arrayList = ctreeFile.getDodaArray();
                if (arrayList != null) {
                    for (Structures.DATOBJ_STRUCT dATOBJ_STRUCT : arrayList) {
                        String string = "CT_" + dATOBJ_STRUCT.ftype.toString();
                        String string2 = Integer.toString(dATOBJ_STRUCT.flen);
                        switch (dATOBJ_STRUCT.ftype) {
                            case VSTRING: {
                                string = "CT_STRING";
                                string2 = "";
                                break;
                            }
                            case VPSTRING: {
                                string = "CT_PTRING";
                                break;
                            }
                            case V2STRING: {
                                string = "CT_2STRING";
                                break;
                            }
                            case V4STRING: {
                                string = "CT_4STRING";
                                string2 = "";
                                break;
                            }
                            case FUNICODE2: {
                                string = "CT_F2UNICODE";
                                break;
                            }
                            case UNICODE: {
                                string = "CT_UNICODE";
                                break;
                            }
                            case UNICODE2: {
                                string = "CT_2UNICODE";
                            }
                        }
                        String string3 = "";
                        if (dATOBJ_STRUCT.ftype != null) {
                            string3 = "( " + dATOBJ_STRUCT.ftype.value + " - 0x" + Integer.toHexString(dATOBJ_STRUCT.ftype.value) + " ) " + string;
                        }
                        this.addRow(n++, n2, string2, string3, dATOBJ_STRUCT.fsymb);
                        n2 += dATOBJ_STRUCT.flen;
                    }
                }
            }
            super.fireTableDataChanged();
        }

        private void addRow(int n, int n2, String string, String string2, String string3) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(n);
            arrayList.add(n2);
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }

        public void addRow(Integer n, String string, String string2, int n2, String string3) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(n);
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(n2);
            arrayList.add(string3);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }

        private void selecRow(String string) {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                Integer n2 = (Integer)this.getValueAt(i, 0);
                if (!n2.toString().equals(string)) continue;
                i = this.table.convertRowIndexToView(i);
                this.table.setRowSelectionInterval(i, i);
                Rectangle rectangle = this.table.getCellRect(i, i, true);
                this.table.scrollRectToVisible(rectangle);
            }
        }
    }

    class PopupActions
    implements ActionListener {
        int mode;

        public PopupActions(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = DatobjTable.this.getSelectedRows();
        }
    }

    public class TTMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
            DatobjTable.this.showTooltip = false;
        }
    }
}

