/*
 * Decompiled with CFR 0.152.
 */
package drctree;

import FairCom.Helper.Dialogs.AboutBox;
import FairCom.Helper.ErrorViewer.ErrorViewerDialog;
import Isam.CtreeSession;
import drctree.AllowUpdatesDlg;
import drctree.ConvMapTable;
import drctree.DatobjTable;
import drctree.DrCtreeApp;
import drctree.FileFilter;
import drctree.FilesTree;
import drctree.Globals;
import drctree.HeaderTable;
import drctree.IfilTable;
import drctree.IfilTree;
import drctree.InfoTable;
import drctree.IsegTable;
import drctree.OSXAdapter;
import drctree.OpenFileDlg;
import drctree.RecordsTable;
import drctree.ResourcesTree;
import drctree.XcreBlkTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreePath;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;

public class DrCtreeView
extends FrameView
implements WindowListener,
DropTargetListener {
    ErrorViewerDialog errorViewerDlg = null;
    FilesTree leftTree = new FilesTree();
    IfilTree ifilTree = new IfilTree();
    ResourcesTree resourcesTree = new ResourcesTree();
    public InfoTable infoTable = new InfoTable(true);
    public HeaderTable headerTable = new HeaderTable(true);
    public XcreBlkTable xcreBlkTable = new XcreBlkTable(true);
    public IfilTable ifilTable = new IfilTable(true);
    public IsegTable isegTable = new IsegTable(true);
    public DatobjTable datobjTable = new DatobjTable(true);
    public ConvMapTable convMapTable = new ConvMapTable(true);
    public RecordsTable recordsTable = new RecordsTable(true);
    private String tempPath = "./";
    private String argmnt = null;
    private DropTarget dt;
    private DragSource ds;
    public boolean indexCBClearing = false;
    public JButton addRecBT;
    private JCheckBoxMenuItem allowUpdatesMenuItem;
    private JScrollPane convMapScrollPane;
    public JTextField currentRecTF;
    private JScrollPane datObjScrollPane;
    private JToggleButton errorViewerBT;
    private JMenuItem filterMenuItem;
    public JButton firstRecBT;
    private JScrollPane headerScrollPane;
    private JButton headerUpdateButton;
    private JScrollPane ifilIiidxScrollPane;
    private JScrollPane ifilsTreeScrollPane;
    public JComboBox indexCB;
    private JScrollPane infoScrollPane;
    public JSplitPane isamRecordsViewPane;
    private JScrollPane isegScrollPane;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JToolBar.Separator jSeparator12;
    private JToolBar.Separator jSeparator13;
    private JToolBar.Separator jSeparator14;
    private JToolBar.Separator jSeparator15;
    private JToolBar.Separator jSeparator2;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane3;
    private JSplitPane jSplitPane4;
    private JTable jTable1;
    private JTable jTable2;
    private JTable jTable3;
    private JTable jTable4;
    private JTable jTable5;
    private JTable jTable6;
    private JTable jTable7;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JTree jTree1;
    private JTree jTree2;
    private JTree jTree3;
    public JButton lastRecBT;
    private JScrollPane leftTreeScrollPane;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    public JButton nextRecBT;
    private JMenuItem opeModeMenuItem;
    private JToggleButton openWithResBT;
    private JMenu optionsMenu;
    public JButton prevRecBT;
    private JSpinner recBlockSP;
    private JScrollPane recordscrollPane;
    private JButton refreshBT;
    public JButton removeRecBT;
    public JTextPane resDumpTP;
    public JTextPane resStructTP;
    public JTabbedPane resTabbedPane;
    private JScrollPane resTreeScrollPane;
    private JCheckBoxMenuItem showHiddenDirMenuItem;
    private JLabel statusMessageLabel;
    public JLabel statusMessageLabel2;
    private JPanel statusPanel;
    protected JTabbedPane tabbedPane;
    public JTextField totalRecTF;
    private JScrollPane xcreBlkScrollPane;

    public DrCtreeView(SingleFrameApplication singleFrameApplication) {
        super(singleFrameApplication);
        Thread.currentThread().setUncaughtExceptionHandler(new MyUncaughtExceptionHandler());
        this.initComponents();
        ArrayList<Image> arrayList = new ArrayList<Image>();
        ImageIcon imageIcon = Globals.getIcon("App16.png");
        Image image = imageIcon.getImage();
        arrayList.add(image);
        imageIcon = Globals.getIcon("App24.png");
        image = imageIcon.getImage();
        arrayList.add(image);
        imageIcon = Globals.getIcon("App32.png");
        image = imageIcon.getImage();
        arrayList.add(image);
        imageIcon = Globals.getIcon("App48.png");
        image = imageIcon.getImage();
        arrayList.add(image);
        this.getFrame().setIconImages(arrayList);
        this.getFrame().addWindowListener(this);
        Globals.appFrame = this;
        if (Globals.appProps.bounds != null && Globals.appProps.bounds.getWidth() > 400.0) {
            this.getFrame().setBounds(Globals.appProps.bounds);
        } else {
            this.getFrame().setBounds(new Rectangle(200, 200, 800, 600));
        }
        this.getFrame().setTitle("DrCtree");
        for (String string : Globals.args) {
            if (!string.equals("-adv")) {
                this.argmnt = string;
                break;
            }
            Globals.advancedMode = true;
        }
        this.leftTree.setPath(this.tempPath);
        this.leftTree.fillTree();
        this.leftTree.setFileFilter(Globals.appProps.fileFilter);
        this.leftTree.setShowHiddenDirs(Globals.appProps.showHiddenDirs);
        this.leftTreeScrollPane.setViewportView((Component)((Object)this.leftTree));
        this.ifilsTreeScrollPane.setViewportView((Component)((Object)this.ifilTree));
        this.resTreeScrollPane.setViewportView((Component)((Object)this.resourcesTree));
        this.showHiddenDirMenuItem.setSelected(Globals.appProps.showHiddenDirs);
        this.infoScrollPane.setViewportView((Component)((Object)this.infoTable));
        this.headerScrollPane.setViewportView((Component)((Object)this.headerTable));
        this.xcreBlkScrollPane.setViewportView((Component)((Object)this.xcreBlkTable));
        this.ifilIiidxScrollPane.setViewportView((Component)((Object)this.ifilTable));
        this.isegScrollPane.setViewportView((Component)((Object)this.isegTable));
        this.datObjScrollPane.setViewportView((Component)((Object)this.datobjTable));
        this.convMapScrollPane.setViewportView((Component)((Object)this.convMapTable));
        this.recordscrollPane.setViewportView((Component)((Object)this.recordsTable));
        this.openWithResBT.setSelected(Globals.appProps.openWithRes);
        this.leftTree.setNodesColor(Globals.appProps.openWithRes);
        this.addRecBT.setEnabled(false);
        this.removeRecBT.setEnabled(false);
        this.dt = new DropTarget(this.getFrame(), this);
        Globals.allowUpdates = false;
        this.registerForMacOSXEvents();
    }

    public void registerForMacOSXEvents() {
        boolean bl = Globals.os.startsWith("mac os x");
        if (bl) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("quit", null));
                OSXAdapter.setAboutHandler(this, this.getClass().getDeclaredMethod("showAboutBox", null));
            }
            catch (Exception exception) {
                System.err.println("Error while loading the OSXAdapter:");
            }
        }
    }

    public void quit() {
        System.exit(0);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                System.out.println("Possible flavor: " + dataFlavorArray[i].getMimeType());
                if (!dataFlavorArray[i].isFlavorJavaFileListType()) continue;
                dropTargetDropEvent.acceptDrop(3);
                List list = (List)transferable.getTransferData(dataFlavorArray[i]);
                for (int j = 0; j < list.size(); ++j) {
                }
                dropTargetDropEvent.dropComplete(true);
                this.leftTree.selectFile(list.get(0).toString());
                return;
            }
            dropTargetDropEvent.rejectDrop();
        }
        catch (Exception exception) {
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Action
    public void showAboutBox() {
        JFrame jFrame = DrCtreeApp.getApplication().getMainFrame();
        ImageIcon imageIcon = Globals.getIcon("App48.png");
        AboutBox aboutBox = new AboutBox((Frame)jFrame, true, (Icon)imageIcon, "DrCtree", null);
        aboutBox.setLocationRelativeTo((Component)jFrame);
        aboutBox.setVisible(true);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.leftTreeScrollPane = new JScrollPane();
        this.jTree1 = new JTree();
        this.tabbedPane = new JTabbedPane();
        this.infoScrollPane = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.headerUpdateButton = new JButton();
        this.headerScrollPane = new JScrollPane();
        this.jTable2 = new JTable();
        this.xcreBlkScrollPane = new JScrollPane();
        this.jTable3 = new JTable();
        this.jPanel3 = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.ifilsTreeScrollPane = new JScrollPane();
        this.jTree2 = new JTree();
        this.jSplitPane3 = new JSplitPane();
        this.ifilIiidxScrollPane = new JScrollPane();
        this.jTable4 = new JTable();
        this.isegScrollPane = new JScrollPane();
        this.jTable5 = new JTable();
        this.jPanel4 = new JPanel();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.datObjScrollPane = new JScrollPane();
        this.jTable6 = new JTable();
        this.jSplitPane4 = new JSplitPane();
        this.resTreeScrollPane = new JScrollPane();
        this.jTree3 = new JTree();
        this.resTabbedPane = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.resDumpTP = new JTextPane();
        this.jScrollPane2 = new JScrollPane();
        this.resStructTP = new JTextPane();
        this.convMapScrollPane = new JScrollPane();
        this.jTable7 = new JTable();
        this.isamRecordsViewPane = new JSplitPane();
        this.jPanel7 = new JPanel();
        this.jLabel2 = new JLabel();
        this.indexCB = new JComboBox();
        this.jToolBar2 = new JToolBar();
        this.firstRecBT = new JButton();
        this.prevRecBT = new JButton();
        this.jSeparator12 = new JToolBar.Separator();
        this.currentRecTF = new JTextField();
        this.totalRecTF = new JTextField();
        this.jSeparator13 = new JToolBar.Separator();
        this.nextRecBT = new JButton();
        this.lastRecBT = new JButton();
        this.jSeparator14 = new JToolBar.Separator();
        this.addRecBT = new JButton();
        this.removeRecBT = new JButton();
        this.jSeparator15 = new JToolBar.Separator();
        this.jLabel1 = new JLabel();
        this.recBlockSP = new JSpinner();
        this.recordscrollPane = new JScrollPane();
        this.jToolBar1 = new JToolBar();
        this.refreshBT = new JButton();
        this.openWithResBT = new JToggleButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.errorViewerBT = new JToggleButton();
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        JMenuItem jMenuItem = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.filterMenuItem = new JMenuItem();
        this.opeModeMenuItem = new JMenuItem();
        this.showHiddenDirMenuItem = new JCheckBoxMenuItem();
        this.allowUpdatesMenuItem = new JCheckBoxMenuItem();
        JMenu jMenu2 = new JMenu();
        JMenuItem jMenuItem2 = new JMenuItem();
        this.statusPanel = new JPanel();
        this.statusMessageLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.statusMessageLabel2 = new JLabel();
        this.mainPanel.setName("mainPanel");
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setName("jSplitPane1");
        this.leftTreeScrollPane.setName("leftTreeScrollPane");
        this.jTree1.setName("jTree1");
        this.leftTreeScrollPane.setViewportView(this.jTree1);
        this.jSplitPane1.setLeftComponent(this.leftTreeScrollPane);
        this.tabbedPane.setName("tabbedPane");
        this.infoScrollPane.setName("infoScrollPane");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setName("jTable1");
        this.infoScrollPane.setViewportView(this.jTable1);
        ResourceMap resourceMap = Application.getInstance(DrCtreeApp.class).getContext().getResourceMap(DrCtreeView.class);
        this.tabbedPane.addTab(resourceMap.getString("infoScrollPane.TabConstraints.tabTitle", new Object[0]), this.infoScrollPane);
        this.jPanel5.setName("jPanel5");
        this.jPanel6.setName("jPanel6");
        this.headerUpdateButton.setText(resourceMap.getString("headerUpdateButton.text", new Object[0]));
        this.headerUpdateButton.setEnabled(false);
        this.headerUpdateButton.setName("headerUpdateButton");
        GroupLayout groupLayout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(261, 261, 261).addComponent(this.headerUpdateButton).addContainerGap(294, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.headerUpdateButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.headerScrollPane.setName("headerScrollPane");
        this.jTable2.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable2.setName("jTable2");
        this.headerScrollPane.setViewportView(this.jTable2);
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addComponent(this.headerScrollPane, -1, 660, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.headerScrollPane, -1, 385, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, -1, -2)));
        this.tabbedPane.addTab(resourceMap.getString("jPanel5.TabConstraints.tabTitle", new Object[0]), this.jPanel5);
        this.xcreBlkScrollPane.setName("xcreBlkScrollPane");
        this.jTable3.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable3.setName("jTable3");
        this.xcreBlkScrollPane.setViewportView(this.jTable3);
        this.tabbedPane.addTab(resourceMap.getString("xcreBlkScrollPane.TabConstraints.tabTitle", new Object[0]), this.xcreBlkScrollPane);
        this.jPanel3.setName("jPanel3");
        this.jSplitPane2.setDividerLocation(100);
        this.jSplitPane2.setName("jSplitPane2");
        this.ifilsTreeScrollPane.setName("ifilsTreeScrollPane");
        this.jTree2.setName("jTree2");
        this.ifilsTreeScrollPane.setViewportView(this.jTree2);
        this.jSplitPane2.setLeftComponent(this.ifilsTreeScrollPane);
        this.jSplitPane3.setDividerLocation(261);
        this.jSplitPane3.setOrientation(0);
        this.jSplitPane3.setName("jSplitPane3");
        this.ifilIiidxScrollPane.setName("ifilIiidxScrollPane");
        this.jTable4.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable4.setName("jTable4");
        this.ifilIiidxScrollPane.setViewportView(this.jTable4);
        this.jSplitPane3.setTopComponent(this.ifilIiidxScrollPane);
        this.isegScrollPane.setName("isegScrollPane");
        this.jTable5.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable5.setName("jTable5");
        this.isegScrollPane.setViewportView(this.jTable5);
        this.jSplitPane3.setRightComponent(this.isegScrollPane);
        this.jSplitPane2.setRightComponent(this.jSplitPane3);
        this.jPanel4.setName("jPanel4");
        this.jButton2.setText(resourceMap.getString("jButton2.text", new Object[0]));
        this.jButton2.setEnabled(false);
        this.jButton2.setName("jButton2");
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGap(260, 260, 260).addComponent(this.jButton2).addContainerGap(311, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jButton2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitPane2, -1, 660, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addComponent(this.jSplitPane2, -1, 385, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2)));
        this.tabbedPane.addTab(resourceMap.getString("jPanel3.TabConstraints.tabTitle", new Object[0]), this.jPanel3);
        this.jPanel1.setName("jPanel1");
        this.jPanel2.setName("jPanel2");
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setEnabled(false);
        this.jButton1.setName("jButton1");
        GroupLayout groupLayout5 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addGap(261, 261, 261).addComponent(this.jButton1).addContainerGap(304, Short.MAX_VALUE)));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addComponent(this.jButton1).addContainerGap(-1, Short.MAX_VALUE)));
        this.datObjScrollPane.setName("datObjScrollPane");
        this.jTable6.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable6.setName("jTable6");
        this.datObjScrollPane.setViewportView(this.jTable6);
        GroupLayout groupLayout6 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.datObjScrollPane, -1, 660, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout6.createSequentialGroup().addComponent(this.datObjScrollPane, -1, 385, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)));
        this.tabbedPane.addTab(resourceMap.getString("jPanel1.TabConstraints.tabTitle", new Object[0]), this.jPanel1);
        this.jSplitPane4.setDividerLocation(150);
        this.jSplitPane4.setName("jSplitPane4");
        this.resTreeScrollPane.setName("resTreeScrollPane");
        this.jTree3.setName("jTree3");
        this.resTreeScrollPane.setViewportView(this.jTree3);
        this.jSplitPane4.setLeftComponent(this.resTreeScrollPane);
        this.resTabbedPane.setTabPlacement(3);
        this.resTabbedPane.setName("resTabbedPane");
        this.jScrollPane1.setName("jScrollPane1");
        this.resDumpTP.setFont(resourceMap.getFont("resDumpTP.font"));
        this.resDumpTP.setName("resDumpTP");
        this.jScrollPane1.setViewportView(this.resDumpTP);
        this.resTabbedPane.addTab(resourceMap.getString("jScrollPane1.TabConstraints.tabTitle", new Object[0]), this.jScrollPane1);
        this.jScrollPane2.setName("jScrollPane2");
        this.resStructTP.setName("resStructTP");
        this.jScrollPane2.setViewportView(this.resStructTP);
        this.resTabbedPane.addTab(resourceMap.getString("jScrollPane2.TabConstraints.tabTitle", new Object[0]), this.jScrollPane2);
        this.jSplitPane4.setRightComponent(this.resTabbedPane);
        this.tabbedPane.addTab(resourceMap.getString("jSplitPane4.TabConstraints.tabTitle", new Object[0]), this.jSplitPane4);
        this.convMapScrollPane.setName("convMapScrollPane");
        this.jTable7.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable7.setName("jTable7");
        this.convMapScrollPane.setViewportView(this.jTable7);
        this.tabbedPane.addTab(resourceMap.getString("convMapScrollPane.TabConstraints.tabTitle", new Object[0]), this.convMapScrollPane);
        this.isamRecordsViewPane.setDividerLocation(80);
        this.isamRecordsViewPane.setOrientation(0);
        this.isamRecordsViewPane.setEnabled(false);
        this.isamRecordsViewPane.setName("isamRecordsViewPane");
        this.jPanel7.setName("jPanel7");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.indexCB.setName("indexCB");
        this.indexCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.indexCBActionPerformed(actionEvent);
            }
        });
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setRollover(true);
        this.jToolBar2.setName("jToolBar2");
        this.firstRecBT.setIcon(resourceMap.getIcon("firstRecBT.icon"));
        this.firstRecBT.setToolTipText(resourceMap.getString("firstRecBT.toolTipText", new Object[0]));
        this.firstRecBT.setFocusable(false);
        this.firstRecBT.setHorizontalTextPosition(0);
        this.firstRecBT.setName("firstRecBT");
        this.firstRecBT.setVerticalTextPosition(3);
        this.firstRecBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.firstRecBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar2.add(this.firstRecBT);
        this.prevRecBT.setIcon(resourceMap.getIcon("prevRecBT.icon"));
        this.prevRecBT.setToolTipText(resourceMap.getString("prevRecBT.toolTipText", new Object[0]));
        this.prevRecBT.setFocusable(false);
        this.prevRecBT.setHorizontalTextPosition(0);
        this.prevRecBT.setName("prevRecBT");
        this.prevRecBT.setVerticalTextPosition(3);
        this.prevRecBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.prevRecBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar2.add(this.prevRecBT);
        this.jSeparator12.setName("jSeparator12");
        this.jToolBar2.add(this.jSeparator12);
        this.currentRecTF.setColumns(5);
        this.currentRecTF.setHorizontalAlignment(0);
        this.currentRecTF.setText(resourceMap.getString("currentRecTF.text", new Object[0]));
        this.currentRecTF.setToolTipText(resourceMap.getString("currentRecTF.toolTipText", new Object[0]));
        this.currentRecTF.setAutoscrolls(false);
        this.currentRecTF.setMinimumSize(new Dimension(30, 20));
        this.currentRecTF.setName("currentRecTF");
        this.currentRecTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.currentRecTFActionPerformed(actionEvent);
            }
        });
        this.currentRecTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                DrCtreeView.this.currentRecTFFocusLost(focusEvent);
            }
        });
        this.jToolBar2.add(this.currentRecTF);
        this.totalRecTF.setColumns(5);
        this.totalRecTF.setEditable(false);
        this.totalRecTF.setText(resourceMap.getString("totalRecTF.text", new Object[0]));
        this.totalRecTF.setFocusable(false);
        this.totalRecTF.setName("totalRecTF");
        this.jToolBar2.add(this.totalRecTF);
        this.jSeparator13.setName("jSeparator13");
        this.jToolBar2.add(this.jSeparator13);
        this.nextRecBT.setIcon(resourceMap.getIcon("nextRecBT.icon"));
        this.nextRecBT.setToolTipText(resourceMap.getString("nextRecBT.toolTipText", new Object[0]));
        this.nextRecBT.setFocusable(false);
        this.nextRecBT.setHorizontalTextPosition(0);
        this.nextRecBT.setName("nextRecBT");
        this.nextRecBT.setVerticalTextPosition(3);
        this.nextRecBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.nextRecBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar2.add(this.nextRecBT);
        this.lastRecBT.setIcon(resourceMap.getIcon("lastRecBT.icon"));
        this.lastRecBT.setToolTipText(resourceMap.getString("lastRecBT.toolTipText", new Object[0]));
        this.lastRecBT.setFocusable(false);
        this.lastRecBT.setHorizontalTextPosition(0);
        this.lastRecBT.setName("lastRecBT");
        this.lastRecBT.setVerticalTextPosition(3);
        this.lastRecBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.lastRecBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar2.add(this.lastRecBT);
        this.jSeparator14.setName("jSeparator14");
        this.jToolBar2.add(this.jSeparator14);
        this.addRecBT.setIcon(resourceMap.getIcon("addRecBT.icon"));
        this.addRecBT.setToolTipText(resourceMap.getString("addRecBT.toolTipText", new Object[0]));
        this.addRecBT.setFocusable(false);
        this.addRecBT.setHorizontalTextPosition(0);
        this.addRecBT.setName("addRecBT");
        this.addRecBT.setVerticalTextPosition(3);
        this.addRecBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.addRecBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar2.add(this.addRecBT);
        this.removeRecBT.setIcon(resourceMap.getIcon("removeRecBT.icon"));
        this.removeRecBT.setToolTipText(resourceMap.getString("removeRecBT.toolTipText", new Object[0]));
        this.removeRecBT.setFocusable(false);
        this.removeRecBT.setHorizontalTextPosition(0);
        this.removeRecBT.setName("removeRecBT");
        this.removeRecBT.setVerticalTextPosition(3);
        this.removeRecBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.removeRecBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar2.add(this.removeRecBT);
        this.jSeparator15.setName("jSeparator15");
        this.jToolBar2.add(this.jSeparator15);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.recBlockSP.setModel(new SpinnerListModel(new String[]{"100", "1000", "10000", "100000"}));
        this.recBlockSP.setName("recBlockSP");
        this.recBlockSP.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DrCtreeView.this.recBlockSPStateChanged(changeEvent);
            }
        });
        GroupLayout groupLayout7 = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addComponent(this.jToolBar2, -2, -1, -2).addGap(41, 41, 41).addComponent(this.jLabel1).addGap(10, 10, 10).addComponent(this.recBlockSP, -2, 71, -2)).addGroup(groupLayout7.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.indexCB, -2, 218, -2))).addContainerGap(207, Short.MAX_VALUE)));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.recBlockSP, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jToolBar2, -2, -1, -2)).addGap(5, 5, 5).addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.indexCB, -2, -1, -2)).addContainerGap(29, Short.MAX_VALUE)));
        this.isamRecordsViewPane.setTopComponent(this.jPanel7);
        this.recordscrollPane.setEnabled(false);
        this.recordscrollPane.setFocusable(false);
        this.recordscrollPane.setName("recordscrollPane");
        this.isamRecordsViewPane.setRightComponent(this.recordscrollPane);
        this.tabbedPane.addTab("Records", this.isamRecordsViewPane);
        this.jSplitPane1.setRightComponent(this.tabbedPane);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setName("jToolBar1");
        this.refreshBT.setIcon(resourceMap.getIcon("refreshBT.icon"));
        this.refreshBT.setText(resourceMap.getString("refreshBT.text", new Object[0]));
        this.refreshBT.setToolTipText(resourceMap.getString("refreshBT.toolTipText", new Object[0]));
        this.refreshBT.setFocusable(false);
        this.refreshBT.setHorizontalTextPosition(0);
        this.refreshBT.setName("refreshBT");
        this.refreshBT.setVerticalTextPosition(3);
        this.refreshBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.refreshBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.refreshBT);
        this.openWithResBT.setIcon(resourceMap.getIcon("openWithResBT.icon"));
        this.openWithResBT.setText(resourceMap.getString("openWithResBT.text", new Object[0]));
        this.openWithResBT.setFocusable(false);
        this.openWithResBT.setName("openWithResBT");
        this.openWithResBT.setVerticalTextPosition(3);
        this.openWithResBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.openWithResBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.openWithResBT);
        this.jSeparator2.setName("jSeparator2");
        this.jToolBar1.add(this.jSeparator2);
        this.errorViewerBT.setIcon(resourceMap.getIcon("errorViewerBT.icon"));
        this.errorViewerBT.setText(resourceMap.getString("errorViewerBT.text", new Object[0]));
        this.errorViewerBT.setFocusable(false);
        this.errorViewerBT.setHorizontalTextPosition(0);
        this.errorViewerBT.setName("errorViewerBT");
        this.errorViewerBT.setVerticalTextPosition(3);
        this.errorViewerBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.errorViewerBTActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.errorViewerBT);
        GroupLayout groupLayout8 = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(groupLayout8);
        groupLayout8.setHorizontalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 871, Short.MAX_VALUE).addComponent(this.jSplitPane1, -1, 871, Short.MAX_VALUE));
        groupLayout8.setVerticalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 455, Short.MAX_VALUE)));
        this.menuBar.setName("menuBar");
        jMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        jMenu.setName("fileMenu");
        ApplicationActionMap applicationActionMap = Application.getInstance(DrCtreeApp.class).getContext().getActionMap(DrCtreeView.class, this);
        jMenuItem.setAction(applicationActionMap.get("quit"));
        jMenuItem.setName("exitMenuItem");
        jMenu.add(jMenuItem);
        this.menuBar.add(jMenu);
        this.optionsMenu.setText(resourceMap.getString("optionsMenu.text", new Object[0]));
        this.optionsMenu.setName("optionsMenu");
        this.filterMenuItem.setText(resourceMap.getString("filterMenuItem.text", new Object[0]));
        this.filterMenuItem.setName("filterMenuItem");
        this.filterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.filterMenuItemActionPerformed(actionEvent);
            }
        });
        this.optionsMenu.add(this.filterMenuItem);
        this.opeModeMenuItem.setText(resourceMap.getString("opeModeMenuItem.text", new Object[0]));
        this.opeModeMenuItem.setName("opeModeMenuItem");
        this.opeModeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.opeModeMenuItemActionPerformed(actionEvent);
            }
        });
        this.optionsMenu.add(this.opeModeMenuItem);
        this.showHiddenDirMenuItem.setText(resourceMap.getString("showHiddenDirMenuItem.text", new Object[0]));
        this.showHiddenDirMenuItem.setName("showHiddenDirMenuItem");
        this.showHiddenDirMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.showHiddenDirMenuItemActionPerformed(actionEvent);
            }
        });
        this.optionsMenu.add(this.showHiddenDirMenuItem);
        this.allowUpdatesMenuItem.setText(resourceMap.getString("allowUpdatesMenuItem.text", new Object[0]));
        this.allowUpdatesMenuItem.setName("allowUpdatesMenuItem");
        this.allowUpdatesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrCtreeView.this.allowUpdatesMenuItemActionPerformed(actionEvent);
            }
        });
        this.optionsMenu.add(this.allowUpdatesMenuItem);
        this.menuBar.add(this.optionsMenu);
        jMenu2.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        jMenu2.setName("helpMenu");
        jMenuItem2.setAction(applicationActionMap.get("showAboutBox"));
        jMenuItem2.setName("aboutMenuItem");
        jMenu2.add(jMenuItem2);
        this.menuBar.add(jMenu2);
        this.statusPanel.setName("statusPanel");
        this.statusPanel.setPreferredSize(new Dimension(610, 28));
        this.statusMessageLabel.setText(resourceMap.getString("statusMessageLabel.text", new Object[0]));
        this.statusMessageLabel.setName("statusMessageLabel");
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setName("jSeparator1");
        this.statusMessageLabel2.setText(resourceMap.getString("statusMessageLabel2.text", new Object[0]));
        this.statusMessageLabel2.setName("statusMessageLabel2");
        GroupLayout groupLayout9 = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(groupLayout9);
        groupLayout9.setHorizontalGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout9.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel, -2, 54, -2).addGap(18, 18, 18).addComponent(this.statusMessageLabel2, -2, 533, -2).addContainerGap(256, Short.MAX_VALUE)).addGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout9.createSequentialGroup().addGap(60, 60, 60).addComponent(this.jSeparator1, -2, 11, -2).addContainerGap(800, Short.MAX_VALUE))));
        groupLayout9.setVerticalGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout9.createSequentialGroup().addComponent(this.statusMessageLabel2, -2, 28, -2).addGap(11, 11, 11)).addGroup(groupLayout9.createSequentialGroup().addComponent(this.statusMessageLabel, -1, 28, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 39, Short.MAX_VALUE)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void refreshBTActionPerformed(ActionEvent actionEvent) {
        TreePath treePath = this.leftTree.getSelectionPath();
        this.leftTree.refreshTree();
    }

    private void openWithResBTActionPerformed(ActionEvent actionEvent) {
        this.leftTree.setNodesColor(this.openWithResBT.isSelected());
        Globals.appProps.openWithRes = this.openWithResBT.isSelected();
        this.leftTree.openFile(-1);
    }

    private void showHiddenDirMenuItemActionPerformed(ActionEvent actionEvent) {
        this.leftTree.setShowHiddenDirs(this.showHiddenDirMenuItem.isSelected());
        Globals.appProps.showHiddenDirs = this.showHiddenDirMenuItem.isSelected();
        Globals.appProps.saveProperties();
        this.leftTree.refreshTree();
    }

    private void filterMenuItemActionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = DrCtreeApp.getApplication().getMainFrame();
        FileFilter fileFilter = new FileFilter((Frame)jFrame, true);
        fileFilter.setLocationRelativeTo(jFrame);
        if (fileFilter.showDialog(Globals.appProps.fileFilter)) {
            this.leftTree.setFileFilter(fileFilter.getFileFilter());
            Globals.appProps.fileFilter = fileFilter.getFileFilter();
            Globals.appProps.saveProperties();
            this.leftTree.refreshTree();
        }
    }

    private void indexCBActionPerformed(ActionEvent actionEvent) {
        if (!this.indexCBClearing) {
            Object object = this.indexCB.getSelectedItem();
            int n = this.indexCB.getSelectedIndex();
            this.leftTree.openFile(n);
        }
    }

    private void currentRecTFActionPerformed(ActionEvent actionEvent) {
        String string = this.currentRecTF.getText();
        int n = Integer.parseInt(string);
    }

    private void recBlockSPStateChanged(ChangeEvent changeEvent) {
        int n;
        String string = (String)this.recBlockSP.getValue();
        this.recordsTable.blockSize = n = Integer.parseInt(string);
        this.recordsTable.refresh(this.leftTree.ctreeFile, RecordsTable.MODE.FIRST);
    }

    private void firstRecBTActionPerformed(ActionEvent actionEvent) {
        this.recordsTable.refresh(this.leftTree.ctreeFile, RecordsTable.MODE.FIRST);
    }

    private void prevRecBTActionPerformed(ActionEvent actionEvent) {
        this.recordsTable.refresh(this.leftTree.ctreeFile, RecordsTable.MODE.PREVIOUS);
    }

    private void nextRecBTActionPerformed(ActionEvent actionEvent) {
        this.recordsTable.refresh(this.leftTree.ctreeFile, RecordsTable.MODE.NEXT);
    }

    private void lastRecBTActionPerformed(ActionEvent actionEvent) {
        this.recordsTable.refresh(this.leftTree.ctreeFile, RecordsTable.MODE.LAST);
    }

    private void errorViewerBTActionPerformed(ActionEvent actionEvent) {
        if (this.errorViewerBT.isSelected()) {
            if (this.errorViewerDlg == null) {
                JFrame jFrame = DrCtreeApp.getApplication().getMainFrame();
                this.errorViewerDlg = new ErrorViewerDialog((Frame)jFrame, false);
                Image image = Globals.getIcon("ErrorViewer.png").getImage();
                this.errorViewerDlg.setIconImage(image);
                this.errorViewerDlg.setLocationRelativeTo((Component)jFrame);
                this.errorViewerDlg.addWindowListener((WindowListener)new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        DrCtreeView.this.errorViewerBT.setSelected(false);
                    }
                });
            }
            this.errorViewerDlg.setVisible(true);
        } else {
            this.errorViewerDlg.setVisible(false);
        }
    }

    private void currentRecTFFocusLost(FocusEvent focusEvent) {
        String string = this.currentRecTF.getText();
        try {
            int n = Integer.parseInt(string);
            this.recordsTable.gotoRecordOffset = n - 1;
            this.recordsTable.refresh(this.leftTree.ctreeFile, RecordsTable.MODE.GOTO);
            this.recordsTable.gotoRecordOffset = 0L;
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void opeModeMenuItemActionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = DrCtreeApp.getApplication().getMainFrame();
        OpenFileDlg openFileDlg = new OpenFileDlg((Frame)jFrame, true);
        openFileDlg.setLocationRelativeTo(jFrame);
        if (openFileDlg.showDialog(this.leftTree.getOpenMode(), this.leftTree.isOpenWithResources())) {
            this.leftTree.setOpenMode(openFileDlg.getOpenMode());
            boolean bl = openFileDlg.isOpenWithResources();
            this.leftTree.setOpenWithResources(bl);
            this.openWithResBT.setSelected(bl);
            Globals.appProps.openWithRes = bl;
            Globals.appProps.saveProperties();
            this.leftTree.refreshTree();
        }
    }

    private void allowUpdatesMenuItemActionPerformed(ActionEvent actionEvent) {
        if (!Globals.allowUpdates) {
            JFrame jFrame = DrCtreeApp.getApplication().getMainFrame();
            AllowUpdatesDlg allowUpdatesDlg = new AllowUpdatesDlg((Frame)jFrame, true);
            allowUpdatesDlg.setLocationRelativeTo(jFrame);
            if (allowUpdatesDlg.showDialog() && allowUpdatesDlg.password.toLowerCase().equals("admin")) {
                Globals.allowUpdates = true;
                this.allowUpdatesMenuItem.setSelected(true);
                this.headerUpdateButton.setEnabled(true);
                this.addRecBT.setEnabled(true);
                this.removeRecBT.setEnabled(true);
                return;
            }
        }
        this.headerUpdateButton.setEnabled(false);
        this.addRecBT.setEnabled(false);
        this.removeRecBT.setEnabled(false);
        this.allowUpdatesMenuItem.setSelected(false);
        Globals.allowUpdates = false;
    }

    private void removeRecBTActionPerformed(ActionEvent actionEvent) {
        this.recordsTable.refresh(this.leftTree.ctreeFile, RecordsTable.MODE.REMOVE);
    }

    private void addRecBTActionPerformed(ActionEvent actionEvent) {
        this.recordsTable.refresh(this.leftTree.ctreeFile, RecordsTable.MODE.ADD);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        int n;
        String string = (String)this.recBlockSP.getValue();
        this.recordsTable.blockSize = n = Integer.parseInt(string);
        this.leftTree.selectFile(this.argmnt);
        this.infoTable.resizeColumns();
        this.headerTable.resizeColumns();
        this.xcreBlkTable.resizeColumns();
        this.ifilTable.resizeColumns();
        this.isegTable.resizeColumns();
        this.datobjTable.resizeColumns();
        this.convMapTable.resizeColumns();
    }

    public static boolean deleteDirectory(File file) {
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    DrCtreeView.deleteDirectory(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
        }
        return file.delete();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        Rectangle rectangle;
        CtreeSession ctreeSession = this.leftTree.getSession();
        if (ctreeSession != null) {
            ctreeSession.Close();
        }
        JFrame jFrame = DrCtreeApp.getApplication().getMainFrame();
        Globals.appProps.bounds = rectangle = jFrame.getBounds();
        Globals.appProps.saveProperties();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    class MyUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        MyUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof IllegalStateException) {
                // empty if block
            }
            if (throwable instanceof UnsatisfiedLinkError) {
                JFrame jFrame = DrCtreeApp.getApplication().getMainFrame();
                String string = "32";
                String string2 = "64";
                String string3 = System.getProperty("os.arch");
                String string4 = throwable.getMessage();
                String string5 = "";
                if (string3.contains("64")) {
                    string = "64";
                    string2 = "32";
                }
                if (jFrame != null) {
                    Toolkit.getDefaultToolkit().beep();
                    string5 = string4.contains("path") ? "ctreeJNIStd library not found." : "Mismatch found between JVM version and ctreeJNIStd library.\n\nThe JVM is " + string + " bit while ctreeJNIStd is " + string2 + " bit.";
                    string5 = string5 + "\n\nPlease install the appropriate version of the ctreeJNIStd library for your Java platform.";
                    JOptionPane.showMessageDialog(jFrame, string5, "Application Error", 0);
                    System.exit(1);
                }
            } else {
                Globals.ShowNormalCursor();
                Globals.showException(throwable, null, false);
            }
        }
    }
}

