/*
 * Decompiled with CFR 0.152.
 */
package drctree;

import FairCom.Helper.Classes.FcDynamicTree;
import FairCom.Helper.Classes.FcTreeNode;
import Isam.CtreeFile;
import Isam.CtreeSession;
import Isam.Enums;
import Isam.JCtree;
import drctree.DrCtreeApp;
import drctree.DrCtreeView;
import drctree.Globals;
import drctree.MyTreeNode;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FilesTree
extends FcDynamicTree {
    private boolean showHiddenDirs = false;
    private boolean openWithResources = false;
    private String[] filters = null;
    private ArrayList<String> expandedNodes = new ArrayList();
    private MyTreeNode currentTreeNode;
    private CtreeSession mySession;
    public CtreeFile ctreeFile;
    private CtreeFile oldCtreeFile;
    private Enums.FILE_MODE openMode = Enums.FILE_MODE.SHARED;
    private String tempPath;
    private int indexMember;
    private boolean isInternalIndex;
    private int pathLevel;
    private int recordIndex;
    private static final Comparator<File> sortByName = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            String string = file.getName().toLowerCase();
            String string2 = file2.getName().toLowerCase();
            return string.compareTo(string2);
        }
    };

    public FilesTree() {
        this.addTreeExpansionListener(new myTreeExpansionListener());
    }

    void refreshTree() {
        MyTreeNode myTreeNode = (MyTreeNode)((Object)this.getLastSelectedPathComponent());
        String string = null;
        if (myTreeNode != null) {
            string = myTreeNode.getFilename();
        }
        this.getExpandedNodes();
        this.fillTree();
        this.expandSavedNodes();
        if (string != null) {
            this.selectFile(string);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        MyTreeNode myTreeNode = (MyTreeNode)((Object)this.getLastSelectedPathComponent());
        if (myTreeNode != null) {
            int n = myTreeNode.getLevel();
            if (n < 1 || myTreeNode == null) {
                return;
            }
            if (myTreeNode.getFileType().ordinal() < 4) {
                return;
            }
            if (this.currentTreeNode == myTreeNode) {
                return;
            }
            this.currentTreeNode = myTreeNode;
            DrCtreeView drCtreeView = (DrCtreeView)DrCtreeApp.getApplication().getMainView();
            JFrame jFrame = DrCtreeApp.getApplication().getMainFrame();
            int n2 = drCtreeView.tabbedPane.getSelectedIndex();
            if (n2 > -1) {
                this.recordIndex = 0;
                this.openFile(myTreeNode);
                drCtreeView.indexCBClearing = true;
                if (drCtreeView.indexCB.getItemCount() > 0) {
                    drCtreeView.indexCB.setSelectedIndex(0);
                }
                drCtreeView.indexCBClearing = false;
                jFrame.setTitle("Dr.c-tree - " + myTreeNode.getText());
                this.repaint();
            }
        }
    }

    void openFile(int n) {
        if (this.currentTreeNode != null) {
            this.recordIndex = n;
            this.openFile(this.currentTreeNode);
        }
    }

    private void openFile(MyTreeNode myTreeNode) {
        block35: {
            Object object;
            FILE_TYPE fILE_TYPE;
            Object object2;
            Object object3;
            String string;
            MyTreeNode myTreeNode2;
            String string2;
            block34: {
                string2 = "";
                string2 = myTreeNode.getFilename();
                myTreeNode2 = this.currentTreeNode;
                this.indexMember = 0;
                this.setNavigationControls(true);
                if (this.getSession() == null) {
                    try {
                        CtreeSession.SetLogFilesPath((String)(this.tempPath + "/"), (Enums.LOG_MODE)Enums.LOG_MODE.ALL);
                        this.mySession = new CtreeSession("ctreeJNIStd", Enums.USER_PROF.setValue((int)(Enums.USER_PROF.NTKEY.value() | Enums.USER_PROF.CLRCHK.value)));
                    }
                    catch (JCtree.CtreeException ctreeException) {
                        if (ctreeException.Error == 40) {
                            try {
                                string = new File(".").getCanonicalPath();
                                object3 = new File(string);
                                for (File file : object2 = ((File)object3).listFiles()) {
                                    if (!file.getCanonicalPath().endsWith(".FCS")) continue;
                                    file.delete();
                                }
                                CtreeSession.SetLogFilesPath((String)(this.tempPath + "/"), (Enums.LOG_MODE)Enums.LOG_MODE.ALL);
                                this.mySession = new CtreeSession("ctreeJNIStd", Enums.USER_PROF.setValue((int)(Enums.USER_PROF.NTKEY.value() | Enums.USER_PROF.CLRCHK.value)));
                            }
                            catch (IOException iOException) {
                                Logger.getLogger(FilesTree.class.getName()).log(Level.SEVERE, null, iOException);
                                break block34;
                            }
                            catch (JCtree.CtreeException ctreeException2) {
                                Globals.showException(ctreeException, "Create Session ");
                                return;
                            }
                        }
                        if (ctreeException.Error == 999) {
                            Globals.showException(ctreeException, "Create Session -> ", "Fatal Error");
                            return;
                        }
                        Globals.showException(ctreeException, "Create Session");
                        return;
                    }
                }
            }
            if ((fILE_TYPE = ((MyTreeNode)myTreeNode.getParent()).getFileType()).ordinal() >= FILE_TYPE.SPRFILE.ordinal() && fILE_TYPE.ordinal() <= FILE_TYPE.SPRFILEYELLOW.ordinal()) {
                string = this.currentTreeNode.getFilename();
                if (string.endsWith("Internal Index")) {
                    int n = string.lastIndexOf(File.separator);
                    string2 = string.substring(0, n);
                    this.indexMember = 1;
                    this.isInternalIndex = true;
                } else {
                    int n = string.lastIndexOf(File.separator);
                    object2 = string.substring(0, n);
                    object = string.substring(n + 1, string.length());
                    string2 = string = (String)object2 + "!" + (String)object;
                }
            }
            if (fILE_TYPE.ordinal() >= FILE_TYPE.SINDEX.ordinal() && fILE_TYPE.ordinal() <= FILE_TYPE.SINDEXYELLOW.ordinal()) {
                string = this.currentTreeNode.getFilename();
                int n = string.lastIndexOf(35);
                object2 = string.substring(n + 1, n + 2);
                this.indexMember = Integer.parseInt((String)object2);
                n = string.lastIndexOf(92);
                string2 = string.substring(0, n);
                fILE_TYPE = ((MyTreeNode)myTreeNode.getParent().getParent()).getFileType();
                if (fILE_TYPE.ordinal() >= FILE_TYPE.SPRFILE.ordinal() && fILE_TYPE.ordinal() <= FILE_TYPE.SPRFILEYELLOW.ordinal()) {
                    string = string2;
                    n = string.lastIndexOf(File.separator);
                    object = string.substring(0, n);
                    String string3 = string.substring(n + 1, string.length());
                    string2 = string = (String)object + "!" + string3;
                }
            }
            this.ctreeFile = this.getSession().AllocateCtreeFile(string2, true);
            this.ctreeFile.currentIndex = (short)this.recordIndex;
            try {
                if (this.isOpenWithResources()) {
                    this.ctreeFile.openFileWithResource(this.getOpenMode());
                } else {
                    this.ctreeFile.openFile(this.getOpenMode());
                }
                if (this.ctreeFile.isSuperfileHost() && this.indexMember == 0) {
                    String string4;
                    this.currentTreeNode.setFileType(FILE_TYPE.SPRFILEGREEN);
                    string = this.currentTreeNode.getFilename();
                    object3 = new MyTreeNode("Internal Index");
                    ((MyTreeNode)((Object)object3)).setFileType(FILE_TYPE.SINDEXGREEN);
                    ((MyTreeNode)((Object)object3)).setFileName(string + File.separator + "Internal Index");
                    this.currentTreeNode.add((MutableTreeNode)object3);
                    object2 = this.ctreeFile.getSuperfileMembers();
                    object = ((ArrayList)object2).iterator();
                    while (object.hasNext() && (string4 = (String)object.next()) != null) {
                        MyTreeNode myTreeNode3 = new MyTreeNode(string4);
                        myTreeNode3.setFileType(FILE_TYPE.FILEGREEN);
                        string = this.currentTreeNode.getFilename();
                        myTreeNode3.setFileName(string + File.separator + string4);
                        this.currentTreeNode.add((MutableTreeNode)((Object)myTreeNode3));
                    }
                }
                this.clearControls();
                if (this.ctreeFile.isIndex() && this.indexMember == 0) {
                    int n = this.ctreeFile.getNumberOfIndexMembers();
                    if (n > 0) {
                        this.currentTreeNode.setFileType(FILE_TYPE.SINDEXGREEN);
                        object3 = this.currentTreeNode.getFilename();
                        for (int i = 1; i <= n; ++i) {
                            object = "Member #" + i;
                            MyTreeNode myTreeNode4 = new MyTreeNode((String)object);
                            myTreeNode4.setFileType(FILE_TYPE.INDEXGREEN);
                            myTreeNode4.setFileName((String)object3 + File.separator + (String)object);
                            this.currentTreeNode.add((MutableTreeNode)((Object)myTreeNode4));
                        }
                    } else {
                        this.currentTreeNode.setFileType(FILE_TYPE.INDEXGREEN);
                    }
                }
                if (!this.ctreeFile.isIndex() && !this.ctreeFile.isSuperfileHost()) {
                    this.ctreeFile.getIfil();
                    this.ctreeFile.getDodaArray();
                }
                object3 = (DrCtreeView)DrCtreeApp.getApplication().getMainView();
                ((DrCtreeView)object3).infoTable.fill(this.ctreeFile);
                ((DrCtreeView)object3).headerTable.fill(this.ctreeFile, this.indexMember);
                ((DrCtreeView)object3).xcreBlkTable.fill(this.ctreeFile, this.indexMember);
                ((DrCtreeView)object3).resourcesTree.fill(this.ctreeFile, this.indexMember);
                ((DrCtreeView)object3).statusMessageLabel2.setText("Current File = " + string2);
                ((DrCtreeView)object3).ifilTree.clear();
                ((DrCtreeView)object3).ifilTable.clearTable();
                ((DrCtreeView)object3).isegTable.clearTable();
                ((DrCtreeView)object3).datobjTable.clearTable();
                if ((this.ctreeFile.isIndex() || this.isOpenWithResources() || this.isInternalIndex) && this.isOpenWithResources()) {
                    this.indexMember = 1;
                }
                if (!this.ctreeFile.isIndex() && !this.ctreeFile.isSuperfileHost()) {
                    ((DrCtreeView)object3).ifilTree.refreshIfilPane(this.ctreeFile);
                    ((DrCtreeView)object3).datobjTable.fill(this.ctreeFile);
                    ((DrCtreeView)object3).convMapTable.fill(this.ctreeFile);
                    ((DrCtreeView)object3).recordsTable.fill(this.ctreeFile);
                }
                if (this.isOpenWithResources()) {
                    this.ctreeFile.closeFileWithResource();
                } else {
                    this.ctreeFile.closeFile();
                }
            }
            catch (JCtree.CtreeException ctreeException) {
                if (this.isOpenWithResources()) {
                    Globals.showException(ctreeException, "Try to open in \"Open Without Resources\" mode\n\n", "Error");
                } else {
                    Globals.showException(ctreeException, "Error");
                }
                switch (this.currentTreeNode.getFileType()) {
                    case FILE: 
                    case FILERED: 
                    case FILEYELLOW: {
                        this.currentTreeNode.setFileType(FILE_TYPE.FILERED);
                    }
                }
                this.ctreeFile = this.oldCtreeFile;
                this.currentTreeNode = myTreeNode2;
                if (this.currentTreeNode == null) break block35;
                this.setSelectionPath(new TreePath(this.currentTreeNode.getPath()));
            }
        }
        this.setNavigationControls(false);
    }

    private void setNavigationControls(boolean bl) {
        DrCtreeView drCtreeView = (DrCtreeView)DrCtreeApp.getApplication().getMainView();
        if (bl || this.ctreeFile != null && this.ctreeFile.isIndex()) {
            drCtreeView.firstRecBT.setEnabled(false);
            drCtreeView.prevRecBT.setEnabled(false);
            drCtreeView.nextRecBT.setEnabled(false);
            drCtreeView.lastRecBT.setEnabled(false);
            drCtreeView.addRecBT.setEnabled(false);
            drCtreeView.removeRecBT.setEnabled(false);
            drCtreeView.currentRecTF.setEnabled(false);
        } else {
            drCtreeView.firstRecBT.setEnabled(true);
            drCtreeView.nextRecBT.setEnabled(true);
            if (Globals.allowUpdates) {
                drCtreeView.addRecBT.setEnabled(true);
                drCtreeView.removeRecBT.setEnabled(true);
            }
            if (this.isOpenWithResources() && this.recordIndex > 0) {
                drCtreeView.prevRecBT.setEnabled(true);
                drCtreeView.lastRecBT.setEnabled(true);
                drCtreeView.currentRecTF.setEnabled(true);
            } else {
                drCtreeView.prevRecBT.setEnabled(false);
                drCtreeView.lastRecBT.setEnabled(false);
                drCtreeView.currentRecTF.setEnabled(false);
            }
        }
        long l = 0L;
        if (!bl && this.ctreeFile != null) {
            l = this.ctreeFile.isVariableLength() ? (this.isOpenWithResources() ? this.ctreeFile.getNumberOfKeyEntries().longValue() : this.ctreeFile.getNumberOfRecords().longValue()) : this.ctreeFile.getNumberOfRecords();
        }
        drCtreeView.totalRecTF.setText("of {" + l + "}");
    }

    private void clearControls() {
        DrCtreeView drCtreeView = (DrCtreeView)DrCtreeApp.getApplication().getMainView();
        drCtreeView.infoTable.clearTable();
        drCtreeView.headerTable.clearTable();
        drCtreeView.xcreBlkTable.clearTable();
        drCtreeView.convMapTable.clearTable();
        drCtreeView.recordsTable.clearTable();
    }

    void refreshNode(MyTreeNode myTreeNode) {
    }

    public void fillTree() {
        this.clear();
        for (File file : File.listRoots()) {
            String string = file.getPath();
            MyTreeNode myTreeNode = new MyTreeNode(string);
            myTreeNode.setFileName(string);
            myTreeNode.setFileType(FILE_TYPE.HARDDISK);
            MyTreeNode myTreeNode2 = (MyTreeNode)this.addObject(myTreeNode);
            File[] fileArray = file.listFiles();
            if (fileArray == null) continue;
            MyTreeNode myTreeNode3 = new MyTreeNode("");
            this.addObject(myTreeNode2, myTreeNode3);
        }
    }

    public void setFileFilter(String string) {
        this.filters = string.split(";");
    }

    private void expandDirectory(MyTreeNode myTreeNode, File file) {
        myTreeNode.removeAllChildren();
        boolean bl = true;
        do {
            bl = !bl;
            File[] fileArray = file.listFiles(new MyFileFilter(bl));
            Arrays.sort(fileArray, sortByName);
            if (fileArray == null) continue;
            for (File file2 : fileArray) {
                if (file2.isHidden() && !this.showHiddenDirs || !this.isFileInFilter(file2)) continue;
                MyTreeNode myTreeNode2 = new MyTreeNode(file2.getName());
                myTreeNode2.setFileType(FILE_TYPE.CLSDIR);
                myTreeNode2.setFileName(file2.getAbsolutePath());
                if (file2.isDirectory()) {
                    if (!file2.canRead()) {
                        myTreeNode2.setFileType(FILE_TYPE.CLSDIRRED);
                    } else {
                        myTreeNode2.setFileType(FILE_TYPE.CLSDIR);
                    }
                } else if (file2.isFile()) {
                    myTreeNode2.setFileType(FILE_TYPE.FILE);
                    this.setNodeColor(myTreeNode2);
                }
                File[] fileArray2 = file2.listFiles();
                if (fileArray2 != null && fileArray2.length > 0) {
                    MyTreeNode myTreeNode3 = new MyTreeNode("");
                    this.addObject(myTreeNode2, myTreeNode3);
                }
                this.addObject(myTreeNode, myTreeNode2);
            }
        } while (!bl);
        this.myTreeModel.reload((TreeNode)((Object)myTreeNode));
    }

    private void getExpandedNodes() {
        this.expandedNodes.clear();
        FcTreeNode fcTreeNode = (FcTreeNode)this.getModel().getRoot();
        if (fcTreeNode.getChildCount() >= 0) {
            Enumeration enumeration = fcTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode = (MyTreeNode)((Object)enumeration.nextElement());
                if (myTreeNode.isExpanded()) {
                    this.expandedNodes.add(myTreeNode.getFilename());
                }
                this._getExpandedNodes(myTreeNode);
            }
        }
    }

    private void _getExpandedNodes(MyTreeNode myTreeNode) {
        if (myTreeNode.getChildCount() >= 0) {
            Enumeration enumeration = myTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode2 = (MyTreeNode)((Object)enumeration.nextElement());
                if (myTreeNode2.isExpanded()) {
                    this.expandedNodes.add(myTreeNode2.getFilename());
                }
                this._getExpandedNodes(myTreeNode2);
            }
        }
    }

    private void expandSavedNodes() {
        FcTreeNode fcTreeNode = (FcTreeNode)this.getModel().getRoot();
        if (fcTreeNode.getChildCount() >= 0) {
            Enumeration enumeration = fcTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode = (MyTreeNode)((Object)enumeration.nextElement());
                if (this.expandedNodes.contains(myTreeNode.getFilename())) {
                    this.expandNode((DefaultMutableTreeNode)((Object)myTreeNode));
                }
                this._expandSavedNodes(myTreeNode);
            }
        }
    }

    private void _expandSavedNodes(MyTreeNode myTreeNode) {
        if (myTreeNode.getChildCount() >= 0) {
            Enumeration enumeration = myTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode2 = (MyTreeNode)((Object)enumeration.nextElement());
                if (!this.expandedNodes.contains(myTreeNode2.getFilename())) continue;
                this.expandNode((DefaultMutableTreeNode)((Object)myTreeNode2));
                this._expandSavedNodes(myTreeNode2);
            }
        }
    }

    public void setShowHiddenDirs(boolean bl) {
        this.showHiddenDirs = bl;
    }

    void setPath(String string) {
        this.tempPath = string;
    }

    public CtreeSession getSession() {
        return this.mySession;
    }

    public void selectFile(String string) {
        if (string != null) {
            Globals.ShowWaitCursor();
            this.pathLevel = 0;
            FcTreeNode fcTreeNode = (FcTreeNode)this.getModel().getRoot();
            MyTreeNode myTreeNode = this.selectFile(fcTreeNode, string.toLowerCase());
            if (myTreeNode != null) {
                TreePath treePath = new TreePath(myTreeNode.getPath());
                this.setSelectionPath(treePath);
                this.scrollPathToVisible(treePath);
            }
            Globals.ShowNormalCursor();
        }
    }

    private MyTreeNode selectFile(FcTreeNode fcTreeNode, String string) {
        String string2 = File.separator;
        String[] stringArray = string.split(string2 + string2);
        String string3 = "";
        int n = 0;
        do {
            if (n > 0) {
                string3 = string3 + File.separator;
            }
            string3 = string3 + stringArray[n].toLowerCase();
        } while (++n <= this.pathLevel);
        if (fcTreeNode.getChildCount() >= 0) {
            Enumeration enumeration = fcTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode = (MyTreeNode)((Object)enumeration.nextElement());
                String string4 = myTreeNode.getFilename().toLowerCase();
                if (string4.endsWith(File.separator)) {
                    string4 = string4.substring(0, string4.length() - 1);
                }
                if (string4 == null) continue;
                if (string4.equals(string)) {
                    return myTreeNode;
                }
                if (!string4.equals(string3)) continue;
                ++this.pathLevel;
                this.expandNode((DefaultMutableTreeNode)((Object)myTreeNode));
                if (myTreeNode.getChildCount() <= 0 || (myTreeNode = this.selectFile(myTreeNode, string)) == null) continue;
                return myTreeNode;
            }
        }
        return null;
    }

    public Enums.FILE_MODE getOpenMode() {
        return this.openMode;
    }

    public void setOpenMode(Enums.FILE_MODE fILE_MODE) {
        this.openMode = fILE_MODE;
    }

    public boolean isOpenWithResources() {
        return this.openWithResources;
    }

    public void setOpenWithResources(boolean bl) {
        this.openWithResources = bl;
    }

    void setNodesColor(boolean bl) {
        this.setOpenWithResources(bl);
        FcTreeNode fcTreeNode = (FcTreeNode)this.getModel().getRoot();
        this._setNodesColor(fcTreeNode);
        this.repaint();
    }

    private void _setNodesColor(FcTreeNode fcTreeNode) {
        if (fcTreeNode.getChildCount() >= 0) {
            Enumeration enumeration = fcTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode = (MyTreeNode)((Object)enumeration.nextElement());
                if (myTreeNode.getFileType() != null && myTreeNode.getFileType().ordinal() > FILE_TYPE.CLSDIRRED.ordinal()) {
                    this.setNodeColor(myTreeNode);
                }
                this._setNodesColor(myTreeNode);
            }
        }
    }

    private void setNodeColor(MyTreeNode myTreeNode) {
        FILE_TYPE fILE_TYPE = myTreeNode.getFileType();
        if (this.isOpenWithResources()) {
            if (fILE_TYPE.ordinal() >= FILE_TYPE.SPRFILE.ordinal() && fILE_TYPE.ordinal() <= FILE_TYPE.SPRFILEYELLOW.ordinal()) {
                myTreeNode.setFileType(FILE_TYPE.SPRFILERED);
            } else if (fILE_TYPE.ordinal() >= FILE_TYPE.SINDEX.ordinal() && fILE_TYPE.ordinal() <= FILE_TYPE.SINDEXYELLOW.ordinal()) {
                myTreeNode.setFileType(FILE_TYPE.SINDEXRED);
            } else if (myTreeNode.getFilename().toLowerCase().endsWith(".dat")) {
                myTreeNode.setFileType(FILE_TYPE.FILEGREEN);
            } else if (myTreeNode.getFilename().toLowerCase().endsWith(".idx") || myTreeNode.getFilename().toLowerCase().startsWith("Member #")) {
                myTreeNode.setFileType(FILE_TYPE.INDEXRED);
            } else {
                myTreeNode.setFileType(FILE_TYPE.FILEYELLOW);
            }
        } else if (fILE_TYPE.ordinal() >= FILE_TYPE.SPRFILE.ordinal() && fILE_TYPE.ordinal() <= FILE_TYPE.SPRFILEYELLOW.ordinal()) {
            myTreeNode.setFileType(FILE_TYPE.SPRFILEGREEN);
        } else if (fILE_TYPE.ordinal() >= FILE_TYPE.SINDEX.ordinal() && fILE_TYPE.ordinal() <= FILE_TYPE.SINDEXYELLOW.ordinal()) {
            myTreeNode.setFileType(FILE_TYPE.SINDEXGREEN);
        } else if (myTreeNode.getFilename().toLowerCase().endsWith(".dat")) {
            myTreeNode.setFileType(FILE_TYPE.FILEGREEN);
        } else if (myTreeNode.getFilename().toLowerCase().endsWith(".idx") || myTreeNode.getFilename().toLowerCase().startsWith("Member #")) {
            myTreeNode.setFileType(FILE_TYPE.INDEXGREEN);
        } else {
            myTreeNode.setFileType(FILE_TYPE.FILEYELLOW);
        }
    }

    private boolean isFileInFilter(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.filters == null) {
            return true;
        }
        String string = file.getPath().toLowerCase();
        for (String string2 : this.filters) {
            if (string2.equals("*")) {
                return true;
            }
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    class myTreeExpansionListener
    implements TreeExpansionListener {
        myTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            int n = treePath.getPathCount();
            if (n > 1) {
                Object[] objectArray = treePath.getPath();
                MyTreeNode myTreeNode = (MyTreeNode)((Object)objectArray[n - 1]);
                FilesTree.this.setSelectionPath(new TreePath((Object)myTreeNode));
                if (myTreeNode.getFileType().ordinal() <= FILE_TYPE.CLSDIR.ordinal()) {
                    myTreeNode.setExpanded(true);
                    File file = new File(myTreeNode.getFilename());
                    FilesTree.this.expandDirectory(myTreeNode, file);
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            int n = treePath.getPathCount();
            if (n > 1) {
                Object[] objectArray = treePath.getPath();
                MyTreeNode myTreeNode = (MyTreeNode)((Object)objectArray[n - 1]);
                myTreeNode.setExpanded(false);
            }
        }
    }

    public static enum FILE_TYPE {
        HARDDISK,
        CLSDIR,
        OPNDIR,
        CLSDIRRED,
        SPRFILE,
        SPRFILERED,
        SPRFILEGREEN,
        SPRFILEYELLOW,
        FILE,
        FILERED,
        FILEGREEN,
        FILEYELLOW,
        SINDEX,
        SINDEXRED,
        SINDEXGREEN,
        SINDEXYELLOW,
        INDEX,
        INDEXRED,
        INDEXGREEN,
        INDEXYELLOW;

    }

    public class MyFileFilter
    implements FileFilter {
        boolean listFiles = true;

        public MyFileFilter(boolean bl) {
            this.listFiles = bl;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory() && !this.listFiles) {
                return true;
            }
            return !file.isDirectory() && this.listFiles;
        }
    }
}

