/*
 * Decompiled with CFR 0.152.
 */
package drctree;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import Isam.CtreeFile;
import Isam.JCtree;
import Isam.Structures;
import drctree.HeaderDesc;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class HeaderTable
extends FcBaseDynamicTable {
    private HeaderTableModel tableModel;
    protected boolean inError;
    private HeaderDesc headerDesc = new HeaderDesc();

    public HeaderTable(boolean bl) {
        this.tableModel = new HeaderTableModel(this);
        this.setModel((TableModel)((Object)this.tableModel));
        this.tableModel.setupColumns();
        FcBaseTableModel.RowSorter rowSorter = this.tableModel.setRowSorter();
        rowSorter.setComparator(0, this.hexIntStringComparator);
        rowSorter.setComparator(3, this.hexIntStringComparator);
        rowSorter.setComparator(4, this.intStringComparator);
    }

    public HeaderTableModel getModel() {
        return this.tableModel;
    }

    void selectRow(String string) {
        this.tableModel.selecRow(string);
    }

    void fill(CtreeFile ctreeFile, int n) {
        this.clearTable();
        this.tableModel.fill(ctreeFile, n);
    }

    public class HeaderTableModel
    extends FcBaseTableModel {
        HeaderTableModel(HeaderTable headerTable2) {
            super((FcBaseDynamicTable)headerTable2, true);
            this.table = headerTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Offset", "Element", "Description", "Hex. Value", "Dec. Value", "Type"};
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(50);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(80);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(250);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(80);
            tableColumn = this.table.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(80);
            tableColumn = this.table.getColumnModel().getColumn(5);
            tableColumn.setPreferredWidth(50);
            this.autoSizeColumns.set(2, true);
            this.readOnlyColumns.set(0, true);
            this.readOnlyColumns.set(1, true);
            this.readOnlyColumns.set(2, true);
            this.readOnlyColumns.set(5, true);
        }

        private void fill(CtreeFile ctreeFile, int n) {
            if (ctreeFile.isOpen()) {
                Structures.HEADER_STRUCT hEADER_STRUCT;
                try {
                    hEADER_STRUCT = ctreeFile.openedWithResources ? ctreeFile.getHeader(0) : ctreeFile.getHeader(n);
                }
                catch (JCtree.CtreeException ctreeException) {
                    return;
                }
                Class<?> clazz = hEADER_STRUCT.getClass();
                Field[] fieldArray = clazz.getFields();
                Integer n2 = 0;
                for (Field field : fieldArray) {
                    String string = field.getName();
                    Class<?> clazz2 = field.getType();
                    String string2 = clazz2.getName();
                    try {
                        Number number;
                        if (string2.equals("long")) {
                            number = field.getLong(hEADER_STRUCT);
                            this.addRow(n2, string, "", "0x" + String.format("%016X", number), ((Long)number).toString(), "Int64");
                            n2 = n2 + 8;
                            continue;
                        }
                        if (string2.equals("int")) {
                            number = field.getInt(hEADER_STRUCT);
                            this.addRow(n2, string, "", "0x" + String.format("%08X", number), ((Integer)number).toString(), "Int32");
                            n2 = n2 + 4;
                            continue;
                        }
                        if (string2.equals("short")) {
                            number = field.getShort(hEADER_STRUCT);
                            this.addRow(n2, string, "", "0x" + String.format("%04X", number), ((Short)number).toString(), "Int16");
                            n2 = n2 + 2;
                            continue;
                        }
                        if (!string2.equals("byte")) continue;
                        number = field.getByte(hEADER_STRUCT);
                        this.addRow(n2, string, "", "0x" + String.format("%02X", number), ((Byte)number).toString(), "Byte");
                        Integer n3 = n2;
                        Integer n4 = n2 = Integer.valueOf(n2 + 1);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Logger.getLogger(HeaderTable.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Logger.getLogger(HeaderTable.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                    }
                }
            }
            super.fireTableDataChanged();
        }

        public void addRow(Integer n, String string, String string2, String string3, String string4, String string5) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("0x" + String.format("%02X", n));
            arrayList.add(string);
            arrayList.add(HeaderTable.this.headerDesc.getDesc(string));
            arrayList.add(string3);
            arrayList.add(string4);
            arrayList.add(string5);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }

        private void selecRow(String string) {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                Integer n2 = (Integer)this.getValueAt(i, 0);
                if (!n2.toString().equals(string)) continue;
                i = this.table.convertRowIndexToView(i);
                this.table.setRowSelectionInterval(i, i);
                Rectangle rectangle = this.table.getCellRect(i, i, true);
                this.table.scrollRectToVisible(rectangle);
            }
        }
    }

    class PopupActions
    implements ActionListener {
        int mode;

        public PopupActions(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = HeaderTable.this.getSelectedRows();
        }
    }

    public class TTMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
            HeaderTable.this.showTooltip = false;
        }
    }
}

