/*
 * Decompiled with CFR 0.152.
 */
package drctree;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import Isam.CtreeFile;
import Isam.Enums;
import Isam.Structures;
import drctree.HeaderDesc;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class IfilTable
extends FcBaseDynamicTable {
    private IfilTableModel tableModel;
    protected boolean inError;
    private HeaderDesc headerDesc = new HeaderDesc();

    public IfilTable(boolean bl) {
        this.tableModel = new IfilTableModel(this);
        this.setModel((TableModel)((Object)this.tableModel));
        this.tableModel.setupColumns();
    }

    public IfilTableModel getModel() {
        return this.tableModel;
    }

    void selectRow(String string) {
        this.tableModel.selecRow(string);
    }

    void fill(CtreeFile ctreeFile, int n) {
        this.clearTable();
        this.tableModel.fill(ctreeFile, n);
    }

    public class IfilTableModel
    extends FcBaseTableModel {
        IfilTableModel(IfilTable ifilTable2) {
            super((FcBaseDynamicTable)ifilTable2, true);
            this.table = ifilTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Element", "Description", "Value", "Type"};
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(60);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(120);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(100);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(60);
            this.autoSizeColumns.set(2, true);
            this.readOnlyColumns.set(0, true);
            this.readOnlyColumns.set(1, true);
            this.readOnlyColumns.set(3, true);
        }

        private void fill(CtreeFile ctreeFile, int n) {
            Structures.IFIL_STRUCT iFIL_STRUCT = ctreeFile.getIfil();
            if (n == 0) {
                this.addRow("pfilnam", "Data File Name", iFIL_STRUCT.pfilnam, "pTEXT");
                this.addRow("dfilno", "Data File Number", iFIL_STRUCT.dfilno, "COUNT");
                this.addRow("dreclen", "Data Record Length", iFIL_STRUCT.dreclen, "UCOUNT");
                this.addRow("dxtdsiz", "Data Extension Size", iFIL_STRUCT.dxtdsiz, "UCOUNT");
                String string = Enums.FILE_MODE.decodeMode((int)iFIL_STRUCT.dfilmod);
                this.addRow("dfilmod", "Data File Mode", "(0x" + Integer.toHexString(iFIL_STRUCT.dfilmod) + ") " + string, "COUNT");
                this.addRow("dnumidx", "Number of Indices", iFIL_STRUCT.dnumidx, "COUNT");
                this.addRow("ixtdsiz", "Index File Ext Size", iFIL_STRUCT.ixtdsiz, "UCOUNT");
                string = Enums.FILE_MODE.decodeMode((int)iFIL_STRUCT.ifilmod);
                this.addRow("ifilmod", "Index File Mode", "(0x" + Integer.toHexString(iFIL_STRUCT.ifilmod) + ") " + string, "COUNT");
                this.addRow("rfstfld", "r-tree 1st Fld Name", iFIL_STRUCT.rfstfld, "pTEXT");
                this.addRow("rlstfld", "r-tree Last Fld Name", iFIL_STRUCT.rlstfld, "pTEXT");
                this.addRow("tfilno", "Temporary File Number", iFIL_STRUCT.tfilno, "COUNT");
            } else {
                Structures.IIDX_STRUCT iIDX_STRUCT = (Structures.IIDX_STRUCT)iFIL_STRUCT.ix.get(n - 1);
                this.addRow("ikeylen", "Key Length", iIDX_STRUCT.ikeylen, "COUNT");
                String string = Enums.KEY_TYPE.decodeMode((int)iIDX_STRUCT.ikeytyp);
                this.addRow("ikeytyp", "Key Type", "(0x" + Integer.toHexString(iIDX_STRUCT.ikeytyp) + ") " + string, "COUNT");
                String string2 = "";
                switch (iIDX_STRUCT.ikeydup) {
                    case 0: {
                        string2 = "No Duplicates";
                        break;
                    }
                    case 1: {
                        string2 = "Duplicates Allowed";
                        break;
                    }
                    case 2: {
                        string2 = "No Dupe Within Partitions";
                        break;
                    }
                    case 5: {
                        string2 = "Dupe & Distinct Keys";
                    }
                }
                this.addRow("ikeydup", "Duplicate Flag", "(" + iIDX_STRUCT.ikeydup + ") " + string2, "COUNT");
                this.addRow("inulkey", "Null Key Flag", iIDX_STRUCT.inulkey, "COUNT");
                this.addRow("iempchr", "Empty Character", iIDX_STRUCT.iempchr, "COUNT");
                this.addRow("inumseg", "Number of Segments", iIDX_STRUCT.inumseg, "COUNT");
                this.addRow("ridxnam", "r-tree Symbolic Name", iIDX_STRUCT.ridxnam, "pTEXT");
                this.addRow("aidxnam", "Alternate Index Name", iIDX_STRUCT.aidxnam, "pTEXT");
                if (iIDX_STRUCT.altseq != 0L) {
                    this.addRow("altseq", "Alternate Collating Seq.", (int)iIDX_STRUCT.altseq, "pCOUNT");
                } else {
                    this.addRow("altseq", "Alternate Collating Seq.", "(none)", "pCOUNT");
                }
                this.addRow("pvbyte", "Alternate Pad Byte", iIDX_STRUCT.pvbyte, "pUTEXT");
            }
            super.fireTableDataChanged();
        }

        public void addRow(String string, String string2, String string3, String string4) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }

        public void addRow(String string, String string2, int n, String string3) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(n);
            arrayList.add(string3);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }

        private void selecRow(String string) {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                Integer n2 = (Integer)this.getValueAt(i, 0);
                if (!n2.toString().equals(string)) continue;
                i = this.table.convertRowIndexToView(i);
                this.table.setRowSelectionInterval(i, i);
                Rectangle rectangle = this.table.getCellRect(i, i, true);
                this.table.scrollRectToVisible(rectangle);
            }
        }
    }

    class PopupActions
    implements ActionListener {
        int mode;

        public PopupActions(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = IfilTable.this.getSelectedRows();
        }
    }

    public class TTMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
            IfilTable.this.showTooltip = false;
        }
    }
}

