/*
 * Decompiled with CFR 0.152.
 */
package drctree;

import FairCom.Helper.Classes.FcDynamicTree;
import FairCom.Helper.Classes.FcTreeNode;
import Isam.CtreeFile;
import Isam.Structures;
import drctree.DrCtreeApp;
import drctree.DrCtreeView;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class IfilTree
extends FcDynamicTree {
    private FcTreeNode currentIfilNode;
    private CtreeFile ctreeFile;

    void refreshIfilPane(CtreeFile ctreeFile) {
        this.refreshIfilPane(ctreeFile, 0);
    }

    void refreshIfilPane(CtreeFile ctreeFile, int n) {
        this.ctreeFile = ctreeFile;
        int n2 = 0;
        this.clear();
        Structures.IFIL_STRUCT iFIL_STRUCT = ctreeFile.getIfil();
        if (iFIL_STRUCT.isValid) {
            FcTreeNode fcTreeNode = new FcTreeNode("IFIL");
            this.addObject(fcTreeNode);
            DrCtreeView drCtreeView = (DrCtreeView)DrCtreeApp.getApplication().getMainView();
            drCtreeView.indexCBClearing = true;
            int n3 = drCtreeView.indexCB.getSelectedIndex();
            drCtreeView.indexCB.removeAllItems();
            drCtreeView.indexCB.addItem("None (Data File Order)");
            if (iFIL_STRUCT.dnumidx > 0) {
                for (Structures.IIDX_STRUCT iIDX_STRUCT : iFIL_STRUCT.ix) {
                    FcTreeNode fcTreeNode2 = new FcTreeNode("IIDX[" + n2 + "]");
                    fcTreeNode2.setNodeId(n2 + 1);
                    this.addObject(fcTreeNode, fcTreeNode2);
                    if (ctreeFile.openedWithResources) {
                        if (iIDX_STRUCT.ridxnam != null && iIDX_STRUCT.ridxnam.length() > 0) {
                            drCtreeView.indexCB.addItem(iIDX_STRUCT.ridxnam);
                        } else {
                            drCtreeView.indexCB.addItem("Index # " + n2);
                        }
                    }
                    ++n2;
                }
                this.setSelectionPath(new TreePath(fcTreeNode.getPath()));
                this.expandNode((DefaultMutableTreeNode)fcTreeNode);
            }
            if (n3 < drCtreeView.indexCB.getItemCount()) {
                drCtreeView.indexCB.setSelectedIndex(n3);
            }
            drCtreeView.indexCBClearing = false;
        }
        this.repaint();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        FcTreeNode fcTreeNode = (FcTreeNode)this.getLastSelectedPathComponent();
        if (fcTreeNode != null) {
            int n = fcTreeNode.getLevel();
            if (n < 1 || fcTreeNode == null) {
                return;
            }
            if (this.currentIfilNode == fcTreeNode) {
                return;
            }
            this.currentIfilNode = fcTreeNode;
            this.refreshIfilView();
        }
    }

    private void refreshIfilView() {
        DrCtreeView drCtreeView = (DrCtreeView)DrCtreeApp.getApplication().getMainView();
        String string = this.currentIfilNode.getText();
        drCtreeView.isegTable.clearTable();
        if (string.equals("IFIL")) {
            drCtreeView.ifilTable.fill(this.ctreeFile, 0);
        } else if (string.startsWith("IIDX")) {
            drCtreeView.ifilTable.fill(this.ctreeFile, this.currentIfilNode.getNodeId());
            drCtreeView.isegTable.fill(this.ctreeFile, this.currentIfilNode.getNodeId());
        }
    }
}

