/*
 * Decompiled with CFR 0.152.
 */
package drctree;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import Isam.CtreeFile;
import Isam.Enums;
import Isam.JCtree;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class InfoTable
extends FcBaseDynamicTable {
    private InfoTableModel tableModel = new InfoTableModel(this);
    protected boolean inError;

    public InfoTable(boolean bl) {
        this.setModel((TableModel)((Object)this.tableModel));
        this.tableModel.setupColumns();
    }

    public InfoTableModel getModel() {
        return this.tableModel;
    }

    void selectRow(String string) {
        this.tableModel.selecRow(string);
    }

    void fill(CtreeFile ctreeFile) {
        this.clearTable();
        this.tableModel.fill(ctreeFile);
    }

    public class InfoTableModel
    extends FcBaseTableModel {
        InfoTableModel(InfoTable infoTable2) {
            super((FcBaseDynamicTable)infoTable2, true);
            this.table = infoTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"#", "Description", "Value"};
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(30);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(280);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(280);
            this.autoSizeColumns.set(2, true);
            this.readOnlyColumns.set(0, true);
            this.readOnlyColumns.set(1, true);
        }

        private void fill(CtreeFile ctreeFile) {
            String string = "";
            if (ctreeFile.isOpen()) {
                try {
                    string = ctreeFile.getSymbolicNames(Enums.GETNAM_MODE.FILNAM);
                }
                catch (JCtree.CtreeException ctreeException) {
                    string = ctreeFile.getFileName();
                }
                int n = 1;
                this.addRow(n++, "File Name", string);
                String string2 = "";
                long l = 0L;
                String string3 = "";
                switch (ctreeFile.getFileType()) {
                    case DATA_FILE: {
                        string2 = "data file";
                        l = ctreeFile.getRecordLength();
                        string3 = "Record Length";
                        if (!ctreeFile.isSuperfileHost()) break;
                        string2 = string2 + " (superfile)";
                        break;
                    }
                    case INDX_FILE: {
                        string2 = "index file";
                        l = ctreeFile.getNodeSize();
                        string3 = "Node Size";
                        break;
                    }
                    case VDAT_FILE: {
                        string2 = "variable-length data file";
                        l = ctreeFile.getRecordLength();
                        string3 = "Record Length";
                        if (!ctreeFile.isSuperfileHost()) break;
                        string2 = string2 + " (superfile)";
                        break;
                    }
                    case UNKNOW: {
                        string2 = "unknown file type";
                    }
                }
                this.addRow(n++, "File Type", string2);
                this.addRow(n++, string3, l + " bytes");
                this.addRow(n++, "Logical File Size", ctreeFile.getLogicalFileSize().toString() + " bytes");
                this.addRow(n++, "Physical File Size", ctreeFile.getPhysicalFileSize().toString() + " bytes");
                Integer n2 = ctreeFile.getFileMode() & ~ctreeFile.getOpenedMode();
                String string4 = Enums.FILE_MODE_DISPLAY.decodeMode((int)n2);
                if ((n2 & Enums.FILE_MODE_DISPLAY.VLENGTH.value) != Enums.FILE_MODE_DISPLAY.VLENGTH.value) {
                    string4 = string4 + ", FIXED";
                }
                this.addRow(n++, "File Mode", "(0x" + Integer.toHexString(n2) + ") " + string4);
                int n3 = ctreeFile.getFileAlignment();
                String string5 = "";
                switch (n3) {
                    case 1: {
                        string5 = "byte";
                        break;
                    }
                    case 2: {
                        string5 = "word";
                        break;
                    }
                    case 3: {
                        string5 = "double word";
                        break;
                    }
                    case 8: {
                        string5 = "quad word";
                    }
                }
                this.addRow(n++, "File Alignment", string5);
                switch (ctreeFile.getFileType()) {
                    case DATA_FILE: {
                        this.addRow(n++, "Number of Records", ctreeFile.getNumberOfRecords().toString());
                        break;
                    }
                    case VDAT_FILE: {
                        if (ctreeFile.openedWithResources && ctreeFile.getNumberOfIndices() > 0) {
                            this.addRow(n++, "Number of Keys (First Index)", ctreeFile.getNumberOfKeyEntries().toString());
                            break;
                        }
                        this.addRow(n++, "Number of Records", "Unknown - Use \"Count Records\" menu option");
                        break;
                    }
                    case INDX_FILE: {
                        this.addRow(n++, "Number of Members", ctreeFile.getNumberOfIndexMembers().toString());
                        this.addRow(n++, "Number of Keys", ctreeFile.getNumberOfKeyEntries().toString());
                    }
                }
                super.fireTableDataChanged();
            }
        }

        public void addRow(int n, String string, String string2) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(n);
            arrayList.add(string);
            arrayList.add(string2);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }

        private void selecRow(String string) {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                Integer n2 = (Integer)this.getValueAt(i, 0);
                if (!n2.toString().equals(string)) continue;
                i = this.table.convertRowIndexToView(i);
                this.table.setRowSelectionInterval(i, i);
                Rectangle rectangle = this.table.getCellRect(i, i, true);
                this.table.scrollRectToVisible(rectangle);
            }
        }
    }

    class PopupActions
    implements ActionListener {
        int mode;

        public PopupActions(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = InfoTable.this.getSelectedRows();
        }
    }

    public class TTMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
            InfoTable.this.showTooltip = false;
        }
    }
}

