/*
 * Decompiled with CFR 0.152.
 */
package drctree;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import Isam.CtreeFile;
import Isam.Enums;
import Isam.Structures;
import drctree.HeaderDesc;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class IsegTable
extends FcBaseDynamicTable {
    private IsegTableModel tableModel;
    protected boolean inError;
    private HeaderDesc headerDesc = new HeaderDesc();

    public IsegTable(boolean bl) {
        this.tableModel = new IsegTableModel(this);
        this.setModel((TableModel)((Object)this.tableModel));
        this.tableModel.setupColumns();
    }

    public IsegTableModel getModel() {
        return this.tableModel;
    }

    void selectRow(String string) {
        this.tableModel.selecRow(string);
    }

    void fill(CtreeFile ctreeFile, int n) {
        this.clearTable();
        this.tableModel.fill(ctreeFile, n);
    }

    public class IsegTableModel
    extends FcBaseTableModel {
        IsegTableModel(IsegTable isegTable2) {
            super((FcBaseDynamicTable)isegTable2, true);
            this.table = isegTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"#", "soffset", "slength", "segmode", "Table Field"};
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(30);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(60);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(60);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(160);
            tableColumn = this.table.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(160);
            this.autoSizeColumns.set(3, true);
            this.readOnlyColumns.set(0, true);
            this.readOnlyColumns.set(4, true);
        }

        private void fill(CtreeFile ctreeFile, int n) {
            Structures.IFIL_STRUCT iFIL_STRUCT = ctreeFile.getIfil();
            Structures.IIDX_STRUCT iIDX_STRUCT = (Structures.IIDX_STRUCT)iFIL_STRUCT.ix.get(n - 1);
            ArrayList arrayList = iIDX_STRUCT.seg;
            int n2 = 0;
            for (Structures.ISEG_STRUCT iSEG_STRUCT : arrayList) {
                int n3 = iSEG_STRUCT.segmode;
                String string = "";
                ArrayList arrayList2 = ctreeFile.getDodaArray();
                if (arrayList2 != null && n3 >= Enums.SEG_MODE.SCHSEG.value && n3 <= Enums.SEG_MODE.UVSCHSEG.value && iSEG_STRUCT.soffset < arrayList2.size()) {
                    string = ((Structures.DATOBJ_STRUCT)arrayList2.get((int)iSEG_STRUCT.soffset)).fsymb;
                }
                String string2 = "";
                boolean bl = false;
                if ((n3 & Enums.SEG_MODE.ALTSEG.value) == Enums.SEG_MODE.ALTSEG.value) {
                    string2 = string2 + "ALTSEG / ";
                }
                if ((n3 & Enums.SEG_MODE.ENDSEG.value) == Enums.SEG_MODE.ENDSEG.value) {
                    string2 = string2 + "ENDSEG / ";
                }
                if ((n3 & Enums.SEG_MODE.UNCSEG.value) == Enums.SEG_MODE.UNCSEG.value) {
                    string2 = string2 + "UNCSEG / ";
                }
                if ((n3 & Enums.SEG_MODE.DSCSEG.value) == Enums.SEG_MODE.DSCSEG.value) {
                    string2 = string2 + "DSCSEG / ";
                }
                if ((n3 & Enums.SEG_MODE.RECBYT.value) == Enums.SEG_MODE.RECBYT.value) {
                    if ((n3 & Enums.SEG_MODE.SCHSRL.value) == Enums.SEG_MODE.SCHSRL.value) {
                        string2 = string2 + "SCHSRL / ";
                        n3 = 0;
                        bl = true;
                    } else {
                        string2 = string2 + "RECBYT / ";
                    }
                }
                if ((n3 & Enums.SEG_MODE.GNXSEG.value) == Enums.SEG_MODE.GNXSEG.value) {
                    string2 = string2 + "GNXSEG / ";
                }
                n3 = iSEG_STRUCT.segmode & 0xF;
                if (!bl) {
                    Enums.SEG_MODE sEG_MODE = Enums.SEG_MODE.setValue((int)n3);
                    string2 = string2 + sEG_MODE.toString();
                }
                this.addRow(n2, iSEG_STRUCT.soffset, iSEG_STRUCT.slength, "(0x" + Integer.toHexString(iSEG_STRUCT.segmode) + ") " + string2, string);
                ++n2;
            }
            super.fireTableDataChanged();
        }

        public void addRow(int n, int n2, int n3, String string, String string2) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(n);
            arrayList.add(n2);
            arrayList.add(n3);
            arrayList.add(string);
            arrayList.add(string2);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }

        private void selecRow(String string) {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                Integer n2 = (Integer)this.getValueAt(i, 0);
                if (!n2.toString().equals(string)) continue;
                i = this.table.convertRowIndexToView(i);
                this.table.setRowSelectionInterval(i, i);
                Rectangle rectangle = this.table.getCellRect(i, i, true);
                this.table.scrollRectToVisible(rectangle);
            }
        }
    }

    class PopupActions
    implements ActionListener {
        int mode;

        public PopupActions(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = IsegTable.this.getSelectedRows();
        }
    }

    public class TTMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
            IsegTable.this.showTooltip = false;
        }
    }
}

