/*
 * Decompiled with CFR 0.152.
 */
package drctree;

import FairCom.Helper.Classes.FcTreeNode;
import drctree.FilesTree;
import drctree.Globals;
import drctree.NodeTag;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class MyTreeNode
extends FcTreeNode {
    private NodeTag tag = new NodeTag();
    private ArrayList<ImageIcon> icons = new ArrayList();

    public MyTreeNode(String string) {
        super(string);
        if (this.icons.isEmpty()) {
            this.loadIcons();
        }
    }

    private void loadIcons() {
        this.icons.add(Globals.getIcon("HardDisk.png"));
        this.icons.add(Globals.getIcon("ClsdFold.png"));
        this.icons.add(Globals.getIcon("OpenFold.png"));
        this.icons.add(Globals.getIcon("ClsdFoldRed.png"));
        this.icons.add(Globals.getIcon("sFile.png"));
        this.icons.add(Globals.getIcon("sFileRed.png"));
        this.icons.add(Globals.getIcon("sFileGreen.png"));
        this.icons.add(Globals.getIcon("sFileYellow.png"));
        this.icons.add(Globals.getIcon("file.png"));
        this.icons.add(Globals.getIcon("fileRed.png"));
        this.icons.add(Globals.getIcon("fileGreen.png"));
        this.icons.add(Globals.getIcon("fileYellow.png"));
        this.icons.add(Globals.getIcon("sIndex.png"));
        this.icons.add(Globals.getIcon("sIndexRed.png"));
        this.icons.add(Globals.getIcon("sIndexGreen.png"));
        this.icons.add(Globals.getIcon("sIndexYellow.png"));
        this.icons.add(Globals.getIcon("index.png"));
        this.icons.add(Globals.getIcon("indexRed.png"));
        this.icons.add(Globals.getIcon("indexGreen.png"));
        this.icons.add(Globals.getIcon("indexYellow.png"));
    }

    public void setFileType(FilesTree.FILE_TYPE fILE_TYPE) {
        this.setCollapsedIcon(this.icons.get(fILE_TYPE.ordinal()));
        if (fILE_TYPE == FilesTree.FILE_TYPE.CLSDIR) {
            this.setExpandedIcon(this.icons.get(fILE_TYPE.ordinal() + 1));
        } else {
            this.setExpandedIcon(this.icons.get(fILE_TYPE.ordinal()));
        }
        this.tag.setFileType(fILE_TYPE);
    }

    public FilesTree.FILE_TYPE getFileType() {
        return this.tag.getFileType();
    }

    public String getFilename() {
        return this.tag.getFileName();
    }

    public boolean isExpanded() {
        return this.tag.isExpanded();
    }

    public void setExpanded(boolean bl) {
        this.tag.setExpanded(bl);
    }

    public void setFileName(String string) {
        this.tag.setFileName(string);
    }
}

