/*
 * Decompiled with CFR 0.152.
 */
package drctree;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.Editors.FcBooleanCellEditor;
import FairCom.Helper.Editors.FcDateTimeCellEditor;
import FairCom.Helper.Editors.FcNumberCellEditor;
import FairCom.Helper.Editors.FcTimeCellEditor;
import FairCom.Helper.Renderers.FcBlobCellRenderer;
import FairCom.Helper.Renderers.FcBooleanCellRenderer;
import FairCom.Helper.Renderers.FcDateCellRenderer;
import FairCom.Helper.Renderers.FcNumberCellRenderer;
import Isam.Converters;
import Isam.CtreeFile;
import Isam.Enums;
import Isam.JCtree;
import Isam.Structures;
import drctree.Globals;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class RecordsTable
extends FcBaseDynamicTable {
    private RecordsTableModel tableModel;
    protected boolean inError;
    FontMetrics metrics = this.getFontMetrics(this.getFont());
    int blockSize;
    boolean noMoreRecords;
    boolean forward;
    long currentFirst;
    boolean recordsRowChanged;
    long gotoRecordOffset;
    int gotoRecord;
    CtreeFile ctreeFile;

    public RecordsTable(boolean bl) {
        this.tableModel = new RecordsTableModel(this);
        this.setModel((TableModel)((Object)this.tableModel));
        TTMouseAdapter tTMouseAdapter = new TTMouseAdapter();
        this.addMouseMotionListener(tTMouseAdapter);
        FcNumberCellRenderer fcNumberCellRenderer = new FcNumberCellRenderer();
        FcDateCellRenderer fcDateCellRenderer = new FcDateCellRenderer();
        FcNumberCellEditor fcNumberCellEditor = new FcNumberCellEditor();
        FcDateTimeCellEditor fcDateTimeCellEditor = new FcDateTimeCellEditor();
        this.setDefaultRenderer(Boolean.class, (TableCellRenderer)new FcBooleanCellRenderer(true));
        this.setDefaultRenderer(Blob.class, (TableCellRenderer)new FcBlobCellRenderer());
        this.setDefaultRenderer(Byte.class, (TableCellRenderer)fcNumberCellRenderer);
        this.setDefaultRenderer(Short.class, (TableCellRenderer)fcNumberCellRenderer);
        this.setDefaultRenderer(Integer.class, (TableCellRenderer)fcNumberCellRenderer);
        this.setDefaultRenderer(Long.class, (TableCellRenderer)fcNumberCellRenderer);
        this.setDefaultRenderer(BigInteger.class, (TableCellRenderer)fcNumberCellRenderer);
        this.setDefaultRenderer(Double.class, (TableCellRenderer)fcNumberCellRenderer);
        this.setDefaultRenderer(Float.class, (TableCellRenderer)fcNumberCellRenderer);
        this.setDefaultRenderer(BigDecimal.class, (TableCellRenderer)fcNumberCellRenderer);
        this.setDefaultRenderer(Number.class, (TableCellRenderer)fcNumberCellRenderer);
        this.setDefaultRenderer(java.util.Date.class, (TableCellRenderer)fcDateCellRenderer);
        this.setDefaultRenderer(Time.class, (TableCellRenderer)fcDateCellRenderer);
        this.setDefaultRenderer(Timestamp.class, (TableCellRenderer)fcDateCellRenderer);
        this.setDefaultEditor(Boolean.class, (TableCellEditor)new FcBooleanCellEditor(true));
        this.setDefaultEditor(Byte.class, (TableCellEditor)fcNumberCellEditor);
        this.setDefaultEditor(Short.class, (TableCellEditor)fcNumberCellEditor);
        this.setDefaultEditor(Integer.class, (TableCellEditor)fcNumberCellEditor);
        this.setDefaultEditor(Long.class, (TableCellEditor)fcNumberCellEditor);
        this.setDefaultEditor(BigInteger.class, (TableCellEditor)fcNumberCellEditor);
        this.setDefaultEditor(Double.class, (TableCellEditor)fcNumberCellEditor);
        this.setDefaultEditor(Float.class, (TableCellEditor)fcNumberCellEditor);
        this.setDefaultEditor(BigDecimal.class, (TableCellEditor)fcNumberCellEditor);
        this.setDefaultEditor(java.util.Date.class, (TableCellEditor)fcDateTimeCellEditor);
        this.setDefaultEditor(Timestamp.class, (TableCellEditor)fcDateTimeCellEditor);
        this.setDefaultEditor(Time.class, (TableCellEditor)new FcTimeCellEditor());
    }

    public ImageIcon getCellIconAt(int n, int n2) {
        RecordTag recordTag = (RecordTag)this.tableModel.getTagAt(n, n2);
        if (recordTag != null) {
            return recordTag.cellIcon;
        }
        return null;
    }

    public RecordsTableModel getModel() {
        return this.tableModel;
    }

    void selectRow(String string) {
        this.tableModel.selecRow(string);
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 < 2) {
            return false;
        }
        return Globals.allowUpdates;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        int n = listSelectionModel.getMinSelectionIndex();
        if (this.previousRow == -1 && n == 0) {
            this.previousRow = 0;
        }
        if (!this.inError && this.previousRow >= 0 && !this.getModel().rowChanged(this.previousRow)) {
            this.inError = true;
            this.editCellAt(this.previousRow, 0);
            this.setRowSelectionInterval(this.previousRow, this.previousRow);
        } else {
            this.inError = false;
            int n2 = -1;
            if (n >= 0) {
                n2 = this.convertRowIndexToModel(n);
            }
            this.previousRow = n2;
        }
        if (n >= 0) {
            Object object = this.getValueAt(n, 0);
            Long l = (Long)this.getValueAt(n, 0);
            Globals.appFrame.currentRecTF.setText(l.toString());
        }
        super.valueChanged(listSelectionEvent);
    }

    void refresh(CtreeFile ctreeFile, MODE mODE) {
        Globals.ShowWaitCursor();
        this.ctreeFile = ctreeFile;
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
        this.tableModel.refresh(ctreeFile, mODE);
        Globals.ShowNormalCursor();
    }

    void fill(CtreeFile ctreeFile) {
        Globals.ShowWaitCursor();
        this.clearTable();
        this.ctreeFile = ctreeFile;
        this.tableModel.fill(ctreeFile);
        Globals.ShowNormalCursor();
    }

    class RecordTag {
        public Object data;
        public String tooltip;
        public ImageIcon cellIcon;

        RecordTag() {
        }
    }

    public class RecordsTableModel
    extends FcBaseTableModel {
        RecordsTableModel(RecordsTable recordsTable2) {
            super((FcBaseDynamicTable)recordsTable2, true);
            this.table = recordsTable2;
            this.showNullAsEmpty = true;
        }

        private void selecRow(String string) {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                Integer n2 = (Integer)this.getValueAt(i, 0);
                if (!n2.toString().equals(string)) continue;
                i = this.table.convertRowIndexToView(i);
                this.table.setRowSelectionInterval(i, i);
                Rectangle rectangle = this.table.getCellRect(i, i, true);
                this.table.scrollRectToVisible(rectangle);
            }
        }

        private void refresh(CtreeFile ctreeFile, MODE mODE) {
            if (!ctreeFile.isOpen()) {
                try {
                    if (ctreeFile.openedWithResources) {
                        ctreeFile.openFileWithResource(ctreeFile.openedMode);
                    } else {
                        ctreeFile.openFile(ctreeFile.openedMode);
                    }
                }
                catch (JCtree.CtreeException ctreeException) {
                    Globals.showException(ctreeException, "Opening ", "Error");
                }
            }
            switch (mODE) {
                case FIRST: {
                    RecordsTable.this.currentFirst = 1L;
                    RecordsTable.this.noMoreRecords = false;
                    RecordsTable.this.forward = true;
                    RecordsTable.this.recordsRowChanged = false;
                    break;
                }
                case NEXT: {
                    RecordsTable.this.currentFirst = 0L;
                    if (!RecordsTable.this.forward) {
                        RecordsTable.this.noMoreRecords = false;
                    }
                    RecordsTable.this.forward = true;
                    RecordsTable.this.recordsRowChanged = false;
                    break;
                }
                case PREVIOUS: {
                    RecordsTable.this.currentFirst = 0L;
                    if (RecordsTable.this.forward) {
                        RecordsTable.this.noMoreRecords = false;
                    }
                    RecordsTable.this.forward = false;
                    RecordsTable.this.recordsRowChanged = false;
                    break;
                }
                case LAST: {
                    RecordsTable.this.currentFirst = 1L;
                    RecordsTable.this.noMoreRecords = false;
                    RecordsTable.this.forward = false;
                    RecordsTable.this.recordsRowChanged = false;
                    break;
                }
                case GOTO: {
                    RecordsTable.this.noMoreRecords = false;
                    RecordsTable.this.forward = true;
                    byte[] byArray = new byte[128];
                    byte[] byArray2 = new byte[128];
                    RecordsTable.this.gotoRecord = (int)RecordsTable.this.gotoRecordOffset;
                    RecordsTable.this.gotoRecordOffset = ctreeFile.getORDKey(byArray, (long)RecordsTable.this.gotoRecord, byArray2);
                    break;
                }
                case ADD: {
                    RecordsTable.this.noMoreRecords = false;
                    RecordsTable.this.forward = true;
                    RecordsTable.this.currentFirst = 1L;
                    byte[] byArray = new byte[]{};
                    this.displayRow(ctreeFile, byArray, RecordsTable.this.currentFirst, false);
                    super.fireTableDataChanged();
                    break;
                }
                case REMOVE: {
                    RecordsTable.this.noMoreRecords = false;
                    RecordsTable.this.forward = true;
                    RecordsTable.this.currentFirst = (Long)this.getValueAt(RecordsTable.this.previousRow, 1);
                    int n = ctreeFile.setRecord(RecordsTable.this.currentFirst, null, 0);
                    if (n == 0) {
                        ctreeFile.begin(Enums.TRAN_BEGIN_MODE.TRNLOG);
                        if (ctreeFile.isVariableLength()) {
                            int n2 = ctreeFile.vRecordLength();
                            byte[] byArray = new byte[n2];
                            n = ctreeFile.reReadVRecord(byArray);
                            n = ctreeFile.deleteVRecord();
                        } else {
                            int n3 = ctreeFile.getRecordLength();
                            byte[] byArray = new byte[n3];
                            n = ctreeFile.reReadRecord(byArray);
                            n = ctreeFile.deleteRecord();
                        }
                        if (n != 0) {
                            // empty if block
                        }
                        ctreeFile.commit(Enums.TRAN_END_MODE.FREE);
                    }
                    RecordsTable.this.currentFirst = 1L;
                }
            }
            if (mODE != MODE.ADD) {
                this.refreshRecords(ctreeFile);
                if (ctreeFile.isOpen()) {
                    try {
                        if (ctreeFile.openedWithResources) {
                            ctreeFile.closeFileWithResource();
                        } else {
                            ctreeFile.closeFile();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        private void refreshRecords(CtreeFile ctreeFile) {
            boolean bl = false;
            if (RecordsTable.this.noMoreRecords) {
                return;
            }
            long l = 0L;
            if (RecordsTable.this.gotoRecordOffset > 0L) {
                l = RecordsTable.this.gotoRecordOffset;
                RecordsTable.this.currentFirst = RecordsTable.this.gotoRecord;
            } else if (this.getRowCount() > 0) {
                if (RecordsTable.this.forward) {
                    l = (Long)this.getValueAt(this.getRowCount() - 1, 1);
                    if (RecordsTable.this.currentFirst == 0L) {
                        RecordsTable.this.currentFirst = (Long)this.getValueAt(this.getRowCount() - 1, 0);
                    } else {
                        bl = true;
                    }
                } else {
                    l = (Long)this.getValueAt(0, 1);
                    if (RecordsTable.this.currentFirst == 0L) {
                        RecordsTable.this.currentFirst = (Long)this.getValueAt(0, 0);
                    } else {
                        RecordsTable.this.currentFirst = ctreeFile.numberOfKeyEntries();
                        bl = true;
                    }
                }
            } else {
                bl = true;
                RecordsTable.this.currentFirst = !RecordsTable.this.forward ? ctreeFile.numberOfKeyEntries() : 1L;
            }
            this.clearTable();
            Integer n = ctreeFile.getRecordLength();
            int n2 = n;
            byte[] byArray = new byte[n.intValue()];
            int n3 = 0;
            int n4 = 0;
            if (bl) {
                block31: {
                    if (ctreeFile.isVariableLength()) {
                        try {
                            n = RecordsTable.this.forward ? Integer.valueOf(ctreeFile.firstVRecord(byArray)) : Integer.valueOf(ctreeFile.lastVRecord(byArray));
                            if (n <= n2) break block31;
                            byArray = new byte[n.intValue()];
                            n2 = n;
                            if (RecordsTable.this.forward) {
                                ctreeFile.firstVRecord(byArray);
                                break block31;
                            }
                            ctreeFile.lastVRecord(byArray);
                        }
                        catch (JCtree.CtreeException ctreeException) {
                            n3 = 999;
                        }
                    } else {
                        n3 = RecordsTable.this.forward ? ctreeFile.firstRecord(byArray) : ctreeFile.lastRecord(byArray);
                    }
                }
                if (n3 == 0) {
                    ++n4;
                    this.displayRow(ctreeFile, byArray, RecordsTable.this.currentFirst, RecordsTable.this.forward);
                }
            } else {
                n3 = ctreeFile.setRecord(l, null, 0);
                if (ctreeFile.isVariableLength()) {
                    n = ctreeFile.vRecordLength();
                    byArray = new byte[n.intValue()];
                    n2 = n;
                    n3 = ctreeFile.reReadVRecord(byArray);
                } else {
                    n3 = ctreeFile.reReadRecord(byArray);
                }
                if (RecordsTable.this.gotoRecordOffset > 0L) {
                    ++RecordsTable.this.currentFirst;
                    ++n4;
                    this.displayRow(ctreeFile, byArray, RecordsTable.this.currentFirst, RecordsTable.this.forward);
                }
            }
            while (n3 == 0 && n4 < RecordsTable.this.blockSize) {
                if (ctreeFile.isVariableLength()) {
                    n = n2;
                    byArray = new byte[n.intValue()];
                    try {
                        n = RecordsTable.this.forward ? Integer.valueOf(ctreeFile.nextVRecord(byArray)) : Integer.valueOf(ctreeFile.previousVRecord(byArray));
                    }
                    catch (JCtree.CtreeException ctreeException) {
                        n3 = 999;
                    }
                    if (n > n2) {
                        byArray = new byte[n.intValue()];
                        n2 = n;
                        n3 = ctreeFile.reReadVRecord(byArray);
                    }
                } else {
                    n3 = RecordsTable.this.forward ? ctreeFile.nextRecord(byArray) : ctreeFile.previousRecord(byArray);
                }
                if (n3 == 0) {
                    RecordsTable.this.currentFirst = RecordsTable.this.forward ? ++RecordsTable.this.currentFirst : --RecordsTable.this.currentFirst;
                    this.displayRow(ctreeFile, byArray, RecordsTable.this.currentFirst, RecordsTable.this.forward);
                } else {
                    RecordsTable.this.noMoreRecords = true;
                }
                ++n4;
            }
            super.fireTableDataChanged();
            if (this.getRowCount() > 0) {
                RecordsTable.this.setRowSelectionInterval(0, 0);
            }
        }

        public boolean isColumnTypeUnsigned(int n) {
            int n2 = (Integer)this.columnsType.get(n);
            Enums.FIELD_TYPE fIELD_TYPE = Enums.FIELD_TYPE.setValue((int)n2);
            switch (fIELD_TYPE) {
                case CHAR: 
                case INT2: 
                case INT4: 
                case INT8: {
                    return false;
                }
                case CHARU: 
                case INT2U: 
                case INT4U: 
                case INT8U: {
                    return true;
                }
            }
            return false;
        }

        public boolean rowChanged(int n) {
            Object object;
            int n2;
            byte[] byArray;
            Integer n3;
            if (!this.hasDirtyColumns || RecordsTable.this.tableModel.getRowCount() == 0) {
                return true;
            }
            if (!RecordsTable.this.ctreeFile.isOpen()) {
                try {
                    if (RecordsTable.this.ctreeFile.openedWithResources) {
                        RecordsTable.this.ctreeFile.openFileWithResource(RecordsTable.this.ctreeFile.openedMode);
                    } else {
                        RecordsTable.this.ctreeFile.openFile(RecordsTable.this.ctreeFile.openedMode);
                    }
                }
                catch (JCtree.CtreeException ctreeException) {
                    // empty catch block
                }
            }
            Long l = (Long)this.getValueAt(n, 1);
            int n4 = RecordsTable.this.ctreeFile.setRecord(l.longValue(), null, 0);
            if (RecordsTable.this.ctreeFile.isVariableLength()) {
                n3 = RecordsTable.this.ctreeFile.vRecordLength();
                byArray = new byte[n3.intValue()];
                n4 = RecordsTable.this.ctreeFile.reReadVRecord(byArray);
            } else {
                n3 = RecordsTable.this.ctreeFile.getRecordLength();
                byArray = new byte[n3.intValue()];
                n4 = RecordsTable.this.ctreeFile.reReadRecord(byArray);
            }
            ArrayList arrayList = RecordsTable.this.ctreeFile.getDodaArray();
            if (arrayList != null) {
                try {
                    RecordsTable.this.ctreeFile.fillDoda(arrayList, byArray);
                }
                catch (JCtree.CtreeException ctreeException) {
                    // empty catch block
                }
            }
            int n5 = arrayList.size();
            int n6 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                Structures.DATOBJ_STRUCT dATOBJ_STRUCT = (Structures.DATOBJ_STRUCT)arrayList.get(n2);
                object = this.getValueAt(n, n2 + 2);
                if (object == null) {
                    dATOBJ_STRUCT.data = null;
                    n6 += dATOBJ_STRUCT.flen;
                    continue;
                }
                String string = object.toString();
                try {
                    switch (dATOBJ_STRUCT.ftype) {
                        case ARRAY: {
                            if ((string.length() + 1) % 3 != 0) {
                                Globals.showMessage(string, "Invalid Value in column " + dATOBJ_STRUCT.fsymb);
                                return false;
                            }
                            byte[] byArray2 = new byte[dATOBJ_STRUCT.flen];
                            int n7 = 0;
                            int n8 = 0;
                            while (n8 < string.length()) {
                                String string2 = string.substring(n8, n8 + 2);
                                try {
                                    byArray2[n7] = (byte)((Character.digit(string.charAt(n8), 16) << 4) + Character.digit(string.charAt(n8 + 1), 16));
                                    n8 += 3;
                                }
                                catch (Exception exception) {
                                    Globals.showMessage(string, "Invalid Value in column " + dATOBJ_STRUCT.fsymb);
                                    return false;
                                }
                                ++n7;
                            }
                            dATOBJ_STRUCT.data = byArray2;
                            n6 += byArray2.length;
                            break;
                        }
                        case BOOL: {
                            dATOBJ_STRUCT.data = !string.equals("false") && !string.equals("0");
                            ++n6;
                            break;
                        }
                        case CHAR: 
                        case CHARU: {
                            dATOBJ_STRUCT.data = Short.parseShort(string);
                            ++n6;
                            break;
                        }
                        case SFLOAT: {
                            dATOBJ_STRUCT.data = Float.valueOf(Float.parseFloat(string));
                            n6 += 4;
                            break;
                        }
                        case EFLOAT: 
                        case DFLOAT: {
                            dATOBJ_STRUCT.data = string.isEmpty() ? null : Double.valueOf(Double.parseDouble(string));
                            n6 += 8;
                            break;
                        }
                        case INT2: 
                        case INT2U: {
                            dATOBJ_STRUCT.data = Integer.parseInt(string);
                            n6 += 2;
                            break;
                        }
                        case INT4: 
                        case INT4U: {
                            dATOBJ_STRUCT.data = Long.parseLong(string);
                            n6 += 4;
                            break;
                        }
                        case MONEY: {
                            int n8 = Converters.ConvertStringToMoney((String)string);
                            dATOBJ_STRUCT.data = n8;
                            break;
                        }
                        case DATE: {
                            java.util.Date date = (java.util.Date)object;
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(date);
                            int n9 = calendar.get(2) + 1;
                            int n10 = Converters.DatePack((int)calendar.get(1), (int)(calendar.get(2) + 1), (int)calendar.get(5));
                            dATOBJ_STRUCT.data = n10;
                            n6 += 4;
                            break;
                        }
                        case TIME: {
                            java.util.Date date = (java.util.Date)object;
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(date);
                            int n11 = calendar.get(10) * 3600;
                            n11 += calendar.get(12) * 60;
                            dATOBJ_STRUCT.data = n11 += calendar.get(13);
                            n6 += 4;
                            break;
                        }
                        case TIMES: {
                            break;
                        }
                        case INT8: 
                        case INT8U: {
                            dATOBJ_STRUCT.data = Long.parseLong(string);
                            n6 += 8;
                            break;
                        }
                        case CURRENCY: {
                            long l2 = Converters.ConvertStringToCurrency((String)string);
                            dATOBJ_STRUCT.data = l2;
                            break;
                        }
                        case NUMBER: {
                            byte[] byArray3 = Converters.ConvertStringToNumber((String)string);
                            dATOBJ_STRUCT.data = byArray3;
                            break;
                        }
                        case FSTRING: 
                        case FUNICODE: 
                        case FPSTRING: 
                        case F2STRING: 
                        case FUNICODE2: 
                        case F4STRING: 
                        case VSTRING: 
                        case UNICODE: 
                        case VPSTRING: 
                        case V2STRING: 
                        case UNICODE2: 
                        case V4STRING: {
                            dATOBJ_STRUCT.data = string;
                            if (string.length() < dATOBJ_STRUCT.flen) {
                                n6 += dATOBJ_STRUCT.flen;
                                break;
                            }
                            n6 += string.length();
                            break;
                        }
                        default: {
                            JCtree.CtreeException ctreeException = new JCtree.CtreeException("FillDoda - Invalid Type :" + dATOBJ_STRUCT.ftype.toString());
                            Globals.showException(ctreeException, "", "Error");
                            break;
                        }
                    }
                    continue;
                }
                catch (Exception exception) {
                    Globals.showMessage(string, "Invalid Value in column " + dATOBJ_STRUCT.fsymb);
                    return false;
                }
            }
            try {
                byArray = new byte[n6 * 2];
                n2 = RecordsTable.this.ctreeFile.fillBuffer(byArray, arrayList);
                long l3 = RecordsTable.this.ctreeFile.begin(Enums.TRAN_BEGIN_MODE.TRNLOG);
                if (l3 == 0L) {
                    n4 = RecordsTable.this.ctreeFile.getLastError();
                }
                if (RecordsTable.this.ctreeFile.isVariableLength()) {
                    n4 = l > 0L ? RecordsTable.this.ctreeFile.reWriteVRecord(byArray, n2) : RecordsTable.this.ctreeFile.AddVRecord(byArray, n2);
                    if (n4 != 0) {
                        Globals.showMessage(n4, "Write Error");
                    }
                    RecordsTable.this.ctreeFile.reReadVRecord(byArray);
                } else {
                    n4 = l > 0L ? RecordsTable.this.ctreeFile.reWriteRecord(byArray) : RecordsTable.this.ctreeFile.AddRecord(byArray);
                }
                n4 = RecordsTable.this.ctreeFile.commit(Enums.TRAN_END_MODE.FREE);
                this.refreshRow(RecordsTable.this.ctreeFile, byArray, new Long(n), n);
            }
            catch (JCtree.CtreeException ctreeException) {
                Globals.showException(ctreeException, "", "Error");
            }
            if (RecordsTable.this.ctreeFile.isOpen()) {
                try {
                    if (RecordsTable.this.ctreeFile.openedWithResources) {
                        RecordsTable.this.ctreeFile.closeFileWithResource();
                    } else {
                        RecordsTable.this.ctreeFile.closeFile();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.hasDirtyColumns = false;
            Integer n12 = 0;
            while (n12 < this.numberOfColumns) {
                this.dirtyColumns.set(n12, false);
                Integer n13 = n12;
                n12 = n12 + 1;
                object = n12;
            }
            return true;
        }

        private void fill(CtreeFile ctreeFile) {
            this.setupColumns(ctreeFile);
            RecordsTable.this.resizeColumns();
            Integer n = ctreeFile.getRecordLength();
            int n2 = n;
            byte[] byArray = new byte[n.intValue()];
            int n3 = 0;
            long l = 0L;
            int n4 = 0;
            RecordsTable.this.noMoreRecords = false;
            if (ctreeFile.isVariableLength()) {
                try {
                    n = ctreeFile.firstVRecord(byArray);
                    if (n > n2) {
                        byArray = new byte[n.intValue()];
                        n2 = n;
                        ctreeFile.firstVRecord(byArray);
                    }
                }
                catch (JCtree.CtreeException ctreeException) {
                    n3 = ctreeException.Error;
                }
            } else {
                n3 = ctreeFile.firstRecord(byArray);
            }
            if (n3 == 0) {
                ++n4;
                l = 1L;
                this.displayRow(ctreeFile, byArray, l, true);
            }
            while (n3 == 0 && n4 < RecordsTable.this.blockSize) {
                if (ctreeFile.isVariableLength()) {
                    try {
                        n = ctreeFile.nextVRecord(byArray);
                        if (n > n2) {
                            byArray = new byte[n.intValue()];
                            n2 = n;
                            n3 = ctreeFile.reReadVRecord(byArray);
                        }
                    }
                    catch (JCtree.CtreeException ctreeException) {
                        n3 = ctreeException.Error;
                    }
                } else {
                    n3 = ctreeFile.nextRecord(byArray);
                }
                if (n3 == 0) {
                    this.displayRow(ctreeFile, byArray, ++l, true);
                } else {
                    RecordsTable.this.noMoreRecords = true;
                }
                ++n4;
            }
            super.fireTableDataChanged();
            if (this.getRowCount() > 0) {
                RecordsTable.this.setRowSelectionInterval(0, 0);
            }
        }

        private void setupColumns(CtreeFile ctreeFile) {
            this.suspendAutoSize = false;
            ArrayList arrayList = ctreeFile.getDodaArray();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            this.clearTable();
            arrayList2.add("Rec. #");
            arrayList2.add("RecPnt");
            if (arrayList != null) {
                for (Structures.DATOBJ_STRUCT dATOBJ_STRUCT : arrayList) {
                    arrayList2.add(dATOBJ_STRUCT.fsymb);
                }
            } else {
                arrayList2.add("DATOBJ structure not available - Raw record view");
            }
            this.addColumns(arrayList2);
            Object object = this.table.getColumnModel().getColumn(0);
            ((TableColumn)object).setPreferredWidth(60);
            this.readOnlyColumns.set(0, true);
            this.readOnlyColumns.set(1, true);
            object = this.table.getColumnModel().getColumn(1);
            ((TableColumn)object).setPreferredWidth(60);
            if (arrayList != null) {
                int n = 2;
                for (Structures.DATOBJ_STRUCT dATOBJ_STRUCT : arrayList) {
                    object = this.table.getColumnModel().getColumn(n);
                    int n2 = RecordsTable.this.metrics.stringWidth(dATOBJ_STRUCT.fsymb) + 10;
                    ((TableColumn)object).setPreferredWidth(n2);
                    this.columnsType.set(n, dATOBJ_STRUCT.ftype.value);
                    switch (dATOBJ_STRUCT.ftype) {
                        case BOOL: {
                            this.columnsClass.set(n, Boolean.class);
                            break;
                        }
                        case CHAR: 
                        case CHARU: {
                            this.columnsClass.set(n, Short.class);
                            break;
                        }
                        case SFLOAT: 
                        case MONEY: {
                            this.columnsClass.set(n, Float.class);
                            break;
                        }
                        case EFLOAT: 
                        case DFLOAT: {
                            this.columnsClass.set(n, Double.class);
                            break;
                        }
                        case INT2: 
                        case INT2U: {
                            this.columnsClass.set(n, Integer.class);
                            break;
                        }
                        case INT4: 
                        case INT4U: {
                            this.columnsClass.set(n, Long.class);
                            break;
                        }
                        case DATE: {
                            this.columnsClass.set(n, java.util.Date.class);
                            break;
                        }
                        case TIME: 
                        case TIMEMS: {
                            this.columnsClass.set(n, Time.class);
                            break;
                        }
                        case TIMES: 
                        case TIMESMS: {
                            this.columnsClass.set(n, Timestamp.class);
                            break;
                        }
                        case INT8: 
                        case INT8U: {
                            this.columnsClass.set(n, BigInteger.class);
                            this.columnsScale.set(n, 0);
                            break;
                        }
                        case CURRENCY: {
                            this.columnsClass.set(n, Double.class);
                            this.columnsScale.set(n, 4);
                            break;
                        }
                        case NUMBER: {
                            this.columnsClass.set(n, BigDecimal.class);
                            this.columnsScale.set(n, -1);
                            break;
                        }
                        case ARRAY: 
                        case FSTRING: 
                        case FUNICODE: 
                        case FPSTRING: 
                        case F2STRING: 
                        case FUNICODE2: 
                        case F4STRING: 
                        case VSTRING: 
                        case UNICODE: 
                        case VPSTRING: 
                        case V2STRING: 
                        case UNICODE2: 
                        case V4STRING: 
                        case XXX: {
                            break;
                        }
                        default: {
                            JCtree.CtreeException ctreeException = new JCtree.CtreeException("Setupcolumns - Invalid Type :" + dATOBJ_STRUCT.ftype.toString());
                            Globals.showException(ctreeException, "", "Error");
                        }
                    }
                    ++n;
                }
            } else {
                object = this.table.getColumnModel().getColumn(2);
                ((TableColumn)object).setPreferredWidth(330);
            }
        }

        private void displayRow(CtreeFile ctreeFile, byte[] byArray, Long l, boolean bl) {
            FcBaseTableModel.RowData rowData = this.fillRowData(ctreeFile, byArray, l);
            if (bl) {
                this.addRow(rowData);
            } else {
                this.insertRow(0, rowData);
            }
        }

        private void refreshRow(CtreeFile ctreeFile, byte[] byArray, Long l, int n) {
            FcBaseTableModel.RowData rowData = this.fillRowData(ctreeFile, byArray, l);
            this.updateRow(rowData, n);
        }

        private FcBaseTableModel.RowData fillRowData(CtreeFile ctreeFile, byte[] byArray, Long l) {
            ArrayList arrayList = ctreeFile.getDodaArray();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(l);
            if (arrayList != null) {
                try {
                    ctreeFile.fillDodaFormatted(arrayList, byArray);
                }
                catch (JCtree.CtreeException ctreeException) {
                    // empty catch block
                }
            }
            long l2 = ctreeFile.currentFileOffset();
            arrayList2.add(l2);
            if (arrayList != null) {
                for (Structures.DATOBJ_STRUCT dATOBJ_STRUCT : arrayList) {
                    FcBaseTableModel.CellData cellData;
                    if (dATOBJ_STRUCT.formattedValue == null) continue;
                    RecordTag recordTag = new RecordTag();
                    if (dATOBJ_STRUCT.formattedValue.length() > 256) {
                        recordTag.tooltip = "Column has been truncated to 256 bytes. Click \"View in Window\" to view the whole column)";
                        recordTag.cellIcon = Globals.getIcon("Alert.png");
                        cellData = new FcBaseTableModel.CellData((FcBaseTableModel)this, (Object)dATOBJ_STRUCT.formattedValue.substring(0, 256), (Object)recordTag);
                    } else {
                        cellData = new FcBaseTableModel.CellData((FcBaseTableModel)this, dATOBJ_STRUCT.data, (Object)recordTag);
                    }
                    switch (dATOBJ_STRUCT.ftype) {
                        case CHAR: {
                            Short s = (Short)dATOBJ_STRUCT.data;
                            cellData = new FcBaseTableModel.CellData((FcBaseTableModel)this, (Object)s, (Object)recordTag);
                            break;
                        }
                        case TIME: {
                            Calendar calendar = Converters.ConvertTimeToCalendar((Integer)((Integer)dATOBJ_STRUCT.data));
                            Time time = new Time(calendar.getTimeInMillis());
                            cellData = new FcBaseTableModel.CellData((FcBaseTableModel)this, (Object)time, (Object)recordTag);
                            break;
                        }
                        case DATE: {
                            Calendar calendar = Converters.ConvertDateToCalendar((int)((Integer)dATOBJ_STRUCT.data));
                            Date date = new Date(calendar.getTimeInMillis());
                            cellData = new FcBaseTableModel.CellData((FcBaseTableModel)this, (Object)date, (Object)recordTag);
                            break;
                        }
                        case TIMES: {
                            Calendar calendar = Converters.ConvertDateTimeToCalendar((double)((Double)dATOBJ_STRUCT.data));
                            Date date = new Date(calendar.getTimeInMillis());
                            cellData = new FcBaseTableModel.CellData((FcBaseTableModel)this, (Object)date, (Object)recordTag);
                            break;
                        }
                        case NUMBER: {
                            String string = Converters.ConvertNumberToString((byte[])((byte[])dATOBJ_STRUCT.data));
                            double d = Double.parseDouble(string);
                            cellData = new FcBaseTableModel.CellData((FcBaseTableModel)this, (Object)d, (Object)recordTag);
                            break;
                        }
                        case MONEY: {
                            Integer n = (Integer)dATOBJ_STRUCT.data;
                            double d = n.doubleValue() / 100.0;
                            cellData = new FcBaseTableModel.CellData((FcBaseTableModel)this, (Object)d, (Object)recordTag);
                            break;
                        }
                        case CURRENCY: {
                            Long l3 = (Long)dATOBJ_STRUCT.data;
                            double d = l3.doubleValue() / 10000.0;
                            cellData = new FcBaseTableModel.CellData((FcBaseTableModel)this, (Object)d, (Object)recordTag);
                            break;
                        }
                        case ARRAY: 
                        case FSTRING: 
                        case FPSTRING: 
                        case F2STRING: 
                        case F4STRING: 
                        case VSTRING: 
                        case VPSTRING: 
                        case V2STRING: 
                        case V4STRING: {
                            recordTag.data = dATOBJ_STRUCT.data;
                            cellData = new FcBaseTableModel.CellData((FcBaseTableModel)this, (Object)dATOBJ_STRUCT.formattedValue, (Object)recordTag);
                        }
                    }
                    arrayList2.add(cellData);
                }
            } else {
                arrayList2.add(new String(byArray, Charset.forName("iso-8859-1")));
            }
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList2);
            return rowData;
        }
    }

    class PopupActions
    implements ActionListener {
        int mode;

        public PopupActions(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = RecordsTable.this.getSelectedRows();
        }
    }

    public class TTMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
            Object object = RecordsTable.this.getModel().getTagAt(n, n2);
            if (object != null && object instanceof RecordTag) {
                RecordTag recordTag = (RecordTag)object;
                if (recordTag.tooltip != null && !recordTag.tooltip.isEmpty()) {
                    RecordsTable.this.showTooltip = true;
                    RecordsTable.this.toolTipText = recordTag.tooltip;
                } else {
                    RecordsTable.this.showTooltip = false;
                }
            } else {
                RecordsTable.this.showTooltip = false;
            }
        }
    }

    public static enum MODE {
        FIRST,
        NEXT,
        PREVIOUS,
        LAST,
        GOTO,
        ADD,
        REMOVE;


        public static MODE fromInt(int n) {
            return MODE.values()[n];
        }
    }
}

