/*
 * Decompiled with CFR 0.152.
 */
package drctree;

import FairCom.Helper.Classes.FcDynamicTree;
import FairCom.Helper.Classes.FcTreeNode;
import Isam.CtreeFile;
import Isam.Enums;
import Isam.JCtree;
import Isam.Structures;
import drctree.DrCtreeApp;
import drctree.DrCtreeView;
import drctree.Globals;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;

public class ResourcesTree
extends FcDynamicTree {
    CtreeFile ctreeFile;

    void fill(CtreeFile ctreeFile, int n) {
        this.ctreeFile = ctreeFile;
        this.clear();
        int n2 = 0;
        int n3 = 1000;
        long l = 0L;
        byte[] byArray = new byte[100];
        byte[] byArray2 = new byte[0x100000];
        do {
            ++n2;
            System.arraycopy(byArray2, 0, byArray, 0, 50);
            l = ctreeFile.getCtResource(byArray, byArray2, Enums.RESOURCE_MODE.NEXT.value | Enums.RESOURCE_MODE.LENGTH.value);
            if (l <= 0L) continue;
            int n4 = CtreeFile.byteArrayToInt((byte[])byArray2, (int)8);
            Structures.RESOURCE_STRUCT rESOURCE_STRUCT = new Structures.RESOURCE_STRUCT(n4);
            l = rESOURCE_STRUCT.offset = ctreeFile.getCtResource(byArray, byArray2, Enums.RESOURCE_MODE.NEXT.value);
            rESOURCE_STRUCT.type = CtreeFile.byteArrayToInt((byte[])byArray2, (int)0);
            rESOURCE_STRUCT.number = CtreeFile.byteArrayToInt((byte[])byArray2, (int)4);
            rESOURCE_STRUCT.length = n4;
            rESOURCE_STRUCT.name = CtreeFile.byteArrayToString((byte[])byArray2, (int)8);
            System.arraycopy(byArray2, 0, rESOURCE_STRUCT.info, 0, n4);
            FcTreeNode fcTreeNode = new FcTreeNode(rESOURCE_STRUCT.name);
            fcTreeNode.tag = rESOURCE_STRUCT;
            this.addObject(fcTreeNode);
            FcTreeNode fcTreeNode2 = new FcTreeNode("Type = " + rESOURCE_STRUCT.type);
            this.addObject(fcTreeNode, fcTreeNode2);
            fcTreeNode2 = new FcTreeNode("Number = " + rESOURCE_STRUCT.number);
            this.addObject(fcTreeNode, fcTreeNode2);
            fcTreeNode2 = new FcTreeNode("Length = " + rESOURCE_STRUCT.length);
            this.addObject(fcTreeNode, fcTreeNode2);
            this.expandNode((DefaultMutableTreeNode)fcTreeNode);
        } while (l > 0L && n2 < n3);
        this.repaint();
        if (n2 == n3) {
            Globals.showMessage("More than " + n3 + " resources found.\n\nCorrupt File ?", "Error");
        }
        DrCtreeView drCtreeView = (DrCtreeView)DrCtreeApp.getApplication().getMainView();
        drCtreeView.resDumpTP.setText("");
        drCtreeView.resStructTP.setText("");
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        FcTreeNode fcTreeNode = (FcTreeNode)this.getLastSelectedPathComponent();
        if (fcTreeNode != null) {
            int n = fcTreeNode.getLevel();
            while (n > 1) {
                fcTreeNode = fcTreeNode.getParent();
                n = fcTreeNode.getLevel();
            }
            Object object = fcTreeNode.tag;
            if (object != null && object instanceof Structures.RESOURCE_STRUCT) {
                Structures.RESOURCE_STRUCT rESOURCE_STRUCT = (Structures.RESOURCE_STRUCT)object;
                this.showResourceDump(rESOURCE_STRUCT);
                this.showResourceStruct(fcTreeNode, rESOURCE_STRUCT);
            }
        }
    }

    private void showResourceDump(Structures.RESOURCE_STRUCT rESOURCE_STRUCT) {
        byte[] byArray = rESOURCE_STRUCT.info;
        DrCtreeView drCtreeView = (DrCtreeView)DrCtreeApp.getApplication().getMainView();
        int n = 0;
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder(64);
        StringBuilder stringBuilder2 = new StringBuilder(64);
        StringBuilder stringBuilder3 = new StringBuilder(64);
        do {
            stringBuilder.setLength(0);
            stringBuilder3.setLength(0);
            stringBuilder.append(String.format("%08d: ", n));
            for (n2 = 0; n2 < 8 && n < byArray.length; ++n, ++n2) {
                char c = (char)(byArray[n] & 0xFF);
                stringBuilder.append(String.format("%02X ", byArray[n]));
                if (c < ' ') {
                    stringBuilder3.append(" .");
                    continue;
                }
                stringBuilder3.append(" ");
                stringBuilder3.append(c);
            }
            if (n2 > 0) {
                while (n2++ < 8) {
                    stringBuilder.append("   ");
                }
                stringBuilder2.append(stringBuilder.toString()).append("  ").append(stringBuilder3.toString()).append("\n");
                continue;
            }
            stringBuilder2.append(stringBuilder.toString()).append("\n");
        } while (n < byArray.length);
        drCtreeView.resDumpTP.setText(stringBuilder2.toString());
        if (stringBuilder2.length() > 0) {
            drCtreeView.resDumpTP.setCaretPosition(1);
        }
    }

    private void showResourceStruct(FcTreeNode fcTreeNode, Structures.RESOURCE_STRUCT rESOURCE_STRUCT) {
        byte[] byArray = rESOURCE_STRUCT.info;
        DrCtreeView drCtreeView = (DrCtreeView)DrCtreeApp.getApplication().getMainView();
        String string = fcTreeNode.getText();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        if (string.equals("FC!DPAD")) {
            stringBuilder.append("Rtype:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nRtnum:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nRname:\t");
            n = this.appendStringBytes(stringBuilder, byArray, n, 8);
            stringBuilder.append("\nVersion:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\n\nHigh:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nLow:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nPadchar:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nDlmchar:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
        } else if (string.equals("FC!DFLD")) {
            int n2 = 0;
            try {
                n2 = this.ctreeFile.getNumberOfFields();
            }
            catch (JCtree.CtreeException ctreeException) {
                return;
            }
            int n3 = 100 + n2 * 100;
            stringBuilder = new StringBuilder(n3);
            stringBuilder.append("Rtype:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nRtnum:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nRname:\t");
            n = this.appendStringBytes(stringBuilder, byArray, n, 8);
            stringBuilder.append("\nVersion:\t");
            Integer n4 = CtreeFile.byteArrayToInt((byte[])byArray, (int)n);
            n += 4;
            stringBuilder.append(n4.toString());
            stringBuilder.append("\n\n----- Fields data -----");
            int n5 = 0;
            if (n4 == 2) {
                n5 = 3;
                n += 58;
            } else if (n4 >= 3) {
                n5 = 3;
            }
            for (int i = 0; i < n2 - 3; ++i) {
                stringBuilder.append("\n\nField[").append(n5).append("] data:\t\t");
                stringBuilder.append("\nNull Flag:\t\t");
                stringBuilder.append(byArray[n]);
                stringBuilder.append("\nPrecision:\t\t");
                stringBuilder.append(byArray[n += 2] & 0xFF);
                stringBuilder.append("\nScale:\t\t");
                stringBuilder.append(byArray[n += 2] & 0xFF);
                n += 2;
                if (n4 == 4) {
                    stringBuilder.append("\nBinFlag:\t\t");
                    stringBuilder.append(byArray[n]);
                    n += 26;
                } else {
                    n += 26;
                }
                ++n5;
            }
        } else if (string.equals("FC!COBF")) {
            stringBuilder.append("Rtype:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nRtnum:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nRname:\t");
            n = this.appendStringBytes(stringBuilder, byArray, n, 8);
            stringBuilder.append("\n\nCobol Sign:\t");
            stringBuilder.append(byArray[n] & 0xFF);
        } else if (string.equals("FC!COBN")) {
            stringBuilder.append("Rtype:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nRtnum:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nRname:\t");
            n = this.appendStringBytes(stringBuilder, byArray, n, 8);
            stringBuilder.append("\n\nMax Record Len:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nBlocking Factor:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nPreallocation:\t\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nExtension:\t\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nCompress:\t\t");
            stringBuilder.append(byArray[n] & 0xFF);
            ++n;
            stringBuilder.append("\nComment:\t\t");
            n = this.appendStringBytes(stringBuilder, byArray, n, 31);
            if (rESOURCE_STRUCT.length == 68) {
                stringBuilder.append("\nMin Record Len:\t");
                n = this.appendIntBytes(stringBuilder, byArray, n);
            }
        } else if (string.equals("FC!COBX")) {
            stringBuilder.append("Rtype:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nRtnum:\t");
            n = this.appendIntBytes(stringBuilder, byArray, n);
            stringBuilder.append("\nRname:\t");
            n = this.appendStringBytes(stringBuilder, byArray, n, 8);
            stringBuilder.append("\n\nDefinition:\n");
            this.appendStringBytes(stringBuilder, byArray, n, -1);
        } else if (string.equals("FC!DEF")) {
            stringBuilder.append("This resource contains SCHEMA informations\n\nPlease switch to IFIL and DATOBJ panes");
        } else {
            stringBuilder.append("Unknown structure");
        }
        drCtreeView.resStructTP.setText(stringBuilder.toString());
        if (stringBuilder.length() > 0) {
            drCtreeView.resStructTP.setCaretPosition(1);
        }
    }

    private int appendIntBytes(StringBuilder stringBuilder, byte[] byArray, int n) {
        Integer n2 = CtreeFile.byteArrayToInt((byte[])byArray, (int)n);
        stringBuilder.append(n2.toString());
        return n + 4;
    }

    private int appendStringBytes(StringBuilder stringBuilder, byte[] byArray, int n, int n2) {
        if (n2 == -1) {
            n2 = byArray.length - n;
        }
        String string = new String(byArray, n, n2);
        stringBuilder.append(string);
        return n + n2;
    }
}

