/*
 * Decompiled with CFR 0.152.
 */
package drctree;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import Isam.CtreeFile;
import Isam.Enums;
import Isam.JCtree;
import Isam.Structures;
import drctree.Globals;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XcreBlkTable
extends FcBaseDynamicTable {
    private XcreBlkTableModel tableModel = new XcreBlkTableModel(this);
    protected boolean inError;

    public XcreBlkTable(boolean bl) {
        this.setModel((TableModel)((Object)this.tableModel));
        this.tableModel.setupColumns();
    }

    public XcreBlkTableModel getModel() {
        return this.tableModel;
    }

    void selectRow(String string) {
        this.tableModel.selecRow(string);
    }

    void fill(CtreeFile ctreeFile, int n) {
        this.clearTable();
        this.tableModel.fill(ctreeFile, n);
    }

    public class XcreBlkTableModel
    extends FcBaseTableModel {
        XcreBlkTableModel(XcreBlkTable xcreBlkTable2) {
            super((FcBaseDynamicTable)xcreBlkTable2, true);
            this.table = xcreBlkTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"#", "Element", "Description", "Value", "Type"};
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(30);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(80);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(160);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(100);
            tableColumn = this.table.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(50);
            this.autoSizeColumns.set(3, true);
            this.readOnlyColumns.set(0, true);
            this.readOnlyColumns.set(1, true);
            this.readOnlyColumns.set(2, true);
            this.readOnlyColumns.set(4, true);
        }

        private void fill(CtreeFile ctreeFile, int n) {
            if (ctreeFile.isOpen()) {
                int n2 = 0;
                try {
                    Structures.XCREBLK_STRUCT xCREBLK_STRUCT = ctreeFile.getXtdCreateBlock();
                    String string = Enums.EXTENDED_MODE.decodeX8Mode((int)xCREBLK_STRUCT.x8mode);
                    this.addRow((Integer)n2++, "x8mode", "Extended File Modes", "(0x" + String.format("%08X", xCREBLK_STRUCT.x8mode) + ") " + string, "LONG");
                    this.addRow((Integer)n2++, "segsiz", "1st Segment Size (MB)", xCREBLK_STRUCT.segsiz, "ULONG");
                    this.addRow((Integer)n2++, "mxfilzhw", "High Word Max File Size", xCREBLK_STRUCT.mxfilzhw, "LONG");
                    this.addRow((Integer)n2++, "mxfilzlw", "Low Word Max File Size", xCREBLK_STRUCT.mxfilzlw, "LONG");
                    this.addRow((Integer)n2++, "fxtsiz", "First File Extent Size", xCREBLK_STRUCT.fxtsiz, "LONG");
                    this.addRow((Integer)n2++, "lxtsiz", "File Extent Size", xCREBLK_STRUCT.lxtsiz, "LONG");
                    this.addRow((Integer)n2++, "segmax", "Maximum Number of Segments", xCREBLK_STRUCT.segmax, "LONG");
                    this.addRow((Integer)n2++, "dskful", "Disk Full Threshold", xCREBLK_STRUCT.dskful, "ULONG");
                    this.addRow((Integer)n2++, "filkey", "File Encryption Key", xCREBLK_STRUCT.filkey, "ULONG");
                    this.addRow((Integer)n2++, "prtkey", "Relative Key# for Partition Key", xCREBLK_STRUCT.prtkey, "LONG");
                    this.addRow((Integer)n2++, "splval", "Special Value Parameter", xCREBLK_STRUCT.splval, "LONG");
                    this.addRow((Integer)n2++, "callparm", "Call Specific Parameter", xCREBLK_STRUCT.callparm, "LONG");
                }
                catch (JCtree.CtreeException ctreeException) {
                    Globals.showException(ctreeException, "getXtdCreateBlock");
                }
            }
            super.fireTableDataChanged();
        }

        public void addRow(Integer n, String string, String string2, String string3, String string4) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(n);
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }

        public void addRow(Integer n, String string, String string2, int n2, String string3) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(n);
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(n2);
            arrayList.add(string3);
            FcBaseTableModel.RowData rowData = new FcBaseTableModel.RowData((FcBaseTableModel)this, arrayList);
            this.addRow(rowData);
        }

        private void selecRow(String string) {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                Integer n2 = (Integer)this.getValueAt(i, 0);
                if (!n2.toString().equals(string)) continue;
                i = this.table.convertRowIndexToView(i);
                this.table.setRowSelectionInterval(i, i);
                Rectangle rectangle = this.table.getCellRect(i, i, true);
                this.table.scrollRectToVisible(rectangle);
            }
        }
    }

    class PopupActions
    implements ActionListener {
        int mode;

        public PopupActions(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = XcreBlkTable.this.getSelectedRows();
        }
    }

    public class TTMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
            XcreBlkTable.this.showTooltip = false;
        }
    }
}

