/*
 * Decompiled with CFR 0.152.
 */
package FairCom.RA.cci;

import FairCom.CtreeDb.CTDatabase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTSession;
import FairCom.Persistence.EntityManager;
import FairCom.Persistence.EntityManagerFactory;
import FairCom.Persistence.Persistence;
import FairCom.RA.cci.CTConnectionMetaDataImpl;
import FairCom.RA.cci.CTInteractionImpl;
import FairCom.RA.cci.CTLocalTransactionImpl;
import FairCom.RA.cci.CTResultSetInfoImpl;
import FairCom.RA.spi.CTManagedConnectionImpl;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;

public class CTConnectionImpl
implements Connection {
    private CTManagedConnectionImpl mngdConn;
    private CTConnectionMetaDataImpl connMetaData;
    private CTSession ctSession;
    private CTDatabase ctDatabase;
    private EntityManager manager = null;
    private String _productName = "";
    private String _productVersion = "";
    private String _userLogonName = "";
    private String _password = "";
    private int _maxConnections = -1;

    public CTConnectionImpl(String string, String string2, String string3, CTManagedConnectionImpl cTManagedConnectionImpl) throws CTException {
        this.Logon(string, string2, string3, 1);
        this.mngdConn = cTManagedConnectionImpl;
    }

    public CTConnectionImpl(String string, String string2, String string3, String string4, int n, CTManagedConnectionImpl cTManagedConnectionImpl) throws CTException {
        this.Connect(string, string2, string3, string4, n, cTManagedConnectionImpl);
    }

    public Interaction createInteraction() throws ResourceException {
        return new CTInteractionImpl(this);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return new CTLocalTransactionImpl(this);
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        return this.connMetaData;
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        return new CTResultSetInfoImpl(this);
    }

    public void close() throws ResourceException {
        try {
            if (this.ctDatabase != null) {
                this.ctDatabase.Disconnect();
            }
            this.ctSession.Logoff();
        }
        catch (CTException cTException) {
            Logger.getLogger(CTConnectionImpl.class.getName()).log(Level.SEVERE, "[" + cTException.GetErrorCode() + "] " + cTException.GetErrorMsg(), cTException);
            throw new ResourceException("Couldn't close CTConnection", (Throwable)cTException);
        }
    }

    public String GetProductName() throws CTException {
        if (this._productName.isEmpty()) {
            this._productName = this.ctSession.GetProductName();
        }
        return this._productName;
    }

    public String GetProductVersion() throws CTException {
        if (this._productVersion.isEmpty()) {
            this._productVersion = this.ctSession.GetProductVersion();
        }
        return this._productVersion;
    }

    public String GetUserLogonName() throws CTException {
        if (this._userLogonName.isEmpty()) {
            this._userLogonName = this.ctSession.GetUserLogonName();
        }
        return this._userLogonName;
    }

    public String GetPassword() {
        if (this._password.isEmpty()) {
            this._password = this.ctSession.GetPassword();
        }
        return this._password;
    }

    public int GetMaxConnections() throws CTException {
        if (this._maxConnections == -1) {
            this._maxConnections = this.ctSession.GetMaxConnections();
        }
        return this._maxConnections;
    }

    public void UpdateManagedConnection(CTManagedConnectionImpl cTManagedConnectionImpl) {
        if (this.mngdConn != null) {
            this.mngdConn.disassociateConnection();
            this.mngdConn = cTManagedConnectionImpl;
        }
    }

    public CTSession GetCTSession() {
        return this.ctSession;
    }

    public CTDatabase GetCTDatabase() {
        return this.ctDatabase;
    }

    public EntityManager GetCTEntityManager(File file, String string, ClassLoader classLoader) {
        if (this.manager == null) {
            EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((File)file, (String)string, (ClassLoader)classLoader);
            this.manager = entityManagerFactory.createEntityManager(this.ctDatabase);
        }
        return this.manager;
    }

    public EntityManager GetCTEntityManager(File file, String string) {
        return this.GetCTEntityManager(file, string, null);
    }

    public void reAuthenticate(String string, String string2, String string3, CTManagedConnectionImpl cTManagedConnectionImpl) throws ResourceException {
        this.close();
        try {
            this.ctSession.Logon(string, string2, string3);
            this.connMetaData = new CTConnectionMetaDataImpl(this.ctSession.GetProductName(), this.ctSession.GetProductVersion(), this.ctSession.GetUserLogonName());
        }
        catch (CTException cTException) {
            Logger.getLogger(CTConnectionImpl.class.getName()).log(Level.SEVERE, "[" + cTException.GetErrorCode() + "] " + cTException.GetErrorMsg(), cTException);
            throw new ResourceException("Couldn't reAuthenticate CTConnection", (Throwable)cTException);
        }
        this.mngdConn = cTManagedConnectionImpl;
    }

    public void reAuthenticate(String string, String string2, String string3, String string4, int n, CTManagedConnectionImpl cTManagedConnectionImpl) throws ResourceException {
        this.close();
        try {
            this.ctSession.Logon(string, string2, string3);
            this.ctDatabase.Connect(string4);
            this.connMetaData = new CTConnectionMetaDataImpl(this.ctSession.GetProductName(), this.ctSession.GetProductVersion(), this.ctSession.GetUserLogonName());
        }
        catch (CTException cTException) {
            Logger.getLogger(CTConnectionImpl.class.getName()).log(Level.SEVERE, "[" + cTException.GetErrorCode() + "] " + cTException.GetErrorMsg(), cTException);
            throw new ResourceException("Couldn't reAuthenticate CTConnection", (Throwable)cTException);
        }
        this.mngdConn = cTManagedConnectionImpl;
    }

    private void Logon(String string, String string2, String string3, int n) throws CTException {
        this.ctSession = new CTSession(n);
        this.ctSession.Logon(string, string2, string3);
        this.connMetaData = new CTConnectionMetaDataImpl(this.ctSession.GetProductName(), this.ctSession.GetProductVersion(), this.ctSession.GetUserLogonName());
        this.ctSession.SetAutoCommit(true);
        this.ctSession.SetOperation(3, 2);
    }

    public final void Connect(String string, String string2, String string3, String string4, int n, CTManagedConnectionImpl cTManagedConnectionImpl) throws CTException {
        this.Logon(string, string2, string3, n);
        this.mngdConn = cTManagedConnectionImpl;
        this.ctDatabase = new CTDatabase(this.ctSession);
        this.ctDatabase.Connect(string4);
    }
}

