/*
 * Decompiled with CFR 0.152.
 */
package FairCom.RA.spi;

import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTSession;
import FairCom.RA.cci.CTConnectionImpl;
import FairCom.RA.spi.CTConnectionRequestInfoImpl;
import FairCom.RA.spi.CTLocalTransactionImpl;
import FairCom.RA.spi.CTManagedConnectionFactoryImpl;
import FairCom.RA.spi.CTManagedConnectionMetaDataImpl;
import FairCom.RA.spi.CTXAResourceImpl;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class CTManagedConnectionImpl
implements ManagedConnection {
    private CTManagedConnectionFactoryImpl mngdConnFactory;
    private CTManagedConnectionMetaDataImpl mngdConnMetaData;
    private CTConnectionImpl activeConn = null;
    private ArrayList<ConnectionEventListener> listeners = new ArrayList();
    private PrintWriter logWriter = new PrintWriter(System.out);
    private CTXAResourceImpl ctXAResource = null;
    private CTLocalTransactionImpl ctLocalTransaction = null;

    public CTManagedConnectionImpl(CTManagedConnectionFactoryImpl cTManagedConnectionFactoryImpl) {
        this.mngdConnMetaData = new CTManagedConnectionMetaDataImpl();
        this.mngdConnFactory = cTManagedConnectionFactoryImpl;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        try {
            String string;
            String string2;
            Object object;
            Object object2;
            if (subject != null) {
                object2 = subject.getPrivateCredentials(PasswordCredential.class);
                object = object2.iterator().next();
                string2 = object.getUserName();
                string = new String(object.getPassword());
            } else {
                string2 = this.mngdConnFactory.getUserName();
                string = this.mngdConnFactory.getPassword();
            }
            if (connectionRequestInfo != null && string2.equals("")) {
                object2 = (CTConnectionRequestInfoImpl)connectionRequestInfo;
                string2 = ((CTConnectionRequestInfoImpl)object2).GetUserName();
                string = ((CTConnectionRequestInfoImpl)object2).GetPassword();
            }
            if (this.activeConn == null) {
                int n;
                if (connectionRequestInfo != null) {
                    CTConnectionRequestInfoImpl cTConnectionRequestInfoImpl = (CTConnectionRequestInfoImpl)connectionRequestInfo;
                    object2 = cTConnectionRequestInfoImpl.GetServerName();
                    object = cTConnectionRequestInfoImpl.GetDatabaseName();
                    n = cTConnectionRequestInfoImpl.GetSessionType();
                } else {
                    object2 = this.mngdConnFactory.getServerName();
                    object = this.mngdConnFactory.geDatabase();
                    n = this.mngdConnFactory.geSessionType();
                }
                this.activeConn = n == 1 || ((String)object).isEmpty() ? new CTConnectionImpl((String)object2, string2, string, this) : new CTConnectionImpl((String)object2, string2, string, (String)object, n, this);
                this.mngdConnMetaData.setEISProductName(this.activeConn.GetProductName());
                this.mngdConnMetaData.setEISProductVersion(this.activeConn.GetProductVersion());
                this.mngdConnMetaData.setMaxConnections(this.activeConn.GetMaxConnections());
                this.mngdConnMetaData.setUserName(this.activeConn.GetUserLogonName());
            } else if (!string2.equalsIgnoreCase(this.activeConn.GetUserLogonName()) || !string.equals(this.activeConn.GetPassword())) {
                int n;
                if (connectionRequestInfo != null) {
                    CTConnectionRequestInfoImpl cTConnectionRequestInfoImpl = (CTConnectionRequestInfoImpl)connectionRequestInfo;
                    object2 = cTConnectionRequestInfoImpl.GetServerName();
                    object = cTConnectionRequestInfoImpl.GetDatabaseName();
                    n = cTConnectionRequestInfoImpl.GetSessionType();
                } else {
                    object2 = this.mngdConnFactory.getServerName();
                    object = this.mngdConnFactory.geDatabase();
                    n = this.mngdConnFactory.geSessionType();
                }
                if (n == 1 || ((String)object).isEmpty()) {
                    this.activeConn.reAuthenticate((String)object2, string2, string, this);
                } else {
                    this.activeConn.reAuthenticate((String)object2, string2, string, (String)object, n, this);
                }
                this.mngdConnMetaData.setUserName(this.activeConn.GetUserLogonName());
            }
        }
        catch (CTException cTException) {
            Logger.getLogger(CTManagedConnectionImpl.class.getName()).log(Level.SEVERE, "[" + cTException.GetErrorCode() + "] " + cTException.GetErrorMsg(), cTException);
            this.fireConnectionEvent(5, (Exception)((Object)cTException));
            throw new SecurityException("Couldn't getConnection", cTException);
        }
        return this.activeConn;
    }

    public void destroy() throws ResourceException {
        if (this.activeConn != null) {
            this.activeConn.close();
            this.fireConnectionEvent(1, null);
        }
    }

    public void cleanup() throws ResourceException {
    }

    public void associateConnection(Object object) throws ResourceException {
        CTConnectionImpl cTConnectionImpl = (CTConnectionImpl)object;
        cTConnectionImpl.UpdateManagedConnection(this);
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener != null) {
            this.listeners.add(connectionEventListener);
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener != null) {
            this.listeners.remove(connectionEventListener);
        }
    }

    public XAResource getXAResource() throws ResourceException {
        if (this.ctXAResource == null && this.activeConn != null) {
            this.ctXAResource = new CTXAResourceImpl(this);
        }
        return this.ctXAResource;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (this.activeConn != null && this.ctLocalTransaction == null) {
            this.ctLocalTransaction = new CTLocalTransactionImpl(this);
        }
        return this.ctLocalTransaction;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return this.mngdConnMetaData;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public void disassociateConnection() {
        this.activeConn = null;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mngdConnFactory;
    }

    public Connection GetActiveConnection() {
        return this.activeConn;
    }

    public void fireConnectionEvent(int n, Exception exception) {
        ConnectionEvent connectionEvent = null;
        connectionEvent = exception == null ? new ConnectionEvent((ManagedConnection)this, n) : new ConnectionEvent((ManagedConnection)this, n, exception);
        connectionEvent.setConnectionHandle((Object)this.activeConn);
        ArrayList<ConnectionEventListener> arrayList = new ArrayList<ConnectionEventListener>(this.listeners);
        for (ConnectionEventListener connectionEventListener : arrayList) {
            switch (n) {
                case 1: {
                    connectionEventListener.connectionClosed(connectionEvent);
                    break;
                }
                case 5: {
                    connectionEventListener.connectionErrorOccurred(connectionEvent);
                    break;
                }
                case 3: {
                    connectionEventListener.localTransactionCommitted(connectionEvent);
                    break;
                }
                case 4: {
                    connectionEventListener.localTransactionRolledback(connectionEvent);
                    break;
                }
                case 2: {
                    connectionEventListener.localTransactionStarted(connectionEvent);
                }
            }
        }
    }

    public CTSession GetCTSession() {
        return this.activeConn.GetCTSession();
    }
}

