/*
 * Decompiled with CFR 0.152.
 */
package FairCom.RA.spi;

import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTSession;
import FairCom.RA.spi.CTManagedConnectionImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class CTXAResourceImpl
implements XAResource {
    private CTManagedConnectionImpl mngdConn;
    private HashMap activeBranches;
    private HashMap preparedBranches;

    public CTXAResourceImpl(CTManagedConnectionImpl cTManagedConnectionImpl) {
        this.mngdConn = cTManagedConnectionImpl;
        this.activeBranches = new HashMap();
        this.preparedBranches = new HashMap();
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        try {
            if (bl) {
                this.prepare(xid);
            }
            this.mngdConn.GetCTSession().Commit();
            this.preparedBranches.remove(xid);
        }
        catch (CTException cTException) {
            Logger.getLogger(CTXAResourceImpl.class.getName()).log(Level.SEVERE, "[" + cTException.GetErrorCode() + "] " + cTException.GetErrorMsg(), cTException);
            throw new XAException("Couldn't Commit a XA transaction");
        }
    }

    @Override
    public void end(Xid xid, int n) throws XAException {
    }

    @Override
    public void forget(Xid xid) throws XAException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (xAResource instanceof CTXAResourceImpl) {
            return xAResource.hashCode() == this.hashCode();
        }
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        try {
            this.mngdConn.GetCTSession().PrepareCommit();
            this.activeBranches.remove(xid);
            this.preparedBranches.put(xid, null);
        }
        catch (CTException cTException) {
            Logger.getLogger(CTXAResourceImpl.class.getName()).log(Level.SEVERE, "[" + cTException.GetErrorCode() + "] " + cTException.GetErrorMsg(), cTException);
            throw new XAException("Couldn't PrepareCommit for a XA transaction");
        }
        return 0;
    }

    @Override
    public Xid[] recover(int n) throws XAException {
        return (Xid[])this.preparedBranches.keySet().toArray();
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.mngdConn.GetCTSession().Abort();
            Collection collection = (Collection)this.activeBranches.get(xid);
            if (collection != null) {
                this.activeBranches.remove(xid);
            } else {
                collection = (Collection)this.preparedBranches.get(xid);
                if (collection != null) {
                    this.preparedBranches.remove(xid);
                }
            }
        }
        catch (CTException cTException) {
            Logger.getLogger(CTXAResourceImpl.class.getName()).log(Level.SEVERE, "[" + cTException.GetErrorCode() + "] " + cTException.GetErrorMsg(), cTException);
            throw new XAException("Couldn't Rollback a XA transaction");
        }
    }

    @Override
    public boolean setTransactionTimeout(int n) throws XAException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void start(Xid xid, int n) throws XAException {
        this.startTwoPhaseCommit(this.mngdConn.GetCTSession());
    }

    private void startTwoPhaseCommit(CTSession cTSession) throws XAException {
        try {
            cTSession.SetTransactionMode(16);
            cTSession.Begin();
        }
        catch (CTException cTException) {
            Logger.getLogger(CTXAResourceImpl.class.getName()).log(Level.SEVERE, "[" + cTException.GetErrorCode() + "] " + cTException.GetErrorMsg(), cTException);
            throw new XAException("Couldn't Start a XA transaction");
        }
    }
}

