#!/bin/bash
# script must be run as sudo
export PATH=$PATH:/usr/local/bin/
shopt -s nocasematch

config=`cat cluster.json`


numargs=$#
if [ $numargs != 2 ] ; then
	echo "$0 Usage"
	echo "setup.sh node <n>"
	echo ""
        echo "where <n> is the node number of node setup is run on."
	echo $numargs
	exit 1
fi

if [ "$1" = "node" ]; then
	if [ "$2" = "1" ] ; then 
		nodearg1=yes
		nodearg2=no
		echo "Running as node 1"
	fi
	if [ "$2" = "2" ] ; then 
		nodearg1=no
		nodearg2=yes
		echo "Running as node 2"
	fi
fi

echo "node 1 $nodearg1"
echo "node 2 $nodearg2"


cluster_name=`echo $config |            jq -r '. | "\(.cluster_name)" '`
cluster_cib=`echo $config |             jq -r '. | "\(.cluster_cib)" '`

fdb_resource_script=`echo $config |     jq -r '. | "\(.fdb_resource_script)" '`
fdb_resource_name=`echo $config |     jq -r '. | "\(.fdb_resource_name)" '`

fdb_install_dir=`echo $config |         jq -r '. | "\(.fdb_install_dir)" '`
fdb_workding_dir=`echo $config |        jq -r '. | "\(.fdb_workding_dir)" '`

fdb_user_account=`echo $config |        jq -r '. | "\(.fdb_user_account)" '`
fdb_group_account=`echo $config |       jq -r '. | "\(.fdb_group_account)" '`

node1=`echo $config |                   jq -r '. | "\(.node1)" '`
node1_fdb_name=`echo $config |          jq -r '. | "\(.node1_fdb_name)" '`
node1_isam_port=`echo $config |         jq -r '. | "\(.node1_isam_port)" '`
node1_sql_port=`echo $config | jq -r '. | "\(.node1_sql_port)" '`
node1_vm_name=`echo $config |           jq -r '. | "\(.node1_vm_name)" '`
node1_repl_port=`echo $config | jq -r '. | "\(.node1_repl_port)" '`

node2=`echo $config | jq -r '. | "\(.node2)" '`
node2_fdb_name=`echo $config | jq -r '. | "\(.node2_fdb_name)" '`
node2_isam_port=`echo $config | jq -r '. | "\(.node2_isam_port)" '`
node2_sql_port=`echo $config | jq -r '. | "\(.node2_sql_port)" '`
node2_vm_name=`echo $config | jq -r '. | "\(.node2_vm_name)" '`
node2_repl_port=`echo $config | jq -r '. | "\(.node2_repl_port)" '`

cluster_vip_name=`echo $config | jq -r '. | "\(.cluster_vip_name)" '`
cluster_ip=`echo $config | jq -r '. | "\(.cluster_ip)" '`

node_monitor_timeout=`echo $config | jq -r '. | "\(.node_monitor_timeout)" '`
node_monitor_interval=`echo $config | jq -r '. | "\(.node_monitor_interval)" '`
node_role=`echo $config | jq -r '. | "\(.node_role)" '`

fencing=`echo $config | jq -r '. |"\(.fencing)" '`
cluster_fence_name=`echo $config | jq -r '. | "\(.cluster_fence_name)" '`
vm_host=`echo $config | jq -r '. | "\(.vm_host)" '`
vm_logon=`echo $config | jq -r '. | "\(.vm_logon)" '`
vm_passwd=`echo $config | jq -r '. | "\(.vm_passwd)" '`

alerts=`echo $config | jq -r '. | "\(.alerts)" '`
cluster_alert_name=`echo $config | jq -r '. | "\(.cluster_alert_name)" '`
cluster_alert_script=`echo $config | jq -r '. | "\(.cluster_alert_script)" '`

replication_config=`echo $config | jq -r '. | "\(.replication_config)" '`
file_filter_xml=`echo $config | jq -r '. | "\(.file_filter_xml)" '`

bin_dir=`echo $config | jq -r '. | "\(.bin_dir)" '`


# Get a sane screen width
[ -z "${COLUMNS:-}" ] && COLUMNS=80

    BOOTUP=color
    RES_COL=80
    MOVE_TO_COL="echo -en \\033[${RES_COL}G"
    SETCOLOR_SUCCESS="echo -en \\033[1;32m"
    SETCOLOR_FAILURE="echo -en \\033[1;31m"
    SETCOLOR_WARNING="echo -en \\033[1;33m"
    SETCOLOR_NORMAL="echo -en \\033[0;39m"

function display_status {

  [ "$BOOTUP" = "color" ] && $MOVE_TO_COL
  echo -n "["
if [[ 0 == $1 ]]; then
  [ "$BOOTUP" = "color" ] && $SETCOLOR_SUCCESS
  echo -n $"  OK  "
else
  [ "$BOOTUP" = "color" ] && $SETCOLOR_FAILURE
  echo -n $"FAILED"
fi
[ "$BOOTUP" = "color" ] && $SETCOLOR_NORMAL
  echo -n "]"
  echo -ne "\r\n"

  if [[ 0 -ne $1 ]]; then
     printf "\t%s" $retstr
  fi

}

#source config.sh
#source status.sh
ret_g=0


# Check for FairCom DB installation
printf "Check for FairCom DB installation"
retstr=`test -d "$fdb_install_dir"`
ret=$?
display_status $ret $retstr
if [ 0 -ne $ret ] ; then exit 1
fi

printf "Check for faircom exeutable"
retstr=`test -f "$fdb_install_dir/server/faircom"`
ret=$?
display_status $ret $retstr
if [ 0 -ne $ret ] ; then exit 1
fi

#Set up firewall portsa
echo "Check and set firewall ports if needed"
reload_flag="false"

printf "Checking port $node1_isam_port"
retstr=`firewall-cmd --list-ports | grep  $node1_isam_port`
ret=$?
display_status $ret $retstr

if [ 0 -ne $ret ] ; then
	printf "\nSetting port $node1_isam_port"
	retstr=`firewall-cmd --zone=public --permanent --add-port=$node1_isam_port/tcp`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`
	reload_flag="true"
fi

printf "Checking port $node1_sql_port"
retstr=`firewall-cmd --list-ports | grep $node1_sql_port`
ret=$?
display_status $ret $retstr

if [ 0 -ne $ret ] ; then
        printf "setting $node1_sql_port"
	retstr=`firewall-cmd --zone=public --permanent --add-port=$node1_sql_port/tcp`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`
	reload_flag="true"
fi

printf "Checking port $node1_repl_port"
retstr=`firewall-cmd --list-ports | grep $node1_repl_port`
ret=$?
display_status $ret $retstr

if [ 0 -ne $ret ] ; then
        printf "setting $node1_repl_port"
	retstr=`firewall-cmd --zone=public --permanent --add-port=$node1_repl_port/tcp`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`
	reload_flag="true"
fi

if [ "$reload_flag" == "true" ]; then
	printf "Reloading firewall... "
	retstr=`firewall-cmd --reload`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`
else
	echo "No firewall changes"
fi


#setup  utility links 
printf "Checking ctstop link"
retstr=`test -f "$bin_dir/ctstop"`
ret=$?
display_status $ret "    link doesn't exist"
	
if [ 0 -ne $ret ] ; then
	printf "Create ctstop link"
	retstr=`ln -s $fdb_install_dir/tools/ctstop $bin_dir/ctstop`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`
fi

printf "Checking ctstat link"
retstr=`test -f "$bin_dir/ctstat"`
ret=$?
display_status $ret "    link doesn't exist"

if [ 0 -ne $ret ] ; then
	printf "Create ctstat link"
	retstr=`ln -s $fdb_install_dir/tools/ctstat $bin_dir/ctstat`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`
fi

printf "Checking ctsmon link"
retstr=`test -f "$bin_dir/ctsmon"`
ret=$?
display_status $ret "    link doesn't exist"

if [ 0 -ne $ret ] ; then
	printf "Create ctsmon link"
	retstr=`ln -s $fdb_install_dir/tools/ctsmon $bin_dir/ctsmon`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`
fi

printf "Checking repadm link"
retstr=`test -f "$bin_dir/repadm"`
ret=$?
display_status $ret "    link doesn't exist"

if [ 0 -ne $ret ] ; then
	printf "Create repadm link"
	retstr=`ln -s $fdb_install_dir/tools/repadm $bin_dir/repadm`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`
fi

printf "Checking startserver link"
retstr=`test -f "$bin_dir/startserver"`
ret=$?
display_status $ret "    link doesn't exist"

if [ 0 -ne $ret ] ; then
	printf "Create startserver link"
	retstr=`ln -s $fdb_install_dir/server/startserver $bin_dir/startserver`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`
fi

printf "Checking stopserver link"
retstr=`test -f "$bin_dir/stopserver"`
ret=$?
display_status $ret "    link doesn't exist"

if [ 0 -ne $ret ] ; then
	printf "Create stopserver link"
	retstr=`ln -s $fdb_install_dir/server/stopserver $bin_dir/stopserver`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`
fi

printf "Checking getsyncstate link"
retstr=`test -f "$bin_dir/getsyncstate"`
ret=$?
display_status $ret "    link doesn't exist"

if [ 0 -ne $ret ] ; then
	printf "Create getsyncstate link"
	retstr=`ln -s $fdb_install_dir/server/getsyncstate $bin_dir/getsyncstate`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`
fi

printf "Checking setsyncstate link"
retstr=`test -f "$bin_dir/setsyncstate"`
ret=$?
display_status $ret "    link doesn't exist"

if [ 0 -ne $ret ] ; then
	printf "Create setsyncstate link"
	retstr=`ln -s $fdb_install_dir/server/setsyncstate $bin_dir/setsyncstate`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`
fi



# Reset FairCom DB server enviorment
#retstr=`stopserver`
#echo $retstr
#sleep 45
	printf "Clearing old data"
	retstr=`rm -rf $fdb_installdir/data/*`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`
#retstr=`startserver`
#sleep 45
#echo $retstr


# Configure syncrhonous replicaiton
echo "Check for replication config file"
retstr=`test -f "$replication_config"`
ret=$?
display_status $ret $retstr

if [ 0 -ne $ret ] ; then
	printf "Check if replicaiton configuration includes synchronous support"
	retstr=`grep syncagent $replication_config >/dev/null`
	ret=$?
	display_status $ret $retstr

	if [ 0 -ne $ret ] ; then
		printf "    attempting to add entry"
		retstr=`echo "    syncagent    yes" >> $replication_config`
		ret=$?
		display_status $ret $retstr
		ret_g=`expr $ret_g + $ret`
	fi

	printf "Check for file filter support"
	retstr=`grep file_filter $replication_config >/dev/null`
	ret=$?
	display_status $ret $retstr

	if [ 0 -ne $ret ] ; then
		printf "    attempting to add entry"
		retstr=`echo "    file_filter <$file_filter_xml" >> $replication_config`
		ret=$?
		display_status $ret $retstr
		ret_g=`expr $ret_g + $ret`
	fi
fi

printf "Check for synchoronous file definitons"
retstr=`test -f "$fdb_install_dir/server/$file_filter_xml"`
ret=$?
display_status $ret $retstr
if [ 0 -ne $ret ] ; then
	printf "\t$file_filter_xml is required"
	exit 1
fi


# L E G A C Y 

#echo "Enable FairCom DB synchronous replication"
#repadm -c addsyncagent node2 -s $node1_fdb_name@$node1
#repadm -c addsyncagent node1 -s $node2_fdb_name@$node2

#echo "Set FairCom DB files for synchronous replication"
#repadm -c addsyncagentfilemap ./ctreeSQL.dbs/admin_test.dat $node2 -s $node1_fdb_name@$node1 
#repadm -c addsyncagentfilemap ./ctreeSQL.dbs/admin_test.dat $node1 -s $node2_fdb_name@$node2


printf "Check resource script is installed"
retstr=`test -f "/usr/lib/ocf/resource.d/heartbeat/$fdb_resource_script"`
ret=$?
display_status $ret $retstr
ret_g=`expr $ret_g + $ret`



echo "Check current cluster status"
retstr=`pcs cluster status`
ret=$?
display_status $ret $retstr
ret_g=`expr $ret_g + $ret`


echo ""
echo "The following steps only take place if specified from primary node 1"
echo "If specified from secondary node 2 further ressource setup is skipped"
echo "running as node 1? : $nodearg1 "

if [[ "$nodearg1" = "yes" ]] ;  then

# The following step must take place after the cluster status is checked
# and depends on the return value.
	if [ $ret -eq 0 ] ; then
		echo "Authenticate hosts. You'll be promoted for the hacluster user and password."
		echo "Take down existing cluster configuration"
		retstr=`pcs cluster destroy --all`
		ret=$?
		display_status $ret $retstr
		ret_g=`expr $ret_g + $ret`
	fi


	echo "Authenticate hosts. You'll be promoted for the hacluster user and password."
	pcs host auth  node1  node2


	echo "Setup cluster with $node1 and $node2"
	retstr=`pcs cluster setup faircomdb_cluster  node1 node2`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`


	echo "Start cluster "
	retstr=`pcs cluster start --all`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`


	echo "Create CIB"
	retstr=`pcs cluster cib $cluster_cib` 
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`


	echo "Enable cluster start on boot"
	retstr=`pcs cluster enable --all`	
	ret=$?		
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`


	# Create Resources
	printf "Create Virtual IP $cluster_vip_name cluster resource"
	retstr=`pcs -f $cluster_cib resource create $cluster_vip_name IPaddr2  \
		ip=$cluster_ip \
	        cidr_netmask=22 \
	        op monitor interval=30`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`

	printf "Create $fdb_resource_name cluster resource"
	retstr=`pcs -f $cluster_cib resource create $fdb_resource_name ocf:heartbeat:$fdb_resource_script  \
		binary=/usr/local/bin/startserver \
		config=$fdb_install_dir/server/config/ctsrvr.cfg \
		ctsmon=/usr/local/bin/ctsmon \
		ctstop=/usr/local/bin/ctstop \
		repadmn=/usr/local/rpadm \
		faircomdb_adminpass=$node1_fdb_adminpass \
		faircomdb_servername=$node1_fdb_name \
		faircomdb_working_directory=$fdb_workding_dir \
		user=$fdb_user_account \
		pid=/var/run/faircomdb.pid `
	# 	optional 
	#	--group ctree-group \
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`

	printf "Make $fdb_resource_name promotable"
	retstr=`pcs -f $cluster_cib resource promotable $fdb_resource_name \
		master-max=1 \
		master-node-max=1 \
		clone-max=2 \
		clone-node-max=1 \
		notify=true`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`
	 
	printf "Add monitor operation to $fdb_resource_name"
	retstr=`pcs -f $cluster_cib resource op add $fdb_resource_name monitor 
		timeout=$node_monitor_timeout \
		interval=$node_monitor_interval \
		role=$node_role`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`

	echo "Update Resource"
	retstr=`pcs -f clcfg resource update faircomdb op promote timeout=120s`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`

	echo "Set resource startup timeout"
	retstr=`pcs -f clcfg resource update faircomdb op start timeout=120s`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`

	echo "Set resorce stop timeout"
	retstr=`pcs -f clcfg resource update faircomdb op stop timeout=120s`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`

	printf "Enable colocation constraint"
	retstr=`pcs -f $cluster_cib constraint colocation add $cluster_vip_name with master $fdb_resource_name-clone score=INFINITY`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`

	printf "Enable constraint start order"
	retstr=`pcs -f $cluster_cib constraint order start $fdb_resource_name-clone then start $cluster_vip_name`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`

	printf "Enable constraint promote order"
	retstr=`pcs -f $cluster_cib constraint order promote $fdb_resource_name-clone then start $cluster_vip_name`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`

	echo "No quorum for only 2 nodes"
	retstr=`pcs -f clcfg property set no-quorum-policy=ignore`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`

	echo "Don't failover during normal operations"
	retstr=`pcs -f clcfg resource defaults update resource-stickiness=INFINITY`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`

	echo "Failover on first error"
	retstr=`pcs -f clcfg resource defaults update migration-threshold=1`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`

	echo "Allow failed resource to resume being master after 60 seconds"
	retstr=`pcs -f clcfg resource defaults update failure-timeout=60`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`

	echo "Apply all CIB changes"
	retstr=`pcs cluster cib-push clcfg`
	ret=$?
	display_status $ret $retstr
	ret_g=`expr $ret_g + $ret`


	printf  "Check if fencing should be enabled\n"
	if [ "$fencing" == "vmware_soap" ]; then
		printf  "Enabling VMWare SOAP fence agent"
		retstr=`pcs stonith create $cluster_fence_name $cluster_fence_script 
			pcmk_host_map="<$node1_vm_name; $node1_vm_name" 
			ipaddr=$vm_host 
			ssl_insecure=1 
			login=$vm_logon
			passwd=$vm_passwd`
		ret=$?
		display_status $ret $retstr
		ret_g=`expr $ret_g + $ret`
	
		retstr=`pcs property set stonith-enabled=$fencing`
		ret=$?
		display_status $ret $retstr
		ret_g=`expr $ret_g + $ret`
		
	else
		printf  "No fence agent enabled\n"
	fi
	

	printf "Check if alerts should be enabled\n"
	if [ "$alerts" == "true" ]; then
		retstr=`test -f "$bin_dir/$cluster_alert_script"`
		ret=$?
		display_status $ret $retstr
		ret_g=`expr $ret_g + $ret`
			
		if [ 0 -ne $ret  ] ; then
			echo "Failover script not found"
		else
			printf  "Enabling alert agent"
			retstr=`pcs  alert create id=$cluster_alert_name path=$cluster_alert_script \
					description="Script to be run at failover" `
			ret=$?
			display_status $ret $retstr
			ret_g=`expr $ret_g + $ret`
		fi
	else
		printf "No alerts enabled\n"
	fi


else
	echo "$fdb_resource_name setup skipped as assumed run from node 1"
fi

echo ""
echo "Setup Complete"
echo ""

exit 0
