/*
 *      OFFICIAL NOTIFICATION: the following CONFIDENTIAL and PROPRIETARY 
 * 	property legend shall not be removed from this source code module 
 * 	for any reason.
 *
 *	This program is the CONFIDENTIAL and PROPRIETARY property 
 *	of FairCom(R) Corporation. Any unauthorized use, reproduction or
 *	transfer of this computer program is strictly prohibited. The 
 *      contents of this file may not be disclosed to third parties, copied or
 *      duplicated in any form, in whole or in part, without the prior written
 *      permission of the FairCom(R) Corporation.
 *
 *      Copyright (c) 1992 - 2023 FairCom Corporation.
 *	This is an unpublished work, and is subject to limited distribution and
 *	restricted disclosure only. ALL RIGHTS RESERVED.
 *
 *			RESTRICTED RIGHTS LEGEND
 *	Use, duplication, or disclosure by the Government is subject to
 *	restrictions set forth in subparagraph (c)(1)(ii) of the Rights in
 * 	Technical Data and Computer Software clause at DFARS 252.227-7013, and/or
 *      in similar or successor clauses in the FAR, DOD or NASA FAR Supplement.
 *      Unpublished rights reserved under the Copyright Laws of the United States.
 *	FairCom Corporation, 6300 West Sugar Creek Drive, Columbia, MO 65203.
 *
 *	c-treeACE(tm)	Version 12
 */

#define CT_VERSION "12.0.2.278(211111)" /* FcLibMasterVERSIONSTAMP  ctreeacu:1 - DO NOT REMOVE THIS COMMENT */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef _WIN32
#include <windows.h>
/* If using Visual Studio 2005 or later: */
#if ( _MSC_VER >= 1400 )
/* Suppress "'function' was declared deprecated" warning */
#pragma warning(disable : 4996)
#endif
#else
#include <dlfcn.h>
#endif

typedef struct {

/*  Indexed file functions  */

    int      (*p_init) (int, int *);
    void     (*p_exit) (void);
    int      (*p_make) (char *, char *, char *, char *, char *, char *);
    void     *(*p_open) (char *, int, char *);
    int      (*p_close) (void *);
    unsigned (*p_read) (void *, char *, int);
    unsigned (*p_next) (void *, char *);
    unsigned (*p_previous) (void *, char *);
    int      (*p_start) (void *, char *, int, int, int);
    int      (*p_write) (void *, char *, unsigned);
    int      (*p_rewrite) (void *, char *, unsigned);
    int      (*p_delete) (void *, char *);
    int      (*p_unlock) (void *);
    int      (*p_info) (void *, int, char *);
    void     (*p_sync) (int);
    int      (*p_remove) (char *);
    int      (*p_rename) (char *, char *);
    int      (*p_version) (char *, char *, char *, int, long*);
    void     (*p_abilities) (void *);
    int      (*p_execute) (char *, char *);
    int      (*p_copy) (char *, char *);
    int      (*p_begin) (void);
    int      (*p_commit) (int);
    int      (*p_rollback) (int);
    int      (*p_recover) (void);

/*  Setup file functions  */

    void     *(*p_register) (char *, void *);
    void     (*p_init_cfg) (void);

/*  Relative file functions  */

    int      (*pr_init) (void);
    void     (*pr_exit) (void);
    int      (*pr_make) (char *, char *, long);
    void     *(*pr_open)  (char *, int, unsigned, unsigned, long);
    int      (*pr_unlock) (void *);
    int      (*pr_close) (void *);
    unsigned (*pr_read) (void *, char *, long);
    unsigned (*pr_next) (void *, char *);
    unsigned (*pr_previous) (void *, char *);
    int      (*pr_start) (void *, long, int);
    int      (*pr_write)  (void *, char *, unsigned, long);
    int      (*pr_delete) (void *, long);
    int      (*pr_rewrite) (void *, char *, unsigned, long);
    int      (*pr_remove) (char *);
    int      (*pr_rename) (char *, char *);
    int      (*pr_copy) (char *, char *);
    int      (*pr_info) (void *, int, char *);

/*  Sequential file functions  */

    int      (*ps_exit) (void *, int);
    int      (*ps_make) (char *, char *);
    void     *(*ps_open) (char *, int, unsigned, int, unsigned, int, char *, int);
    int      (*ps_close) (void *, int);
    int      (*ps_read) (void *, char *);
    int      (*ps_write) (void *, char *, unsigned, int);
    int      (*ps_rewrite) (void *, char *, unsigned);
    int      (*ps_remove) (char *);
    int      (*ps_rename) (char *, char *);
    int      (*ps_copy) (char *, char *);
    void     *(*ps_seek) (void *, void *, int);
    int      (*ps_info) (void *, int, char *);

/*  Compatibility for future additions */
    
	void     (*p_future[8]) (void);

} FS_DISPATCH;

typedef short *(*p_Astdlib_f_errno) (void);
typedef long  *(*p_Astdlib_f_int_errno) (void);
typedef long  *(*p_Astdlib_f_int2_errno) (void);
typedef short *(*p_Astdlib_f_no_lock) (void);
typedef char  **(*p_Astdlib_f_errmsg) (void);

typedef void (*p_SetCobolErrorFunctions) (
	p_Astdlib_f_errno,
	p_Astdlib_f_int_errno,
	p_Astdlib_f_int2_errno,
	p_Astdlib_f_no_lock,
	p_Astdlib_f_errmsg);

typedef short *(*p_Avision_i_implied_transaction) (void);
typedef short *(*p_Avision_i_in_commit) (void);
typedef short *(*p_Avision_i_in_transaction) (void);

typedef void (*p_SetVisionInfoFunctions) (
	p_Avision_i_implied_transaction,
	p_Avision_i_in_commit,
	p_Avision_i_in_transaction);

typedef struct _CT_FUNC {
	void (*ptr)(void);
	char *name;
} CT_FUNC;

CT_FUNC ct_errfunc[] = {
	/* ptr	name */
	{NULL,	"ct_SetVisionInfoFunctions"},
	{NULL,	"ct_SetCobolErrorFunctions"}
};

typedef int      (*p_init) (int, int *);
typedef void     (*p_exit) (void);
typedef int      (*p_make) (char *, char *, char *, char *, char *, char *);
typedef void     *(*p_open) (char *, int, char *);
typedef int      (*p_close) (void *);
typedef unsigned (*p_read) (void *, char *, int);
typedef unsigned (*p_next) (void *, char *);
typedef unsigned (*p_previous) (void *, char *);
typedef int      (*p_start) (void *, char *, int, int, int);
typedef int      (*p_write) (void *, char *, unsigned);
typedef int      (*p_rewrite) (void *, char *, unsigned);
typedef int      (*p_delete) (void *, char *);
typedef int      (*p_unlock) (void *);
typedef int      (*p_info) (void *, int, char *);
typedef void     (*p_sync) (int);
typedef int      (*p_remove) (char *);
typedef int      (*p_rename) (char *, char *);
typedef int      (*p_version) (char *, char *, char *, int, long*);
typedef void     (*p_abilities) (void *);
typedef int      (*p_execute) (char *, char *);
typedef int      (*p_copy) (char *, char *);
typedef int      (*p_begin) (void);
typedef int      (*p_commit) (int);
typedef int      (*p_rollback) (int);
typedef int      (*p_recover) (void);
typedef void     *(*p_register) (char *, void *);
typedef void     (*p_init_cfg) (void);
typedef void *   (*p_XDDOpen) (int, char *);
typedef long     (*p_XDDCheck) (void *, unsigned char *, long buflen, char *, long *, long *, long *);
typedef void     (*p_XDDClose) (void *);
typedef int      (*p_lockerid) (long *);

CT_FUNC ct_func[] = {
	/* ptr	name */
	{NULL,	"ct_init"},
	{NULL,	"ct_exit"},
	{NULL,	"ct_make"},
	{NULL,	"ct_open"},
	{NULL,	"ct_close"},
	{NULL,	"ct_read"},
	{NULL,	"ct_next"},
	{NULL,	"ct_previous"},
	{NULL,	"ct_start"},
	{NULL,	"ct_write"},
	{NULL,	"ct_rewrite"},
	{NULL,	"ct_delete"},
	{NULL,	"ct_unlock"},
	{NULL,	"ct_info"},
	{NULL,	"ct_sync"},
	{NULL,	"ct_remove"},
	{NULL,	"ct_rename"},
	{NULL,	"ct_version"},
	{NULL,	"ct_abilities"},
	{NULL,	"ct_execute"},
	{NULL,	"ct_copy"},
	{NULL,	"ct_begin"},
	{NULL,	"ct_commit"},
	{NULL,	"ct_rollback"},
	{NULL,	"ct_recover"},
	{NULL,	NULL},
	{NULL,	"ct_init_cfg"},
	{NULL,	"ct_XDDOpen"},
	{NULL,	"ct_XDDCheck"},
	{NULL,	"ct_XDDClose"},
	{NULL,	"ct_lockerid"}
};

#ifdef _WIN32
#ifndef MAXULONG_PTR
typedef DWORD *DWORD_PTR;
#endif
#endif

void ctDisplayErrorMessage(const char *message, const char* target)
{
#ifdef _WIN32
	LPCTSTR lpszTitle = TEXT("Error");
	LPVOID lpSysErrMsg;
	DWORD nSysErr = GetLastError(); 
	LPVOID lpDisplayMsg;
	SIZE_T nDisplayMsgLen;
	LPCTSTR lpszDisplayMsgFmt = TEXT("%s %s.\n%s");
	DWORD_PTR pSysErrArgs[] = { (DWORD_PTR)0 };
	
	pSysErrArgs[0] = (DWORD_PTR)target;

	if (message == NULL)
		message = "";
	if (target == NULL)
		target = "(null)";

	FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM |
		FORMAT_MESSAGE_ARGUMENT_ARRAY,
		NULL,
		nSysErr,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
		(LPTSTR) &lpSysErrMsg,
		0, (va_list*)pSysErrArgs );


	nDisplayMsgLen = lstrlen(message) + lstrlen(target) + lstrlen(lpszDisplayMsgFmt) + lstrlen(lpSysErrMsg);
	lpDisplayMsg = (LPVOID)LocalAlloc(LMEM_ZEROINIT, nDisplayMsgLen * sizeof(TCHAR));

	sprintf((LPTSTR)lpDisplayMsg, lpszDisplayMsgFmt, message, target, lpSysErrMsg);

	MessageBox(NULL, (LPCTSTR)lpDisplayMsg, lpszTitle, MB_OK|MB_ICONHAND);

	LocalFree(lpSysErrMsg);
	LocalFree(lpDisplayMsg);
#else
	const char *fmtstr = {"%s: %s\n\r"};
	fprintf(stderr, fmtstr, message, target);
	fprintf(stderr, "%s\n\r", dlerror());
#endif
	return;
}

const char* ctGetLibraryName(void)
{
#ifdef _WIN32
	const char *defnam = "mtclient.dll";
#else
	const char *defnam = "libmtclient.so";
#endif
	const char *envvar = "CTREE_LIB";
	const char *libnam = getenv(envvar);
	if (libnam == NULL || strlen(libnam) < 1)
		return defnam;
	else
		return libnam;
}

void* ctLoadLibrary(const char *name)
{
	void *handle;

#ifdef _WIN32
	handle = LoadLibrary(name);
#else
	handle = dlopen(name, RTLD_NOW);
#endif
	return handle;
}

void ctFreeLibrary(void *handle)
{
	if (handle == NULL)
		return;
#ifdef _WIN32
	FreeLibrary((HINSTANCE)handle);
#else
	dlclose(handle);
#endif
	return;
}

void (*ctGetProcAddress(void* hlib, const char *name))(void)
{
#ifdef _WIN32
	return (void (*)(void))GetProcAddress((HINSTANCE)hlib, name);
#else
	return (void (*)(void))dlsym(hlib, name);
#endif
}

int ctGetFunctionAddress(void* hlib, CT_FUNC *func)
{
	int retval = 0;

	if (func->name != NULL)
	{
		func->ptr = ctGetProcAddress(hlib, func->name); 
		if (func->ptr == NULL) 
		{
			ctDisplayErrorMessage("Could not load function", func->name);
			retval++;
		}
	}

	return retval;
}

int ctGetFunctionsAddress(void* hlib, CT_FUNC *func, const unsigned nfunc)
{
	int retval = 0;
	unsigned i;

	for (i = 0; i < nfunc; i++)
	{
		retval += ctGetFunctionAddress(hlib, &func[i]);
	}

	return retval;
}

extern short *Astdlib_f_errno(void);
extern long  *Astdlib_f_int_errno(void);
extern long  *Astdlib_f_int2_errno(void);
extern short *Astdlib_f_no_lock(void);
extern char  **Astdlib_f_errmsg(void);
extern short *Avision_i_implied_transaction(void);
extern short *Avision_i_in_commit(void);
extern short *Avision_i_in_transaction(void);

void *ghLib = NULL;
int ct_init (int outer_vers, int *inner_vers)
{
	const char *libnam = ctGetLibraryName();
	ghLib = ctLoadLibrary(libnam);
	if (ghLib != NULL)
	{
		if (ctGetFunctionAddress(ghLib, &ct_errfunc[0]))
		{
			ctFreeLibrary(ghLib); 
			return 0;
		}
		else
		{
			((p_SetVisionInfoFunctions)ct_errfunc[0].ptr)(
				&Avision_i_implied_transaction,
				&Avision_i_in_commit,
				&Avision_i_in_transaction
			);
		}
		if (ctGetFunctionAddress(ghLib, &ct_errfunc[1]))
		{
			ctFreeLibrary(ghLib); 
			return 0;
		}
		else
		{
			((p_SetCobolErrorFunctions)ct_errfunc[1].ptr)(
				&Astdlib_f_errno,
				&Astdlib_f_int_errno,
				&Astdlib_f_int2_errno,
				&Astdlib_f_no_lock,
				&Astdlib_f_errmsg
			);
		}
		if (ctGetFunctionsAddress(ghLib, ct_func, sizeof(ct_func)/sizeof(CT_FUNC)))
		{
			ctFreeLibrary(ghLib); 
			return 0;
		}
	}
	else
	{
		ctDisplayErrorMessage("Could not load library", libnam);
		return 0;
	}

	return ((p_init)ct_func[0].ptr)(outer_vers, inner_vers);
}
void ct_exit (void)
{
	if (ct_func[1].ptr == NULL)
		return;
	((p_exit)ct_func[1].ptr)();

	ctFreeLibrary(ghLib); 
}
int ct_make (char *name, char *comment, char *p_parms, char *l_parms, char *keys, char *trans)
{
	if (ct_func[2].ptr == NULL)
		return 0;
	return ((p_make)ct_func[2].ptr)(name, comment, p_parms, l_parms, keys, trans);
}
void *ct_open (char *name, int mode, char *l_parms)
{
	if (ct_func[3].ptr == NULL)
		return NULL;
	return ((p_open)ct_func[3].ptr)(name, mode, l_parms);
}
int ct_close (void *file)
{
	if (ct_func[4].ptr == NULL)
		return 0;
	return ((p_close)ct_func[4].ptr)(file);
}
unsigned ct_read (void *file, char *rec, int keynum)
{
	if (ct_func[5].ptr == NULL)
		return 0;
	return ((p_read)ct_func[5].ptr)(file, rec, keynum);
}
unsigned ct_next (void *file, char *rec)
{
	if (ct_func[6].ptr == NULL)
		return 0;
	return ((p_next)ct_func[6].ptr)(file, rec);
}
unsigned ct_previous (void *file, char *rec)
{
	if (ct_func[7].ptr == NULL)
		return 0;
	return ((p_previous)ct_func[7].ptr)(file, rec);
}
int ct_start (void *file, char *rec, int keynum, int keysize, int mode)
{
	if (ct_func[8].ptr == NULL)
		return 0;
	return ((p_start)ct_func[8].ptr)(file, rec, keynum, keysize, mode);
}
int ct_write (void *file, char *rec, unsigned len)
{
	if (ct_func[9].ptr == NULL)
		return 0;
	return ((p_write)ct_func[9].ptr)(file, rec, len);
}
int ct_rewrite (void *file, char *rec, unsigned len)
{
	if (ct_func[10].ptr == NULL)
		return 0;
	return ((p_rewrite)ct_func[10].ptr)(file, rec, len);
}
int ct_delete (void *file, char *rec)
{
	if (ct_func[11].ptr == NULL)
		return 0;
	return ((p_delete)ct_func[11].ptr)(file, rec);
}
int ct_unlock (void *file)
{
	if (ct_func[12].ptr == NULL)
		return 0;
	return ((p_unlock)ct_func[12].ptr)(file);
}
int ct_info (void *file, int mode, char *result)
{
	if (ct_func[13].ptr == NULL)
		return 0;
	return ((p_info)ct_func[13].ptr)(file, mode, result);
}
void ct_sync (int mode)
{
	if (ct_func[14].ptr == NULL)
		return;
	((p_sync)ct_func[14].ptr)(mode);
}
int ct_remove (char *name)
{
	if (ct_func[15].ptr == NULL)
		return 0;
	return ((p_remove)ct_func[15].ptr)(name);
}
int ct_rename (char *from, char *to)
{
	if (ct_func[16].ptr == NULL)
		return 0;
	return ((p_rename)ct_func[16].ptr)(from, to);
}
int ct_version (char *name, char *file_version, char *int_version, int system_id, long *system_num)
{
	if (ct_func[17].ptr == NULL)
		return 0;
	if (int_version)
		strcpy(int_version, CT_VERSION);
	return ((p_version)ct_func[17].ptr)(name, file_version, NULL, system_id, system_num);
}
void ct_abilities (void *ab)
{
	if (ct_func[18].ptr == NULL)
		return;
	((p_abilities)ct_func[18].ptr)(ab);
}
int ct_execute (char *filesys, char *command)
{
	if (ct_func[19].ptr == NULL)
		return 0;
	return ((p_execute)ct_func[19].ptr)(filesys, command);
}
int ct_copy (char *from, char *to)
{
	if (ct_func[20].ptr == NULL)
		return 0;
	return ((p_copy)ct_func[20].ptr)(from, to);
}
int ct_begin (void)
{
	if (ct_func[21].ptr == NULL)
		return 0;
	return ((p_begin)ct_func[21].ptr)();
}
int ct_commit (int unknown)
{
	if (ct_func[22].ptr == NULL)
		return 0;
	return ((p_commit)ct_func[22].ptr)(unknown);
}
int ct_rollback (int unknown)
{
	if (ct_func[23].ptr == NULL)
		return 0;
	return ((p_rollback)ct_func[23].ptr)(unknown);
}
int ct_recover (void)
{
	if (ct_func[24].ptr == NULL)
		return 0;
	return ((p_recover)ct_func[24].ptr)();
}
void ct_init_cfg(void)
{
	if (ct_func[26].ptr == NULL)
		return;
	((p_init_cfg)ct_func[26].ptr)();
}

void *ct_XDDOpen(short signconv, char *text)
{
	if (ct_func[27].ptr == NULL)
		return(NULL);
	return ((p_XDDOpen)ct_func[27].ptr)(signconv, text);
}

long  ct_XDDCheck(void * hdl, unsigned char * buffer, long buflen, char * msg, long * offset, long * size, long * type)
{
	if (ct_func[28].ptr == NULL)
		return(0);
	return ((p_XDDCheck)ct_func[28].ptr)(hdl, buffer, buflen, msg, offset, size, type);
}

void ct_XDDClose(void *hdl)
{
	if (ct_func[29].ptr == NULL)
		return;
	((p_XDDClose)ct_func[29].ptr)(hdl);
}

int ct_lockerid(void)
{
	long lockerid = 0;

	if (ct_func[30].ptr == NULL)
		return 0;
	return (((p_lockerid)ct_func[30].ptr)(&lockerid)) ? (int)lockerid : 0;
}

FS_DISPATCH ct_dispatch = {
	ct_init,
	ct_exit,
	ct_make,
	ct_open,
	ct_close,
	ct_read,
	ct_next,
	ct_previous,
	ct_start,
	ct_write,
	ct_rewrite,
	ct_delete,
	ct_unlock,
	ct_info,
	ct_sync,
	ct_remove,
	ct_rename,
	ct_version,
	ct_abilities,
	ct_execute,
	ct_copy,
	ct_begin,
	ct_commit,
	ct_rollback,
	ct_recover,
	0,
	ct_init_cfg
};

#ifdef _MSC_VER
#pragma warning(disable : 4996) 
#endif
void ct_args_syntax(char *argv)
{
	const char *logname = getenv("CTREE_LOG");
	FILE *logfile = NULL;

	if (logname && strlen(logname))
	{
		if (!strcmp(logname, "-")) {
			logfile = stderr;
		} else {
			logfile = fopen(logname, "a");
		}
		if (logfile)
		{
			fprintf(logfile, "Argument syntax error: \"%s\"\n", argv);

			if (logfile != stderr)
				fclose(logfile);
		}
	}
}
/*
 * ct_exam_args() implements the "--setenv:variable=value" 
 * command-line option to set environment variables within
 * the ACUCOBOL runtime before programs are loaded.
 *
 * call ct_exam_args() from the exam_args() function in sub.c
 * by changing it as follows:

int ct_exam_args(int argc, char *argv[]);

int
exam_args(int argc, char *argv[])
{
    return ct_exam_args(argc, argv);
}

 */
int ct_exam_args(int argc, char *argv[])
{
	/* Comment in sub.c states that:
	 * "Return 0 for default handling by Acurun, -1 to halt or 1 to cause Acurun to ignore */
	int retval = 0;
	const char *optname = {"--setenv"};
	const int optlen = strlen(optname);
	int i;

	for (i=1; i<argc && argv[i]; i++)
	{
		if (!strncmp(argv[i], optname, optlen))
		{
			char *arg = strchr(argv[i]+optlen, ':');
			if (!arg || !*arg)
			{
				ct_args_syntax(argv[i]);
				retval = -1;
				break;
			}
			else
			if (!strchr(arg+1, '='))
			{
				ct_args_syntax(argv[i]);
				retval = -1;
			}
			else
			{
				putenv(arg+1);
				/* Comment in sub.c states that:
				 * "The runtime ignores all arguments that begin with a double dash (--)"
				 * but apparently it is not true therefore returning 1 */
				retval = 1;
			}
		}
	}

    return retval;
}

/* end of ctreeacu.c */
