       identification division.
       program-id.    xddchk.

       environment division.
       configuration section.
       input-output section.
       file-control.
       data division.
       file section.
       working-storage section.
       
       01  xdd-message PIC x(256) value spaces.
       01  record-area pic x(32756) value spaces.
       01  file-in-a   pic x(80) value spaces.
       01  xdd-in-a    pic x(80) value spaces.
       01  file-in     pic x(80) value spaces.
       01  xdd-in      pic x(80) value spaces.

       copy "xdddef.def".
       copy "filesys.def".
       77  file-handlein  pointer.
       77  len-rec-in           pic 9(5) value 0.
       
       procedure division chaining file-in-a xdd-in-a.
       MAIN.
           if file-in-a = spaces
              display "USAGE: xddchk <inputfile> <xddfile>"
              accept omitted
              goback 1
           end-if

           if xdd-in-a = spaces
              display "USAGE: xddchk <inputfile> <xddfile>"
              accept omitted
              goback 1
           end-if
           
           initialize file-in
           string file-in-a delimited by spaces
                    low-values delimited by size
                 into file-in.
                 
           initialize xdd-in
           string xdd-in-a delimited by spaces
                     low-values delimited by size
                  into xdd-in.
 
           perform READ-INFORMATION
           
           perform INIT-XDD
           
           perform until 1 = 2
              perform READ-IN-RECORD
              if E-NOT-FOUND
                 exit perform
              end-if
              if return-code not = 0 
                 set xdd-rec-len to return-code
                 perform  CHECK-XDD
              end-if              
           end-perform
           
           perform CLOSE-XDD.
           perform CLOSE-FILE.
           display "execution terminated".
           accept omitted. 
           goback.


       INIT-XDD.
           move A_NUM_CONV to xdd-numeric-convention
           CALL "XDDOPEN" USING
                           by value xdd-numeric-convention
                           by reference xdd-in 
                           RETURNING xdd-handle.
           if xdd-handle = 0
               display "xdd file not found " xdd-in
               accept omitted
               goback 1
           end-if.

        CHECK-XDD.
           set xdd-rec-ptr to address of record-area.
           

           CALL "XDDCHECK" USING by value xdd-handle 
                              by value xdd-rec-ptr 
                              by value xdd-rec-len 
                              by reference xdd-message
                              by reference xdd-field-position
                              by reference xdd-field-size
                              by reference xdd-field-type
                              RETURNING xdd-retcode.
           if xdd-retcode <> XDD_CONV_NOERR
               display ""
               display "error " xdd-retcode with no advancing
               display " for field at position " xdd-field-position
                       with no advancing
               display " size " xdd-field-size with no advancing
               display " type " xdd-field-type
               display " " xdd-message
           else
               display "." with no advancing
           end-if.

        CLOSE-XDD.
           CALL "XDDCLOSE" USING by value xdd-handle.


        READ-INFORMATION.

           set OPEN-FUNCTION to true

           compute open_mode = Finput + Fread-lock

           inspect file_in replacing trailing spaces by low-values.
           inspect LOGICAL-INFO replacing trailing spaces by low-values.

           call "I$IO" using io_function 
                             file_in
                             open_mode
                             LOGICAL-INFO.

           move return_code  to file_handlein

           if return-code = 0
                display "File in "    no
                display file_in_a     no
                display " not found!" 
                accept omitted
                goback 1
           end-if.

           set INFO-FUNCTION      to true

           set GET-LOGICAL-PARAMS to true

           inspect LOGICAL-INFO replacing trailing spaces by low-values.

           call "I$IO" using io_function
                             file_handlein
                             info_mode
                             logical_info

           set GET-PHYSICAL-PARAMS to true

           inspect physical-info replacing trailing spaces 
                   by low-values.

           call "I$IO" using io_function
                             file_handlein
                             info_mode
                             physical-info.
 
        READ-IN-RECORD.
           move spaces to record-area.
           set NEXT-FUNCTION to true
           call "I$IO" using io_function file_handlein record-area.
           if return-code = 0
              if E-NOT-FOUND
                 continue
              end-if
           end-if.
        
        CLOSE-FILE.
           set CLOSE-FUNCTION to true
           call "I$IO" using io_function file_handlein.
        