      *
      * cscopy.cbl
      *
      * Public domain COBOL example
      *
      * FairCom Corporation, 6300 West Sugar Creek Drive, Columbia, MO 65203 USA
      *
      * Copy indexed file
      *

       IDENTIFICATION DIVISION.
       PROGRAM-ID.  cscopy.

       ENVIRONMENT DIVISION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       DATA DIVISION.
       WORKING-STORAGE SECTION.
       77  inpt                PIC X.
       77  arg1                PIC X(60).
       77  arg2                PIC X(60).
       77  SOURCE-FILE         PIC X(60).
       77  DEST-FILE           PIC X(60).
       77  FILE-TYPE           PIC X.
       77  COPY-STATUS         PIC 99.

       PROCEDURE DIVISION CHAINING arg1 arg2.

       main.
           IF arg1 = " " OR arg2 = " "
              DISPLAY "<" arg1 ">" " " "<" arg1 ">"
              DISPLAY "Usage: cscopy <source> <dest>"
           ELSE
              PERFORM CopyFile
           END-IF.
           DISPLAY " "
           DISPLAY "Press <ENTER> key to exit . . ."
           ACCEPT inpt

           STOP RUN.

       CopyFile.
           MOVE arg1 TO SOURCE-FILE
           MOVE arg2 TO DEST-FILE
           MOVE "I" TO FILE-TYPE.
           CALL "C$COPY" USING SOURCE-FILE, DEST-FILE, FILE-TYPE,
                             GIVING COPY-STATUS.
           DISPLAY "C$COPY returned " COPY-STATUS.
