      *
      * getinfo.cbl
      *
      * Public domain COBOL example
      *
      * FairCom Corporation, 6300 West Sugar Creek Drive, Columbia, MO 65203 USA
      *
      * Shows how to retrieve file information 
      *

       IDENTIFICATION DIVISION.
       PROGRAM-ID.  getinfo.

       ENVIRONMENT DIVISION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       DATA DIVISION.
       WORKING-STORAGE SECTION.
       01 inpt                         pic x.
       77  arg1                   PIC X(60).
       77  WS-NOME-FILE           PIC X(60).
       77  RISPX                  PIC X.
       01  AREA-INFO-FILE.
           02  WRK-PATH-FILE      PIC X(128).
           02  WRK-FILE-POINTER   POINTER.
           02  WRK-REC-SIZE       PIC 9(6).
           02  WRK-NUM-KEY        PIC 99.
           02  WRK-NUM-RECORD     PIC 9(6).
           02  WRK-FILE-SIZE      PIC 9(9).
           02  WRK-FILE-ERNO      PIC S9(5).

       COPY "FILESYS.DEF".

       PROCEDURE DIVISION CHAINING arg1.

       main.
           IF NOT arg1 = " "
              MOVE arg1 TO WS-NOME-FILE
              PERFORM GetInfo
              PERFORM DisplayInfo
           ELSE
              DISPLAY "Usage: getinfo <filename>"
           END-IF.
           DISPLAY " "
           DISPLAY "Press <ENTER> key to exit . . ."
           ACCEPT inpt

           STOP RUN.

       GetInfo.
           INITIALIZE AREA-INFO-FILE.
           STRING WS-NOME-FILE DELIMITED BY SPACES
                  X'00' DELIMITED BY SIZE INTO WRK-PATH-FILE.
           MOVE FINPUT TO OPEN-MODE.
           SET OPEN-FUNCTION TO TRUE.
           INITIALIZE LOGICAL-INFO.
           MOVE "," TO L-COMMA-1 L-COMMA-2.
           MOVE LOW-VALUES TO L-END.
           CALL "I$IO" USING IO-FUNCTION, WRK-PATH-FILE, OPEN-MODE,
                             LOGICAL-INFO GIVING WRK-FILE-POINTER
           IF  WRK-FILE-POINTER = 0
               DISPLAY "Errore apertura file (Invio) "
                               LINE 24 POSITION 10
               ACCEPT RISPX LINE 0 POSITION 0 TAB NO BEEP
               MOVE 9 TO WRK-FILE-ERNO
           ELSE
              SET INFO-FUNCTION TO TRUE
              SET GET-LOGICAL-PARAMS TO TRUE
              CALL "I$IO" USING IO-FUNCTION, WRK-FILE-POINTER, INFO-MODE
                                LOGICAL-INFO GIVING WRK-FILE-ERNO
              SET INFO-FUNCTION TO TRUE
              SET GET-RECORD-COUNT TO TRUE
              CALL "I$IO" USING IO-FUNCTION, WRK-FILE-POINTER, INFO-MODE
                                RECORD-COUNT-INFO GIVING WRK-FILE-ERNO
              MOVE MAX-REC-SIZE      TO WRK-REC-SIZE
              MOVE NUM-KEYS          TO WRK-NUM-KEY
              MOVE NUMBER-OF-RECORDS TO WRK-NUM-RECORD
              SET INFO-FUNCTION TO TRUE
              SET GET-FILE-SIZE TO TRUE
              CALL "I$IO" USING IO-FUNCTION, WRK-FILE-POINTER, INFO-MODE
                                FILE-SIZE-INFO GIVING WRK-FILE-ERNO
              MOVE WHOLE-FILE-SIZE   TO WRK-FILE-SIZE
              SET CLOSE-FUNCTION TO TRUE
              CALL "I$IO" USING IO-FUNCTION, WRK-FILE-POINTER,
                                GIVING WRK-FILE-ERNO
           END-IF.

       DisplayInfo.
           DISPLAY "File name........: " WRK-PATH-FILE
           DISPLAY "File size........: " WRK-FILE-SIZE
           DISPLAY "Record length....: " WRK-REC-SIZE
           DISPLAY "Number of records: " WRK-NUM-RECORD
           DISPLAY "Number of keys...: " WRK-NUM-KEY
