       identification division.
       program-id.    mig.

       environment division.
       configuration section.
       input-output section.
       file-control.
       select FileList assign to NomeFileInput
           organization line sequential
           access sequential.
       data division.
       file section.
       fd  FileList.
       01  FileList-Record pic x(256).
       working-storage section.
       01  w-message pic x(80).
       01  NomeFileInput           pic x(256).

       copy "filesys.def".

       77  file-handlein  pointer.
       77  file-handleout handle.
       77 HOST-IN PIC X(6) VALUE "VISION".
       77 HOST-OUT PIC X(6) VALUE "CTREE".

       01  file-in-a      pic x(80) value spaces.
       01  file-out-a     pic x(80) value spaces.
       01  file-in-h      pic x(80) value spaces.
       01  file-out-h     pic x(80) value spaces.
       01  file_work      pic x(80) value spaces.
    
       01  file-in        pic x(80) value spaces.
       01  file-out       pic x(80) value spaces.

       77  len            pic 999 value 0.
       01  keys           pic x(4000) value spaces.
       01  keys-w         pic x(4000) value spaces.
       01  trans          pic x(256).

       01  record-area    pic x(32756) value spaces.
       01  record-area-w  pic x(32756) value spaces.

       01  comment  .
           03 pic x value low-values.

       01  disp_step      pic x.
           88 step_1      value "\".
           88 step_2      value "|".
           88 step_3      value "/".

       77  len-rec-in           pic 9(5) value 0.
       77  len-rec-out          pic 9(5) value 0.
       01  pic x.
           88 yes-sysout  value "Y" false "N".
       01  pic x.
           88 yes-progress value "Y" false "N".
       01  pic x.
           88 yes-filelist   value "Y" false "N".

       77  EnvironmentValue        pic x(5).
       01  IdxAvanzamento          pic 99.
       01  FILLER.
           03 FILLER               occurs 50.
              05 ValoreAvanzamento pic 9(10).
       01  AvanzamentoCorrente     pic 9(10).
       01  AvanzamentoMostra       pic 9(10).
       77  ind                pic 999 value 0.
       01  f-errno-x        pic 9999.	
       01  f-errno-x_2      pic 9999.
 
       01  w-com.
           03 recread     pic 9(15) value 0.
           03 recnoread   pic 9(15) value 0.
           03 recwrite    pic 9(15) value 0.
           03 recnowrite  pic 9(15) value 0.
           03 recdiff     pic 9(15) value 0.
           03 recreado    pic 9(15) value 0.
           03 recnoreado  pic 9(15) value 0.
           03 reccommit   pic 9(15) value 0.

      *-
       procedure division chaining file-in-a file-out-a.
       INIZIO.
           perform READ-ENVIRONMENT.
           perform MIGRATING-FILE.
           goback.

      ***---
       MIGRATING-FILE.

           move 1 to F-NO-LOCK
           if yes-filelist
              perform MIGRATION-BATCH
              goback
           end-if

           if file_in_a = spaces
             if yes-sysout  display " "  upon sysout
                	        display "Input file: " upon sysout no
                 else        display omitted
       	               display "Input file: " no
              end-if
              accept file_in_a
           end-if

           if file_out_a = spaces
              if yes-sysout  display "Output file: " upon sysout no
                    else        display "Output file: " no
              end-if
              accept file_out_a
           end-if

           perform MIGRATION.

       MIGRATION-BATCH.
           move file-in-a to  NomeFileInput

           open input FileList

              perform until 1 = 2
                 move spaces to FileList-Record file-in-a file-out-a
                 read FileList next  
                         at end exit perform  
                 end-read
                 unstring FileList-Record delimited by ","
                          into file-in-a file-out-a
                 if file-in-a = spaces 
                    exit perform cycle
                 end-if
                 if file-out-a = spaces 
                         string file-in-a delimited by spaces
                          "-out"  delimited by size into  file-out-a
                 end-if
                 perform MIGRATION

              end-perform
              close FileList.
         

       MIGRATION.
           perform SET-HOST

           perform READ-INFORMATION.

           perform MAKE-NEW-FILE 
           perform OPEN-NEW-FILE.


           perform CALCOLA-BARRA-AVANZAMENTO

           if yes-sysout
               display "Converting ......... " file-in-a
                          upon sysout
           else
               display "Converting ......... " file-in-a
           end-if
 
           move 0 to AvanzamentoCorrente.
           move 1 to IdxAvanzamento.
           move ValoreAvanzamento(IdxAvanzamento) to AvanzamentoMostra
                          
           perform until 1 = 2
              perform READ-IN-RECORD

              if E-NOT-FOUND
                 exit perform
              end-if

              if return-code not = 0 
                 move return-code to record-size
                 perform  WRITE-OUT-RECORD
              end-if

              if yes-progress
                 if NUMBER-OF-RECORDS >= 50
                    add 1 to AvanzamentoCorrente
                    if AvanzamentoCorrente = AvanzamentoMostra
                       perform MOSTRA-AVANZAMENTO
                       if IdxAvanzamento < 50
                          add 1 to IdxAvanzamento
                          move ValoreAvanzamento(IdxAvanzamento) 
                                                 to AvanzamentoMostra
                       end-if
                    end-if
                 end-if
              end-if
              
           end-perform

           if yes-progress
              if NUMBER-OF-RECORDS < 50
                 perform MOSTRA-AVANZAMENTO-COMPLETATO
              end-if
              if yes-sysout     display " "   upon sysout
                                display " "   upon sysout
                    else        display " "
                                display omitted
               end-if
           end-if 
           perform CLOSE-FILE.


      ***---
       CALCOLA-BARRA-AVANZAMENTO.
           if NUMBER-OF-RECORDS >= 50
              perform test after varying IdxAvanzamento from 1 by 1
                           until IdxAvanzamento = 50
                 compute ValoreAvanzamento(IdxAvanzamento) rounded =
                         (NUMBER-OF-RECORDS / 50) * IdxAvanzamento
              end-perform
           else 
              move 0 to ValoreAvanzamento(1)
           end-if.

      ***---
       MOSTRA-AVANZAMENTO.
           if yes-sysout
              evaluate IdxAvanzamento
              when  5    display "10%"  upon sysout no
              when 10    display "20%"  upon sysout no
              when 15    display "30%"  upon sysout no
              when 20    display "40%"  upon sysout no
              when 25    display "50%"  upon sysout no
              when 30    display "60%"  upon sysout no
              when 35    display "70%"  upon sysout no
              when 40    display "80%"  upon sysout no
              when 45    display "90%"  upon sysout no
              when 50    display "100%" upon sysout no
              when other display "."    upon sysout no
              end-evaluate
           else
              evaluate IdxAvanzamento
              when  5    display "10%"  no
              when 10    display "20%"  no
              when 15    display "30%"  no
              when 20    display "40%"  no
              when 25    display "50%"  no
              when 30    display "60%"  no
              when 35    display "70%"  no
              when 40    display "80%"  no
              when 45    display "90%"  no
              when 50    display "100%" no
              when other display "."    no
              end-evaluate
           end-if.
      
      ***---
       MOSTRA-AVANZAMENTO-COMPLETATO.
           if yes-sysout
              display "....10%....20%....30%....40%....50%....60%....70%
      -               "....80%....90%....100%" upon sysout no
           else
              display "....10%....20%....30%....40%....50%....60%....70%
      -               "....80%....90%....100%" no
           end-if.

      ***---
       READ-INFORMATION.
           set environment "default-host" to HOST-IN

           set OPEN-FUNCTION to true

           compute open_mode = Finput + Fread-lock

           inspect file_in replacing trailing spaces by low-values.
           inspect LOGICAL-INFO replacing trailing spaces by low-values.

           call "I$IO" using io_function 
                             file_in
                             open_mode
                             LOGICAL-INFO.

           move return_code  to file_handlein

           if return-code = 0
             if yes-sysout
                display "File in "    upon sysout no
                display file_in_a     upon sysout no
                display " not found!" upon sysout
             else
                display "File in "    no
                display file_in_a     no
                display " not found!" 
                accept omitted
             end-if
                goback 1
           end-if.

           set INFO-FUNCTION      to true

           set GET-LOGICAL-PARAMS to true

           inspect LOGICAL-INFO replacing trailing spaces by low-values.

           call "I$IO" using io_function
                             file_handlein
                             info_mode
                             logical_info

           set GET-PHYSICAL-PARAMS to true

           inspect physical-info replacing trailing spaces 
                   by low-values.

           call "I$IO" using io_function
                             file_handlein
                             info_mode
                             physical-info

           move 1 to   block-multiple
           move 0 to   pre-allocation-amount
           move 1 to   extension-amount
           move 0 to   compression-factor
           move 0 to   encrypted-flag
           move spaces to keys-w
		   
           set GET-RECORD-COUNT to true

           call "I$IO" using io_function
                             file_handlein
                             info_mode
                             record-count-info

		   
           perform test after varying ind from 0 by 1 
                                until ind = num-keys - 1

              move ind to info_mode

              inspect key-info  replacing trailing spaces by low-values

              call "I$IO" using io_function
                                file_handlein
                                info_mode
                                key-info

              move 1 to len
              inspect key-info tallying len for characters 
                                 before initial x"00"

              move keys-w to keys
              string keys-w key-info(1:len - 1) delimited by spaces 
                     into keys
              move keys to keys-w
              string keys-w "," delimited by spaces into keys-w

           end-perform.

      ***---
       MAKE-NEW-FILE.
           set environment "default-host" to HOST-OUT
           set OPEN-FUNCTION to true
           move Finput to open_mode
           inspect file_out replacing trailing spaces by low-values
           inspect LOGICAL-INFO replacing trailing spaces by 
                                                           low-values
           call "I$IO" using io_function 
                             file_out
                             open_mode
                             LOGICAL-INFO
           move return-code to file_handleout
           if file_handleout = 0
              evaluate true
              when E-NOT-FOUND
              when E-MISSING-FILE
                   continue
              when other
                   perform MOSTRA-ERRORE-ED-ESCI
                   exit paragraph
              end-evaluate
           else
              set CLOSE-FUNCTION to true
              call "I$IO" using io_function file_handleout
           end-if
           set FLUSH-FUNCTION to true
           call "I$IO" using io-function, 0

           set MAKE-FUNCTION to true

           inspect file_out     replacing trailing spaces by low-values.
           inspect comment      replacing trailing spaces by low-values.
           inspect physical-info
                                replacing trailing spaces by low-values.
           inspect logical_info replacing trailing spaces by low-values.
           inspect keys         replacing trailing spaces by low-values.


           call "I$IO" using io_function file_out,
                             comment, physical-info
                             logical_info keys.

           set FLUSH-FUNCTION to true

           call "I$IO" using io-function, 0.

      ***---
       OPEN-NEW-FILE.
           set environment "default-host" to HOST-OUT

           set OPEN-FUNCTION to true
           
           if HOST-OUT = "CTREE"
              compute open_mode = Fmass-update+Foutput+Fbulk-addition
           else
              compute open_mode = Fmass-update+Foutput+Fwrite-lock
           end-if

           inspect file_out     replacing trailing spaces by low-values
           inspect logical-info replacing trailing spaces by low-values

           call "I$IO" using io_function
                             file_out
                             open_mode
                             logical-info.

           move return_code  to file_handleout.

           if return-code = 0
              perform MOSTRA-ERRORE-ED-ESCI
           end-if.

      ***---
       MOSTRA-ERRORE-ED-ESCI.
           if yes-sysout
              display "File out "   upon sysout no
              display file_out_a    upon sysout no
              display " not found!" upon sysout
              move f-errno to f-errno-x
              move f-int-errno to f-errno-x-2
              move spaces to w-message
              string "Error:" delimited by size
                 f-errno-x delimited by size
                 "," delimited by size
                 f-errno-x-2 delimited by size
                 into w-message
              display w-message upon sysout
            else
              display "File out "   no
              display file_out_a    no
              display " not found!" 
              move f-errno to f-errno-x
              move f-int-errno to f-errno-x-2
              move spaces to w-message
              string "Error:" delimited by size
                 f-errno-x delimited by size
                 "," delimited by size
                 f-errno-x-2 delimited by size
                 into w-message
              display w-message
              accept omitted
            end-if.

      ***---
       READ-IN-RECORD.
           move spaces to record-area.
           set NEXT-FUNCTION to true
           call "I$IO" using io_function file_handlein record-area.
           if return-code not = 0
              add 1 to recread
              move return-code to len-rec-in
           else
              if E-NOT-FOUND
                 continue
              end-if
           end-if.

      ***---
       START-IN-RECORD.
           set START-FUNCTION to true
           set F-NOT-LESS     to true
           move 0 to KEY-NUM START-KEY-SIZE
           call "I$IO" using io_function
                             file_handlein
                             record-area
                             KEY-NUM
                             START-KEY-SIZE
                             START-MODE.

      ***---
       START-OUT-RECORD.
           set START-FUNCTION to true
           set F-NOT-LESS     to true
           move 0 to KEY-NUM START-KEY-SIZE
           call "I$IO" using io_function 
                             file_handleout
                             record-area
                             KEY-NUM
                             START-KEY-SIZE
                             START-MODE.

      ***---
       WRITE-OUT-RECORD.
           set WRITE-FUNCTION to true
           call "I$IO" using io_function 
                             file_handleout
                             record-area(1:record-size)
                             record-size.
           if return-code not = 0
              add 1 to recwrite
           else
              display "Write failed" upon sysout
           end-if.

      ***---

      ***---
       CLOSE-FILE.
           set CLOSE-FUNCTION to true
           call "I$IO" using io_function file_handlein.
           call "I$IO" using io_function file_handleout.

      ***---
       OPEN-OUT-FILE.
           set environment "default-host" to HOST-OUT.

           set OPEN-FUNCTION to true

           compute open_mode =  Fmass-update + Finput

           inspect file_out     replacing trailing spaces by low-values.
           inspect LOGICAL-INFO replacing trailing spaces by low-values.

           call "I$IO" using io_function
                             file_out
                             open_mode
                             LOGICAL-INFO.

           move return_code  to file_handleout.

           
       READ-ENVIRONMENT.
           accept EnvironmentValue
                  from environment "MIGRATE_SYSOUT"
           call "C$TOUPPER" using EnvironmentValue, value 5
           evaluate EnvironmentValue
              when "1"
              when "ON"
              when "TRUE"
              when "YES"  set yes-sysout to true
              when other  set yes-sysout to false
           end-evaluate.
           accept EnvironmentValue
                  from environment "MIGRATE_PROGRESS"
           call "C$TOUPPER" using EnvironmentValue, value 5
           evaluate EnvironmentValue
              when "0"
              when "OFF"
              when "FALSE"
              when "NO"  set yes-progress to false
              when other  set yes-progress to true
           end-evaluate.

           accept EnvironmentValue
                  from environment "MIGRATE_FILELIST"
           call "C$TOUPPER" using EnvironmentValue, value 5
           evaluate EnvironmentValue
              when "1"
              when "ON"
              when "TRUE"
              when "YES"  set yes-filelist to true
              when other  set yes-filelist to false
           end-evaluate.

       SHOW-CMD-LINE.
           goback.

       SET-HOST.
      *setta il file host per il file di input 
      *     move file_in_a to file_work
      *     move 0 to ind
      *     inspect file_work tallying ind for all ".".
      *     if ind > 0
      *        perform varying ind from 1 by 1 until ind = 80
      *           if file_work(ind:1) = "."
      *              if ind > 1		   
      *                 subtract 1 from ind
      *                 exit perform
      *              end-if		       
      *           end-if
      *        end-perform
      *     else
      *        move 80 to ind
      *     end-if
      *     move spaces to file_in_h
      *     string file_work(1:ind)  delimited by spaces
      *            "-HOST" delimited by size
      * 		  into file_in_h

      *setta il file host per il file di outout
      *     move file-out-a to file_work
      *     move 0 to ind
      *     inspect file_work tallying ind for all ".".
      *     if ind > 0
      *        perform varying ind from 1 by 1 until ind = 80
      *           if file_work(ind:1) = "."
      *              if ind > 1		   
      *                 subtract 1 from ind
      *                 exit perform
      *              end-if		       
      *           end-if
      *        end-perform
      *     else
      *        move 80 to ind
      *     end-if
      *     move spaces to file-out-h
      *     string file_work(1:ind)  delimited by spaces
      *          "-HOST" delimited by size
      *           into file-out-h 

           initialize file_in
           string file_in_a delimited by spaces
       	         low-values delimited by size
                 into file_in
           initialize file_out
           string file_out_a delimited by spaces
       	          low-values delimited by size
                  into file_out.
 
