      *
      * cobol_failover.cbl
      *
      * Public domain COBOL example
      *
      * FairCom Corporation, 6300 West Sugar Creek Drive, Columbia, MO 65203 USA
      *
      * The goal of this tutorial is to introduce to c-treeACE for COBOL driver
      * to accomplish creating and manipulating a table through the c-treeACE Server
      *
      * From a functional point of view this application will perform the following:
      *
      * If the file does not exist:
      *  1.  Create custmast file
      *  2.  Exit
      * If the file already exist:
      *  1.  Open custmast file
      *  2.  Populate the file with records
      * If a duplicate key error occurs:
      *  1.  Delete all existing records
      *  2.  Populate the file with records
      * If disconnection error occurs:
      *  1.  Close File
      *  2.  Re-open file (onto next available server in the cluster)
      *  3.  Populate the file with records

      * $SET CALLFH"CTEXTFH"

       IDENTIFICATION DIVISION.
       PROGRAM-ID.  cobol-failover.

       ENVIRONMENT DIVISION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT NOT OPTIONAL custmast-file
               ASSIGN TO "custmast"
           ORGANIZATION IS INDEXED
           ACCESS MODE IS DYNAMIC
           RECORD KEY IS cm-custnumb
           FILE STATUS IS stat.

       DATA DIVISION.
       FILE SECTION.
       FD custmast-file
           RECORD IS VARYING IN SIZE FROM 16 TO 1024 CHARACTERS.
       01 custmast-record.
           03 cm-custnumb PIC X(4).
           03 cm-custzipc PIC X(9).
           03 cm-custstat PIC X(2).
           03 cm-custrtng PIC X(1).
           03 cm-custname PIC X(47).
           03 cm-custaddr PIC X(47).
           03 cm-custcity PIC X(47).

       WORKING-STORAGE SECTION.
       01 numb                         pic 9999 value 1000.
       01 inpt                         pic x.
       01 stat                         pic xx.
       01 file-stat REDEFINES stat.
          05 status-key-1              pic 9.
          05 status-key-2              pic x.
          05 status-key-2-binary REDEFINES status-key-2
                                       pic 9 comp-x.
      * RM/COBOL
      *                                 pic 9 comp.
       01 display-ext-status.
           05 filler                   pic xx value "9/".
           05 display-key-2            pic 999.
       01 crerr                        pic xx999.
       01 file-crerr REDEFINES crerr.
          05 crerr-1                   pic xx.
          05 crerr-2                   pic 999.

       PROCEDURE DIVISION.
       DECLARATIVES.
       on-custmast-file SECTION.
           USE AFTER STANDARD ERROR PROCEDURE ON custmast-file.

       Handle-Error.
      *    if file does not exist 
           IF stat = "35"
      *     IF status-key-1 = "9" AND status-key-2-binary = 13

      *       create table
              PERFORM Create-CustomerMaster-Table

              DISPLAY "Now setup an HA group in Replication Manager"
      *       and exist immediately
              STOP RUN

           ELSE
      *    if record already exists
           IF stat = 22

      *       delete any existing records
              PERFORM Delete-Records
      *       populate the table with data
              PERFORM Add-Records

           ELSE

      *       get c-tree error in crerr-2
              CALL "C$RERR" USING crerr
      *       if disconnection error
              IF crerr-1 = "9D" AND ( crerr-2 = "127" OR
                                      crerr-2 = "128" OR
                                      crerr-2 = "129" OR
                                      crerr-2 = "7" OR
                                      crerr-2 = "808" OR
                                      crerr-2 = "809" OR
                                      crerr-2 = "820" OR
                                      crerr-2 = "150" )
                 DISPLAY "Disconnected! Attempting to failover..."
      *          close file
                 CLOSE custmast-file
      *          re-open file on next available server in the cluster
                 OPEN I-O custmast-file
      *          populate the table with data
                 PERFORM Add-Records
              ELSE
                 IF status-key-1 = "9"
                    MOVE status-key-2-binary TO display-key-2
                    DISPLAY "ERROR: [" display-ext-status "]"
                       WITH NO ADVANCING
                 ELSE
                    DISPLAY "ERROR: [" stat "]"
                       WITH NO ADVANCING
                 END-IF
                 DISPLAY " [" crerr-1 "][" crerr-2 "]"
                 DISPLAY "*** Execution aborted ***"
                 DISPLAY "Press <ENTER> key to exit..."
                 ACCEPT inpt
                 STOP RUN
              END-IF
           END-IF
           END-IF
           GO TO on-custmast-file-exit.

       Create-CustomerMaster-Table.
           DISPLAY "        Create table..."

      *    create table
           OPEN OUTPUT custmast-file
           CLOSE custmast-file
           .

       Sleep.
           call "C$SLEEP" using "1" end-call
           .

       Add-Records.
           DISPLAY "        Add records..."

           PERFORM UNTIL stat NOT = "00"
              MOVE numb                TO cm-custnumb
              MOVE "92867"             TO cm-custzipc
              MOVE "CA"                TO cm-custstat
              MOVE "1"                 TO cm-custrtng
              MOVE "Bryan Williams"    TO cm-custname
              MOVE "2999 Regency"      TO cm-custaddr
              MOVE "Orange"            TO cm-custcity
              WRITE custmast-record
              PERFORM Display-Record
              ADD 1 TO numb

              MOVE numb                TO cm-custnumb
              MOVE "61434"             TO cm-custzipc
              MOVE "CT"                TO cm-custstat
              MOVE "1"                 TO cm-custrtng
              MOVE "Michael Jordan"    TO cm-custname
              MOVE "13 Main"           TO cm-custaddr
              MOVE "Harford"           TO cm-custcity
              WRITE custmast-record
              PERFORM Display-Record
              ADD 1 TO numb

              MOVE numb                TO cm-custnumb
              MOVE "73677"             TO cm-custzipc
              MOVE "GA"                TO cm-custstat
              MOVE "1"                 TO cm-custrtng
              MOVE "Joshua Brown"      TO cm-custname
              MOVE "4356 Cambridge"    TO cm-custaddr
              MOVE "Atlanta"           TO cm-custcity
              WRITE custmast-record
              PERFORM Display-Record
              ADD 1 TO numb

              MOVE numb                TO cm-custnumb
              MOVE "10034"             TO cm-custzipc
              MOVE "MO"                TO cm-custstat
              MOVE "1"                 TO cm-custrtng
              MOVE "Keyon Dooling"     TO cm-custname
              MOVE "19771 Park Avenue" TO cm-custaddr
              MOVE "Columbia"          TO cm-custcity
              WRITE custmast-record
              PERFORM Display-Record
              ADD 1 TO numb

              PERFORM Sleep
           END-PERFORM
           .

       on-custmast-file-exit.
           EXIT.

       END DECLARATIVES.

       Main SECTION.
       begin.
           PERFORM Init.

           PERFORM Define.

           PERFORM Manage.

           PERFORM Done.

           DISPLAY "Press <ENTER> key to exit . . .".
           ACCEPT inpt.

           STOP RUN.

       Init.
           DISPLAY "INIT".
      *    no specific action is required to connect

       Define.
           DISPLAY "DEFINE".

      *    open or create table
           OPEN I-O custmast-file.

       Manage.
           DISPLAY "MANAGE".

      *    populate the table with data
           PERFORM Add-Records.

       Done.
           DISPLAY "DONE".

           CLOSE custmast-file.

       Display-Record.
           DISPLAY "                " WITH NO ADVANCING
           DISPLAY cm-custnumb "    " WITH NO ADVANCING
           DISPLAY cm-custname.

       Delete-Records.
           DISPLAY "        Delete records..."

           MOVE low-values TO cm-custnumb
           START custmast-file KEY NOT LESS cm-custnumb
           PERFORM UNTIL stat NOT = "00"
              READ custmast-file NEXT
                 AT END
                    EXIT PERFORM
                 NOT AT END
                    DELETE custmast-file
              END-READ
           END-PERFORM.

