       IDENTIFICATION DIVISION.
       PROGRAM-ID.  mfconvert.
       
       $set FCDREG
       
       ENVIRONMENT DIVISION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
        SELECT FAKE-FILE
           ASSIGN TO DYNAMIC fake-filename
           ORGANIZATION IS INDEXED
           ACCESS MODE IS DYNAMIC
           LOCK MODE IS EXCLUSIVE
           RECORD KEY IS fakefield.
       DATA DIVISION.
       FILE SECTION.
        FD  FAKE-FILE
           RECORD CONTAINS 4 CHARACTERS.
        01 FAKE-RECORD.
           03 fakefield PIC X(4).
           
       WORKING-STORAGE SECTION.

         01  SRC-FH                     PIC X(08) VALUE 'EXTFH'.
         01  DST-FH                     PIC X(08) VALUE 'CTEXTFH'.

         01 commandLineArgs             PIC X(1024).
         01 callst                      PIC X(2) COMP-5.
         01 st                          PIC X(2).
         01 file-status redefines st.
           05 status-key-1              PIC X.
           05 status-key-2              PIC X.
           05 status-key-2-binary redefines status-key-2
                                        PIC 99 COMP-X.
         01 READ-CTR                    COMP-5  PIC S9(09).
         01 totalrec                    PIC 9(12).
         01 src-filename                PIC X(512).
         01 dst-filename                PIC X(512).
         01 fake-filename               PIC X(524).
         01 padspaces                   PIC 9(8) VALUE ZERO COMP-4.
         01 keydefblock                 PIC X(1024).

         01 recordbuf                   USAGE POINTER.
         01 recordlen                   PIC X(4) COMP-X.
         01 display-ext-status.
           05 filler                    PIC XX VALUE "9/".
           05 display-key-2             PIC 999.
         01 fcdvers                     PIC 9(1).
         01 dstfcd.
           copy "xfhfcd.cpy".
         01 srcfcd.
           copy "xfhfcd.cpy".
       
         01  Action-Code.
           05  Action-Type              PIC X(1).
               78  Cobol-Type                  value x'FA'.
               78  Special-Type                value x'00'.
           05  Cobol-Op                 PIC X(1).
               78  Open-Input                  value x'00'.
               78  Open-Output                 value x'01'.
               78  Close-File                  value x'80'.
               78  Close-Lock                  value x'81'.
               78  Write-Record                value x'F3'.
               78  Step-Next                   value x'CA'.
               78  Read-Next                   value x'F5'.
               78  Get-File-Info               value x'06'.

       LINKAGE SECTION.

       PROCEDURE DIVISION.
      
       main.
         display "*** START ***"

         perform Init.

      * retrieve command line options: sourcefile destfile
         display "*** GET ARGS ***"
         accept commandLineArgs from command-line
           
         unstring commandLineArgs delimited by space
             into src-filename dst-filename

         if src-filename = SPACES OR dst-filename = SPACES
             perform DisplayUsage
         end-if

      * trim padding spaces
         inspect src-filename tallying padspaces 
            for characters before space
         inspect dst-filename tallying padspaces 
            for characters before space
         
         display "SOURCE: " src-filename(1:padspaces)
         display "DESTIN: " dst-filename(1:padspaces)

         perform GetFCDVersion

      * retrieve the file information for the source file
      * fill FCD
         
         display "*** get source file information ***"
         move 255 to FCD-ORGANIZATION of srcfcd
         if fcdvers = 1
            move 512 to FCD-NAME-LENGTH of fcd3 of srcfcd
            set FCD-FILENAME-ADDRESS of fcd3 of srcfcd to 
                address of src-filename
            set FCD-KEY-DEF-ADDRESS of fcd3 of srcfcd to 
                address of keydefblock
         else
            move 512 to FCD-NAME-LENGTH of fcd2 of srcfcd
            set FCD-FILENAME-ADDRESS of fcd2 of srcfcd to 
                address of src-filename
            set FCD-KEY-DEF-ADDRESS of fcd2 of srcfcd to 
                address of keydefblock
         end-if
         
         move Special-Type           to Action-Type
         move Get-File-Info          to Cobol-Op
         perform Call-SRC
         
         if  FCD-ORGANIZATION of srcfcd <> 2
            display "unsupported source file organization."
            display "file organization is " FCD-ORGANIZATION of srcfcd
            stop run
         end-if

         display "*** create destination file ***"
      * copy src fcd to dest fcd
         move srcfcd to dstfcd
         move 128 to FCD-OPEN-MODE of dstfcd  *> fcd--open-closed
         if fcdvers = 1
             set FCD-FILENAME-ADDRESS of fcd3 of dstfcd to 
                 address of dst-filename
         else
             set FCD-FILENAME-ADDRESS of fcd2 of dstfcd to 
                 address of dst-filename
         end-if
                  
         move Cobol-Type           to Action-Type
         move Open-Output          to Cobol-Op
         perform Call-DST
         
         display "*** open original file ***"
         move Cobol-Type           to Action-Type
         move Open-Input          to Cobol-Op
         perform Call-SRC
         
         display "*** preparing record buffer ***"
      * get max record length from fcd
         if fcdvers = 1
             move FCD-MAX-REC-LENGTH of fcd3 of srcfcd to recordlen
         else
             move FCD-MAX-REC-LENGTH of fcd2 of srcfcd to recordlen
         end-if
      * MF needs at least 1 extra byte for unknown reasons
      * allocating 8 extra bytes in case is for alignment issues
         add 8 to recordlen
      * allocate record buffer
         call "CBL_ALLOC_MEM" using     recordbuf
               by value  recordlen
               by value  0
               returning callst
         if callst <> 0
            display "Memory allocation ERROR: [" callst "]"
         end-if
         if fcdvers = 1
             set FCD-RECORD-ADDRESS of fcd3 of srcfcd to recordbuf
             set FCD-RECORD-ADDRESS of fcd3 of dstfcd to recordbuf
         else
             set FCD-RECORD-ADDRESS of fcd2 of srcfcd to recordbuf
             set FCD-RECORD-ADDRESS of fcd2 of dstfcd to recordbuf
         end-if

         perform CopyLoop
         
         display "*** closing original file ***"
         move Cobol-Type           to Action-Type
         move Close-File          to Cobol-Op
         perform Call-SRC
         
         display "*** closing destination file ***"
         move Cobol-Type           to Action-Type
         move Close-File          to Cobol-Op
         perform Call-DST
         perform ErrorHandling
         display "Migrated " totalrec " records"
         move 0 to return-code
         stop run.

       DisplayUsage.
         display SPACE
         display "Usage: mfconvert source_file destination_file"
         display SPACE
         stop run.

       Init.
         move 1 to return-code
         move low-value to src-filename
         move low-value to dst-filename
         move low-value to keydefblock.

       GetFCDVersion.
         string
             dst-filename  delimited by space
             ".mfconvert" delimited by size
             into fake-filename
         end-string.

         open output FAKE-FILE
         move fh--fcd of FAKE-FILE to srcfcd
         move 128 to FCD-OPEN-MODE of srcfcd  *> fcd--open-closed
         move FCD-VERSION of srcfcd to fcdvers
         close FAKE-FILE
         delete file FAKE-FILE
         if fcdvers = 1
             display " detected fcd version 3"
         else
             display " detected fcd version 2"
         end-if.

       Copyloop.
         display "*** copying records ***"
         MOVE ZERO TO READ-CTR
         MOVE 0 TO totalrec
         perform until file-status not = "00"
      * read source
             move Cobol-Type          to Action-Type
      *       move Step-Next          to Cobol-Op
             move Read-Next          to Cobol-Op
             perform Call-SRC
      * copy record length information       
             if file-status = "00"
                 if fcdvers = 1
                      move FCD-CURRENT-REC-LEN of fcd3 of srcfcd to
                           FCD-CURRENT-REC-LEN of fcd3 of dstfcd
                 else
                      move FCD-CURRENT-REC-LEN of fcd2 of srcfcd to
                           FCD-CURRENT-REC-LEN of fcd2 of dstfcd
                 end-if
                 ADD 1 TO READ-CTR
                 ADD 1 TO totalrec
                 IF  READ-CTR > 10000
                   DISPLAY '.' WITH NO ADVANCING
                   MOVE 1 TO READ-CTR
                 end-if
      * write destination
                 move Cobol-Type          to Action-Type
                 move Write-Record          to Cobol-Op
                 perform Call-DST
             end-if
         end-perform.

       Call-SRC.
         move "00" to FCD-FILE-STATUS of srcfcd
         call SRC-FH using Action-Code, srcfcd
         move FCD-FILE-STATUS of srcfcd to file-status
         perform ErrorHandling.

       Call-DST.
         move "00" to FCD-FILE-STATUS of dstfcd
         call DST-FH using Action-Code, dstfcd
         move FCD-FILE-STATUS of dstfcd to file-status
         perform ErrorHandling.
       
       ErrorHandling.
         if file-status <> "10" AND file-status <> "00"
             if status-key-1 = "9"
               move status-key-2-binary to display-key-2
               display "ERROR: [" display-ext-status "]"
             else
               display "ERROR: [" file-status "]"
             end-if      
           
             display "*** Execution aborted ***"
             move file-status to return-code
             stop run
         end-if.
         
