      *> Copyright (c) 2005 - 2015 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. cobol-esql.
                
       WORKING-STORAGE SECTION.  
       EXEC SQL INCLUDE SQLCA END-EXEC.    
  
       01  IS-REC.
           03 IS-KEY   pic 9(4).
           03 IS-DATA  pic x(30). 

       77  REC-COUNT   pic 9(4).

       77  DBNAME      pic x any length value "ctreeSQL".
       77  USERID      pic x any length value "admin".
       77  PASSWD      pic x any length value "ADMIN".              


       PROCEDURE DIVISION.
       Main.                             
      *first of all we have to configure the jdbc environment.
      *in this sample we're using isCOBOL SQL Server, ensure you have "ctreeJDBC.jar" in your CLASSPATH  
           set environment "jdbc.driver" to "ctree.jdbc.ctreeDriver"
           set environment "jdbc.url"    to "jdbc:ctree:6597@localhost:"  
      *the first step in sql programs is the connection to the database
           EXEC SQL CONNECT TO :DBNAME AS Conn 
                               USER :USERID  
                               USING :PASSWD
           END-EXEC     
           perform TEST-SQL-STATUS
      *now we can execute sql queries           
      *first of all we should create a test table
           EXEC SQL CREATE TABLE IS-TABLE 
                                (IS-KEY NUMERIC(4) NOT NULL, 
                                 IS-DATA CHAR(30))
           END-EXEC                     
           perform TEST-SQL-STATUS
      *create a primary key for that table
           EXEC SQL ALTER TABLE IS_TABLE ADD PRIMARY KEY (IS_KEY)
           END-EXEC                     
           perform TEST-SQL-STATUS
      *fill the table with some records
           EXEC SQL INSERT INTO IS-TABLE VALUES (1, 'row1') END-EXEC
           EXEC SQL INSERT INTO IS-TABLE VALUES (2, 'row2') END-EXEC
           EXEC SQL INSERT INTO IS-TABLE VALUES (3, 'row3') END-EXEC
           EXEC SQL INSERT INTO IS-TABLE VALUES (4, 'row4') END-EXEC
           EXEC SQL INSERT INTO IS-TABLE VALUES (5, 'row5') END-EXEC
      *commit all operations (maybe the db is not in autocommit mode)
           EXEC SQL COMMIT END-EXEC              
      *how to read table data using a cursor
           EXEC SQL DECLARE C1 CURSOR FOR SELECT * FROM IS-TABLE 
           END-EXEC               
           perform TEST-SQL-STATUS

           EXEC SQL OPEN C1  END-EXEC     
           perform TEST-SQL-STATUS

           perform until 1 = 2
             EXEC SQL FETCH NEXT C1 INTO :IS-KEY, :IS-DATA END-EXEC
             if SQLCODE = 100
                exit perform
             end-if
           end-perform

           EXEC SQL CLOSE C1 END-EXEC
      *disconnect from the db
           EXEC SQL DISCONNECT ALL END-EXEC           
      *end of sample, now you have a new table called IS-TABLE in your database
      *drop it before running this program again
           stop run
           .

       TEST-SQL-STATUS.
           if SQLCODE NOT = 0
              display message SQLCODE   x"0d0a"
                              SQLERRMC                            
                              title "SQL Error"
              EXEC SQL DISCONNECT ALL END-EXEC
              stop run
           end-if
           .
