       IDENTIFICATION DIVISION.

       PROGRAM-ID. SQLIZEEXAMPLE.

       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       
           COPY "CARDFILE.SL".
                             
       DATA DIVISION.

       FILE SECTION.           
       
           COPY "CARDFILE.FD".
                                        
       WORKING-STORAGE SECTION.
       
       01  WS_CARDFILE_STATUS_CODE     PIC XX.  
       01  WS_CARDFILE_STATUS_CODE_85 PIC X(14).       
       
       01  WS_CRED_NUM_X  PIC X(20).
       01  WS_CRED_NUM_X_2  PIC X(10).
       01  WS_VALID_CRED_NUM PIC S9(2) COMP.
       01  WS_LEN_CRED_NUM   PIC S9(2) COMP.
       01  WS_COUNT       PIC 9(4).

       01  WS_TOTAL_RECORDS PIC 9(8) VALUE ZEROS.
       01  WS_DATA_REMAINS_SWITCH     PIC X(2)      VALUE SPACES.
       01  WS_VALID_CARDS          PIC 9(4).

       01  WS_DISP_X  PIC X(47).
       
       LINKAGE SECTION.

       SCREEN SECTION.

       PROCEDURE DIVISION.
       
       DECLARATIVES.

       CARDHERROR SECTION.
           USE AFTER ERROR PROCEDURE ON CARDFILE.

       ERROR-ROUTINE.
           IF WS_CARDFILE_STATUS_CODE = "35"
              OPEN OUTPUT CARDFILE
              CLOSE CARDFILE
              OPEN INPUT CARDFILE
           ELSE
              CALL "C$RERR" USING WS_CARDFILE_STATUS_CODE_85
              DISPLAY 'ERROR ON FILE:'
              DISPLAY WS_CARDFILE_STATUS_CODE_85
              DISPLAY "Press enter to exit:"
              ACCEPT WS_CRED_NUM_X
              STOP RUN
           END-IF.

       END DECLARATIVES.       

       MAIN SECTION.
       MAIN-PARA.
 
           MOVE ZERO TO WS_VALID_CARDS.
           MOVE ZERO TO WS_TOTAL_RECORDS.
           MOVE ZERO TO WS_VALID_CRED_NUM.
           DISPLAY ""
           DISPLAY "|--------------------------------------------|"
           DISPLAY "|            Please visit us on              |"
           DISPLAY "|             www.FairCom.com                |"
           DISPLAY "|              c-treeACE SQL                 |"
           DISPLAY "|           FairCom Corporation              |"
           DISPLAY "|        6300 West Sugar Creek Drive         |"
           DISPLAY "|             Columbia, MO 65203             |"
           DISPLAY "|--------------------------------------------|"
           DISPLAY "|       This program lists and counts        |"
           DISPLAY "|    all credit card holders within a file   |".
           DISPLAY "|    whose credit card numbers are similar   |".
           DISPLAY "|     to a sequence provided by the user.    |".
           DISPLAY "|      Once it processed the whole file      |".
           DISPLAY "|    it displays the total counting number.  |".
           DISPLAY "|--------------------------------------------|"
           DISPLAY ""
           
           PERFORM UNTIL WS_VALID_CRED_NUM = 1
             DISPLAY "Please provide a number to search for:"
             DISPLAY "XXXXXXXXXX          (1-10 digits)"
             MOVE  0  TO WS_CRED_NUM_X
             ACCEPT WS_CRED_NUM_X
             MOVE  0  TO WS_COUNT
             MOVE  0  TO WS_LEN_CRED_NUM
             INSPECT WS_CRED_NUM_X REPLACING 
                 ALL LOW-VALUE BY SPACE
             INSPECT WS_CRED_NUM_X
                    TALLYING WS_COUNT FOR TRAILING SPACE
             COMPUTE WS_LEN_CRED_NUM = 
                LENGTH OF WS_CRED_NUM_X - WS_COUNT      
             IF  WS_LEN_CRED_NUM <= 10 THEN
                IF WS_LEN_CRED_NUM > 0 THEN
                   MOVE 1 TO WS_VALID_CRED_NUM
                ELSE
                   DISPLAY ""
                   DISPLAY "ERROR: INVALID INPUT!"
                   DISPLAY "Insert at least 1 digit."
                   DISPLAY ""
                END-IF
             ELSE
                DISPLAY ""
                DISPLAY "ERROR: INVALID INPUT!"
                DISPLAY "Greater than 10 digits."
                DISPLAY ""
             END-IF
           END-PERFORM.
           OPEN I-O CARDFILE.
           READ CARDFILE NEXT
               AT END MOVE 'NO' TO WS_DATA_REMAINS_SWITCH
           END-READ.
           PERFORM PROCESS-RECORDS
               UNTIL WS_DATA_REMAINS_SWITCH = 'NO'.
           PERFORM PRINT_SUMMARY.


           CLOSE CARDFILE.
                       
           
       010-PROCESS.
       
           GOBACK.
       
       PROCESS-RECORDS.
           
           MOVE CARD-RECORD-NUMBER TO WS_CRED_NUM_X_2.
           MOVE WS_CRED_NUM_X_2(1:WS_LEN_CRED_NUM) 
              TO WS_CRED_NUM_X_2.
                      
           IF WS_CRED_NUM_X_2 = WS_CRED_NUM_X  
             ADD 1 TO WS_VALID_CARDS
             IF WS_VALID_CARDS = 1 THEN
                DISPLAY ""
                DISPLAY "|--------------------------------------------|"
                DISPLAY "|CARD NUMBER  | NAME                         |"
             END-IF   
             MOVE "| " TO WS_DISP_X
             MOVE CARD-RECORD-NUMBER TO WS_DISP_X(3:10)
             MOVE "  |  " TO WS_DISP_X(13:5)
             MOVE CARD-CUSTOMER-NAME TO WS_DISP_X(18:28)
             MOVE "   |" TO WS_DISP_X(43:4)
             DISPLAY WS_DISP_X
           END-IF. 
      
           ADD 1 TO WS_TOTAL_RECORDS.
           READ CARDFILE NEXT
               AT END MOVE 'NO' TO WS_DATA_REMAINS_SWITCH
               DISPLAY "|--------------------------------------------|"
               DISPLAY ""
           END-READ. 
           
        PRINT_SUMMARY.
           DISPLAY "TOTAL NUMBER OF CARDS MATCHING:".
           DISPLAY WS_VALID_CARDS.
           DISPLAY "TOTAL NUMBER OF RECORDS READ:"
           DISPLAY WS_TOTAL_RECORDS.
           
           DISPLAY "Press enter to exit:"
           ACCEPT WS_CRED_NUM_X
           DISPLAY "|--------------------------------------------|"
           DISPLAY "|  Thank you for trying our SQLIZE Tutorial  |"
           DISPLAY "|            Please visit us on              |"
           DISPLAY "|             www.FairCom.com                |"
           DISPLAY "|--------------------------------------------|"
           .