      *
      * cobol_Tutorial1.cbl
      *
      * Public domain COBOL example
      *
      * FairCom Corporation, 6300 West Sugar Creek Drive, Columbia, MO 65203 USA
      *
      * The goal of this tutorial is to introduce to c-treeACE for COBOL driver
      * to accomplish creating and manipulating a table through the c-treeACE Server
      *
      * From a functional point of view this application will perform the following:
      *  1.  Logon onto a session
      *  2.  Add 1 table with some fields
      *  3.  Populate the table with a few records
      *  4.  Display the contents of the table
      *

      * $SET CALLFH"CTEXTFH"

       IDENTIFICATION DIVISION.
       PROGRAM-ID.  cobol-Tutorial1.

       ENVIRONMENT DIVISION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT NOT OPTIONAL custmast-file
               ASSIGN TO "custmast"
           ORGANIZATION IS INDEXED
           ACCESS MODE IS DYNAMIC
           RECORD KEY IS cm-custnumb
           FILE STATUS IS stat.

       DATA DIVISION.
       FILE SECTION.
       FD custmast-file
           RECORD IS VARYING IN SIZE FROM 16 TO 1024 CHARACTERS.
       01 custmast-record.
           03 cm-custnumb PIC X(4).
           03 cm-custzipc PIC X(9).
           03 cm-custstat PIC X(2).
           03 cm-custrtng PIC X(1).
           03 cm-custname PIC X(47).
           03 cm-custaddr PIC X(47).
           03 cm-custcity PIC X(47).

       WORKING-STORAGE SECTION.
       01 inpt                         pic x.
       01 stat                         pic xx.
       01 file-stat REDEFINES stat.
          05 status-key-1              pic 9.
          05 status-key-2              pic x.
          05 status-key-2-binary REDEFINES status-key-2
                                       pic 9 comp-x.
      * RM/COBOL
      *                                 pic 9 comp.
       01 display-ext-status.
           05 filler                   pic xx value "9/".
           05 display-key-2            pic 999.
       01 crerr                        pic xxxx.
       01 file-crerr REDEFINES crerr.
          05 crerr-1                   pic xx.
          05 crerr-2                   pic xx.

       PROCEDURE DIVISION.
       DECLARATIVES.
       on-custmast-file SECTION.
           USE AFTER STANDARD ERROR PROCEDURE ON custmast-file.

       Handle-Error.
      *    if file does not exist 
           IF stat = "35"
      *     IF status-key-1 = "9" AND status-key-2-binary = 13

      *       create table
              PERFORM Create-CustomerMaster-Table

      *       re-open table for input/output
              OPEN I-O custmast-file

      *       populate the table with data
              PERFORM Add-Records

           ELSE

              IF status-key-1 = "9"
                 MOVE status-key-2-binary TO display-key-2
                 DISPLAY "ERROR: [" display-ext-status "]"
              ELSE
                  DISPLAY "ERROR: [" stat "]"
      * RM/COBOL
      *           CALL "C$RERR" USING crerr
      *           DISPLAY "ERROR: [" crerr-1 "][" crerr-2 "]"
              END-IF
              DISPLAY "*** Execution aborted ***"
              DISPLAY "Press <ENTER> key to exit..."
              ACCEPT inpt
              STOP RUN
           END-IF
           GO TO on-custmast-file-exit.

       Create-CustomerMaster-Table.
           DISPLAY "        Create table..."

      *    create table
           OPEN OUTPUT custmast-file
           CLOSE custmast-file
           .

       Add-Records.
           DISPLAY "        Add records..."

           MOVE "1000"              TO cm-custnumb
           MOVE "92867"             TO cm-custzipc
           MOVE "CA"                TO cm-custstat
           MOVE "1"                 TO cm-custrtng
           MOVE "Bryan Williams"    TO cm-custname
           MOVE "2999 Regency"      TO cm-custaddr
           MOVE "Orange"            TO cm-custcity
           WRITE custmast-record

           MOVE "1001"              TO cm-custnumb
           MOVE "61434"             TO cm-custzipc
           MOVE "CT"                TO cm-custstat
           MOVE "1"                 TO cm-custrtng
           MOVE "Michael Jordan"    TO cm-custname
           MOVE "13 Main"           TO cm-custaddr
           MOVE "Harford"           TO cm-custcity
           WRITE custmast-record

           MOVE "1002"              TO cm-custnumb
           MOVE "73677"             TO cm-custzipc
           MOVE "GA"                TO cm-custstat
           MOVE "1"                 TO cm-custrtng
           MOVE "Joshua Brown"      TO cm-custname
           MOVE "4356 Cambridge"    TO cm-custaddr
           MOVE "Atlanta"           TO cm-custcity
           WRITE custmast-record

           MOVE "1003"              TO cm-custnumb
           MOVE "10034"             TO cm-custzipc
           MOVE "MO"                TO cm-custstat
           MOVE "1"                 TO cm-custrtng
           MOVE "Keyon Dooling"     TO cm-custname
           MOVE "19771 Park Avenue" TO cm-custaddr
           MOVE "Columbia"          TO cm-custcity
           WRITE custmast-record
           .

       on-custmast-file-exit.
           EXIT.

       END DECLARATIVES.

       Main SECTION.
       begin.
           PERFORM Init.

           PERFORM Define.

           PERFORM Manage.

           PERFORM Done.

           DISPLAY "Press <ENTER> key to exit . . .".
           ACCEPT inpt.

           STOP RUN.

       Init.
           DISPLAY "INIT".
      *    no specific action is required to connect

       Define.
           DISPLAY "DEFINE".

      *    open or create table
           OPEN I-O custmast-file.

       Manage.
           DISPLAY "MANAGE".

      *    display contents of table
           PERFORM Display-Records.

      *    delete any existing records
      *     PERFORM Delete-Records.

       Done.
           DISPLAY "DONE".

           CLOSE custmast-file.

       Display-Records.
           DISPLAY "        Display records..."

           MOVE low-values TO cm-custnumb
           START custmast-file KEY NOT LESS cm-custnumb
           PERFORM UNTIL stat NOT = "00"
              READ custmast-file NEXT
                 AT END
                    EXIT PERFORM
                 NOT AT END
                    DISPLAY "                " WITH NO ADVANCING
                    DISPLAY cm-custnumb "    " WITH NO ADVANCING
                    DISPLAY cm-custname
              END-READ
           END-PERFORM.

       Delete-Records.
           DISPLAY "        Delete records..."

           MOVE low-values TO cm-custnumb
           START custmast-file KEY NOT LESS cm-custnumb
           PERFORM UNTIL stat NOT = "00"
              READ custmast-file NEXT
                 AT END
                    EXIT PERFORM
                 NOT AT END
                    DELETE custmast-file
              END-READ
           END-PERFORM.

